#ifndef VARDUMP_EVENT_H
#define VARDUMP_EVENT_H

#include "VarDumpRecord.h"
#include <TClonesArray.h>

namespace pamela {
  /**
   * VarDumpEvent data Wrapper.
   * 
   * The pamela::VarDumpEvent represents the VarDump packet generated by the PAMELA CPU software.
   * It contains the values of the PAMELA CPU software's vectors written in Mass Memory between 
   * two storing operations.
   */
  class VarDumpEvent: public pamela::SubPacket {
  private:
    static TClonesArray *fgRecords;
  public:
  
    /**
     * Contain multiple instances of pamela::VarDumpRecord type.
     */
    TClonesArray*   Records;

    /**
     * The Compilation Timestamp of the PAMELA CPU software.
     */
    UINT32          PARAMETER_STAMP;

    VarDumpEvent(void);
    ~VarDumpEvent(void);
    
    ClassDef(VarDumpEvent, 1)
  };
}

#endif /* VARDUMP_EVENT_H */

