/**
* Header_Scan
* Author  Nagni
* version 1.0
*
* Version 1.1 - 28 December 2004
* If outList does not exist the function exit to prompt
* If nevents = 0 the function exit to promt
*
* Version 1.2 - 3 January 2005
* Two canvases are created to see the graphs better
*
* Version 1.25 - 13 January 2005
* Changed Int_t to Float because of variable range size
* (UInt_t has been excluded beacuse of uncompatibility with TGraph)
*
* version 1.3  - 22 February 2005 - Nagni
* For compatibility with batch mode excution:
* 1) Added "include <iostream>" and "using namespace std" 
* 2) Removed gROOT->Reset()
*
* Version 1.4
* Date 08 March 2005
* Added "format" parameter for saving the produced image in various formats
* (for a complete list of types refer to TPad::SaveAs method)
*
* Version 1.5
* Date 09 February 2006 - Marcelli
* Update to work with new Yoda output
*
* Version 1.6
* Date 27 February 2006 - Marcelli
* For compilation: 
*     Added function "int main(int argc, char* argv[])"
*
*
* Description: This script creates two canvases with five pads. The first pad shows packetID variable (for all packets) vs. OBT.
*     	       The second pad shows the number of physic packets vs. OBT. The third pad shows the lenght of Physic packets (byte) vs. OBT.
*              The fourth pad shows the packetcounter of physic packets vs. OBT. The fifth pad shows PacketCounter vs. File Offset.
*
* Parameters:
* 	       TSTring base          - the path to the root directory for the specific Pamela unpack session
*                                      There is no default value, without this input the program will not run
*              TString outDir        - the path where to save the output image (Default = ./) 
*              TString format        - the format which will be used fo rsave the produced images (Default = "jpg") 
*
*
* Version 1.7
* Date 16 June 2006 - Malvezzi
*
* Description of changes:
*                         Implementation of the case: numebr of events <= 0.
*                         Remove graph "grPcktId1"; see PacketScan for the same information.
*             Fixed bugs: for a large namber of events is not possible to have vectors, so I have subsituted graphs with histograms
*                         or divided the graphs in more than one canvas.
*
*/


#include <fstream>
#include <math.h>
#include "TLatex.h"
#include "TF1.h"
#include "TPaveText.h"
#include "TMultiGraph.h"
#include <sstream>
#include <iostream>
#include "TString.h"
#include "TStyle.h"
#include "TFile.h"
#include "TList.h"
#include "TTree.h"
#include "TObjString.h"
#include "TCanvas.h"
#include "TGraph.h"
#include "TH1F.h"
#include "TGaxis.h"
#include "EventHeader.h"
#include "PscuHeader.h"

using namespace std;

void HeaderScan(TString base, TString outDir, TString format)
{

  //------------------- Variables initilization -------------------------//
  Long64_t nevents=0; 
  ULong_t lastime, firstime;// offset, lastoffset, firstoffset;
  double obmin=0.;
  double obmax=0.; 
  stringstream oss, oss1, oss2, oss3, noentries;
  //------- load root file --------------
  TFile *file = new TFile(base.Data());
  if (!file){
    printf("No such file in the directory has been found");
    return;
  }
  
  TTree *PhysicsTr = (TTree*)file->Get("Physics");
  TBranch *headBr = PhysicsTr->GetBranch("Header");

  pamela::EventHeader  *eh   = 0;
  pamela::PscuHeader   *ph   = 0;

  PhysicsTr->SetBranchAddress("Header", &eh);

  nevents = headBr->GetEntries();

  TString filename = ((TObjString*)base.Tokenize('/')->Last())->GetString(); 
  filename = ((TObjString*)filename.Tokenize('.')->First())->GetString();

  //----------- If nevents < = 0 ---------------------------------/
  if (nevents<=0) {
    printf("nevents = %i \n", nevents);
    printf(" \n");

    TCanvas *canv = new TCanvas("No entries", "No entries ", 400, 200);
    canv->SetFillColor(10);
    canv->cd();

    TLatex *l = new TLatex();
    l->SetTextAlign(12);
    l->SetTextSize(0.15);
    l->SetTextColor(2);
    noentries.str("");
    noentries<< "HeaderScan_QL:";
    l->DrawLatex(0.05, 0.7, noentries.str().c_str()); 
    noentries.str("");
    noentries<< "No Physics entries for this files";
    l->DrawLatex(0.05, 0.5, noentries.str().c_str()); 

    if (outDir == "./") {
      oss.str("");
      oss << filename.Data() << "_HeaderScan_QL." << format.Data();
    } else {
      oss.str("");
      oss << outDir.Data() << filename.Data() << "_HeaderScan_QL." << format.Data();
    }
  
    canv->Update();
    canv->SaveAs(oss.str().c_str()); 

    return;
  }

  //-------------- to know the max and min OBT ----------------------------//
   headBr->GetEntry(0);
   ph = eh->GetPscuHeader();
   firstime = ph->GetOrbitalTime();

   for (Int_t i = 0; i < nevents; i++){
    headBr->GetEntry(i);
    ph = eh->GetPscuHeader();
    if((ph->GetOrbitalTime()) <= firstime) firstime=ph->GetOrbitalTime();
    if((ph->GetOrbitalTime()) >= lastime) lastime=ph->GetOrbitalTime();
    }
  
  //------------------------ First histogram -----------------------------------//

   obmin=firstime;
   obmax=lastime;  
  
  oss1.str("");
  oss1 <<"File name= "<< filename.Data() <<". Start time= " << obmin << ", end time= "<< obmax <<" ms"<<". Physics Packet per minute";
  Int_t  nbin   = (lastime-firstime)/60000;
  TH1F *h1 = new TH1F ("histo1", oss1.str().c_str(), nbin, obmin, obmax);
  
  //------------- Graph PscuCounter vs FileOffset ---------------------------------
  const Int_t size = 10000;
  Int_t ev=0;
  Double_t PscuCounter[size], FileOffset[size], tempo[size], PcktLenght[size];
  Int_t m=0;
  Int_t pag= (nevents/10000)+1;

  TMultiGraph *mg1 = new TMultiGraph();
  oss1.str("");
  oss1 << filename.Data() <<": PscuCounter vs FileOffset.";
  mg1->SetTitle(oss1.str().c_str());

  TMultiGraph *mg2 = new TMultiGraph();
  oss1.str("");
  oss1 << filename.Data() <<": OBT vs FileOffset.";
  mg2->SetTitle(oss1.str().c_str());

  TMultiGraph *mg3 = new TMultiGraph();
  oss2.str("");
  oss2 << filename.Data() <<": Lenght of Physic packets";
  mg3->SetTitle(oss2.str().c_str());

  TMultiGraph *mg4 = new TMultiGraph();
  oss3.str("");
  oss3 << filename.Data() <<": Physics Counter";
  mg4->SetTitle(oss3.str().c_str());

  TCanvas *finalCanv1 = new TCanvas("Header_1", base, 1280, 1024);
  finalCanv1->Divide(1,3);
  finalCanv1->SetFillColor(10);

  TCanvas *finalCanv2 = new TCanvas("Header_2", base, 1280, 1024);
  finalCanv2->Divide(1,2);
  finalCanv2->SetFillColor(10);

 /////ciclo sulle pagine////////////////////
  for (Int_t interval=0; interval<pag; interval++){

   for (Int_t l = 0; l < size; l++){     //ciclo su un sottogruppo
    headBr->GetEntry(ev+l);
    ph = eh->GetPscuHeader();  
    PscuCounter[l]= ph->GetCounter(); // = PcktCounter[l]
    FileOffset[l]=ph->GetFileOffset();
    tempo[l]=ph->GetOrbitalTime();
    PcktLenght[l]=ph->GetPacketLenght();
    h1->Fill(ph->GetOrbitalTime());  
    m=l;
   }   

   TGraph *graph1= new TGraph(m, tempo, PcktLenght);
   graph1->SetMarkerColor(2);
   graph1->SetMarkerSize(.5);
   graph1->SetMarkerStyle(21);
   mg3->Add(graph1);

   TGraph *graph2= new TGraph(m, tempo, PscuCounter);
   graph2->SetMarkerColor(4);
   graph2->SetMarkerSize(.5);
   graph2->SetMarkerStyle(21);
   mg4->Add(graph2);

   TGraph *graph3= new TGraph(m, FileOffset, PscuCounter);
   graph3->SetMarkerColor(3);
   graph3->SetMarkerSize(.5);
   graph3->SetMarkerStyle(21);
   mg1->Add(graph3);

   TGraph *graph4= new TGraph(m, FileOffset, tempo);
   graph4->SetMarkerColor(kBlue);
   graph4->SetMarkerSize(.5);
   graph4->SetMarkerStyle(21);
   mg2->Add(graph4);

   ev=ev+10000;
  }
  //------------ First Canvas ---------------------//

  finalCanv1->cd(1);
  h1->SetStats(kFALSE);
  h1->GetXaxis()->SetTitle("OBT   (ms)");
  h1->GetXaxis()->CenterTitle();
  h1->GetXaxis()->SetLabelSize(0.04);
  h1->GetYaxis()->SetTitle("Number of events ");
  h1->GetYaxis()->CenterTitle();
  h1->GetYaxis()->SetTitleSize(0.06);
  h1->GetYaxis()->SetTitleOffset(0.8);
  h1->Draw();
  
  finalCanv1->cd(2);
  mg3->Draw("AP");
  mg3->GetXaxis()->SetTitle("OBT    (ms)");
  mg3->GetXaxis()->CenterTitle();
  mg3->GetXaxis()->SetLabelSize(0.04);
  mg3->GetYaxis()->SetTitle("Lenght  (byte)");
  mg3->GetYaxis()->CenterTitle();
  mg3->GetYaxis()->SetLabelSize(0.04);
  mg3->GetYaxis()->SetTitleSize(0.06);
  mg3->GetYaxis()->SetTitleOffset(0.8);


  finalCanv1->cd(3);
  mg4->Draw("AP");
  mg4->GetXaxis()->SetTitle("OBT    (ms)");
  mg4->GetXaxis()->SetTitleSize(0.05);
  mg4->GetXaxis()->CenterTitle();
  mg4->GetXaxis()->SetLabelSize(0.04);
  mg4->GetYaxis()->SetTitle("Counter");
  mg4->GetYaxis()->SetTitleSize(0.05);
  mg4->GetYaxis()->CenterTitle();
  mg4->GetYaxis()->SetLabelSize(0.04);
  mg4->GetYaxis()->SetTitleSize(0.06);
  mg4->GetYaxis()->SetTitleOffset(0.8);

  finalCanv1->Update();
  
  oss.str("");
  oss << outDir.Data() << filename.Data();
  oss  << "_HeaderScan_1." << format.Data();
  finalCanv1->SaveAs(oss.str().c_str());
  


  //------------ Second Canvas ---------------------//
   finalCanv2->cd(1);
   mg1->Draw("AP");
   mg1->GetXaxis()->SetTitle("File Offset");
   mg1->GetXaxis()->CenterTitle();
   mg1->GetXaxis()->SetTitleSize(0.05);
   mg1->GetXaxis()->SetLabelSize(0.04);
   mg1->GetYaxis()->SetTitle("Counter");
   mg1->GetYaxis()->CenterTitle();
   mg1->GetYaxis()->SetTitleSize(0.05);
   mg1->GetYaxis()->SetLabelSize(0.04);

   finalCanv2->cd(2);
   mg2->Draw("AP");
   mg2->GetXaxis()->SetTitle("File Offset");
   mg2->GetXaxis()->CenterTitle();
   mg2->GetXaxis()->SetTitleSize(0.05);
   mg2->GetXaxis()->SetLabelSize(0.04);
   mg2->GetYaxis()->SetTitle("OBT");
   mg2->GetYaxis()->CenterTitle();
   mg2->GetYaxis()->SetTitleSize(0.05);
   mg2->GetYaxis()->SetLabelSize(0.04);

   finalCanv2->Update();

   oss1.str("");
   oss1 << outDir.Data() << filename.Data();
   oss1 << "_HeaderScan_2"<<"." << format.Data();

   finalCanv2->SaveAs(oss1.str().c_str());
  
   file->Close();
  
}

int main(int argc, char* argv[]){
  TString path;
  TString outDir     = "./";
  TString format     = "jpg";
 if (argc < 2){
    printf("You have to insert at least the file to analyze \n");
    printf("Try '--help' for more information. \n");
    exit(1);
  }  
  if (!strcmp(argv[1], "--help")){
        printf( "Usage: HeaderScan FILE [OPTION] \n");
        printf( "\t --help                 Print this help and exit \n");
        printf( "\t -outDir[path]          Path where to put the output [default ./] \n");
        printf( "\t -format[jpg|ps|gif]    Format for output files [default 'jpg'] \n");
        exit(1);
  }
  path=argv[1];
  for (int i = 2; i < argc; i++){ 
    if (!strcmp(argv[i], "-outDir")){
      if (++i >= argc){
	printf( "-outDir needs arguments. \n");
	printf( "Try '--help' for more information. \n");
	exit(1);
      } 
      else{
	outDir = argv[i];
	continue;
      }
    }  
    if (!strcmp(argv[i], "-format")){
      if (++i >= argc){
	printf( "-format needs arguments. \n");
	printf( "Try '--help' for more information. \n");
	exit(1);
      }
      else{
	format = argv[i];
	continue;
      }
    }
  }
  HeaderScan(argv[1], outDir, format);
}
