//
// FCaloQLOOK.cc -- standalone program to call the FCaloQLOOK macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/02/28)
//
// Changelog:
//
// 0.00 - 1.00 : working.
//
#include <TSystem.h>
#include <iostream>
#include <sstream>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
//
extern void FCaloQLOOK(TString, int, int, TString, TString, Bool_t, Bool_t);
extern void info();
extern void stringcopy(TString& , const TString& , Int_t , Int_t );
using namespace std;
//
void usage(){
  printf("\nUsage:\n\n FCaloQLOOK [-name] file [OPTIONS] \n");
  printf("\n file             must be in the form: /path/to/filesfromyoda/ZZZ_XXX_YYYYY_cln2.root  \n");
  printf(  "                  if in the first position \"-name\" can be omitted. \n");  
  printf("\n OPTIONS: \n");  
  printf("\n -v                  be verbose \n");  
  printf(  " -fromev from_event  first event to analyze [default = 0] \n");
  printf(  " -toev to_event      last event to analyze  [default = 0] \n");
  printf(  " -oudDir output_dir  path of the output directory [default = ./] (with or without final '/') \n");
  printf(  " -format format      format for output file (without . )[default = png] \n");
  printf(  " -interactive        shows figures on the screen [default = non-interactive] \n");
  printf(  " -wait               wait for canvas to be closed before going on [default = don't wait] \n");
  printf("\nExamples: ");
  printf("\n\nFCaloQLOOK /home/pamela/filesfromyoda/dw_050301_00100.root \n");
  printf("\nFCaloQLOOK -v -name /home/pamela/filesfromyoda/dw_050301_00100.root \n");
  printf("\nFCaloQLOOK /home/pamela/filesfromyoda/DW_050523_01600.root -v -fromev 0 -toev 0 -outDir /tmp/ -format gif \n\n");
}

int main(int numinp, char *inps[]){
  TString name;
  TString outdir = "./";
  TString format = "png";
  int fromev = 0;
  int toev = 0;
  int nul = 0;
  bool beverbose = false;
  Bool_t iactive = false;
  Bool_t w4i = false;
  //
  if ( numinp > 1 ){
    name = (TString)inps[1];
    for ( int i = 0; i < numinp; i++ ){
      
      if ( !strcmp(inps[i],"--version") ){
	info();
	return(0);
      };
      if ( !strcmp(inps[i],"-h") || !strcmp(inps[i],"--help") ){
	usage();
	return(0);
      };
      if ( !strcmp(inps[i],"-name") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	name = (TString)inps[i+1];
      };
      if ( !strcmp(inps[i],"-outDir") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	outdir = (TString)inps[i+1];
      };
      if ( !strcmp(inps[i],"-format") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	format = (TString)inps[i+1];
      };

      if ( !strcmp(inps[i],"-fromev") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	fromev = atoi(inps[i+1]);
      };
      if ( !strcmp(inps[i],"-toev") ) {
	if ( numinp-1 < i+1 ){
	  usage();
	  exit(-3);
	};
	toev = atoi(inps[i+1]);
      };     
      if ( !strcmp(inps[i],"-interactive") ) {
	iactive = true;
      };     
      if ( !strcmp(inps[i],"-wait") ) {
	w4i = true;
      };     
      if ( !strcmp(inps[i],"-v") || !strcmp(inps[i],"--verbose") ) beverbose = true;
    };
  } else {
    //
    // no input parameters exit with error, we need at least the run id.
    //
    usage();
    return(0);    
  };
  //
  if ( !beverbose ){
    //
    const string fil = gSystem->BaseName(name.Data());
    Int_t posiz = fil.find(".root");
    //
    TString file2;
    if ( posiz == -1 ){
      file2 = gSystem->BaseName(name.Data());
    } else {
      Int_t posiz2 = 0;
      stringcopy(file2,gSystem->BaseName(name.Data()),posiz2,posiz);
    };
    const char *figrec = file2;
    //
    const char *outDir = outdir;
    stringstream figsave;    
    figsave.str("");
    figsave << outDir << "/" ;
    figsave << figrec << "_CaloQLOOK.txt";
    //
    // redirect to /dev/null the stdout and stderr
    //
    nul = open(figsave.str().c_str(), O_CREAT | O_RDWR,S_IREAD | S_IWRITE);
    dup2(nul,1);
    dup2(nul,2);
  };
  printf("\n Welcome to FCaloQLOOK! \n");
  //
  FCaloQLOOK(name,fromev,toev,outdir,format,iactive,w4i);
  //
  if ( !beverbose ) close(nul);
  //
  return(0);
}
