/*
 * TriggerScanBasic
 * Author  Nagni
 * Modified by G. De Rosa
 * Version 1.2 - Modified by G. De Rosa
 * Date 27 Apr 2006
 * Version 1.4 - Modified by G. De Rosa
 * Date 26 Jun 2006: Inserted dependences on OnBoardTime and modified histogram ranges.
 * Version 1.5 - Modified by G. De Rosa
 * Date 9 Mar 2007: To read correctly the OBT changed the type of time variables from signed to unsigned
 *
 * Description:
 * Describe the performance of the Trigger.
 *
 * Parameters:
 * 	TString base            - the path to the root directory for the specific Pamela unpack session 
 * 	TString outDirectory    - the path where to save the output image (Default = base) 
 *      TString format          - the format which will be used for save the produced images (Default = "ps") 
 */

#include <TROOT.h>
#include <TFile.h>
#include <TString.h>
#include <TObjString.h>
#include <TTree.h>
#include <TBranch.h>
#include <TGraph.h>
#include <TStyle.h>
#include <TH1.h>
#include <TH1F.h>
#include <TH2S.h>
#include <TPaveText.h>
#include <TCanvas.h>
#include <TLatex.h>
#include <TGraph.h>
#include <physics/trigger/TriggerEvent.h>
#include <EventHeader.h>
#include <PscuHeader.h>
#include <iostream>

using namespace std;

char bit(int decimal, char pos)
{
  return( (decimal>>pos)%2 );
}

void TriggerScanBasic(TString base, TString outDirectory = "", TString format = ""){
 
  ULong_t lastime, firstime;
  double obmin=0.;
  double obmax=0.; 
  stringstream oss, oss1, oss2, oss3, noentries, stringa;   
  std::stringstream sst;
  if (outDirectory == "") outDirectory = base.Data();
  TString filename = ((TObjString*)base.Tokenize('/')->Last())->GetString();
  
  TFile *file  =new TFile(base.Data()) ;
  if (!file){
    printf("file not Found \n");
    return;
  }
  
  TTree *PhysicsTr = (TTree*)file->Get("Physics");
  TBranch *TrigBr = PhysicsTr->GetBranch("Trigger");
  TBranch *HeadBr = PhysicsTr->GetBranch("Header");

  pamela::EventHeader *eh = 0;
  pamela::PscuHeader  *ph = 0;
  
  pamela::trigger::TriggerEvent *triggerEvent = 0;
  
  PhysicsTr->SetBranchAddress("Trigger", &triggerEvent);
  PhysicsTr->SetBranchAddress("Header", &eh);
  
  Long64_t nevents    = TrigBr->GetEntries();
  if (nevents <= 0) {
    printf("nevents = %llu \n", nevents);
    file->Close();
    return;
  }
  
   //-------------- to know the max and min OBT ----------------------------//
   HeadBr->GetEntry(0);
   ph = eh->GetPscuHeader();
   firstime = ph->GetOrbitalTime();
   HeadBr->GetEntry(nevents);
   ph = eh->GetPscuHeader();
   lastime = ph->GetOrbitalTime();
   int i =0;
   while(i < nevents){
     HeadBr->GetEntry(i);
     ph = eh->GetPscuHeader();
     if((ph->GetOrbitalTime()) <= firstime) firstime=ph->GetOrbitalTime();
     if((ph->GetOrbitalTime()) >= lastime) lastime=ph->GetOrbitalTime();
     i++;
     }
  
  //------------------------ First histogram -----------------------------------//
  obmin=firstime;
  obmax=lastime; 
  Int_t  nbin   = (lastime-firstime)/60000; // on 1 min
  gStyle->SetOptStat(0);
  TH1F *h1 = new TH1F ("histo1", "" , nbin, obmin, obmax);
  TH1F *h2 = new TH1F ("histo2", "" , nbin, obmin, obmax);
  TH1F *h5 = new TH1F ("histo5", "" , nbin, obmin, obmax);
  TH1F *LiveTimeMean      = new TH1F("LiveTimeMean", sst.str().c_str(),nbin, obmin, obmax);
  TH1F *DeadTimeMean      = new TH1F("DeadTimeMean", sst.str().c_str(),nbin, obmin, obmax);
  //==============================================================

  /* Histo DEF */

  /*
   * S4 and Calorimeter Counters histograms
   */
  TCanvas *S4CalCanvas = new TCanvas("S4CalCanvas","S4CalCanvas", 1280, 1024);
  S4CalCanvas->Divide(1,2);
  //----------
  sst.str("");
  sst << "S4 Counters based on " << base.Data();
  //----------
  sst.str("");
  sst << "Calorimeter Rate Counters based on " << base.Data();
  TH1F *S4Cal2Histo      = new TH1F("S4Cal2Histo", sst.str().c_str(), 20, 0, 20);

  // int i  = 0;
  i = 0;
  Int_t size  = nevents;

  ULong_t UnsOBT=0;

  Double_t *time = new Double_t[size];
  Double_t *evCounter = new Double_t[size];
  Double_t *deadTime  = new Double_t[size];
  Double_t *liveTime  = new Double_t[size];
  //
  Double_t *trigrate0  = new Double_t[size];
  Double_t *trigrate1  = new Double_t[size];
  Double_t *trigrate2  = new Double_t[size];
  Double_t *trigrate3  = new Double_t[size];
  Double_t *trigrate4  = new Double_t[size];
  Double_t *trigrate5  = new Double_t[size];
  //
  Double_t *pmt1  = new Double_t[size];
  Double_t *pmt2  = new Double_t[size];
  Double_t *pmt3  = new Double_t[size];
  //
  Double_t *s4rate  = new Double_t[size];  
  //
  Double_t *pmt1_0  = new Double_t[size];
  Double_t *pmt1_1  = new Double_t[size];
  Double_t *pmt1_2  = new Double_t[size];
  Double_t *pmt1_3  = new Double_t[size];
  Double_t *pmt1_4  = new Double_t[size];
  Double_t *pmt1_5  = new Double_t[size];
  Double_t *pmt1_6  = new Double_t[size];
  Double_t *pmt1_7  = new Double_t[size];
  Double_t *pmt1_8  = new Double_t[size];
  Double_t *pmt1_9  = new Double_t[size];
  Double_t *pmt1_10 = new Double_t[size];
  Double_t *pmt1_11 = new Double_t[size];
  Double_t *pmt1_12 = new Double_t[size];
  Double_t *pmt1_13 = new Double_t[size];
  Double_t *pmt1_14 = new Double_t[size];
  Double_t *pmt1_15 = new Double_t[size];
  Double_t *pmt1_16 = new Double_t[size];
  Double_t *pmt1_17 = new Double_t[size];
  Double_t *pmt1_18 = new Double_t[size];
  Double_t *pmt1_19 = new Double_t[size];
  Double_t *pmt1_20 = new Double_t[size];
  Double_t *pmt1_21 = new Double_t[size];
  Double_t *pmt1_22 = new Double_t[size];
  Double_t *pmt1_23 = new Double_t[size];
  //
  Double_t *pmt2_0  = new Double_t[size];
  Double_t *pmt2_1  = new Double_t[size];
  Double_t *pmt2_2  = new Double_t[size];
  Double_t *pmt2_3  = new Double_t[size];
  Double_t *pmt2_4  = new Double_t[size];
  Double_t *pmt2_5  = new Double_t[size];
  Double_t *pmt2_6  = new Double_t[size];
  Double_t *pmt2_7  = new Double_t[size];
  Double_t *pmt2_8  = new Double_t[size];
  Double_t *pmt2_9  = new Double_t[size];
  Double_t *pmt2_10 = new Double_t[size];
  Double_t *pmt2_11 = new Double_t[size];
  Double_t *pmt2_12 = new Double_t[size];
  Double_t *pmt2_13 = new Double_t[size];
  Double_t *pmt2_14 = new Double_t[size];
  Double_t *pmt2_15 = new Double_t[size];
  Double_t *pmt2_16 = new Double_t[size];
  Double_t *pmt2_17 = new Double_t[size];
  Double_t *pmt2_18 = new Double_t[size];
  Double_t *pmt2_19 = new Double_t[size];
  Double_t *pmt2_20 = new Double_t[size];
  Double_t *pmt2_21 = new Double_t[size];
  Double_t *pmt2_22 = new Double_t[size];
  Double_t *pmt2_23 = new Double_t[size];
  
  //
  while(i < nevents){
    HeadBr->GetEntry(i);
    TrigBr->GetEntry(i);
    
    /* time vector fill*/
    ph           = eh->GetPscuHeader();
    UnsOBT       = ph->GetOrbitalTime();

    time[i] = UnsOBT;


    /* eventCounter vector fill*/
    evCounter[i] = triggerEvent->evcount;

    if( evCounter[i] > 1 ){
      
      /* live time vector fill*/
      liveTime[i] = 0.16 * triggerEvent->dltime[0];
      

      if (liveTime[i]<600) h1->Fill(ph->GetOrbitalTime(),liveTime[i]); 
      if (liveTime[i]<600) h2->Fill(ph->GetOrbitalTime()); 

      /* dead time vector fill*/
      deadTime[i] = 0.01 * triggerEvent->dltime[1];
      
      if (deadTime[i]<600) h5->Fill(ph->GetOrbitalTime(),deadTime[i]);
    }

    gStyle->SetStatY(0.85);

    /* PMT Plane Counters */
    
    pmt1[i] = 1.*triggerEvent->pmtpl[0];
    pmt2[i] = 1.*triggerEvent->pmtpl[1];
    pmt3[i] = 1.*triggerEvent->pmtpl[2];

    /* Trigger Rate Counters*/

    trigrate0[i] = (1/4.)*triggerEvent->trigrate[0];
    trigrate1[i] = (1/4.)*triggerEvent->trigrate[1];
    trigrate2[i] = (1/4.)*triggerEvent->trigrate[2];
    trigrate3[i] = (1/4.)*triggerEvent->trigrate[3];
    trigrate4[i] = (1/4.)*triggerEvent->trigrate[4];
    trigrate5[i] = (1/4.)*triggerEvent->trigrate[5];
    
    /* S4 and Calorimeter Counters fill*/

    s4rate[i]  = triggerEvent->s4calcount[0];
    S4Cal2Histo->Fill(triggerEvent->s4calcount[1]);
    //
        
    /* pmtcount1 */
    pmt1_0[i] = triggerEvent->pmtcount1[0];
    pmt1_1[i] = triggerEvent->pmtcount1[1];
    pmt1_2[i] = triggerEvent->pmtcount1[2];
    pmt1_3[i] = triggerEvent->pmtcount1[3];
    pmt1_4[i] = triggerEvent->pmtcount1[4];
    pmt1_5[i] = triggerEvent->pmtcount1[5];	  
    pmt1_6[i] = triggerEvent->pmtcount1[6];
    pmt1_7[i] = triggerEvent->pmtcount1[7];
    pmt1_8[i] = triggerEvent->pmtcount1[8];
    pmt1_9[i] = triggerEvent->pmtcount1[9];
    pmt1_10[i] = triggerEvent->pmtcount1[10];
    pmt1_11[i] = triggerEvent->pmtcount1[11];
    pmt1_12[i] = triggerEvent->pmtcount1[12];
    pmt1_13[i] = triggerEvent->pmtcount1[13];	  
    pmt1_14[i] = triggerEvent->pmtcount1[14];
    pmt1_15[i] = triggerEvent->pmtcount1[15];
    pmt1_16[i] = triggerEvent->pmtcount1[16];
    pmt1_17[i] = triggerEvent->pmtcount1[17];
    pmt1_18[i] = triggerEvent->pmtcount1[18];
    pmt1_19[i] = triggerEvent->pmtcount1[19];
    pmt1_20[i] = triggerEvent->pmtcount1[20];
    pmt1_21[i] = triggerEvent->pmtcount1[21];	  
    pmt1_22[i] = triggerEvent->pmtcount1[22];
    pmt1_23[i] = triggerEvent->pmtcount1[23];


    /* pmtcount2 */

    pmt2_0[i] = triggerEvent->pmtcount2[0];
    pmt2_1[i] = triggerEvent->pmtcount2[1];
    pmt2_2[i] = triggerEvent->pmtcount2[2];
    pmt2_3[i] = triggerEvent->pmtcount2[3];
    pmt2_4[i] = triggerEvent->pmtcount2[4];
    pmt2_5[i] = triggerEvent->pmtcount2[5];	  
    pmt2_6[i] = triggerEvent->pmtcount2[6];
    pmt2_7[i] = triggerEvent->pmtcount2[7];
    pmt2_8[i] = triggerEvent->pmtcount2[8];
    pmt2_9[i] = triggerEvent->pmtcount2[9];
    pmt2_10[i] = triggerEvent->pmtcount2[10];
    pmt2_11[i] = triggerEvent->pmtcount2[11];
    pmt2_12[i] = triggerEvent->pmtcount2[12];
    pmt2_13[i] = triggerEvent->pmtcount2[13];	  
    pmt2_14[i] = triggerEvent->pmtcount2[14];
    pmt2_15[i] = triggerEvent->pmtcount2[15];
    pmt2_16[i] = triggerEvent->pmtcount2[16];
    pmt2_17[i] = triggerEvent->pmtcount2[17];
    pmt2_18[i] = triggerEvent->pmtcount2[18];
    pmt2_19[i] = triggerEvent->pmtcount2[19];
    pmt2_20[i] = triggerEvent->pmtcount2[20];
    pmt2_21[i] = triggerEvent->pmtcount2[21];	  
    pmt2_22[i] = triggerEvent->pmtcount2[22];
    pmt2_23[i] = triggerEvent->pmtcount2[23];
    //
    i++;
  }
  
  gStyle->SetOptStat(111111);
  gStyle->SetStatH(0.15);
  gStyle->SetStatW(0.15);

  /*
   * Event Counter graph
   */
  TCanvas *EvCounterCanvas = new TCanvas("EvCounterCanvas","EvCounterCanvas", 1280, 1024);
  //----------
  sst.str("");	
  sst << "Event Counter";
  TGraph *evCounterGraph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)evCounter);
  evCounterGraph->SetTitle(sst.str().c_str());
  evCounterGraph->GetXaxis()->SetTitle("OnBoardTime");
  evCounterGraph->GetXaxis()->CenterTitle();
  evCounterGraph->Draw("APL");

  /*
   * Dead and Live time graphs
   */
  TCanvas *DeadLiveCanvas = new TCanvas("DeadLiveCanvas","DeadLiveCanvas", 1280, 1024);
  DeadLiveCanvas->Divide(1,2);
  //----------
  sst.str("");
  sst << "Graph of Dead Time vs OBT based on " << base.Data();
  TGraph *DeadTimeGraph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)deadTime);
  DeadLiveCanvas->cd(1);
  sst.str("");
  sst << "Dead Time";
  DeadTimeGraph->SetTitle(sst.str().c_str());
  DeadTimeGraph->SetFillColor(2);
  DeadTimeGraph->GetXaxis()->SetTitle("OnBoardTime");
  DeadTimeGraph->GetXaxis()->CenterTitle();
  DeadTimeGraph->GetYaxis()->SetTitle("DeadTime(ms)");
  DeadTimeGraph->GetYaxis()->CenterTitle();
  //  DeadTimeGraph->SetMaximum(100);
  DeadTimeGraph->Draw("AP");
  //----------
  sst.str("");
  sst << "Graph of Live Time vs OBT based on " << base.Data();
  TGraph *LiveTimeGraph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)liveTime);
  DeadLiveCanvas->cd(2);
  sst.str("");
  sst << "Live Time";
  LiveTimeGraph->SetTitle(sst.str().c_str());
  LiveTimeGraph->SetFillColor(2);
  LiveTimeGraph->GetXaxis()->SetTitle("OnBoardTime");
  LiveTimeGraph->GetXaxis()->CenterTitle();
  LiveTimeGraph->GetYaxis()->SetTitle("LiveTime(ms)");
  LiveTimeGraph->GetYaxis()->CenterTitle();
  LiveTimeGraph->Draw("AP");

  /*
   * Average Dead and Live time graphs
   */
  TCanvas *MeanLiveDeadCanvas = new TCanvas("MeanLiveDeadCanvas","MeanLiveDeadCanvas", 1280, 1024);
  MeanLiveDeadCanvas->Divide(1,2);
  
  MeanLiveDeadCanvas->cd(1);
  DeadTimeMean->Divide(h5,h2);
  sst.str("");
  sst << "Average Dead Time";
  DeadTimeMean->GetXaxis()->SetTitle("OnBoardTime");
  DeadTimeMean->GetXaxis()->CenterTitle();
  DeadTimeMean->GetYaxis()->SetTitle("Average Dead Time (over 1min)");
  DeadTimeMean->GetYaxis()->CenterTitle();
  DeadTimeMean->Draw();
  MeanLiveDeadCanvas->cd(2);
  LiveTimeMean->Divide(h1,h2);
  sst.str("");
  sst << "Average Live Time";
  LiveTimeMean->GetXaxis()->SetTitle("OnBoardTime");
  LiveTimeMean->GetXaxis()->CenterTitle();
  LiveTimeMean->GetYaxis()->SetTitle("Average Live Time (over 1min)");
  LiveTimeMean->GetYaxis()->CenterTitle();
  LiveTimeMean->Draw();

  /*	
   * PMT Plane Counters Graph
   */
  
  TCanvas *PMTCanvas = new TCanvas("PMTCanvas","PMTCanvas", 1280, 1024);
  PMTCanvas->Divide(1,3);
  //----------
  sst.str("");
  sst << "Graph of PMT Plane Counters (S11 AND S12) vs OBT based on " << base.Data();
  TGraph *PMT1Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1);
  PMTCanvas->cd(1);
  sst.str("");
  sst << "PMT Plane Counters (S11 AND S12)";
  PMT1Graph->SetTitle(sst.str().c_str());
  PMT1Graph->SetFillColor(2);
  PMT1Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1Graph->GetXaxis()->CenterTitle();
  PMT1Graph->GetYaxis()->SetTitle("PMT Plane Counters (over 60 ms)");
  PMT1Graph->GetYaxis()->CenterTitle();
  PMT1Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "Graph PMT Plane Counters (S21 AND S22) vs OBT based on " << base.Data();
  TGraph *PMT2Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2);
  PMTCanvas->cd(2);
  sst.str("");
  sst << "PMT Plane Counters (S21 AND S22)";
  PMT2Graph->SetTitle(sst.str().c_str());
  PMT2Graph->SetFillColor(2);
  PMT2Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2Graph->GetXaxis()->CenterTitle();
  PMT2Graph->GetYaxis()->SetTitle("PMT Plane Counters (over 60 ms)");
  PMT2Graph->GetYaxis()->CenterTitle();
  PMT2Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "Graph PMT Plane Counters (S31 AND S32) vs OBT based on " << base.Data();
  TGraph *PMT3Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt3);
  PMTCanvas->cd(3);
  sst.str("");
  sst << "PMT Plane Counters (S31 AND S32)";
  PMT3Graph->SetTitle(sst.str().c_str());
  PMT3Graph->SetFillColor(2);
  PMT3Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT3Graph->GetXaxis()->CenterTitle();
  PMT3Graph->GetYaxis()->SetTitle("PMT Plane Rate Counters (over 60 ms)");
  PMT3Graph->GetYaxis()->CenterTitle();
  PMT3Graph->Draw("AP");
  //
  //----------

  /*	
   * Trigger Rate Counters draw
   */
  
  TCanvas *TrigRate1Canvas = new TCanvas("TrigRate1Canvas","TrigRate1Canvas", 1280, 1024);
  TrigRate1Canvas->Divide(1,3);
  //----------
  sst.str("");
  sst << "Graph of Trigger Rate Counters (S11 OR S12) AND (S21 OR S22) AND (S31 OR S32) vs OBT based on " << base.Data();

  TGraph *TrigRate0Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)trigrate0);
  TrigRate1Canvas->cd(1);
  sst.str("");
  sst << "Trigger Rate Counters (S11 OR S12) AND (S21 OR S22) AND (S31 OR S32)";
  TrigRate0Graph->SetTitle(sst.str().c_str());
  TrigRate0Graph->SetFillColor(2);
  TrigRate0Graph->GetXaxis()->SetTitle("OnBoardTime");
  TrigRate0Graph->GetXaxis()->CenterTitle();
  TrigRate0Graph->GetYaxis()->SetTitle("Trigger Rate Counters (Hz)");
  TrigRate0Graph->GetYaxis()->CenterTitle();
  TrigRate0Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "Graph Trigger Rate Counters (S11 AND S12) AND (S21 AND S22) AND (S31 AND S32) vs OBT based on " << base.Data();
  TGraph *TrigRate1Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)trigrate1);
  TrigRate1Canvas->cd(2);
  sst.str("");
  sst << "Trigger Rate Counters (S11 AND S12) AND (S21 AND S22) AND (S31 AND S32)";
  TrigRate1Graph->SetTitle(sst.str().c_str());
  TrigRate1Graph->SetFillColor(2);
  TrigRate1Graph->GetXaxis()->SetTitle("OnBoardTime");
  TrigRate1Graph->GetXaxis()->CenterTitle();
  TrigRate1Graph->GetYaxis()->SetTitle("Trigger Rate Counters (Hz)");
  TrigRate1Graph->GetYaxis()->CenterTitle();
  TrigRate1Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "Graph Trigger Rate Counters  (S21 OR S22) AND (S31 OR S32) vs OBT based on " << base.Data();
  TGraph *TrigRate2Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)trigrate2);
  TrigRate1Canvas->cd(3);
  sst.str("");
  sst << "Trigger Rate Counters (S21 OR S22) AND (S31 OR S32) ";
  TrigRate2Graph->SetTitle(sst.str().c_str());
  TrigRate2Graph->SetFillColor(2);
  TrigRate2Graph->GetXaxis()->SetTitle("OnBoardTime");
  TrigRate2Graph->GetXaxis()->CenterTitle();
  TrigRate2Graph->GetYaxis()->SetTitle("Trigger Rate Counters (Hz)");
  TrigRate2Graph->GetYaxis()->CenterTitle();
  TrigRate2Graph->Draw("AP");
  //
  //----------
  //
  TCanvas *TrigRate2Canvas = new TCanvas("TrigRate2Canvas","TrigRate2Canvas", 1280, 1024);
  TrigRate2Canvas->Divide(1,3);
  //----------
  sst.str("");
  sst << "Graph of Trigger Rate Counters (S21 AND S22) AND (S31 AND S32) vs OBT based on " << base.Data();

  TGraph *TrigRate3Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)trigrate3);
  TrigRate2Canvas->cd(1);
  sst.str("");
  sst << "Trigger Rate Counters (S21 AND S22) AND (S31 AND S32)";
  TrigRate3Graph->SetTitle(sst.str().c_str());
  TrigRate3Graph->SetFillColor(2);
  TrigRate3Graph->GetXaxis()->SetTitle("OnBoardTime");
  TrigRate3Graph->GetXaxis()->CenterTitle();
  TrigRate3Graph->GetYaxis()->SetTitle("Trigger Rate Counters (Hz)");
  TrigRate3Graph->GetYaxis()->CenterTitle();
  TrigRate3Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "Graph Trigger Rate Counters S12 AND (S21 AND S22) vs OBT based on " << base.Data();
  TGraph *TrigRate4Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)trigrate4);
  TrigRate2Canvas->cd(2);
  sst.str("");
  sst << "Trigger Rate Counters S12 AND (S21 AND S22)";
  TrigRate4Graph->SetTitle(sst.str().c_str());
  TrigRate4Graph->SetFillColor(2);
  TrigRate4Graph->GetXaxis()->SetTitle("OnBoardTime");
  TrigRate4Graph->GetXaxis()->CenterTitle();
  TrigRate4Graph->GetYaxis()->SetTitle("Trigger Rate Counters (Hz)");
  TrigRate4Graph->GetYaxis()->CenterTitle();
  TrigRate4Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "Graph Trigger Rate Counters (S11 OR S12) AND (S31 OR S32) vs OBT based on " << base.Data();
  TGraph *TrigRate5Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)trigrate5);
  TrigRate2Canvas->cd(3);
  sst.str("");
  sst << "Trigger Rate Counters (S11 OR S12) AND (S31 OR S32)";
  TrigRate5Graph->SetTitle(sst.str().c_str());
  TrigRate5Graph->SetFillColor(2);
  TrigRate5Graph->GetXaxis()->SetTitle("OnBoardTime");
  TrigRate5Graph->GetXaxis()->CenterTitle();
  TrigRate5Graph->GetYaxis()->SetTitle("Trigger Rate Counters (Hz)");
  TrigRate5Graph->GetYaxis()->CenterTitle();
  TrigRate5Graph->Draw("AP");
  //----------

  gStyle->SetOptStat("mr");

  /* S4 and Calorimeter Counters draw*/
  TGraph *s4RateGraph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)s4rate);
  S4CalCanvas->cd(1);
  sst.str("");
  sst << "S4 Trigger Rate Counters";
  s4RateGraph->SetTitle(sst.str().c_str());
  s4RateGraph->SetFillColor(2);
  s4RateGraph->GetXaxis()->SetTitle("OnBoardTime");
  s4RateGraph->GetXaxis()->CenterTitle();
  s4RateGraph->GetYaxis()->SetTitle("Trigger Rate Counters (Hz)");
  s4RateGraph->GetYaxis()->CenterTitle();
  s4RateGraph->Draw("AP");
  //----------
  S4CalCanvas->cd(2);
  gPad->SetLogy(1);
  S4Cal2Histo->GetXaxis()->SetTitle("Hz");
  S4Cal2Histo->Draw();
  //  
  //
  //  
  gStyle->SetOptStat("mr");
  gStyle->SetStatH(0.3);
  gStyle->SetStatW(0.3);
  

  //----------  
  TCanvas *RatePMT1 = new TCanvas("RatePMT1", "Rate PMT S11A", 1);
  RatePMT1->Divide (3,3);
  //----------  
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_0Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_0);
  RatePMT1->cd(1);
  sst.str("");
  sst << "PMT S111A";
  PMT1_0Graph->SetTitle(sst.str().c_str());
  PMT1_0Graph->SetFillColor(2);
  PMT1_0Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_0Graph->GetXaxis()->CenterTitle();
  PMT1_0Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_0Graph->GetYaxis()->CenterTitle();
  PMT1_0Graph->Draw("AP");
  //delete PMT1_0Graph;
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_1Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_1);
  RatePMT1->cd(2);
  sst.str("");
  sst << "PMT S112A";
  PMT1_1Graph->SetTitle(sst.str().c_str());
  PMT1_1Graph->SetFillColor(2);
  PMT1_1Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_1Graph->GetXaxis()->CenterTitle();
  PMT1_1Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_1Graph->GetYaxis()->CenterTitle();
  PMT1_1Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_2Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_2);
  RatePMT1->cd(3);
  sst.str("");
  sst << "PMT S113A";
  PMT1_2Graph->SetTitle(sst.str().c_str());
  PMT1_2Graph->SetFillColor(2);
  PMT1_2Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_2Graph->GetXaxis()->CenterTitle();
  PMT1_2Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_2Graph->GetYaxis()->CenterTitle();
  PMT1_2Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_3Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_3);
  RatePMT1->cd(4);
  sst.str("");
  sst << "PMT S114A";
  PMT1_3Graph->SetTitle(sst.str().c_str());
  PMT1_3Graph->SetFillColor(2);
  PMT1_3Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_3Graph->GetXaxis()->CenterTitle();
  PMT1_3Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_3Graph->GetYaxis()->CenterTitle();
  PMT1_3Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_4Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_4);
  RatePMT1->cd(5);
  sst.str("");
  sst << "PMT S115A";
  PMT1_4Graph->SetTitle(sst.str().c_str());
  PMT1_4Graph->SetFillColor(2);
  PMT1_4Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_4Graph->GetXaxis()->CenterTitle();
  PMT1_4Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_4Graph->GetYaxis()->CenterTitle();
  PMT1_4Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_5Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_5);
  RatePMT1->cd(6);
  sst.str("");
  sst << "PMT S116A";
  PMT1_5Graph->SetTitle(sst.str().c_str());
  PMT1_5Graph->SetFillColor(2);
  PMT1_5Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_5Graph->GetXaxis()->CenterTitle();
  PMT1_5Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_5Graph->GetYaxis()->CenterTitle();
  PMT1_5Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_6Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_6);
  RatePMT1->cd(7);
  sst.str("");
  sst << "PMT S117A";
  PMT1_6Graph->SetTitle(sst.str().c_str());
  PMT1_6Graph->SetFillColor(2);
  PMT1_6Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_6Graph->GetXaxis()->CenterTitle();
  PMT1_6Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_6Graph->GetYaxis()->CenterTitle();
  PMT1_6Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_7Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_7);
  RatePMT1->cd(8);
  sst.str("");
  sst << "PMT S118A";
  PMT1_7Graph->SetTitle(sst.str().c_str());
  PMT1_7Graph->SetFillColor(2);
  PMT1_7Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_7Graph->GetXaxis()->CenterTitle();
  PMT1_7Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_7Graph->GetYaxis()->CenterTitle();
  PMT1_7Graph->Draw("AP");

  ////////////////

  TCanvas *RatePMT2 = new TCanvas("RatePMT2", "Rate PMT S11B", 1);
  RatePMT2->Divide (3,3);
  //----------  
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_8Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_8);
  RatePMT2->cd(1);
  sst.str("");
  sst << "PMT S111B";
  PMT1_8Graph->SetTitle(sst.str().c_str());
  PMT1_8Graph->SetFillColor(2);
  PMT1_8Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_8Graph->GetXaxis()->CenterTitle();
  PMT1_8Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_8Graph->GetYaxis()->CenterTitle();
  PMT1_8Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_9Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_9);
  RatePMT2->cd(2);
  sst.str("");
  sst << "PMT S112B";
  PMT1_9Graph->SetTitle(sst.str().c_str());
  PMT1_9Graph->SetFillColor(2);
  PMT1_9Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_9Graph->GetXaxis()->CenterTitle();
  PMT1_9Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_9Graph->GetYaxis()->CenterTitle();
  PMT1_9Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_10Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_10);
  RatePMT2->cd(3);
  sst.str("");
  sst << "PMT S113B";
  PMT1_10Graph->SetTitle(sst.str().c_str());
  PMT1_10Graph->SetFillColor(2);
  PMT1_10Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_10Graph->GetXaxis()->CenterTitle();
  PMT1_10Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_10Graph->GetYaxis()->CenterTitle();
  PMT1_10Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_11Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_11);
  RatePMT2->cd(4);
  sst.str("");
  sst << "PMT S114B";
  PMT1_11Graph->SetTitle(sst.str().c_str());
  PMT1_11Graph->SetFillColor(2);
  PMT1_11Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_11Graph->GetXaxis()->CenterTitle();
  PMT1_11Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_11Graph->GetYaxis()->CenterTitle();
  PMT1_11Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_12Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_12);
  RatePMT2->cd(5);
  sst.str("");
  sst << "PMT S115B";
  PMT1_12Graph->SetTitle(sst.str().c_str());
  PMT1_12Graph->SetFillColor(2);
  PMT1_12Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_12Graph->GetXaxis()->CenterTitle();
  PMT1_12Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_12Graph->GetYaxis()->CenterTitle();
  PMT1_12Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_13Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_13);
  RatePMT2->cd(6);
  sst.str("");
  sst << "PMT S116B";
  PMT1_13Graph->SetTitle(sst.str().c_str());
  PMT1_13Graph->SetFillColor(2);
  PMT1_13Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_13Graph->GetXaxis()->CenterTitle();
  PMT1_13Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_13Graph->GetYaxis()->CenterTitle();
  PMT1_13Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_14Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_14);
  RatePMT2->cd(7);
  sst.str("");
  sst << "PMT S117B";
  PMT1_14Graph->SetTitle(sst.str().c_str());
  PMT1_14Graph->SetFillColor(2);
  PMT1_14Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_14Graph->GetXaxis()->CenterTitle();
  PMT1_14Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_14Graph->GetYaxis()->CenterTitle();
  PMT1_14Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_15Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_15);
  RatePMT2->cd(8);
  sst.str("");
  sst << "PMT S118B";
  PMT1_15Graph->SetTitle(sst.str().c_str());
  PMT1_15Graph->SetFillColor(2);
  PMT1_15Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_15Graph->GetXaxis()->CenterTitle();
  PMT1_15Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_15Graph->GetYaxis()->CenterTitle();
  PMT1_15Graph->Draw("AP");

  ///////////////


  TCanvas *RatePMT3 = new TCanvas("RatePMT3", "Rate PMT S11B", 1);
  RatePMT3->Divide (3,4);
  //----------  
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_16Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_16);
  RatePMT3->cd(1);
  sst.str("");
  sst << "PMT S121A";
  PMT1_16Graph->SetTitle(sst.str().c_str());
  PMT1_16Graph->SetFillColor(2);
  PMT1_16Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_16Graph->GetXaxis()->CenterTitle();
  PMT1_16Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_16Graph->GetYaxis()->CenterTitle();
  PMT1_16Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_17Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_17);
  RatePMT3->cd(2);
  sst.str("");
  sst << "PMT S122A";
  PMT1_17Graph->SetTitle(sst.str().c_str());
  PMT1_17Graph->SetFillColor(2);
  PMT1_17Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_17Graph->GetXaxis()->CenterTitle();
  PMT1_17Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_17Graph->GetYaxis()->CenterTitle();
  PMT1_17Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_18Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_18);
  RatePMT3->cd(3);
  sst.str("");
  sst << "PMT S123A";
  PMT1_18Graph->SetTitle(sst.str().c_str());
  PMT1_18Graph->SetFillColor(2);
  PMT1_18Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_18Graph->GetXaxis()->CenterTitle();
  PMT1_18Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_18Graph->GetYaxis()->CenterTitle();
  PMT1_18Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_19Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_19);
  RatePMT3->cd(4);
  sst.str("");
  sst << "PMT S124A";
  PMT1_19Graph->SetTitle(sst.str().c_str());
  PMT1_19Graph->SetFillColor(2);
  PMT1_19Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_19Graph->GetXaxis()->CenterTitle();
  PMT1_19Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_19Graph->GetYaxis()->CenterTitle();
  PMT1_19Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_20Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_20);
  RatePMT3->cd(5);
  sst.str("");
  sst << "PMT S125A";
  PMT1_20Graph->SetTitle(sst.str().c_str());
  PMT1_20Graph->SetFillColor(2);
  PMT1_20Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_20Graph->GetXaxis()->CenterTitle();
  PMT1_20Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_20Graph->GetYaxis()->CenterTitle();
  PMT1_20Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_21Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_21);
  RatePMT3->cd(6);
  sst.str("");
  sst << "PMT S126A";
  PMT1_21Graph->SetTitle(sst.str().c_str());
  PMT1_21Graph->SetFillColor(2);
  PMT1_21Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_21Graph->GetXaxis()->CenterTitle();
  PMT1_21Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_21Graph->GetYaxis()->CenterTitle();
  PMT1_21Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_22Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_22);
  RatePMT3->cd(7);
  sst.str("");
  sst << "PMT S121B";
  PMT1_22Graph->SetTitle(sst.str().c_str());
  PMT1_22Graph->SetFillColor(2);
  PMT1_22Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_22Graph->GetXaxis()->CenterTitle();
  PMT1_22Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_22Graph->GetYaxis()->CenterTitle();
  PMT1_22Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT1_23Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt1_23);
  RatePMT3->cd(8);
  sst.str("");
  sst << "PMT S122B";
  PMT1_23Graph->SetTitle(sst.str().c_str());
  PMT1_23Graph->SetFillColor(2);
  PMT1_23Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT1_23Graph->GetXaxis()->CenterTitle();
  PMT1_23Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT1_23Graph->GetYaxis()->CenterTitle();
  PMT1_23Graph->Draw("AP");

  /////////////////////////

  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_0Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_0);
  RatePMT3->cd(9);
  sst.str("");
  sst << "PMT S123B";
  PMT2_0Graph->SetTitle(sst.str().c_str());
  PMT2_0Graph->SetFillColor(2);
  PMT2_0Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_0Graph->GetXaxis()->CenterTitle();
  PMT2_0Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_0Graph->GetYaxis()->CenterTitle();
  PMT2_0Graph->Draw("AP");

  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_1Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_1);
  RatePMT3->cd(10);
  sst.str("");
  sst << "PMT S124B";
  PMT2_1Graph->SetTitle(sst.str().c_str());
  PMT2_1Graph->SetFillColor(2);
  PMT2_1Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_1Graph->GetXaxis()->CenterTitle();
  PMT2_1Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_1Graph->GetYaxis()->CenterTitle();
  PMT2_1Graph->Draw("AP");

  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_2Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_2);
  RatePMT3->cd(11);
  sst.str("");
  sst << "PMT S125B";
  PMT2_2Graph->SetTitle(sst.str().c_str());
  PMT2_2Graph->SetFillColor(2);
  PMT2_2Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_2Graph->GetXaxis()->CenterTitle();
  PMT2_2Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_2Graph->GetYaxis()->CenterTitle();
  PMT2_2Graph->Draw("AP");

  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_3Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_3);
  RatePMT3->cd(12);
  sst.str("");
  sst << "PMT S126B";
  PMT2_3Graph->SetTitle(sst.str().c_str());
  PMT2_3Graph->SetFillColor(2);
  PMT2_3Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_3Graph->GetXaxis()->CenterTitle();
  PMT2_3Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_3Graph->GetYaxis()->CenterTitle();
  PMT2_3Graph->Draw("AP");

  ////////////////////


  TCanvas *RatePMT4 = new TCanvas("RatePMT4", "Rate PMT S11B", 1);
  RatePMT4->Divide (3,3);
  //----------  
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_4Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_4);
  RatePMT4->cd(1);
  sst.str("");
  sst << "PMT S211A";
  PMT2_4Graph->SetTitle(sst.str().c_str());
  PMT2_4Graph->SetFillColor(2);
  PMT2_4Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_4Graph->GetXaxis()->CenterTitle();
  PMT2_4Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_4Graph->GetYaxis()->CenterTitle();
  PMT2_4Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_5Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_5);
  RatePMT4->cd(2);
  sst.str("");
  sst << "PMT S212A";
  PMT2_5Graph->SetTitle(sst.str().c_str());
  PMT2_5Graph->SetFillColor(2);
  PMT2_5Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_5Graph->GetXaxis()->CenterTitle();
  PMT2_5Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_5Graph->GetYaxis()->CenterTitle();
  PMT2_5Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_6Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_6);
  RatePMT4->cd(3);
  sst.str("");
  sst << "PMT S211B";
  PMT2_6Graph->SetTitle(sst.str().c_str());
  PMT2_6Graph->SetFillColor(2);
  PMT2_6Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_6Graph->GetXaxis()->CenterTitle();
  PMT2_6Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_6Graph->GetYaxis()->CenterTitle();
  PMT2_6Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_7Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_7);
  RatePMT4->cd(4);
  sst.str("");
  sst << "PMT S212B";
  PMT2_7Graph->SetTitle(sst.str().c_str());
  PMT2_7Graph->SetFillColor(2);
  PMT2_7Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_7Graph->GetXaxis()->CenterTitle();
  PMT2_7Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_7Graph->GetYaxis()->CenterTitle();
  PMT2_7Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_8Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_8);
  RatePMT4->cd(5);
  sst.str("");
  sst << "PMT S221A";
  PMT2_8Graph->SetTitle(sst.str().c_str());
  PMT2_8Graph->SetFillColor(2);
  PMT2_8Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_8Graph->GetXaxis()->CenterTitle();
  PMT2_8Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_8Graph->GetYaxis()->CenterTitle();
  PMT2_8Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_9Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_9);
  RatePMT4->cd(6);
  sst.str("");
  sst << "PMT S222A";
  PMT2_9Graph->SetTitle(sst.str().c_str());
  PMT2_9Graph->SetFillColor(2);
  PMT2_9Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_9Graph->GetXaxis()->CenterTitle();
  PMT2_9Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_9Graph->GetYaxis()->CenterTitle();
  PMT2_9Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_10Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_10);
  RatePMT4->cd(7);
  sst.str("");
  sst << "PMT S221B";
  PMT2_10Graph->SetTitle(sst.str().c_str());
  PMT2_10Graph->SetFillColor(2);
  PMT2_10Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_10Graph->GetXaxis()->CenterTitle();
  PMT2_10Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_10Graph->GetYaxis()->CenterTitle();
  PMT2_10Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_11Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_11);
  RatePMT4->cd(8);
  sst.str("");
  sst << "PMT S222B ";
  PMT2_11Graph->SetTitle(sst.str().c_str());
  PMT2_11Graph->SetFillColor(2);
  PMT2_11Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_11Graph->GetXaxis()->CenterTitle();
  PMT2_11Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_11Graph->GetYaxis()->CenterTitle();
  PMT2_11Graph->Draw("AP");

  /////////////////////////


  TCanvas *RatePMT5 = new TCanvas("RatePMT5", "Rate PMT S311A", 1);
  RatePMT5->Divide (3,4);
  //----------  
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_12Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_12);
  RatePMT5->cd(1);
  sst.str("");
  sst << "PMT S311A ";
  PMT2_12Graph->SetTitle(sst.str().c_str());
  PMT2_12Graph->SetFillColor(2);
  PMT2_12Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_12Graph->GetXaxis()->CenterTitle();
  PMT2_12Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_12Graph->GetYaxis()->CenterTitle();
  PMT2_12Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_13Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_13);
  RatePMT5->cd(2);
  sst.str("");
  sst << "PMT S312A";
  PMT2_13Graph->SetTitle(sst.str().c_str());
  PMT2_13Graph->SetFillColor(2);
  PMT2_13Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_13Graph->GetXaxis()->CenterTitle();
  PMT2_13Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_13Graph->GetYaxis()->CenterTitle();
  PMT2_13Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_14Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_14);
  RatePMT5->cd(3);
  sst.str("");
  sst << "PMT S313A";
  PMT2_14Graph->SetTitle(sst.str().c_str());
  PMT2_14Graph->SetFillColor(2);
  PMT2_14Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_14Graph->GetXaxis()->CenterTitle();
  PMT2_14Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_14Graph->GetYaxis()->CenterTitle();
  PMT2_14Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_15Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_15);
  RatePMT5->cd(4);
  sst.str("");
  sst << "PMT S311B";
  PMT2_15Graph->SetTitle(sst.str().c_str());
  PMT2_15Graph->SetFillColor(2);
  PMT2_15Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_15Graph->GetXaxis()->CenterTitle();
  PMT2_15Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_15Graph->GetYaxis()->CenterTitle();
  PMT2_15Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_16Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_16);
  RatePMT5->cd(5);
  sst.str("");
  sst << "PMT S312B";
  PMT2_16Graph->SetTitle(sst.str().c_str());
  PMT2_16Graph->SetFillColor(2);
  PMT2_16Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_16Graph->GetXaxis()->CenterTitle();
  PMT2_16Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_16Graph->GetYaxis()->CenterTitle();
  PMT2_16Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_17Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_17);
  RatePMT5->cd(6);
  sst.str("");
  sst << "PMT S313B";
  PMT2_17Graph->SetTitle(sst.str().c_str());
  PMT2_17Graph->SetFillColor(2);
  PMT2_17Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_17Graph->GetXaxis()->CenterTitle();
  PMT2_17Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_17Graph->GetYaxis()->CenterTitle();
  PMT2_17Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_18Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_18);
  RatePMT5->cd(7);
  sst.str("");
  sst << "PMT S321A";
  PMT2_18Graph->SetTitle(sst.str().c_str());
  PMT2_18Graph->SetFillColor(2);
  PMT2_18Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_18Graph->GetXaxis()->CenterTitle();
  PMT2_18Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_18Graph->GetYaxis()->CenterTitle();
  PMT2_18Graph->Draw("AP");
  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_19Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_19);
  RatePMT5->cd(8);
  sst.str("");
  sst << "PMT S322A";
  PMT2_19Graph->SetTitle(sst.str().c_str());
  PMT2_19Graph->SetFillColor(2);
  PMT2_19Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_19Graph->GetXaxis()->CenterTitle();
  PMT2_19Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_19Graph->GetYaxis()->CenterTitle();
  PMT2_19Graph->Draw("AP");

  /////////////////////////

  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_20Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_20);
  RatePMT5->cd(9);
  sst.str("");
  sst << "PMT S323A";
  PMT2_20Graph->SetTitle(sst.str().c_str());
  PMT2_20Graph->SetFillColor(2);
  PMT2_20Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_20Graph->GetXaxis()->CenterTitle();
  PMT2_20Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_20Graph->GetYaxis()->CenterTitle();
  PMT2_20Graph->Draw("AP");

  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_21Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_21);
  RatePMT5->cd(10);
  sst.str("");
  sst << "PMT S321B";
  PMT2_21Graph->SetTitle(sst.str().c_str());
  PMT2_21Graph->SetFillColor(2);
  PMT2_21Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_21Graph->GetXaxis()->CenterTitle();
  PMT2_21Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_21Graph->GetYaxis()->CenterTitle();
  PMT2_21Graph->Draw("AP");

  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_22Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_22);
  RatePMT5->cd(11);
  sst.str("");
  sst << "PMT S322B";
  PMT2_22Graph->SetTitle(sst.str().c_str());
  PMT2_22Graph->SetFillColor(2);
  PMT2_22Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_22Graph->GetXaxis()->CenterTitle();
  PMT2_22Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_22Graph->GetYaxis()->CenterTitle();
  PMT2_22Graph->Draw("AP");

  //----------
  sst.str("");
  sst << "pmtcount1[0] vs OBT based on " << base.Data();
  TGraph *PMT2_23Graph   = new TGraph(nevents, (const Double_t*)time, (const Double_t*)pmt2_23);
  RatePMT5->cd(12);
  sst.str("");
  sst << "PMT S323B";
  PMT2_23Graph->SetTitle(sst.str().c_str());
  PMT2_23Graph->SetFillColor(2);
  PMT2_23Graph->GetXaxis()->SetTitle("OnBoardTime");
  PMT2_23Graph->GetXaxis()->CenterTitle();
  PMT2_23Graph->GetYaxis()->SetTitle("PMT Counters");
  PMT2_23Graph->GetYaxis()->CenterTitle();
  PMT2_23Graph->Draw("AP");

  
  // print the output
  const char *saveas = format;
  if ( !strcmp(saveas,"ps") ) {
    // ------print the ps
    
    gStyle->SetOptStat(111111);

    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic." << saveas  << "(";
    EvCounterCanvas->Print(sst.str().c_str());
    DeadLiveCanvas->Print(sst.str().c_str());
    MeanLiveDeadCanvas->Print(sst.str().c_str());
    PMTCanvas->Print(sst.str().c_str());
    TrigRate1Canvas->Print(sst.str().c_str());
    TrigRate2Canvas->Print(sst.str().c_str());

    gStyle->SetOptStat("mr");
    S4CalCanvas->Print(sst.str().c_str());

    gStyle->SetOptStat("mr");
    RatePMT1->Print(sst.str().c_str());
    RatePMT2->Print(sst.str().c_str());
    RatePMT3->Print(sst.str().c_str());
    RatePMT4->Print(sst.str().c_str());
    //
    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic." << saveas << ")";    
    RatePMT5->Print(sst.str().c_str());

  } else {

    gStyle->SetOptStat(111111);

    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic1." << saveas;
    EvCounterCanvas->SaveAs(sst.str().c_str());

    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic2." << saveas;
    DeadLiveCanvas->SaveAs(sst.str().c_str());

    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic3." << saveas;
    MeanLiveDeadCanvas->SaveAs(sst.str().c_str());
    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic4." << saveas;
    PMTCanvas->SaveAs(sst.str().c_str());
    
    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic5." << saveas;
    TrigRate1Canvas->SaveAs(sst.str().c_str());

    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic6." << saveas;
    TrigRate2Canvas->SaveAs(sst.str().c_str());
    
    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic7." << saveas;
    S4CalCanvas->SaveAs(sst.str().c_str());

    gStyle->SetOptStat("mr");

    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic8." << saveas;
    RatePMT1->SaveAs(sst.str().c_str());

    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic9." << saveas;
    RatePMT2->SaveAs(sst.str().c_str());

    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic10." << saveas;
    RatePMT3->SaveAs(sst.str().c_str());

    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic11." << saveas;
    RatePMT4->SaveAs(sst.str().c_str());
    
    gStyle->SetOptStat("mr");

    sst.str("");
    sst << outDirectory.Data() << filename.Data() << "TriggerScanBasic12." << saveas;
    RatePMT5->SaveAs(sst.str().c_str());
    
  }

}


int main(int argc, char* argv[]){
  TString path;
  TString outDir        ="./";
  TString format        ="ps";
  
  if (argc < 2){
    printf("You have to insert at least the file to analyze \n");
    printf("Try '--help' for more information. \n");
    exit(1);
  }  
  
  if (!strcmp(argv[1], "--help")){
    printf( "Usage: TriggerScanBasic FILE [OPTION] \n");
    printf( "\t --help                  Print this help and exit \n");	
    printf( "\t -outDir[path]           Path where to put the output [default ./] \n");
    printf( "\t -format[ps]             Format for output files [default 'ps'] \n");
    exit(1);
  }
  
  
  path=argv[1];
  
  for (int i = 2; i < argc; i++){
    
    if (!strcmp(argv[i], "-outDir")){
      if (++i >= argc){
	printf( "-outDir needs arguments. \n");
	printf( "Try '--help' for more information. \n");
	exit(1);
      } 
      else{
	outDir = argv[i];
	continue;
      }
    }
    
    
    
    if (!strcmp(argv[i], "-format")){
      if (++i >= argc){
	printf( "-format needs arguments. \n");
	printf( "Try '--help' for more information. \n");
	exit(1);
      } 
      else{
	format = argv[i];
	continue;
      }
    }
  }

  TriggerScanBasic(argv[1], outDir, format);

}
