//
// CaloCHKCALIB.cc -- standalone program to call the CaloCHKCALIB macro. 
//    by Emiliano Mocchiutti
//
//   Version 1.00 (2005/08/16)
//
// Changelog: 
//
// 0.00 - 1.00 : working.
//
#include <TSystem.h>
#include <iostream>
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>
//
extern void FCaloCHKCALIB(TString,  Long64_t, TString, int, TString);
extern void info();
using namespace std;
//
void usage(){
  printf("\nUsage:\n\n FCaloCHKCALIB [-v] file calib_number output_directory matra figure_format \n");
  printf("\n -v               be verbose \n");  
  printf(  " file             must be in the form: /path/to/filesfromyoda/dw_000000_00000/  \n");
  printf(  " calib_number     is an integer (progressive calibration number), 0 = all \n");
  printf(  " output_dir       directory where to store figures \n");
  printf(  " matra            integer, 1 to print the strip rms in a box plot 0 to skip it\n");
  printf(  " figure format    any format recognized by ROOT (eps,gif,...)\n");
  printf("\nExample: \n\nFCaloCHKCALIB /home/pamela/filesfromyoda/dw_050301_00100/ 0 /tmp/ 0 ps \n\n");
}
//
int main(int numinp, char *inps[]){
  TString name;
  TString outdir = "";
  TString format = "ps";
  int matra = 0;
  Long64_t calibno = 0;
  char *pEnd;
  int nul = 0;
  bool beverbose = false;
  if ( numinp == 1 ){
    usage();
    return(0);    
  };
  if ( numinp > 1 ){
    if ( !strcmp(inps[1],"--version") ){
      info();
      return(0);
    };
    if ( !strcmp(inps[1],"-h") || !strcmp(inps[1],"--help") || numinp>7 ){
      usage();
      return(0);
    } else {
      if ( !strcmp(inps[1],"-v") || !strcmp(inps[1],"--verbose") ){
	beverbose = true;
	if ( numinp == 2 ) { 
	  info();
	  return(0);    
	};
	if ( numinp >= 3 ) name = (TString)inps[2];
	if ( numinp >= 4 ) calibno = strtoull(inps[3],&pEnd,0);
	if ( numinp >= 5 ) outdir = (TString)inps[4];
	if ( numinp >= 6 ) matra = atoi(inps[5]);
	if ( numinp == 7 ) format = (TString)inps[6];
      } else {
	if ( numinp >= 2 ) name = (TString)inps[1];
	if ( numinp >= 3 ) calibno = strtoull(inps[2],&pEnd,0);
	if ( numinp >= 4 ) outdir = (TString)inps[3];
	if ( numinp >= 5 ) matra = atoi(inps[4]);
	if ( numinp == 6 ) format = (TString)inps[5];
      };
    };
  };
  //
  if ( !beverbose ){
    //
    // redirect to /dev/null the stdout and stderr
    //
    nul = open("/dev/null", O_CREAT | O_RDWR,S_IREAD | S_IWRITE);
    dup2(nul,1);
    dup2(nul,2);
  };
  printf("\n Welcome to FCaloCHKCALIB! \n");
  //
  FCaloCHKCALIB(name,calibno,outdir,matra,format);
  //
  if ( !beverbose ) close(nul);
  return(0);
}
