/****************************************************************************
/*  F i l e   D a t a                                                        
/*                                                                           
/*  Module       :   Initialization                                                 
/*  C.I. No.     :                                                           
/*  $Revision: 1.1.1.1 $
/*  $Date: 2006/04/25 09:00:21 $
/*  Belonging to :                                                           
/*               :                                                           
/*  $RCSfile: IN_InitManager_p.c,v $
/*  Program Type :                                                           
/*  Sub-modules  :                                                           
/*                                                                           
/****************************************************************************
/*  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
/*                                                                           
/*  Host system  :                                                           
/*  SW Compiler  :                                                           
/*  $Author: kusanagi $
/*               :                                                           
/****************************************************************************
/*  U p d a t i n g                                                          
/*                                                                           
/*  $Log: IN_InitManager_p.c,v $
/*  Revision 1.1.1.1  2006/04/25 09:00:21  kusanagi
/*  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
/*
/*  Revision 1.1.1.1  2003/08/04 09:40:21  sebastiani
/*  Imported sources laben rel. 19.06.2003 integrated with pam2
/*
/*  Revision 1.3  2002/05/09 08:16:34  zulia
/*  *  acceptance release
/*
/*                                                                           
/*****************************************************************************/

/*============================= Include File ================================*/
  
#include <src/Initialization/InitManager/IN_InitManager_p.h>
#include <src/Initialization/InitManager/IN_InitManager_op.h>


/*****************************************************************************/

/*======= I n i t M a n a g e r   P R O V I D E D    I N T E R F A C E ======*/

/*****************************************************************************/

/*========================= E N T R Y    P O I N T ==========================*/

/*****************************************************************************/
/* @Function: IN_piSystemInitialization                                      */
/* @Purpose :                                                                */
/*  This function is called from the RTEMS init_exec function and has the    */
/*  responsibility for resources creation and starting.  Morever during this */
/*  step all the initializations of the application are performed.           */
/*  At the end the task is deleted.                                          */
/*                                                                           */
/* @@                                                                        */
/* @Parameter Name      @Mode   @Description                                 */
/*                      IN                                                   */
/* task                 OUT     Return code                                  */
/* @@                                                                        */
/*****************************************************************************/

task IN_piSystemInitialization(task_argument argument)
{

    /* Initialize the application  */
    IN_opInitAllSystem();

/* ==========================================================================
    Delete task Init
   ==========================================================================*/   
    OS_piTaskDelete(SELF);
}
