/****************************************************************************
 *  F i l e   D a t a                                                        
 *  $Id: TRK_generator.c,v 1.1.1.1 2006/04/25 09:00:21 kusanagi Exp $
 *  $Revision: 1.1.1.1 $
 *  $Date: 2006/04/25 09:00:21 $
 *  $RCSfile: TRK_generator.c,v $
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  $Author: kusanagi $
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          

 *  $Log: TRK_generator.c,v $
 *  Revision 1.1.1.1  2006/04/25 09:00:21  kusanagi
 *  These program extract in an XML format the info contained into the ROOT files generated by YODA from the PAMELA data. To visualize the XML files in a more human readable format a collection of XSL files are given in the Data subfolder.
 *
 *  Revision 1.3  2003/10/22 12:47:50  faber
 *  *** empty log message ***
 *
 *  Revision 1.1  2003/10/03 16:12:26  faber
 *  *** empty log message ***
 *
 *                                                                           
 *****************************************************************************/


/* cmdgenerator must be included before all other *.h files */
#include "cmdgenerator.h"
//#include "TRK_Driver_INFN.h"

DAQ_DECLBUF(idaqbuf,1024);
DAQ_DECLBUF(cmdbuf,1024);
DAQ_DECLBUF(ac_idaqbuf,1024);
DAQ_DECLBUF(data,1024);
DAQ_DECLBUF(data2,1024);
DAQ_DECLBUF(idaq2,1024);
DAQ_DECLBUF(ram_readdata,1);
DAQ_DECLBUF(flash_readdata,1);
DAQ_DECLBUF(dsp_readdata,1);

DAQ_CMD_BUF emptybuf = {0,0,0};


DECL_FUNC(TRK_TRIGGER) {
  DAQ_Format_CMD_Empty(b);
  
  EXEC(DAQ_Format_CMD_Fill(b,10,0x00),__LINE__);
  
  write_buf(filename,b);
}

DECL_FUNC(TRK_CALIB_NORMAL) {
  DAQ_Format_CMD_Empty(b);

  EXEC(DAQ_Format_CMD_Fill(b,10,0x00),__LINE__);
  
  write_buf(filename,b);
}

DECL_FUNC(TRK_CALIB_SPECIAL) {
  DAQ_Format_CMD_Empty(b);

  EXEC(DAQ_Format_CMD_Fill(b,10,0x00),__LINE__);
  
  write_buf(filename,b);
}


DECL_FUNC(TRK_READ_CALIB1) {
  DAQ_Format_CMD_Empty(b);

  EXEC(DAQ_Format_CMD_Fill(b,10,0x00),__LINE__);
  
  write_buf(filename,b);
}

DECL_FUNC(TRK_READ_EVENT) {
  DAQ_Format_CMD_Empty(b);

  EXEC(DAQ_Format_CMD_Fill(b,10,0x00),__LINE__);
  
  write_buf(filename,b);
}



void init_buffers() {

  DAQ_Init();

  DAQ_BUFFER_INIT(idaqbuf);
  DAQ_BUFFER_INIT(idaq2);
  DAQ_BUFFER_INIT(data);
  DAQ_BUFFER_INIT(data2);
  DAQ_BUFFER_INIT(ram_readdata);
  DAQ_BUFFER_INIT(dsp_readdata);
  DAQ_BUFFER_INIT(flash_readdata);

  DAQ_Format_Ram_ReadData(&ram_readdata);
  DAQ_Format_Dsp_ReadData(&dsp_readdata);
  DAQ_Format_Flash_ReadData(&flash_readdata);
}


int main() {
  status_code s=0;  
  init_buffers();

  TRK_TRIGGER("TRK_TRIGGER",&data);
  TRK_CALIB_NORMAL("TRK_CALIB_NORMAL",&data);
  TRK_CALIB_SPECIAL("TRK_CALIB_SPECIAL",&data);
  TRK_READ_CALIB1("TRK_READ_CALIB1",&data);
  TRK_READ_EVENT("TRK_READ_EVENT",&data);

  DAQ_Format_CMD_Empty(&data);  
  write_buf("last_run_tag",&data);

  exit(0);
  return 0;
}

