#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

extern unsigned char crc8_8(unsigned char ,unsigned char);


int main(void) 
{
    int i,n;

    unsigned char temp;
    unsigned char crc; /* 8 bits */

    int l;

/* ----------------------------------------------------- */
/* remeber to change: w width, l, command name, command bytes */

    /* w width = l = CL + 1 */

    unsigned char w[4]; /* 8 bits */

    /* l = CL+1 */

    l=4;

    /* command name */

    printf("\n--------------------------\n");
    printf("-- Command 'write on control register'");
    printf("\n--------------------------");

    /* command length CL = data block length + 2 */ 

    w[0]=0x00;
    w[1]=0x03;

    /* comm. numb. */

    w[2]=0xF0;

    /* data block */

    w[3]=0x10;
    
/* ----------------------------------------------------- */

    /* print byte value and d/s sequence (from MSB) */

    printf("\n\n-- command length:");
    printf("\n-- MSB: %x", w[0]);
    printf("\n-- LSB: %x", w[1]);
    
    printf("\n\n-- command number:");
    printf("\n-- %x", w[2]);
	
    printf("\n\n-- data block:");

    for (i=3; i < l; i++)
      {
        printf("\n-- %x", w[i]);
      }


    /* ib_comm_d/s: 1 initially */

    temp=0x1;

    printf("\n\nib_odd_temp <= '0';");
    printf("\nib_temp <= '1';");
    printf("\nwait for 0 ns;\n");

    /* first 3 bytes */

    for (i=0; i < 3; i++)
      {
        printf("\n-- word %d : %x\n\n", i, w[i]);
	for (n=7; n >= 0; n--)
	  {
	    /* strobe */

     
	    if (temp == ((w[i] >> n) & 1))
	      {
	      printf("ib_temp <= NOT ib_temp; wait for 0 ns;");
              printf(" ib_comm_s0_in_driver <= ib_temp;\n");
	      }

	    temp = (w[i] >> n) & 1;

	    printf("ib_comm_d0_in_driver <= '%x';\n", temp);
	    printf("ib_odd_temp <= NOT ib_odd_temp; wait for 37.5 ns;");
            printf(" odd_ds_ck_in_driver <= ib_odd_temp;\n");
	    printf("wait for 37.5 ns;\n\n");
	  }
      }

      /* computes and sends ICC*/

      crc=0;
      for (i =0; i < 3; i++)
	{	
	    crc=crc8_8(crc, w[i]);
	}
      printf("\n-- ICC computed: %x\n\n",crc);
      for (n=7; n >= 0; n--)
	{
	  /* strobe */
	  if (temp == ((crc >> n) & 1))
	    {
	      printf("ib_temp <= NOT ib_temp; wait for 0 ns;");
              printf(" ib_comm_s0_in_driver <= ib_temp;\n");
	    }

	  temp = (crc >> n) & 1;
	  printf("ib_comm_d0_in_driver <= '%x';\n", temp);
	  printf("ib_odd_temp <= NOT ib_odd_temp; wait for 37.5 ns;");
          printf(" odd_ds_ck_in_driver <= ib_odd_temp;\n");
	  printf("wait for 37.5 ns;\n\n");
	}

      /* sends data block */

      for (i=3; i < l; i++)
	{
	  printf("\n-- word %d : %x\n\n", i, w[i]);
	  for (n=7; n >= 0; n--)
	    {

	      /* strobe */
     
	      if (temp == ((w[i] >> n) & 1))
		{
		  printf("ib_temp <= NOT ib_temp; wait for 0 ns;");
		  printf(" ib_comm_s0_in_driver <= ib_temp;\n");
		}

	      temp = (w[i] >> n) & 1;

	      printf("ib_comm_d0_in_driver <= '%x';\n", temp);
	      printf("ib_odd_temp <= NOT ib_odd_temp; wait for 37.5 ns;");
	      printf(" odd_ds_ck_in_driver <= ib_odd_temp;\n");
	      printf("wait for 37.5 ns;\n\n");
	    }
	}

      /* computes and sends FCC */

      for (i = 3; i < l; i++)
	{	
	    crc=crc8_8(crc, w[i]);
	}
      printf("\n-- FCC computed: %x\n\n",crc);
      for (n=7; n >= 0; n--)
	{
	
	  /* strobe */

	  if (temp == ((crc >> n) & 1))
	    {
	      printf("ib_temp <= NOT ib_temp; wait for 0 ns;");
              printf(" ib_comm_s0_in_driver <= ib_temp;\n");
	    }

	  temp = (crc >> n) & 1;
	  printf("ib_comm_d0_in_driver <= '%x';\n", temp);
	  printf("ib_odd_temp <= NOT ib_odd_temp; wait for 37.5 ns;");
          printf(" odd_ds_ck_in_driver <= ib_odd_temp;\n");
	  printf("wait for 37.5 ns;\n\n");
	}

      printf("\nwait for 100 ns;\n");

      printf("\n-- IDAQ internal reset\n");	
      printf("\nib_comm_d0_in_driver <= '1';\n");
      printf("ib_comm_s0_in_driver <= '1';\n");
      printf("odd_ds_ck_in_driver <= '0';\n");

      printf("\nwait for 8000 ns;\n");

      return 1;
      
}

unsigned char crc8_8(unsigned char old,unsigned char data)
{
  union crc_word {
    unsigned char word;
    struct bit_field_w {
      unsigned b0:1;
      unsigned b1:1;
      unsigned b2:1;
      unsigned b3:1;
      unsigned b4:1;
      unsigned b5:1;
      unsigned b6:1;
      unsigned b7:1;
    } bit;
  } c,d,r;

  c.word = old;
  d.word = (unsigned short)data;

  r.bit.b0  = c.bit.b0  ^ c.bit.b6 ^ c.bit.b7 ^ d.bit.b0  ^ d.bit.b6 ^ d.bit.b7;
  r.bit.b1  = c.bit.b0  ^ c.bit.b1 ^ c.bit.b6 ^ d.bit.b0  ^ d.bit.b1 ^ d.bit.b6;
  r.bit.b2  = c.bit.b0  ^ c.bit.b1 ^ c.bit.b2 ^ c.bit.b6  ^ d.bit.b0 ^ d.bit.b1 ^d.bit.b2 ^ d.bit.b6;
  r.bit.b3  = c.bit.b1  ^ c.bit.b2 ^ c.bit.b3 ^ c.bit.b7  ^ d.bit.b1 ^ d.bit.b2 ^d.bit.b3 ^ d.bit.b7;
  r.bit.b4  = c.bit.b2  ^ c.bit.b3 ^ c.bit.b4 ^ d.bit.b2  ^ d.bit.b3 ^ d.bit.b4;
  r.bit.b5  = c.bit.b3  ^ c.bit.b4 ^ c.bit.b5 ^ d.bit.b3  ^ d.bit.b4 ^ d.bit.b5;
  r.bit.b6  = c.bit.b4  ^ c.bit.b5 ^ c.bit.b6 ^ d.bit.b4  ^ d.bit.b5 ^ d.bit.b6;
  r.bit.b7  = c.bit.b5  ^ c.bit.b6 ^ c.bit.b7 ^ d.bit.b5  ^ d.bit.b6 ^ d.bit.b7;

  return r.word;
}









