<?xml version="1.0" encoding="UTF-8"?>    <!-- Prologo XML -->
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">   <!-- Dichiarazione del documento XSLT -->
<!--    <xsl:stylesheet version="1.0" 
    xmlns:xsl="http://www.w3.org/TR/WD-xsl"> -->
    
<!--    
=====================================================================================
 Stylesheet: PhysEndRunTemplate.xsl
    Version: 1.0 (2005-03-14)
     Author: Maurizio Nagni
     Descr.: Format the output of the PhysEndRunToXml.c script to generate a human 
             readble verion of the PhysEndRun packet
=====================================================================================
-->
    
<!--Contains some utility to converts dec/hex/bin numbers-->
<xsl:include href="numberutils_lib.xsl"/>

<!--Contains all the customer specific parameters-->
<!--<xsl:include href="Configure.xsl"/>-->
   
   <!-- Define which a key called "varDes" 
   	which will search inside the node "var" of the reference
   	ArrDumpInfo.xml (or whatever file instead of the is used)
	all values values of the node "idx" matching the valued passed when 
	the key "fileName" is called -->
   <!-- No xml file is defined here because the xsl:key is absolutely generic -->
<!--   <xsl:key name="arrDes" match="arr" use="idx"/>

   <xsl:template match="/" name="ArrDumpReference">
     <xsl:param name="code"/>
     <xsl:param name="arrval"/>
     <xsl:for-each select="document('./compilationInfo/PRH_ParamHandler_INFN_auto.arr.xml')">
       <xsl:for-each select="key('arrDes', $code)">
	 <td> <th align="left"><xsl:value-of select="name"/><xsl:text>(</xsl:text><xsl:value-of select="idx"/><xsl:text>)</xsl:text> </th> </td>
	 <td> <th align="left"><xsl:copy-of select="$arrval"/></th> </td>
	 <td> <th align="left"><xsl:value-of select="comment"/></th> </td>
       </xsl:for-each> 
     </xsl:for-each>
   </xsl:template>
-->
   <xsl:template match="/" name="PhysEndRunTemplate">
     <html>
       <body STYLE="font-family:Arial, helvetica, sans-serif; font-size:10pt">
	 <h2>PhysEndRun Event (all values are hex except OBT and PktNumber)</h2>
 	   <xsl:for-each select="//PHYSER_EVENT">
	     <hr size = '1' color = '#ff0000'/>
	     <table border='1' width = '100%' height = '5'>
	       <tr bgcolor="#ff0000" >
		<th align="left">Packet OBT</th>
		<th align="left">Packet Num</th>
		<th width = '100%'></th>
	       </tr>
	       <tr>
		 <td align="center"><xsl:value-of select="PACKET_OBT"/></td>
		 <td align="center"><xsl:value-of select="PACKET_NUM"/></td>
		 <td  width = '100%'></td>
	       </tr>
	     </table>
	     <table border="1" width = '100%'>
	       <tr bgcolor="#7777FF">
		 <th align="left" colspan = '99'>CALO EndRun Section</th>
	       </tr>
	       <xsl:for-each select="CALOENDRUN_RECORDS/CALOENDRUN_RECORD">
		 <tr bgcolor="#1acd32">
		   <th align="center">Board Id HK</th>
		   <th align="center">Board Status HK</th>
		   <th align="center">Board Id REG</th>
		   <th align="center">Board Status REG</th>
		   <td  rowspan = '2' colspan = '99'>
		     <table border = '1' width = '100%'>
		       <tr>
			 <th align="center">HK0</th>
			   <xsl:for-each select="HK0/HK0_ITEM">
			     <td bgcolor="#ffffff">
				 <xsl:call-template name="Dec2Hex">
				   <xsl:with-param name="value" select="."/>
				 </xsl:call-template>
			     </td>
			   </xsl:for-each>
		       </tr>
		       <tr>
			 <th bgcolor="#1acd32" align="center">HK1</th>
			   <xsl:for-each select="HK1/HK1_ITEM">
			    <td bgcolor="#ffffff">
			      <xsl:call-template name="Dec2Hex">
				<xsl:with-param name="value" select="."/>
			      </xsl:call-template>
			    </td>
			   </xsl:for-each>
		       </tr>
		       <tr>
			 <th bgcolor="#1acd32" align="center">REG</th>
			 <xsl:for-each select="CALO_REG/CALO_REG_ITEM">
			   <td bgcolor="#ffffff">
			       <xsl:call-template name="Dec2Hex">
				 <xsl:with-param name="value" select="."/>
			       </xsl:call-template>
			   </td>
			 </xsl:for-each>
		       </tr>
		     </table>
		   </td>
		 </tr>
		 <tr>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="BOARD_ID_HK"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="BOARD_ST_HK"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="BOARD_ID_REG"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="BOARD_ST_REG"/>
		     </xsl:call-template>
		   </td>
		 </tr>
	       </xsl:for-each>
	       <xsl:for-each select="TBENDRUN">
		 <tr bgcolor="#7777FF">
		   <th align="left" colspan = '99'>TriggerBoard EndRun Section</th>
		 </tr>
		 <tr bgcolor="#1acd32">
		 <table border="1" width = '100%'>
		 <tr>		 
		   <th align="center">Alarm Mask</th>
		   <th align="center">S3 Mask</th>
		   <th align="center">S2 Mask</th>
		   <th align="center">S21 Mask</th>
		   <th align="center">S11 Mask</th>
		   <th align="center">S4 Mask</th>
		   <th align="center">Calo Mask</th>
		   <th align="center">Busy Mask</th>
		   <th align="center">Calib Flag</th>
		   <th align="center">S4 Trig</th>
		   <th align="center">Calo Trig</th>
		   <th align="center">Tof Trig</th>
		 </tr>
		 <tr>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="ALARM_MASK"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="PMT_MASK_S3"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="PMT_MASK_S2"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="PMT_MASK_S21"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="PMT_MASK_S11"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="S4_MASK"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="CALO_MASK"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="BUSY_MASK"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="CALIB_FLAG"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="S4_TRIG"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="CALO_TRIG"/>
		     </xsl:call-template>
		   </td>
		   <td>
		     <xsl:call-template name="Dec2Hex">
		       <xsl:with-param name="value" select="TOF_TRIG"/>
		     </xsl:call-template>
		   </td>
		 </tr>
		 </table>
		 </tr>
	      </xsl:for-each>
	     </table>
	   </xsl:for-each>
	   <!--
		   <td>
		   <xsl:text>0x</xsl:text>
		   <xsl:call-template name="Dec2Hex">
		   <xsl:with-param name="value" select="INFO1"/>
		   </xsl:call-template>
		   <xsl:value-of select="INFO1"/>
		   </td>
	       -->
	   	   
       </body>
     </html>
   </xsl:template>
   
 </xsl:stylesheet>
