#include <utils/yodaUtility.h>
#include "TrkFunctions.cpp"
#include <iostream>
#include <TPaveText.h>
#include <TLatex.h>
#include <TCanvas.h>
#include <TGraph.h>
#include <PscuHeader.h>
#include <EventHeader.h>
#include <RunHeaderEvent.h>
#include <TStyle.h>
#include <TObjString.h>
#include <physics/tracker/TrackerEvent.h>

/**
 * TrkQLook_BASIC.cpp
 *
 * autor: D.Fedele
 * version 1.0
 * Parameters:
 * 	base - the path to the root directory for the specific
 *	       Pamela unpack session
 *      fromevent - first event to analyse
 *      toevent - last event to analyse
 *      outdir - total path of output file 
 * 	outfile - extension of output file (pdf,ps,gif,jpg)
 * 
 */

void TrkQLook_BASIC(TString file,Int_t fromevent,Int_t toevent, TString outdir,TString outfile)
{   
  // 
  //   obtain information about the data file and select the output dir
  const string filepath=file.Data(); 
  Int_t dwpos = filepath.find("DW_");
  Int_t dwpos1 = filepath.find(".root");
  TString fpath=(filepath.c_str());
  TString base,ffile ;
  stringcopy(ffile,fpath,dwpos,dwpos1);
  stringcopy(base,fpath,0,dwpos);

  TString out;
  if(outdir.Length()==0){
    out = base;
  }else{
    out = outdir;
  }
   
  //
  // inizialise the variables and open the file
  pamela::tracker::TrackerEvent *te=0;
  pamela::EventHeader *eh=0,*eH=0;
  pamela::RunHeaderEvent *reh=0;
  pamela::PscuHeader *ph=0,*pH=0;

  TFile *datafile = new TFile(file);
  TTree *otr 	      = (TTree*)datafile->Get("RunHeader");
  otr->SetBranchAddress("Header",&eH);
  otr->SetBranchAddress("RunHeader",&reh);
  TTree *tr 	      = (TTree*)datafile->Get("Physics");
  tr->SetBranchAddress("Tracker",&te);
  tr->SetBranchAddress("Header",&eh);

   
  Long64_t nevent = tr->GetEntries();
  Long64_t neventH = otr->GetEntries();
  Int_t minevent=0;
  Int_t maxevent=0; 
//   cout<<"Total n.events  "<<nevent<<"  e neventH= "<<neventH<<endl;

  if (nevent<=0){
    datafile->Close();
    return;
  }
  if ( fromevent > toevent && toevent>0 ){
    printf("It must be fromevent < toevent \n");
    return;
  }
  if ( fromevent > nevent || fromevent < 0 ) {
    printf("You can choose fromevent between 0 (all) and %lld \n",nevent);
    return;
  }
  if ( toevent > nevent || toevent < 0 ) {
    printf("You can choose toevent between 0 (all) and %lld \n",nevent);
    return;
  }
  if ( fromevent == 0 ) {
    minevent = 0;
    maxevent = nevent;
  } else {
    minevent = fromevent;
    if ( toevent > 0 ){
      maxevent = toevent+1;
    } else if (toevent > nevent) {	   
      maxevent = nevent;
    } else {	   
      maxevent = toevent+1;   
    }
    nevent=maxevent-minevent ;
  }

  //
  // other variables definitions
  stringstream oss,fromfile,isfile;
  const Int_t size=nevent;
  Int_t dsp=0,count=0,trk_cal_us[50];
  Double_t perc;
  Double_t yd[size*12], x[size+1];
  Double_t yyd[size+1],yyb[size], xb[size];
  ULong64_t HOBT[50];
  TGraph *dataletime,*dataletime1;
  
  for (Int_t i=0; i<50;i++){
    HOBT[i]=0;
    trk_cal_us[i]=0;
  }

  //***************************************************************************************
  // LOOP on each event
  //***************************************************************************************
 
  //
  // information about trk_calib_used
  for (Int_t ev=0; ev<neventH; ev++){
    otr->GetEntry(ev);
    pH = eH->GetPscuHeader();
    HOBT[ev]= pH->GetOrbitalTime();
    trk_cal_us[ev]=reh->TRK_CALIB_USED;
  }


  //
  // information about datalength
  x[0]=(Double_t)HOBT[0];
  for (Int_t ev=minevent; ev<maxevent; ev++){
    tr->GetEntry(ev);
    ph = eh->GetPscuHeader();
    
    x[(ev-minevent)+1]= ph->GetOrbitalTime();
    dsp=0;
    for(Int_t i=0; i<12; i++){
      dsp=te->DSPnumber[i]-1;
      yd[(ev-minevent)*12+dsp]= te->DATAlength[i];
    }
  };
  datafile->Close();


  //****************************************************************************************
  //Output figure
  //****************************************************************************************
  
  TCanvas *DataTimeCanv=new TCanvas("Tracker_Detector_Report_","",900,1200);
  DataTimeCanv->SetFillColor(10);
  DataTimeCanv->Range(0,0,100,100);
  fromfile<<"TrackerQLookBasic      File: "<<ffile;
  isfile<<"DATALENGTH vs. ORBITALTIME ";

  TLatex *t=new TLatex();
  t->SetTextFont(32);
  t->SetTextColor(1);
  t->SetTextAlign(12);
  t->SetTextSize(0.02);
  t->DrawLatex(2.,98.7,fromfile.str().c_str());
  TLatex *t1=new TLatex();
  t1->SetTextFont(32);
  t1->SetTextColor(1);
  t1->SetTextAlign(12);
  t1->SetTextSize(0.02);
  t1->DrawLatex(70.,98.7,isfile.str().c_str());
  fromfile.str("");
  isfile.str("");


  //*************************************************************************************
  //book pads and histos
  //***************************************************************************************
  gStyle->SetLabelSize(0.06,"x");
  gStyle->SetLabelSize(0.06,"y");
  gStyle->SetStatFontSize(0.075);
  gStyle->SetOptStat(1110);
  gStyle->SetFillColor(10);  
  gStyle->SetTitleFontSize(0.1);
  gStyle->SetTitleOffset(0.8,"y");
  gStyle->SetTitleOffset(0.9,"x");
  gStyle->SetTitleSize(0.06,"y");
  gStyle->SetTitleSize(0.055,"x");

  TPad *pad[12];          //pad for histos
  Double_t posy = 0.95;    // up y-coord - top pads
  Double_t hpad = 0;   // pad height
  Double_t posx1=0;          // left  x-coord - pad column
  Double_t posx0=0;          //       x-coord - column division
  Double_t wrel = 0;     // relative x size of first sub-column
  Double_t marg = 0.004;   // margin among pads

  hpad = (posy-marg*11)/6;
  wrel = (1-marg*4)/2;
  stringstream title;
  stringstream hid;

  for(Int_t n = 0; n<12; n++) {
    if ( (n+1)%2==1 ) {
      if(n>1) posy = posy-(marg*2+hpad);
      posx1 = marg;
      posx0 = posx1 + wrel;
    }
    else {
      posx1 = posx0 + 2*marg;
      posx0 = posx1 + wrel;
    }

    /* -----------> pad for histograms  */
    pad[n] = new TPad("pad"," ",posx1,posy-hpad,posx0,posy,18,0,0);
  };            
  
  TLine li;
  li.SetLineColor(1);
  li.SetLineStyle(1);
  li.SetLineWidth(1);
  //**********************************************************************************
  // Fill Graphs and Histos
  //**********************************************************************************
  stringstream calus;
  TLatex *t2=new TLatex();
  t2->SetTextFont(32);
  t2->SetTextColor(1);
  t2->SetTextAlign(13);
  t2->SetTextSize(0.08);

  for (Int_t i=0; i<12 ; i++){ 
    perc=0;
    count=0;
    yyd[0]=-10000.;
    for (Int_t ev=minevent; ev<maxevent; ev++){
      yyd[(ev-minevent)+1]=yd[12*(ev-minevent)+i];
      if(i==6){
	if(yyd[(ev-minevent)+1]>1500){
	  if(yyd[(ev-minevent)+1]<3075){
	    yyb[count]= yyd[(ev-minevent)+1];
	    xb[count]= x[(ev-minevent)+1];
	    count++;
	  }
	}
      }
      else{
	if(yyd[(ev-minevent)+1]>750){
	  if(yyd[(ev-minevent)+1]<3075){
	    yyb[count]= yyd[(ev-minevent)+1];
	    xb[count]= x[(ev-minevent)+1];
	    count++;
	  }
	}
      }
    }
    
    if((maxevent-minevent)>100) perc=(count*100)/(maxevent-minevent);
    else perc=(count*10)/(maxevent-minevent);

    Double_t min,max;
    if((maxevent-minevent)<100){
      min=x[0];
      max=x[size]*1.0001;
    }
    else{
      min=x[0];
      max=x[size-1]*1.0005;
    }
    oss<<"DSP  "<<i+1;
    DataTimeCanv->cd();
    if(perc>1) pad[i]->SetFillColor(2);
    else  pad[i]->SetFillColor(10);
    pad[i]->SetFrameFillColor(10);
    pad[i]->Draw();
    pad[i]->cd();
    dataletime= new TGraph((maxevent-minevent)+1,x,yyd);
    dataletime->SetTitle(oss.str().c_str());
    dataletime->GetXaxis()->SetTitle("OBT (ms)");
    dataletime->GetXaxis()->CenterTitle();
    dataletime->GetXaxis()->SetRangeUser(min,max);
    dataletime->GetYaxis()->SetTitle("datalength (Word 13 bit)");
    dataletime->GetYaxis()->CenterTitle();
    dataletime->GetYaxis()->SetRangeUser(0,3500);
    dataletime->SetMarkerStyle(21);
    if((maxevent-minevent)<50) dataletime->SetMarkerSize(0.5);
    else dataletime->SetMarkerSize(0.3);
    dataletime->SetMarkerColor(1);
    dataletime->Draw("ap");
    if(perc>1){
      dataletime1= new TGraph(count,xb,yyb);
      dataletime1->SetMarkerStyle(21);
      if((maxevent-minevent)<50) dataletime1->SetMarkerSize(0.5);
      else dataletime1->SetMarkerSize(0.3);
      dataletime1->SetMarkerColor(2);
      dataletime1->Draw("psame");
    }
    li.SetLineColor(1);
    li.SetLineStyle(1);
    li.SetLineWidth(1);
    if(i!=6) li.DrawLine(min,750,max,750);
    else li.DrawLine(min,1500,max,1500);
    li.DrawLine(min,3075,max,3075); 
    for(Int_t j=0;j<neventH;j++){
      li.SetLineColor(12);
      li.SetLineStyle(4);
      li.SetLineWidth(1);
      li.DrawLine(HOBT[j],0.,HOBT[j],3500.);
      if(trk_cal_us[j]==104){
	calus<<"D";
	t2->SetTextColor(6);
	t2->DrawLatex(HOBT[j],3350.,calus.str().c_str());
	calus.str("");
      }	
      else{
	calus<<trk_cal_us[j];
	t2->SetTextColor(3);
	t2->DrawLatex(HOBT[j],3350.,calus.str().c_str());
	calus.str("");
      }
    }
    oss.str("");
  };
   
  DataTimeCanv->Update();

  //*************************************************************************
  // Save output Files
  //*************************************************************************
  stringstream out1;
  
  // if(!strcmp(outfile.Data(),"pdf")){
//     stringstream com;
//     out1<<ffile<<"_TrkQLook_BASIC.ps";
//     DataTimeCanv->Print(out+out1.str().c_str());
//     com<<"ps2pdf13 "<<out<<ffile<<"_TrkQLook_BASIC.ps "<<out<<ffile<<"_TrkQLook_BASIC.pdf";
//     system(com.str().c_str());
//     com.str("");
//     com<<"rm -f "<<out<<ffile<<"_TrkQLook_BASIC.ps ";
//     system(com.str().c_str());
//     com.str("");
//   }
//   else{
    out1<<ffile<<"_TrkQLook_BASIC."<<outfile.Data();
    DataTimeCanv->Print(out+out1.str().c_str());
    out1.str("");
//   }

  dataletime->Delete();
  delete DataTimeCanv;
  
  gROOT->Reset();
//   printf("... end of packets. \n");
  return;
}
