/** @file
 * $Source: /afs/ba.infn.it/user/pamela/src/CVS/yoda/event/log/LogRecord.h,v $
 * $Id: LogRecord.h,v 6.0 2006/02/07 17:11:08 kusanagi Exp $
 * $Author: kusanagi $
 * 
 * Header file for the LogRecord class.
 */
#ifndef LOG_RECORD_H
#define LOG_RECORD_H
#include "../SubPacket.h"
namespace pamela {
  /**
   * LogRecord data Wrapper
   *
   * Each pamela::LogRecord represents a PAMELA CPU software?s error or other software conditions.
   * The pair (FILE_ID,LINE) identifies a unique error/log trace that can be found in all source code:
   * this gives the maximum of the information with the minimum of size
   * (this information also goes in part to the history area).
   */
  class LogRecord: public TObject {
  private:
    
  public:
    /**
     * The On-Board-Time of the Record.
     */
    UINT32  RECORD_OBT;

    /**
     * The Type of the Record.
     *
     * BITMASK description:            <BR>
     * #define LU_WARNING       (1<<0) <BR>
     * #define LU_CRITICAL      (1<<1) <BR>
     * #define LU_INTERNAL      (1<<2) <BR>
     * #define LU_FATAL         (1<<3) <BR>
     * #define LU_NORMAL_TRACE  (1<<4) <BR>
     * #define LU_DEBUG_TRACE   (1<<5) <BR>
     * #define LU_ALARM         (1<<6) <BR>
     * #define LU_HA            (1<<7) <BR>
     * <B> The first seven bits are mutually esclusive. </B>
     * Bit 8 indicates if this log is also recorded in the history area.
     */
    UINT8   MASKTYPE;

    /**
     * The FileId of the record.
     * Identification code of a specific PAMELA CPU software ".c" file in which this error/log trace occurred. 
     * Each source file is identified by a unique number in the range [0,255].
     */
    UINT8   FILE_ID;

    /**
     * The Line_No of te record.
     * Identify the line number inside the file code referred by the FILE_ID parameter.
     */
    UINT16  LINE_NO;

    /**
     * Supplementary field which depends on the related log trace.
     */
    UINT32  INFO1;
        
    LogRecord(void);
    ~LogRecord(void){};
    ClassDef(LogRecord, 1)
  };
}

#endif /* LOG_RECORD_H */

