/****************************************************************************
 *  F i l e   D a t a                                                        
 *  $Id: TOF_TimeOfFlight_INFN.c,v 1.18 2005/03/20 18:26:47 sebastiani Exp $
 *  $Revision: 1.18 $
 *  $Date: 2005/03/20 18:26:47 $
 *  $RCSfile: TOF_TimeOfFlight_INFN.c,v $
 *                                                                           
 ****************************************************************************
 *  S W   D e v e l o p m e n t   E n v i r o n m e n t                      
 *                                                                           
 *  $Author: sebastiani $
 *               :                                                           
 ****************************************************************************
 *  U p d a t i n g                                                          

 *  $Log: TOF_TimeOfFlight_INFN.c,v $
 *  Revision 1.18  2005/03/20 18:26:47  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.17  2005/02/19 10:19:39  sebastiani
 *  ALM_S4_CALIB_00_HARD,ALM_S4_CALIB_00_SOFT,ALM_S4_128TRIGGER_0 added
 *
 *  Revision 1.16  2005/01/26 18:46:48  sebastiani
 *  new bug fixes for WS
 *
 *  Revision 1.15  2005/01/10 14:02:13  faber
 *  TRG,AC_1,AC_2,TOF Error Handler reviewed
 *
 *  Revision 1.14  2004/11/19 15:41:50  sebastiani
 *  *** empty log message ***
 *
 *  Revision 1.13  2004/11/19 15:14:52  sebastiani
 *  PRH_EXTERN_{VAR,ARR,TABLE} removed and put them on the autogenerated parameter heeader file
 *
 *  Revision 1.12  2004/09/17 15:52:00  faber
 *  fix command queue Cmd2Fe/Fe2Daq right invocation for Test funcion inf TOF and TRG
 *
 *  Revision 1.11  2004/09/17 15:01:00  faber
 *  LU_INFN_LOG flags fixing
 *
 *  Revision 1.10  2004/09/13 14:16:53  faber
 *  ErrorHandler for TOF/TRG + Test function TOF/TRG
 *
 *  Revision 1.9  2004/08/31 09:08:35  sebastiani
 *  fix warning
 *
 *  Revision 1.8  2004/08/27 13:30:39  alfarano
 *  cvs header
 *
 *  Revision 1.1  2003/10/03 16:12:26  faber
 *  *** empty log message ***
 *
 *                                                                           
 *****************************************************************************/
/*============================= Include File ================================*/


#include <src/INFN/LU_SourceFileID_INFN.h>
#define __FILEID__ _TOF_TimeOfFlight_INFN__c

#include <src/INFN/PRH_ParamHandler_INFN.h>
#include <src/INFN/LU_LogUtility_INFN.h>
#include <src/INFN/PRH_ParamHandler_INFN_auto.h>
LU_DECL_MASK();

#include <src/INFN/DAQ_IDAQ_INFN.h>
#include <src/INFN/CM_Common_INFN.h>
#include <src/INFN/KHB_Driver_INFN.h>
#include <src/INFN/TOF_TimeOfFlight_INFN.h>

#include <src/INFN/CH_CommandHandler_INFN.h>
#include <src/INFN/HK_Manager_INFN.h>
#include <src/INFN/HB_HKBuffer_INFN.h>
#include <src/INFN/ALM_Alarm_INFN.h>
#include <src/INFN/MH_ModeHandler_INFN.h>

/*============================ Global define ================================*/

#define _LU_EXIT_IFERROR(status) do\
{\
  if ((status) != CM_RC_SUCCESSFUL)\
    {\
      /* HK_UpdateKHBMaskRegister(KHB_MASK_ALL,KHB_PRESET); */ \
//      TOF_STATUS = 0; \
      LU_INFN_LOG(LU_CRITICAL|LU_HA,LU_MASK(__FILEID__),__FILEID__,__LINE__,status);\
      return(status);\
    }\
} while (0)


/*============================== global types  ==============================*/

//#define TOF_FE_RESET_BASE_ID CH_TOF_FE_RESET_0

DAQ_DECLBUF(TOF_buf_data,SM_DAQPKTSIZE);

static DAQ_CMD_BUF TOF_WRITE_PMT_THR_1;
static DAQ_CMD_BUF TOF_WRITE_PMT_THR_2;
static DAQ_CMD_BUF TOF_WRITE_PMT_THR_3;
static DAQ_CMD_BUF TOF_WRITE_PMT_THR_4;
static DAQ_CMD_BUF TOF_WRITE_PMT_THR_5;
static DAQ_CMD_BUF TOF_WRITE_PMT_THR_6;
// static UINT32 TOF_STATUS;

void TOF_Init_TOF_Buffer() 
{
  DAQ_INIT_BUF_FROM_PARAMBUF(TOF_WRITE_PMT_THR_1);
  DAQ_INIT_BUF_FROM_PARAMBUF(TOF_WRITE_PMT_THR_2);
  DAQ_INIT_BUF_FROM_PARAMBUF(TOF_WRITE_PMT_THR_3);
  DAQ_INIT_BUF_FROM_PARAMBUF(TOF_WRITE_PMT_THR_4);
  DAQ_INIT_BUF_FROM_PARAMBUF(TOF_WRITE_PMT_THR_5);
  DAQ_INIT_BUF_FROM_PARAMBUF(TOF_WRITE_PMT_THR_6);
}

status_code TOF_Init() 
{
  DAQ_BUFFER_INIT(TOF_buf_data);

  TOF_Init_TOF_Buffer();

  TOF_Init_ATOETO();

  return CM_RC_SUCCESSFUL;
}

/*
status_code TOF_GetTofStatus(UINT32 *status)
{
  *status = TOF_STATUS;
  return CM_RC_SUCCESSFUL;
}
*/
status_code TOF_Init_ATOETO()
{
  int i;

  //  CH_SetAtoEto(CH_TOF_WRITE_MASK,0,1);
  CH_SetAtoEto(CH_TOF_ALARM_READ,1,2);
  //  CH_SetAtoEto(CH_TOF_ROW_MODE,0,1);
  // CH_SetAtoEto(CH_TOF_DSP_MODE,0,1);
  CH_SetAtoEto(CH_TOF_FE_CLEAR,0,1);

  //  for(i=0; i < 7; i++)
  //  CH_SetAtoEto(TOF_FE_RESET_BASE_ID+i,0,1);

  CH_SetAtoEto(CH_TOF_WRITE_PMT_THR_H_1,0,1);
  CH_SetAtoEto(CH_TOF_WRITE_PMT_THR_H_2,0,1);
  CH_SetAtoEto(CH_TOF_WRITE_PMT_THR_H_3,0,1);
  CH_SetAtoEto(CH_TOF_WRITE_PMT_THR_H_4,0,1);
  CH_SetAtoEto(CH_TOF_WRITE_PMT_THR_H_5,0,1);
  CH_SetAtoEto(CH_TOF_WRITE_PMT_THR_H_6,0,1);

  CH_SetAtoEto(CH_TOF_FE_TDC_ACQ_1,1,2);
  CH_SetAtoEto(CH_TOF_FE_TDC_ACQ_2,1,2);
  CH_SetAtoEto(CH_TOF_FE_TDC_ACQ_3,1,2);
  CH_SetAtoEto(CH_TOF_FE_TDC_ACQ_4,1,2);
  CH_SetAtoEto(CH_TOF_FE_TDC_ACQ_5,1,2);
  CH_SetAtoEto(CH_TOF_FE_TDC_ACQ_6,1,2);
  CH_SetAtoEto(CH_TOF_FE_TDC_ACQ_7,1,2);
  CH_SetAtoEto(CH_TOF_FE_TDC_ACQ_8,1,2);
  CH_SetAtoEto(CH_TOF_FE_TDC_ACQ_9,1,2);
  CH_SetAtoEto(CH_TOF_FE_TDC_ACQ_10,1,2);
  CH_SetAtoEto(CH_TOF_FE_TDC_ACQ_11,1,2);
  CH_SetAtoEto(CH_TOF_FE_TDC_ACQ_12,1,2);
  
  CH_SetAtoEto(CH_TOF_FE_RESET_1,0,1);
  CH_SetAtoEto(CH_TOF_FE_RESET_2,0,1);
  CH_SetAtoEto(CH_TOF_FE_RESET_3,0,1);
  CH_SetAtoEto(CH_TOF_FE_RESET_4,0,1);
  CH_SetAtoEto(CH_TOF_FE_RESET_5,0,1);
  CH_SetAtoEto(CH_TOF_FE_RESET_6,0,1);

  CH_PARAMBUF_SET_ATO_ETO(TOF_WRITE_PMT_THR_1,0,1);
  CH_PARAMBUF_SET_ATO_ETO(TOF_WRITE_PMT_THR_2,0,1);
  CH_PARAMBUF_SET_ATO_ETO(TOF_WRITE_PMT_THR_3,0,1);
  CH_PARAMBUF_SET_ATO_ETO(TOF_WRITE_PMT_THR_4,0,1);
  CH_PARAMBUF_SET_ATO_ETO(TOF_WRITE_PMT_THR_5,0,1);
  CH_PARAMBUF_SET_ATO_ETO(TOF_WRITE_PMT_THR_6,0,1);
}

status_code TOF_Initialization()
{
  status_code status;
  DAQ_CMD_BUF* auto_buf;  
  UINT16 alarm_reg;

  //  TOF_STATUS = 1;

  DAQ_Format_CMD_Empty(&TOF_buf_data);
  status = DAQ_ResetPIF(DAQ_DEFAULT_ETO_TICS,DAQ_MAX_DTO_TICS,SM_DAQSETUP,HB_PKTTYPE_TOF_INIT);

  CH_GetBuf(CH_TOF_FE_CLEAR,&auto_buf );
  DAQ_Format_Cmd2Fe(&TOF_buf_data,auto_buf,DAQ_FE_TOF);
  
  CH_GetBuf(CH_DUMMY_COMMAND,&auto_buf);
  DAQ_Format_Cmd2Fe(&TOF_buf_data,auto_buf,DAQ_FE_SPARE);

  DAQ_Format_Cmd2Fe(&TOF_buf_data,&TOF_WRITE_PMT_THR_1,DAQ_FE_TOF);
  DAQ_Format_Cmd2Fe(&TOF_buf_data,auto_buf,DAQ_FE_SPARE);
  DAQ_Format_Cmd2Fe(&TOF_buf_data,&TOF_WRITE_PMT_THR_2,DAQ_FE_TOF);
  DAQ_Format_Cmd2Fe(&TOF_buf_data,auto_buf,DAQ_FE_SPARE);
  DAQ_Format_Cmd2Fe(&TOF_buf_data,&TOF_WRITE_PMT_THR_3,DAQ_FE_TOF);
  DAQ_Format_Cmd2Fe(&TOF_buf_data,auto_buf,DAQ_FE_SPARE);
  DAQ_Format_Cmd2Fe(&TOF_buf_data,&TOF_WRITE_PMT_THR_4,DAQ_FE_TOF);
  DAQ_Format_Cmd2Fe(&TOF_buf_data,auto_buf,DAQ_FE_SPARE);
  DAQ_Format_Cmd2Fe(&TOF_buf_data,&TOF_WRITE_PMT_THR_5,DAQ_FE_TOF);
  DAQ_Format_Cmd2Fe(&TOF_buf_data,auto_buf,DAQ_FE_SPARE);
  DAQ_Format_Cmd2Fe(&TOF_buf_data,&TOF_WRITE_PMT_THR_6,DAQ_FE_TOF);
  DAQ_Format_Cmd2Fe(&TOF_buf_data,auto_buf,DAQ_FE_SPARE);

  status = DAQ_StoreCmdQueue2PIF(SM_CALEXP0,&TOF_buf_data);	    
  LU_EXIT_IFERROR(status);
  status = DAQ_SendCmdQueue2CMDIF(SM_CALEXP0);
  LU_EXIT_IFERROR(status);	  		  	  
  
  //  TOF_STATUS = 0;

  return status;
}


status_code TOF_Test_Plan(CH_COMMANDS first,
			  CH_COMMANDS loop_first,CH_COMMANDS loop_second) {
  status_code s;
  DAQ_CMD_BUF *gmt,*tfc;
  DAQ_CMD_BUF *p_first;
  DAQ_CMD_BUF *p_loop_first;
  DAQ_CMD_BUF *p_loop_second;
  DAQ_FE fe_tb = DAQ_SELECT_TRIG(PRH_VAR_TB_LINK);
  int i;

  CH_GetBuf(CH_TB_GIVE_ME_TRIGGER,&gmt);
  CH_GetBuf(CH_TOF_FE_CLEAR,&tfc);
  CH_GetBuf(first,&p_first);
  CH_GetBuf(loop_first,&p_loop_first);
  CH_GetBuf(loop_second,&p_loop_second);

  s=DAQ_Format_Cmd2Fe(&TOF_buf_data,p_first,DAQ_FE_TOF);

  LU_EXIT_IFERROR(s);

  for(i=0;i<9;i++) {
    s=DAQ_Format_Cmd2Fe(&TOF_buf_data,gmt,fe_tb);
    LU_EXIT_IFERROR(s);
    s=DAQ_Format_Fe2Daq(&TOF_buf_data,p_loop_first,DAQ_FE_TOF);
    LU_EXIT_IFERROR(s);
    s=DAQ_Format_Fe2Daq(&TOF_buf_data,p_loop_second,DAQ_FE_TOF);
    LU_EXIT_IFERROR(s);
    s =DAQ_Format_Cmd2Fe(&TOF_buf_data,tfc,DAQ_FE_TOF);
    LU_EXIT_IFERROR(s);
  }
  return s;
}

#if 0
status_code TOF_Test() {
  status_code s;
  DAQ_CMD_BUF *cmd;

  DAQ_Format_CMD_Empty(&TOF_buf_data);
  s = DAQ_ResetPIF(DAQ_DEFAULT_ETO_TICS,DAQ_DEFAULT_DTO_TICS,
			SM_DAQSETUP,HB_PKTTYPE_TEST_TOF);
  LU_EXIT_IFERROR(s);

  CH_GetBuf(CH_TOF_FE_CLEAR,&cmd);
  s=DAQ_Format_Cmd2Fe(&TOF_buf_data,cmd,DAQ_FE_TOF);
  LU_EXIT_IFERROR(s);

  CH_GetBuf(CH_DUMMY_COMMAND,&cmd);
  s=DAQ_Format_Cmd2Fe(&TOF_buf_data,cmd,DAQ_FE_SPARE);
  LU_EXIT_IFERROR(s);
  
  if(PRH_ARR_TOF_PLAN[0])
    s = TOF_Test_Plan(CH_TOF_WRITE_PMT_THR_H_1,CH_TOF_FE_TDC_ACQ_1,CH_TOF_FE_TDC_ACQ_2);
  LU_EXIT_IFERROR(s);

  if(PRH_ARR_TOF_PLAN[1])
    s = TOF_Test_Plan(CH_TOF_WRITE_PMT_THR_H_2,CH_TOF_FE_TDC_ACQ_3,CH_TOF_FE_TDC_ACQ_4);
  LU_EXIT_IFERROR(s);

  if(PRH_ARR_TOF_PLAN[2])
    s = TOF_Test_Plan(CH_TOF_WRITE_PMT_THR_H_3,CH_TOF_FE_TDC_ACQ_5,CH_TOF_FE_TDC_ACQ_6);
  LU_EXIT_IFERROR(s);

  if(PRH_ARR_TOF_PLAN[3])
    s = TOF_Test_Plan(CH_TOF_WRITE_PMT_THR_H_4,CH_TOF_FE_TDC_ACQ_7,CH_TOF_FE_TDC_ACQ_8);
  LU_EXIT_IFERROR(s);
  
  if(PRH_ARR_TOF_PLAN[4])
    s = TOF_Test_Plan(CH_TOF_WRITE_PMT_THR_H_5,CH_TOF_FE_TDC_ACQ_9,CH_TOF_FE_TDC_ACQ_10);
  LU_EXIT_IFERROR(s);

  if(PRH_ARR_TOF_PLAN[5])
    s = TOF_Test_Plan(CH_TOF_WRITE_PMT_THR_H_6,CH_TOF_FE_TDC_ACQ_11,CH_TOF_FE_TDC_ACQ_12);
  LU_EXIT_IFERROR(s);
  
  s = DAQ_StoreCmdQueue2PIF(SM_CALEXP2,&TOF_buf_data);	    
  LU_EXIT_IFERROR(s);

  s = DAQ_SendCmd2PIFWaitDAQReply(SM_CALEXP2,
				  DAQ_STORE_MM,NULL,DAQ_NO_STORE_RAM);
  return s;

}
#endif


status_code TOF_Error_Handler()
{
  status_code status = CM_RC_SUCCESSFUL;
  DAQ_CMD_BUF* auto_buf;
  UINT16 khb_sr;

  DAQ_Format_CMD_Empty(&TOF_buf_data);
  
  CH_GetBuf(CH_TOF_ALARM_READ,&auto_buf);  
  DAQ_Format_Fe2Daq(&TOF_buf_data,auto_buf,DAQ_FE_TOF);

  DAQ_StoreCmdQueue2PIF(SM_CALEXP3,&TOF_buf_data);
  
  status = DAQ_SendCmd2PIFWaitDAQReply(SM_CALEXP3,DAQ_STORE_MM,&TOF_buf_data,DAQ_STORE_RAM);

  if(status != CM_RC_SUCCESSFUL || TOF_buf_data.len  < SM_PKTHEADER_LEN+3) {
    status=CM_RC_DO_RESET_IF_ALM;
  }else{
    if( ( (TOF_buf_data.buf[SM_PKTHEADER_LEN]   & 0x7F) != 0) ||
	( (TOF_buf_data.buf[SM_PKTHEADER_LEN+1] & 0xFF) != 0)
	) {
      status=HK_ReadKHBStatusRegister(&khb_sr);


      if((khb_sr & (KHB_STS_ALARM_IDAQ | KHB_STS_ALARM_TOF)) 
	 || status!=CM_RC_SUCCESSFUL)
	return CM_RC_DO_POWER_OFF_ON;
      if( PRH_VAR_GOM_DURING_ALARM == MH_GOM_INITIALIZATION || 
	  PRH_VAR_GOM_DURING_ALARM == MH_GOM_ACQUISITION ) {
	return CM_RC_DO_RESET_IF_ALM;
      }

    }
  }
  
  return status;
}



