import os, time

#
# Benchmark(path_to_file)
# author  Maurizio Nagni
# version 1.0 - 3 September 2005
#
# Calculate the time spent by a process.
# Data are stored in a CSV format for portability.
#
# Parameters:
#       path_to_file    - the file where to store the result(s)
#

class Benchmark:
    def __init__(self, fileName='/tmp/defaultBenchmark.txt'):
        self.fileName = fileName
        self.file = open(fileName, 'a')

    def __del__(self):
        self.close()
        
    def start(self, path, datFileName, operation = ''):
        self.datFileName = datFileName
        self.operation   = operation
        self.size        = os.path.getsize(path + datFileName)
        self.starter     = time.time()

    def end(self):
        self.ender = time.time()
        #Times oreder is User - System - Elepsed
        self.file.write(self.datFileName + ', ' + time.ctime(self.starter) + ', ' + time.ctime(self.ender) + ', ' + str(self.ender - self.starter) + ', '  + str(self.size) + ', ' + self.operation + '\n')
        self.file.flush()

    def close(self):
        self.file.close()

# Example of usage
#        
#bench = Benchmark('/home/nagni/benchmark.csv')
#filePath = '/home/nagni/Data/'
#fileName = 'DW_050321_202.dat'

#bench.start(path, fileName)
#-------------------------
# Do your operations here
#-------------------------
#bench.end()
#bench.close()

