'''
  scriptProcess()
  author  Maurizio Nagni
  version 1.0 - 21 September 2005

  This class will process all the scripts given the 
  
  Parameters:
 
'''
class scriptsProcess():
    def __init(self, dirPath, scriptPath)
        self.__scriptPath = scriptPath
        self.__dirPath    = dirPath

        #--- Setup ROOT scripts path----
        gROOT.SetMacroPath(self.__scriptPath)
        #--- Setup ROOT in Batch mode----
        gROOT.SetBatch(True)

        
    def __processScripts(self):
            '''
            Here I create the Dictionary defining the  pair scriptName:optionsList for next execution
            
            ''' 
            #PacketScan(TString base, TString outDirectory = "", TString format = "gif")
            scriptDict = {'PacketScan': ', "", "eps"'}
            
            #NeutronDetectorScan(TString base, TString outDir = "", TString format = "gif")
            scriptDict.update({'NeutronDetectorScan': ', "", "eps"'})

            #TmtcTemperature(TString base, TString outDir = "", TString format = "gif")
            scriptDict.update({'TmtcTemperature': ', "", "eps"'})

            #S4Scan(TString base, int num = 0, TString autoSc = "true",TString outDirectory = "", TString format = "gif")
            scriptDict.update({'S4Scan': ', 0, "true", "", "eps"'})

            #CalibS4Scan(TString base, int num = 0, TString autoSc = "true", TString outDir = "", TString format = "gif")
            scriptDict.update({'CalibS4Scan': ', 0, "true", "", "eps"'})

            #HeaderScan(TString base, TString outDirectory = "", TString format = "gif")
            scriptDict.update({'HeaderScan': ', "", "eps"'})

            #TrackerScan(TString base, TString outDir = "", Int_t event = -1, TString format = "gif")
            scriptDict.update({'TrackerScan': ', "", -1, "eps"'})

            #CaloCHKSTRIPS(TString filename, Int_t calibnumber=0, TString outDir = "", Int_t INTERACTIVE=0, TString saveas = "gif")
            scriptDict.update({'CaloCHKSTRIPS': ', 0, "", 0, "eps"'})

            #CaloMIP(TString filename, Int_t view = 0, Int_t plane = 0, Int_t strip = 0,  Int_t fromevent = 0, Int_t toevent = 0, TString outDir = "", TString saveas = "gif")
            #scriptDict.update({'CaloMIP': ', 0, 0, 0, 0, 0, "", "eps"'})

            #CaloQLOOK(TString filename, Int_t fromevent=0, Int_t toevent=0, TString outDir = "", TString saveas = "gif")
            scriptDict.update({'CaloQLOOK': ', 0, 0, "", "eps"'})

            #CaloPULSE(TString filename, TString outDir = "", Int_t tosave = 0, TString saveas = "eps")
            scriptDict.update({'CaloPULSE': ', "", 1, "eps"'})

            #LogToXML(TString base, TString outDirectory = "", TString runBr = "true")
            scriptDict.update({'LogToXML': ', "", "false"'})

            #VarDumpToXML(TString base, TString outDirectory = "", TString runBr = "true", TString jData = "false")
            scriptDict.update({'VarDumpToXML': ', "", "false", "true"'})

            #ArrDumpToXML(TString base, TString outDirectory = "", TString runBr = "true", TString jData = "false")
            scriptDict.update({'ArrDumpToXML': ', "", "false", "true"'})

            #RunHeaderToXML(TString base, TString outDirectory = "", TString runBr = "true", TString jData = "false")
            scriptDict.update({'RunHeaderToXML': ', "", "false", "true"'})

            #PhysEndRunToXML(TString base, TString outDirectory = "", TString runBr = "true", TString jData = "false")
            scriptDict.update({'PhysEndRunToXML': ', "", "false", "true"'})

            #McmdToXML(TString base, TString outDirectory = "", TString runBr = "true", TString jData = "false")
            scriptDict.update({'McmdToXML': ', "", "false", "true"'})
            
            #AcQLOOK(TString base,int fromevent=0, int toevent=0, TString outDir = "", TString format = "gif")
            scriptDict.update({'AcQLOOK': ', 0, 0, "", "eps"'})

            #AcCALIB(TString base, TString sec_base = "", TString outDir = "", TString format = "gif")
            scriptDict.update({'AcCALIB': ', "", "", "eps"'})

            #TrackerQLOOK(TString base,Int_t fromevent=0,Int_t toevent=0, TString outdir = "")
            scriptDict.update({'TrackerQLOOK': ', 0, 0, ""'})

            #TrkCalibQLOOK(TString base,Int_t step=0,Int_t fromevent = 0, Int_t toevent = 0, TString outdir = "")
            scriptDict.update({'TrkCalibQLOOK': ', 0, 0, 0, ""'})
            
            #TOFScan(TString base, TString outDirectory = "", TString format = "gif")
            scriptDict.update({'TOFScan': ', "", "eps"'})

            #TriggerScan(TString base, TString outDirectory = "", TString format = "gif")
            scriptDict.update({'TriggerScan': ', "", "eps"'})
            
            #dirPath = self.__targetHost + self.__fileName.split('.')[0] + "00/"
            for (fun, opt) in scriptDict.iteritems():
                pid = os.fork()
                if pid == 0:
                    #Child process
                    #First of all I have to disconnect the child process from the parent XDisplay
                    # Set close-on-exec for all (guess 30 max) file descriptors.
                    for fd in range(30):
                        try:
                            fcntl.fcntl(fd, fcntl.F_SETFD, 1)
                        except IOError: # Probably fd is not open.
                            pass
                    #-----------------------------------------------------------------------------    
                    #Then I start to analize
                    if ((gROOT.LoadMacro(scriptPath + fun + '.c') == 0) or (gROOT.LoadMacro(scriptPath + fun + '.cc') == 0)):
                        try:
                            cmd = fun + '("' + self.__dirPath + '"' + opt + ')'
                            print 'Executing scritp ' + fun
                            gROOT.ProcessLineSync(r''+cmd)
                        except error:
                            print 'Error on executing scritp ' + fun #+ ' Here the stack \n' + Exception.str()
                    else :
                        print 'Error on loading scritp ' + fun #+ ' Here the stack \n' + Exception.str()
                    os._exit(0)
                else:
                    #Parent process
                    try:
                        wpid,exitstatus = os.waitpid(pid, 0)
                    except OSError, e:
                        print str(e)
            #os.putenv("DISPLAY",storeDisplay)
