############################################################################
#    Copyright (C) 2006 by Maurizio Nagni   #
#    nagni@roma2.infn.it   #
#                                                                          #
#    This program is free software; you can redistribute it and#or modify  #
#    it under the terms of the GNU General Public License as published by  #
#    the Free Software Foundation; either version 2 of the License, or     #
#    (at your option) any later version.                                   #
#                                                                          #
#    This program is distributed in the hope that it will be useful,       #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of        #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         #
#    GNU General Public License for more details.                          #
#                                                                          #
#    You should have received a copy of the GNU General Public License     #
#    along with this program; if not, write to the                         #
#    Free Software Foundation, Inc.,                                       #
#    59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             #
############################################################################
#!/usr/bin/env python
# l2manager.py 
# Author: Maurizio Nagni
# Date: 4 February 2006
#
# Description:
# 	First implementation of the L2Manager for the processing of the
# 	PAMELA RUNs up to Level2 data. To execute from the command line:
#
#	python l2manager.py configFile.conf
#
#	where configFile have to be conform to the structure
#
#	[L2Manager]
#	l2Manager_log: 	/pathToLogFile/xxx.log
#	libyoda_file: 	/pathToLibYoda/libyoda.so


import sys, os, time, logging
from ConfigParser import *
from ROOT import *
from ngn.pamela.L2Manager import L2Manager

def main():
	if len(sys.argv) > 1:
		confFile = sys.argv[1]
		if not (os.access(confFile, os.F_OK)):
			print 'Cannot find configuration file. \n'
			sys.exit(1)
	else:
		print 'Please insert a configuration file path.\n'
		sys.exit(1)        
		
	config = ConfigParser()
	config.read(confFile)
	try:
		logfile = config.get('L2Manager', 'l2Manager_log')
		libPath = config.get('L2Manager', 'libyoda_file')
		DETECTORS_BRANCHES = ['Trigger', 'Tof']
		MAIN_TREE = 'Physics'
	except NoSectionError, detail:
		print 'Section missing in configuration file: ', detail
		sys.exit(1)
	except NoOptionError, detail:
		print 'Wrong option in configuration file: ', detail
		sys.exit(1)
		
	#initialize the logger
	logger = logging.getLogger(logfile)
	hdlr = logging.FileHandler(logfile)
	formatter = logging.Formatter('%(asctime)s %(levelname)s %(message)s')
	hdlr.setFormatter(formatter)
	logger.addHandler(hdlr) 
	logger.setLevel(logging.DEBUG)
	
	runs = selectRUNs()
	manager = L2Manager(runs, libPath, logger, DETECTORS_BRANCHES, MAIN_TREE)
	manager.processRuns()
	logger.info('Main terminated \n')


#Select RUN from the database according to some rules (???)
def selectRUNs():
	print 'SELECT RUNs!'
	return [1, 2]

#Just for test....
main()

