#!/bin/bash

#
# !!! AGGIUNGERE RETRIEVING TLE!
#

source /gpfs/wizard/flight/production/installed/set_pam_env.sh > /dev/null 2>&1;

if [ "$PAM_BIN" == "" ]; then exit; fi

export PRODDIR=/gpfs/wizard/flight/production/

export POSTRR=$PRODDIR/postRawreader/

export L0=$PRODDIR/level0/

export WRKDIR=$PRODDIR/deamons/wrkdir/

export LOGDIR=$PRODDIR/logs/

export SCRIPT=$PRODDIR/deamons/script/

export DB=pamela
#export DB=test

export HOST=srv-g2-01.ts.infn.it

export USER=root

export PSW=Calo0%Ts

touch $WRKDIR/dv.dvlist

LOG=$WRKDIR/dv.log

BUSY=$WRKDIR/dvlist.busy

touch $LOG

touch $BUSY

echo -n " DEAMON STARTED AT " >> $LOG;

date >> $LOG;

echo "494" > $WRKDIR/dv.step 

TIME=`tail -1 $WRKDIR/dv.step`;

while [ $TIME -gt 0 ]; do

    echo " Retrieving latest TLE " >> $LOG;
    
    $SCRIPT/retrieve_TLE.sh --output=$WRKDIR/tle.txt >> $LOG 2>&1;
    
    if [ -s $WRKDIR/tle.txt ]; then

	echo " Calling YodaProfiler to fill TLE in the DB " >> $LOG;

	YodaProfiler -tle $WRKDIR/tle.txt >> $LOG 2>&1;

    fi
    
    PRIMA=`date -u +%s`

    let PRIMA=$PRIMA-7200

    export QUERY="select ID from GL_RUN where INSERT_TIME<FROM_UNIXTIME('${PRIMA}')"

    mysql --host=$HOST -u $USER --password=$PSW --execute="${QUERY}" $DB | sed 's/|//g' | tr -d [ID] &> $WRKDIR/dv.runlist ;

#    mysql --host=$HOST -u $USER --password=$PSW --execute="select ID from GL_RUN where VALIDATION=1;" $DB | sed 's/|//g' | tr -d [ID] &> $WRKDIR/dv.runlist ;
#    echo "6622" > $WRKDIR/dv.runlist;
	
    for run in `sort $WRKDIR/dv.runlist`; do

	DONE=0;

	for rundone in `cat $WRKDIR/dv.dvlist`; do

	    if [ $run -eq $rundone ]; then

		DONE=1;

	    fi;

	done;

	if [ $DONE -eq 0 ]; then
	
	    echo " Submitting job for run $run "
	
	    sleep 1;

	    R=0;

	    TEST=""
					
	    while [ "$TEST" == "" ] && [ $R -lt 10 ]; do
					
		let R=$R+1;
					    
		QUEUE=ts_wizard

		CHECK=`bhist -q "${QUEUE}" -p`; 

		while [ "$CHECK" != "No matching job found" ]; do
	    
		    sleep 20;

		    CHECK=`bhist -q "${QUEUE}" -p`; 
				    
		    if [ "$CHECK" != "No matching job found" ]; then

			CHECK2=`bhist -q "normal" -p`; 

			if [ "$CHECK2" == "No matching job found" ]; then

			    echo " Using normal queue since ts_wizard is full " >> $LOG;

			    QUEUE="normal";
					    
			    CHECK=`bhist -q "${QUEUE}" -p`;
					    
			fi;
					
		    fi;

		done; 

		SUBO=`bsub -q $QUEUE -oo $LOGDIR/dv.lsf.$run.log $SCRIPT/dv.sh $run`;
					    
		echo " Output from LSF is: $SUBO " >> $LOG;
					    
		TEST=`echo $SUBO | grep "is submitted"`;
					    
		if [ "$TEST" == "" ]; then 
					    
		    echo " Send LSF job failure! " >> $LOG;
						
		    echo " Retry n. $R " >> $LOG;
						
		fi
					    
	    done
				    
	    if [ $R -ge 10 ]; then
					    
		echo -n " PROBLEMS SENDING LSF JOBS! " >> $LOG;
					    
		date >> $LOG;
						
		echo " Run $run not processed yet, I will retry later " >> $LOG;
					
	    else				    

		CHOK=`tail -1 $BUSY`;
						
		if [ "$CHOK" == "" ]; then
							
		    echo "0" > $BUSY;

		    CHOK=`tail -1 $BUSY`;

		fi

		while [ $CHOK -eq 1 ]; do
					    
		    echo -n " LIST FILE IS BUSY " >> $LOG;
			    
		    date >> $LOG;
					    
		    sleep 1;

		    CHOK=`tail -1 $BUSY `;
		    		    
		done
					    
		echo "1" > $BUSY;

		echo $run >> $WRKDIR/dv.dvlist;
					    
		echo "0" > $BUSY;

		TIME=`tail -1 $WRKDIR/dv.step `;
		
		while [ $TIME -eq 1 ]; do

		    echo -n " TIME = 1! DEAMON PAUSE " >> $LOG;

		    date >> $LOG;

		    sleep 120;

		    TIME=`tail -1 $WRKDIR/dv.step `;
					    
		done

		if [ $TIME -le 0 ]; then

		    echo -n " EXIT DEAMON, RECEIVED TERM SIGNAL " >> $LOG;
				
		    date >> $LOG;
					
		    exit;

		fi;
				
	    fi;

	fi;

    done;

    TIME=`tail -1 $WRKDIR/dv.step `;
		
    while [ $TIME -eq 1 ]; do

	echo -n " TIME = 1! DEAMON PAUSE " >> $LOG;

	date >> $LOG;

	sleep 120;

	TIME=`tail -1 $WRKDIR/dv.step `;
		    		    
    done;

    if [ $TIME -le 0 ]; then

	echo -n " EXIT DEAMON, RECEIVED TERM SIGNAL " >> $LOG;

	date >> $LOG;

	exit;

    fi

    sleep $TIME;

    TIME=`tail -1 $WRKDIR/dv.step `;

done;

echo -n " EXIT DEAMON, RECEIVED TERM SIGNAL " >> $LOG;

date >> $LOG;
