#!/bin/bash

source /gpfs/wizard/flight/production/installed/set_pam_env.sh

source /gpfs/wizard/UIPnP/UIPnP.sh

if [ "$PAM_BIN" == "" ]; then exit; fi

export PRODDIR=/gpfs/wizard/flight/production/

export PRERR=$PRODDIR/preRawreader/

export WRKDIR=$PRODDIR/deamons/wrkdir/

export LOGDIR=$PRODDIR/logs/

#export CASTOR=gsiftp://lxfarm08.mephi.ru/scratch04/preRawreader/
export CASTOR=gsiftp://castorgrid.cr.cnaf.infn.it/castor/cnaf.infn.it/pamela/pamela-cnaf/data/flight/preRawreader/

touch $WRKDIR/copy.copylist

LOG=$WRKDIR/copy.log

STEP=$WRKDIR/copy.step

touch $LOG

echo -n " DEAMON STARTED AT " >> $LOG;

date >> $LOG;

echo "600" > $STEP;

TIME=`tail -1 $STEP`;

STARTPROXY=`date +%s`

voms-proxy-init --voms pamela -pwstdin < $WRKDIR/connect

while [ $TIME -gt 0 ]; do

    STOPPROXY=`date +%s`

    let DELTAPROXY=$STOPPROXY-$STARTPROXY

    if [ $DELTAPROXY -gt 6000 ]; then
	
	STARTPROXY=`date +%s`

	voms-proxy-init --voms pamela -pwstdin < $WRKDIR/connect;

	echo -n "(1) EXPIRED PROXY: " >> $LOG;

	date >> $LOG;	

    fi
	
    edg-gridftp-ls $CASTOR &> $WRKDIR/copy.rawlist
#    ls $PRERR/02202004.pam &> $WRKDIR/copy.rawlist;

    echo -n "#############>>>> DATE: " >> $LOG;	

    date >> $LOG;	

    for file in `sort -r $WRKDIR/copy.rawlist`; do
#    for file in `sort $WRKDIR/copy.rawlist`; do

	DONE=0;

	CHECK=`grep $file $WRKDIR/copy.copylist`;

	CHECKPAM=`echo $file | grep pam`

	if [ "${CHECK}" != "" ]; then 

	    DONE=1;

	fi;

	if [ "${CHECKPAM}" == "" ]; then 

	    DONE=1;

	fi;

	if [ -s $PRERR/$file ]; then
		
	    DONE=1;
	
	fi;	


#	for sentfile in `cat $WRKDIR/copy.copylist`; do

#	    CHECKPAM=`echo $file | grep pam`

#	    FNAME=`basename $file`				    

#	    if [ "${FNAME}" == "${sentfile}" ] || [ "${CHECKPAM}" == "" ]; then
	    
#		DONE=1;

#            fi;

#	    if [ -s $PRERR/$FNAME ]; then
		
#		DONE=1;
	
#	    fi;

#        done

        if [ $DONE -eq 0 ]; then

	    FNAME=`basename $file`			

	    STOPPROXY=`date +%s`

	    let DELTAPROXY=$STOPPROXY-$STARTPROXY

	    if [ $DELTAPROXY -gt 6000 ]; then
	
		STARTPROXY=`date +%s`
		
		voms-proxy-init --voms pamela -pwstdin < $WRKDIR/connect

		echo -n "(2) EXPIRED PROXY: " >> $LOG;	

		date >> $LOG;	
	
	    fi

	    CNAME1=`edg-gridftp-ls --verbose $CASTOR | grep $FNAME`;
	    
	    sleep 30;

	    STOPPROXY=`date +%s`

	    let DELTAPROXY=$STOPPROXY-$STARTPROXY

	    if [ $DELTAPROXY -gt 6000 ]; then
	
		STARTPROXY=`date +%s`
		
		voms-proxy-init --voms pamela -pwstdin < $WRKDIR/connect

		echo -n "(2) EXPIRED PROXY: " >> $LOG;	

		date >> $LOG;	
	
	    fi

	    CNAME2=`edg-gridftp-ls --verbose $CASTOR | grep $FNAME`;

	    echo $CNAME2 >> $LOG;
			
	    while [ "$CNAME1" != "$CNAME2" ]; do

		CNAME2=`edg-gridftp-ls --verbose $CASTOR | grep $FNAME`;

		sleep 30;		

		echo -n "UNFINISHED FILE: " >> $LOG;	

		date >> $LOG;	

		echo $CNAME1 >> $LOG;

		echo $CNAME2 >> $LOG;

		STOPPROXY=`date +%s`

		let DELTAPROXY=$STOPPROXY-$STARTPROXY

		if [ $DELTAPROXY -gt 6000 ]; then
	
		    STARTPROXY=`date +%s`
		
		    voms-proxy-init --voms pamela -pwstdin < $WRKDIR/connect
		
		fi
			
		CNAME1=`edg-gridftp-ls --verbose $CASTOR | grep $FNAME`;

	    done;
 
            echo "Transferring $FNAME!" >> $LOG;

	    STOPPROXY=`date +%s`

	    let DELTAPROXY=$STOPPROXY-$STARTPROXY

	    if [ $DELTAPROXY -gt 6000 ]; then

		STARTPROXY=`date +%s`
	
		voms-proxy-init --voms pamela -pwstdin < $WRKDIR/connect

		echo -n "(3) EXPIRED PROXY: " >> $LOG;	

		date >> $LOG;	

	    fi

	    globus-url-copy $CASTOR/$FNAME file://$PRERR/$FNAME;

	    if [ -s $PRERR/$FNAME ]; then

		echo "$FNAME succesfully transmitted (I think)" >> $LOG;

		echo $FNAME >> $WRKDIR/copy.copylist;			

	    else
	    
		echo "Some problem occured for file $FNAME, it is empty" >> $LOG;

		echo "$FNAME scheduled to be retransmitted" >> $LOG;

	    fi;

	    HOUR=`date +%H`;
	    
	    if [ $HOUR -gt 6 ] && [ $HOUR -lt 19 ]; then
	    
		echo "Hour is ${HOUR}, day-time I will sleep for 5 seconds" >> $LOG;

		sleep 5;
		 
	    else

		echo "Hour is ${HOUR}, night-time I will sleep for 1 seconds" >> $LOG;

		sleep 1;

	    fi;

	fi;

        TIME=`tail -1 $STEP `;
		
	if [ $TIME -le 0 ]; then

	    echo -n " EXIT DEAMON, RECEIVED TERM SIGNAL " >> $LOG;

	    date >> $LOG;
	    
	    exit;

	fi

    done;

    sleep $TIME;

    TIME=`tail -1 $STEP`;

done;

echo -n " EXIT DEAMON, RECEIVED TERM SIGNAL " >> $LOG;

date >> $LOG;


#    if [ -f $HDEAM/tr.log ]; then

#	cat $HDEAM/tr.log | mail -s "Log from retrieving deamon" Emiliano.Mocchiutti@ts.infn.it

#	rm -f $HDEAM/tr.log;
	
#    fi;

