#!/bin/bash

export PRODDIR=/gpfs/wizard/flight/production/

export POSTRR=$PRODDIR/postRawreader/

export LOGDIR=$PRODDIR/logs/

export YODA_DATA=$PRODDIR/level0/

export YODA_LOGS=$PRODDIR/level0/

FILE=$1

LOG=$LOGDIR/yoda.`basename $FILE .pam`.log

rm -f $LOG;

touch $LOG;

chmod g+rw $LOG;

echo "#####################################" >> $LOG 2>&1;

echo " YODA LOG FOR FILE $FILE " >> $LOG 2>&1;

echo "#####################################" >> $LOG 2>&1;

echo -n " Start date is: " >> $LOG 2>&1;

date >> $LOG 2>&1;

echo " Job is running on WN: "`hostname` >> $LOG 2>&1;

source /gpfs/wizard/flight/production/installed/set_pam_env.sh > /dev/null 2>&1;

if [ "$PAM_BIN" == "" ]; then 
    
    echo "ERROR DURING PAM_ENV SETUP!" >> $LOG 2>&1; 

    exit; 

fi

if [ -f $YODA_DATA/`basename $FILE .pam`.root ]; then

    R=0;

    while [ -f $YODA_DATA/`basename $FILE .pam`.root.$R ]; do

	let R=$R+1;
    
    done;
    
    OLDFILE=$YODA_DATA/`basename $FILE .pam`.root ;
    
    NEWFILE=$YODA_DATA/`basename $FILE .pam`.root.$R ;

    echo " File $OLDFILE already exists, renamed to $NEWFILE " >> $LOG 2>&1;

    mv -f $OLDFILE $NEWFILE >> $LOG 2>&1;
    
fi;

yoda $FILE >> $LOG 2>&1;

if [ -f $YODA_DATA/`basename $FILE .pam`.root ]; then
	chmod g+rw $YODA_DATA/`basename $FILE .pam`.root >> $LOG 2>&1;
fi;
if [ -f $YODA_DATA/`basename $FILE .pam`Corrupted.dat ]; then 
	chmod g+rw $YODA_DATA/`basename $FILE .pam`Corrupted.dat >> $LOG 2>&1;
fi;

echo -n " End date is: " >> $LOG  2>&1;

date >> $LOG 2>&1;



