#!/bin/bash

export PRODDIR=/gpfs/wizard/flight/production/

export RAWDIR=$PRODDIR/preRawreader/

export RRDIR=$PRODDIR/Rawreader/

export CLN1DIR=$PRODDIR/postRawreader/

export LOGDIR=$PRODDIR/logs/

export INFTXT=$LOGDIR/rr/inf_and_txt/

FILE=$1

LOG=$LOGDIR/rr.`basename $FILE .pam`.log

rm -f $LOG;

touch $LOG;

chmod g+rw $LOG;

echo "#####################################" >> $LOG 2>&1;

echo " RAWREADER LOG FOR FILE $FILE " >> $LOG 2>&1;

echo "#####################################" >> $LOG 2>&1;

echo -n " Start date is: " >> $LOG 2>&1;

date >> $LOG 2>&1;

echo " Job is running on WN: "`hostname` >> $LOG 2>&1;

source /gpfs/wizard/flight/production/installed/set_pam_env.sh > /dev/null 2>&1;

if [ "$PAM_BIN" == "" ]; then 
    
    echo "ERROR DURING PAM_ENV SETUP!" >> $LOG 2>&1; 

    exit; 

fi

ROUTE=${FILE:0:5}
DOWN0=${FILE:5:7}
DOWN=`basename $DOWN0 .pam`

RawReader.exe $RAWDIR $FILE >> $LOG 2>&1;

FOUND=0;

for file in `find $RRDIR/$ROUTE/ -name ${ROUTE}_${DOWN}_*_cln1.pam`;  do

    mv -f $file $CLN1DIR >> $LOG 2>&1;
	    
    chmod g+rw $CLN1DIR/`basename $file` >> $LOG 2>&1;

    FOUND=1;

done

mv -f $RRDIR/$ROUTE/`basename $FILE .pam`_cln1.inf $INFTXT >> $LOG 2>&1;
 
chmod g+rw $INFTXT/`basename $FILE .pam`_cln1.inf >> $LOG 2>&1;

mv -f $RRDIR/$ROUTE/`basename $FILE .pam`_protocol.txt $INFTXT >> $LOG 2>&1;
	    
chmod g+rw $INFTXT/`basename $FILE .pam`_protocol.txt >> $LOG 2>&1;

rm -rf $RRDIR/$ROUTE/`basename $FILE .pam`_* >> $LOG 2>&1;

rm -rf $RRDIR/$ROUTE/${DOWN}_* >> $LOG 2>&1;

TEST=`ls $RRDIR/$ROUTE/`;

if [ "$TEST" == "" ]; then

    rm -rf $RRDIR/$ROUTE/ >> $LOG 2>&1;

fi;

echo -n " End date is: " >> $LOG  2>&1;

date >> $LOG 2>&1;


