#!/bin/bash

source /gpfs/wizard/flight/production/installed/set_pam_env.sh > /dev/null 2>&1;

if [ "$PAM_BIN" == "" ]; then exit; fi

export PRODDIR=/gpfs/wizard/flight/production/

export L0=$PRODDIR/level0/good/

export CLN1=$PRODDIR/postRawreader/

export WRKDIR=$PRODDIR/deamons/wrkdir/

export SCRIPT=$PRODDIR/deamons/script/

export LOGDIR=$PRODDIR/logs/

export PAM_DBHOST=mysql://srv-g2-01.ts.infn.it/pamela
#export PAM_DBHOST=mysql://srv-g2-01.ts.infn.it/test
#export PAM_DBHOST=mysql://localhost/emitest?socket=`mysql_config --socket`

export PAM_DBUSER=root

export PAM_DBPSW=Calo0%Ts

touch $WRKDIR/profiler.profilerlist

LOG=$WRKDIR/profiler.log

touch $LOG

echo -n " YODAPROFILER DEAMON STARTED AT " >> $LOG;

date >> $LOG;

echo "300" > $WRKDIR/profiler.step 

TIME=`tail -1 $WRKDIR/profiler.step`;

while [ $TIME -ne 0 ]; do

	ls $L0/*.root &> $WRKDIR/profiler.yodalist 2>/dev/null;

	for nfile in `sort $WRKDIR/profiler.yodalist`; do

		file=`basename $nfile`
	    
		DONE=0;

		for procfile in `cat $WRKDIR/profiler.profilerlist`; do

			if [ $file == $procfile ]; then

				DONE=1;

			fi;

		done;

		while [ $DONE -eq 0 ]; do

                        NOW=`date +%s`

                        CTIME=`date --reference=$nfile +%s`

                        let DELTA=NOW-CTIME

                        while [ $DELTA -lt 300 ]; do

                                echo "File $file is hot! waiting 59 seconds..." >> $LOG;

                                sleep 59;

				NOW=`date +%s`

				CTIME=`date --reference=$nfile +%s`

				let DELTA=NOW-CTIME

                        done;
			
			echo -n "FILE IS COLD NOW: " >> $LOG;	

			date >> $LOG;

               	        echo "Processing file $file!" >> $LOG;

			R=0;

			if [ -s $L0/$file ]; then

			    echo " File $file is on disk! " >> $LOG;
				    
			else

			    COPY="";

			    echo " File not found on disk or empty! " >> $LOG;

			    date +%s >> $LOG;

			    R=2;

			fi

			if [ $R -gt 1 ]; then

			    echo -n " PROBLEMS! " >> $LOG;
					
			    echo " File $file not processed yet, I will retry later " >> $LOG;
				    
			else

			    YodaProfiler -rawFile $CLN1/$file -yodaFile $L0/$file >> $LOGDIR/profiler.`basename $file .root`.log 2>&1 ;
#			    YodaProfiler -force -rawFile $CLN1/$file -yodaFile $L0/$file >> $LOGDIR/profiler.`basename $file .root`.log 2>&1 ;

			    echo $file >> $WRKDIR/profiler.profilerlist;
					    
			    sleep 15;

			fi;

			DONE=1;

		done;

		TIME=`tail -1 $WRKDIR/profiler.step `;
		
		while [ $TIME -eq 1 ]; do

		    TIME=`tail -1 $WRKDIR/profiler.step `;
		    		    
		    echo -n " TIME = 1! DEAMON PAUSE " >> $LOG;

		    date >> $LOG;

		    sleep 120;

 		done

		if [ $TIME -le 0 ]; then

		    echo -n " EXIT DEAMON, RECEIVED TERM SIGNAL " >> $LOG;

		    date >> $LOG;

		    exit;

 		fi

	done;

        TIME=`tail -1 $WRKDIR/profiler.step `;
		
	if [ $TIME -le 0 ]; then

	    echo -n " EXIT DEAMON, RECEIVED TERM SIGNAL " >> $LOG;

	    date >> $LOG;

	    exit;

	fi

	while [ $TIME -eq 1 ]; do

	    TIME=`tail -1 $WRKDIR/profiler.step `;
		    		    
	    echo -n " TIME = 1! DEAMON PAUSE " >> $LOG;

	    date >> $LOG;

	    sleep 120;

	done

	sleep $TIME;

        TIME=`tail -1 $WRKDIR/profiler.step `;

done;

echo -n " EXIT DEAMON, RECEIVED TERM SIGNAL " >> $LOG;

date >> $LOG;
