#!/bin/bash

source /gpfs/wizard/flight/production/installed/set_pam_env.sh > /dev/null 2>&1;

if [ "$PAM_BIN" == "" ]; then exit; fi

export PRODDIR=/gpfs/wizard/flight/production/

export POSTRR=$PRODDIR/postRawreader/

export WRKDIR=$PRODDIR/deamons/wrkdir/

export LOGDIR=$PRODDIR/logs/

export SCRIPT=$PRODDIR/deamons/script/

touch $WRKDIR/yoda.yodalist

LOG=$WRKDIR/yoda.log

BUSY=$WRKDIR/yodalist.busy

touch $LOG

touch $BUSY

echo -n " DEAMON STARTED AT " >> $LOG;

date >> $LOG;

echo "293" > $WRKDIR/yoda.step 
#echo "-300" > $WRKDIR/yoda.step 

TIME=`tail -1 $WRKDIR/yoda.step`;

while [ $TIME -gt 0 ]; do

	ls $LOGDIR/rr/good/rr.[0-9]*.log* > $WRKDIR/yoda.cln1list;
###	ls $LOGDIR/rr/good/rr.00110000.log* > $WRKDIR/yoda.cln1list;
	
	for nfile in `sort $WRKDIR/yoda.cln1list`; do

		DONE=0;

		bfile=`basename $nfile`;
	
		rfile=${bfile:3:5};

		dfile=${bfile:8:3};


		for file in `ls $POSTRR/${rfile}_${dfile}_*_cln*.pam`; do

		    for procfile in `cat $WRKDIR/yoda.yodalist`; do

			    if [ $file == $procfile ]; then

				    DONE=1;

			    fi;

		    done;

		    if [ $DONE -eq 0 ]; then

			NOW=`date +%s`

			CTIME=`date --reference=$file +%s`

			let DELTA=NOW-CTIME

		        if [ $DELTA -gt 300 ]; then

			    echo -n "FILE IS COLD NOW: " >> $LOG;	

			    date >> $LOG;

			    echo "NOW IS $NOW" >> $LOG;
			    
			    echo "LAST ACCESS TIME IS $CTIME" >> $LOG;

			    echo "Processing file $file!" >> $LOG;

			    NOME=`basename $file .pam`

			    R=0;

			    TEST=""
					
			    while [ "$TEST" == "" ] && [ $R -lt 10 ]; do
					
				let R=$R+1;
					    
				QUEUE=ts_wizard

				CHECK=`bhist -q "${QUEUE}" -p`; 

				while [ "$CHECK" != "No matching job found" ]; do
	    
				    sleep 20;

				    CHECK=`bhist -q "${QUEUE}" -p`; 
				    
				    if [ "$CHECK" != "No matching job found" ]; then

					CHECK2=`bhist -q "normal" -p`; 

					if [ "$CHECK2" == "No matching job found" ]; then

					    echo " Using normal queue since ts_wizard is full " >> $LOG;

					    QUEUE="normal";
					    
					    CHECK=`bhist -q "${QUEUE}" -p`;
					    
					fi;
					
				    fi;

				done; 

				SUBO=`bsub -q $QUEUE -oo $LOGDIR/yoda.lsf.$NOME.log $SCRIPT/yoda.sh $file`;
					    
				echo " Output from LSF is: $SUBO " >> $LOG;
					    
				TEST=`echo $SUBO | grep "is submitted"`;
					    
				if [ "$TEST" == "" ]; then 
					    
				    echo " Send LSF job failure! " >> $LOG;
						
				    echo " Retry n. $R " >> $LOG;
						
				fi
					    
			    done
				    
			    if [ $R -ge 10 ]; then
					    
				echo -n " PROBLEMS SENDING LSF JOBS! " >> $LOG;
					    
				date >> $LOG;
						
				echo " File $file not processed yet, I will retry later " >> $LOG;
						
			    else				    

				CHOK=`tail -1 $BUSY`;
						
				if [ "$CHOK" == "" ]; then
							
				    echo "0" > $BUSY;

				    CHOK=`tail -1 $BUSY`;

				fi

				while [ $CHOK -eq 1 ]; do
					    
				    echo -n " LIST FILE IS BUSY " >> $LOG;
					    
				    date >> $LOG;
					    
				    sleep 1;

				    CHOK=`tail -1 $BUSY `;
		    		    
				done
					    
				echo "1" > $BUSY;

				echo $file >> $WRKDIR/yoda.yodalist;
					    
				echo "0" > $BUSY;

				TIME=`tail -1 $WRKDIR/yoda.step `;
		
				while [ $TIME -eq 1 ]; do

				    echo -n " TIME = 1! DEAMON PAUSE " >> $LOG;

				    date >> $LOG;

				    sleep 120;

				    TIME=`tail -1 $WRKDIR/yoda.step `;
					    
				done

				if [ $TIME -le 0 ]; then

				    echo -n " EXIT DEAMON, RECEIVED TERM SIGNAL " >> $LOG;
				
				    date >> $LOG;
					
				    exit;

				fi;
				
			    fi;

			fi;
			    
		    fi;

		done;

	        TIME=`tail -1 $WRKDIR/yoda.step `;
		
		while [ $TIME -eq 1 ]; do

		    echo -n " TIME = 1! DEAMON PAUSE " >> $LOG;

		    date >> $LOG;

		    sleep 120;

		    TIME=`tail -1 $WRKDIR/yoda.step `;
		    		    
 		done;

		if [ $TIME -le 0 ]; then

		    echo -n " EXIT DEAMON, RECEIVED TERM SIGNAL " >> $LOG;

		    date >> $LOG;

		    exit;

 		fi

	    done;

        TIME=`tail -1 $WRKDIR/yoda.step `;
		
	while [ $TIME -eq 1 ]; do

	    echo -n " TIME = 1! DEAMON PAUSE " >> $LOG;

	    date >> $LOG;

	    sleep 120;

	    TIME=`tail -1 $WRKDIR/yoda.step `;
		    		    
	done

	if [ $TIME -le 0 ]; then

	    echo -n " EXIT DEAMON, RECEIVED TERM SIGNAL " >> $LOG;

	    date >> $LOG;

	    exit;

	fi

	sleep $TIME;

        TIME=`tail -1 $WRKDIR/yoda.step `;

done;

echo -n " EXIT DEAMON, RECEIVED TERM SIGNAL " >> $LOG;

date >> $LOG;
