*
* $Id$
*
* $Log$
*
*CMZ :  3.00/00 08/02/2002  17.36.53  by  Unknown
*CMZ :  2.01/00 08/03/2000  18.34.57  by  Unknown
*CMZ :  2.00/00 25/02/2000  15.46.40  by  Francesco Cafagna
*CMZ :  1.02/00 22/10/99  16.17.58  by  Francesco Cafagna
*CMZ :  1.01/00 21/05/96  17.33.37  by  Francesco Cafagna
*CMZ :  1.00/02 04/04/96  16.08.24  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   23/02/96
      SUBROUTINE GPDTRD
************************************************************************
*                                                                      *
* To perform TRD digitization                                          *
*                                                                      *
* Called by: GUDIGI                                                    *
* Author: Francesco Cafagna, 23/02/96 12.50.38                         *
*                                                                      *
************************************************************************
#include "gcunit.inc"
#include "gpphit.inc"
       PARAMETER (NH=NHTRD,NHM=NHMTRD,NVOL=5)
#include "gprhit.inc"
#include "gptrd.inc"
#include "gpsed.inc"
*
      INTEGER IS,ID,NV,NVM,NNHM
      CHARACTER*4 CSET
*
*
* Vector zeroed
*
      CALL VZERO(ITRBS,NHMTRD)
*ML:
*      CALL VZERO(ITRSO,NHMTRD)
      CALL VZERO(ITRSI,NHMTRD)
*END ML.
#if defined(GPAMELA_INTER)
      CALL VZERO(XAVTRD,NHMTRD)
      CALL VZERO(YAVTRD,NHMTRD)
      CALL VZERO(ZAVTRD,NHMTRD)
#endif
#if !defined(GPAMELA_INTER)
      CALL VZERO(XINTRD,NHMTRD)
      CALL VZERO(YINTRD,NHMTRD)
      CALL VZERO(ZINTRD,NHMTRD)
#endif
      CALL VZERO(XOUTTRD,NHMTRD)
      CALL VZERO(YOUTTRD,NHMTRD)
      CALL VZERO(ZOUTTRD,NHMTRD)
      CALL VZERO(ERELTRD,NHMTRD)
      CALL VZERO(PATHTRD,NHMTRD)
      CALL VZERO(P0TRD,NHMTRD)
      CALL VZERO(IPARTRD,NHMTRD)
      CALL VZERO(ETRTRD,NHMTRD)
      CALL VZERO(NTRTRD,NHMTRD)
      CALL VZERO(ELOSTRD,NHMTRD)
      CALL VZERO(NUMD  ,NVOL)
C ML:
#if defined(GPAMELA_GARFIELD)
      CALL VZERO(EGARTRD,NHMTRD)
      CALL VZERO(NGARTRD,NHMTRD)
#endif
C END ML.
*
* Starting from the TOP
*
      NV = NVOL
      NVM= NVMAX
      IS   = ISTRD
      ID   = IDTRSI
      CSET = 'TRD '
      IT = -1
*
* Check on the volume level
*
      IF (NV.GT.NVM) THEN
         WRITE(CHMAIL,10000) CSET,CNSED(IS,ID),NVOL,NVMAX,
     +                        IDRUN,IDEVT
         CALL GMAIL(1,0)
         GO TO 10
      ENDIF
      CALL VZERO(VHITS,NH*NHM)
      CALL VZERO(ITRA ,NHM)
      CALL VZERO(NUMBV,NVOL*NHM)
      NHITS = -1
      CALL GPRHIT(CSET,CNSED(IS,ID),IS,ID,NVOL,NH,NHM,1,
     +            IT,NUMD,ITRA,NUMBV,VHITS,NHITS)
*
* If there was a problem in GPRHIT then exit
*
      IF(NHITS.LT.0) THEN
         WRITE(CHMAIL,10200) CSET,CNSED(IS,ID),NHITS,NHM,
     +                        IDRUN,IDEVT
         CALL GMAIL(1,0)
         NTHTRD = -NHITS
         GO TO 10
      ENDIF
*
* >>>>>>>>>>>>>>>>>>>>>> DIGI action
*
*
* Fill the CWN common
*
      NTHTRD = NHITS
      DO I=1,NHITS
         ITRBS(I) = NUMBV((NVTRD-1),I)
*ML:
*         ITRBS(I) = NUMBV((NVTRD-2),I)
*         ITRSO(I) = NUMBV((NVTRD-1),I)
         ITRSI(I) = NUMBV(NVTRD,I)
*END ML.
#if defined(GPAMELA_INTER)
         XAVTRD(I) = VHITS(1,I)
         YAVTRD(I) = VHITS(2,I)
         ZAVTRD(I) = VHITS(3,I)
         XOUTTRD(I) = VHITS(4,I)
         YOUTTRD(I) = VHITS(5,I)
         ZOUTTRD(I) = VHITS(6,I)
         XINTRD(I) = 2*XAVTRD(I) - XOUTTRD(I)
         YINTRD(I) = 2*YAVTRD(I) - YOUTTRD(I)
         ZINTRD(I) = 2*ZAVTRD(I) - ZOUTTRD(I)
#endif
#if !defined(GPAMELA_INTER)
         XINTRD(I) = VHITS(1,I)
         YINTRD(I) = VHITS(2,I)
         ZINTRD(I) = VHITS(3,I)
         XOUTTRD(I) = VHITS(4,I)
         YOUTTRD(I) = VHITS(5,I)
         ZOUTTRD(I) = VHITS(6,I)
         XAVTRD(I) = (XINTRD(I)+XOUTTRD(I))/2.
         YAVTRD(I) = (YINTRD(I)+YOUTTRD(I))/2.
         ZAVTRD(I) = (ZINTRD(I)+ZOUTTRD(I))/2.
#endif
C         ERELTRD(I) = VHITS(7,I)
         ELOSTRD(I) = VHITS(7,I)
         PATHTRD(I) = VHITS(8,I)
         IPARTRD(I) = VHITS(9,I)
         P0TRD(I) = VHITS(10,I)
         ETRTRD(I) = VHITS(11,I)
         NTRTRD(I) = VHITS(12,I)
C ML:
#if defined(GPAMELA_GARFIELD)
         ERELTRD(I) = VHITS(11,I)+VHITS(13,I)
C         EGARTRD(I) = VHITS(11,I)
C         NGARTRD(I) = VHITS(12,I)
         EGARTRD(I) = VHITS(13,I)
         NGARTRD(I) = VHITS(14,I)
C	 PRINT*,'EGARTRD,NGARTRD=',EGARTRD(I),NGARTRD(I),I
C	 PRINT*,'PATHTRD=',VHITS(8,I)
#endif
C END ML.
      ENDDO
*
10000  FORMAT(' GPDTRD: VOLUME level too big: SET=',A4,', DET=',A4,
     +        ',NVOL=',I3,', NVMAX=',I3,', RUN=',I5,', EVT=',I8)
10100  FORMAT(' GPDTRD: MAX number of hits retrived: SET=',A4,
     +        ', DET=',A4,',NHREAD=',I5,', NHMAX=',I5,
     +        ', RUN=',I5,', EVT=',I8)
10200  FORMAT(' GPDTRD: Error in GPRHIT: SET=',A4,
     +        ', DET=',A4,',NHITS=',I5,', NHMAX=',I5,
     +        ', RUN=',I5,', EVT=',I8)
   10 RETURN
      END
