*
* $Id$
*
* $Log$
*
*CMZ :  2.01/00 06/03/2000  13.07.03  by  Francesco Cafagna
*CMZ :  2.00/00 25/02/2000  17.16.49  by  Francesco Cafagna
*CMZ :  1.02/00 22/10/99  16.17.58  by  Francesco Cafagna
*CMZ :  1.01/00 21/05/96  17.33.37  by  Francesco Cafagna
*CMZ :  1.00/02 04/04/96  16.08.24  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   23/02/96
      SUBROUTINE GPDTOF
************************************************************************
*                                                                      *
* To perform TOF digitization                                          *
*                                                                      *
* Called by: GUDIGI                                                    *
* Author: Francesco Cafagna, 23/02/96 12.50.38                         *
*                                                                      *
************************************************************************
#include "gcunit.inc"
#include "gpphit.inc"
      PARAMETER (NH=NHTOF,NHM=NHMTOF,NVOL=3)
#include "gprhit.inc"
#include "gptof.inc"
#include "gpsed.inc"
*
      INTEGER IS,ID,NV,NVM,NNHM,INDEX,NPLANE
      CHARACTER*4 CSET(7)
      DATA CSET/'S11 ','S12 ','S21 ','S22 ','S31 ','S32 ','S4  '/
*
* Vector zeroed
*
      CALL VZERO(IPLTOF,NHM)
      CALL VZERO(IPADDLE,NHM)
      CALL VZERO(IPARTOF,NHM)
      CALL VZERO(XINTOF,NHM)
      CALL VZERO(YINTOF,NHM)
      CALL VZERO(ZINTOF,NHM)
      CALL VZERO(XOUTTOF,NHM)
      CALL VZERO(YOUTTOF,NHM)
      CALL VZERO(ZOUTTOF,NHM)
      CALL VZERO(ERELTOF,NHM)
      CALL VZERO(TIMETOF,NHM)
      CALL VZERO(PATHTOF,NHM)
      CALL VZERO(P0TOF,NHM)
*
      CALL VZERO(NUMD  ,NVOL)
*
* Start with tof top
*
      NV = NVOL
      NVM= NVMAX
      IT = -1
      NTHTOF = 0
      INDEX = 0
      DO II=1,7
         IS= II
         ID= 1
*
* Check on the volume level
*
         IF (NV.GT.NVM) THEN
            WRITE(CHMAIL,10000) CSET,CNSED(IS,ID),NVOL,NVMAX, IDRUN,
     +      IDEVT
            CALL GMAIL(1,0)
            GO TO 10
         ENDIF
         CALL VZERO(VHITS,NH*NHM)
         CALL VZERO(ITRA ,NHM)
         CALL VZERO(NUMBV,NVOL*NHM)
         NHITS = -1
         CALL GPRHIT(CSET(II),CNSED(IS,ID),IS,ID,NVOL,NH,NHM,1,
     +   IT,NUMD,ITRA,NUMBV,VHITS,NHITS)
*
* If there was a problem in GPRHIT then exit
*
         IF(NHITS.LT.0) THEN
            WRITE(CHMAIL,10200) CSET(IS),CNSED(IS,ID),NHITS,NHM,
     +      IDRUN,IDEVT
            CALL GMAIL(1,0)
            GO TO 10
         ENDIF
*
* Fill the CWN common
*
         NPLANE = II
         NTHTOF = NHITS + NTHTOF
         DO I=1,NHITS
            INDEX = INDEX + 1
            IPLTOF(INDEX) = NPLANE
*ML:
            IPADDLE(INDEX) = NUMBV(NVTOF,I)
            IF(II.EQ.7) THEN
               IPADDLE(INDEX) = NUMBV(NVS4,I)
            ENDIF
*END ML.
#if defined(GPAMELA_INTER)
            XAVTOF(INDEX) = VHITS(1,I)
            YAVTOF(INDEX) = VHITS(2,I)
            ZAVTOF(INDEX) = VHITS(3,I)
            XOUTTOF(INDEX) = VHITS(4,I)
            YOUTTOF(INDEX) = VHITS(5,I)
            ZOUTTOF(INDEX) = VHITS(6,I)
            XINTOF(INDEX) = 2*XAVTOF(INDEX) - XOUTTOF(INDEX)
            YINTOF(INDEX) = 2*YAVTOF(INDEX) - YOUTTOF(INDEX)
            ZINTOF(INDEX) = 2*ZAVTOF(INDEX) - ZOUTTOF(INDEX)
#endif
#if !defined(GPAMELA_INTER)
            XINTOF(INDEX) = VHITS(1,I)
            YINTOF(INDEX) = VHITS(2,I)
            ZINTOF(INDEX) = VHITS(3,I)
            XOUTTOF(INDEX) = VHITS(4,I)
            YOUTTOF(INDEX) = VHITS(5,I)
            ZOUTTOF(INDEX) = VHITS(6,I)
            XAVTOF(INDEX) = (XINTOF(INDEX)+XOUTTOF(INDEX))/2.
            YAVTOF(INDEX) = (YINTOF(INDEX)+YOUTTOF(INDEX))/2.
            ZAVTOF(INDEX) = (ZINTOF(INDEX)+ZOUTTOF(INDEX))/2.
#endif
*ML:
*            ERELTOF(INDEX) = VHITS(7,I)
            ERELTOF(INDEX) = VHITS(11,I)
            TIMETOF(INDEX) = VHITS(8,I)
            PATHTOF(INDEX) = VHITS(9,I)
            IPARTOF(INDEX) = VHITS(10,I)
*            P0TOF (INDEX) = VHITS(11,I)
            P0TOF(INDEX) = VHITS(7,I)
         ENDDO
      ENDDO
*
10000  FORMAT(' GPDTOF: VOLUME level too big: SET=',A4,', DET=',A4,
     +        ',NVOL=',I3,', NVMAX=',I3,', RUN=',I5,', EVT=',I8)
10100  FORMAT(' GPDTOF: MAX number of hits retrived: SET=',A4,
     +        ', DET=',A4,',NHREAD=',I5,', NHMAX=',I5,
     +        ', RUN=',I5,', EVT=',I8)
10200  FORMAT(' GPDTOF: Error in GPRHIT: SET=',A4,
     +        ', DET=',A4,',NHITS=',I5,', NHMAX=',I5,
     +        ', RUN=',I5,', EVT=',I8)
   10 RETURN
      END
