*
* $Id$
*
* $Log$
*
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.06  by  Francesco Cafagna
*CMZ :  1.02/00 07/03/97  14.48.41  by  Francesco Cafagna
*CMZ :  1.00/02 06/02/96  17.34.50  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   09/12/95
      SUBROUTINE GPSPEV
************************************************************************
*                                                                      *
* Volumes definition for the silicon tracking system and magnet        *
* Called by: GPGEM                                                     *
* Author: Francesco Cafagna, 05/12/95 13.39.41                         *
*                                                                      *
************************************************************************
#include "gpgeo.inc"
#include "gpmed.inc"
*
      INTEGER IROT,IVOLU,N,NMED,NUM
      REAL X,Y,Z
*
*  Define the SPEB     volume
*
      NMED= MN2
      CALL GSVOLU('SPEB','BOX ',NMED,SPEB, 3,IVOLU)
*
*  Define the MGPL     volume
*
      NMED= MMAG
      CALL GSVOLU('MGPL','BOX ',NMED,MGPL, 3,IVOLU)
*
*  Define the MGPI     volume
*
      NMED= MN2
      CALL GSVOLU('MGPI','BOX ',NMED,MGPI, 3,IVOLU)
*
*  Define the TRPB     volume
*
      NMED= MAL
      CALL GSVOLU('TRPB','BOX ',NMED,TRPB, 3,IVOLU)
*
*  Define the TRPL     volume
*
      NMED= MN2
      CALL GSVOLU('TRPL','BOX ',NMED,TRPL, 3,IVOLU)
*
*  Define the TRSL     volume
*
      NMED= MN2
      CALL GSVOLU('TRSL','BOX ',NMED,TRSL, 3,IVOLU)
*
*  Define the TSPA     volume
*
      NMED= MSIT
      CALL GSVOLU('TSPA','BOX ',NMED,TSPA, 3,IVOLU)
*
*  Define the TRCP     volume
*
      NMED= MCF
      CALL GSVOLU('TRCP','BOX ',NMED,TRCP, 3,IVOLU)
*
* Positioning volume TSPA     into the mother TRSL
*
      N= 1
      X= 0.
      Y= TRSL(2) - TSPA(2)
      Z= 0.
      CALL GSPOS('TSPA',N,'TRSL',X,Y,Z,0,'ONLY')
      N= 2
      Y= Y - 2.*TSPA(2)
      CALL GSPOS('TSPA',N,'TRSL',X,Y,Z,0,'ONLY')
*
* Positioning volume TRCP     into the mother TRSL
*
      N= 1
      Z= 0.
      Y= 0.
      X= -TRSL(1) + TRCP(1)
      CALL GSPOS('TRCP',N,'TRSL',X,Y,Z,0,'ONLY')
      N= 2
      X= -X
      CALL GSPOS('TRCP',N,'TRSL',X,Y,Z,0,'ONLY')
*
* Positioning volume TRSL     into the mother TRPL
*
      Y= 0.
      Z= 0.
      DO I=1, NTRSL
         X= -TRPL(1) + TRSL(1) +2.*(I-1)*TRSL(1)
         CALL GSPOS('TRSL',I,'TRPL',X,Y,Z,0,'ONLY')
      ENDDO
*
* Positioning volume MGPI     into the mother MGPL
*
      N= 1
      X= 0.
      Y= 0.
      Z= 0.
      CALL GSPOS('MGPI',N,'MGPL',X,Y,Z,0,'ONLY')
*
* Positioning volume TRPL     into the mother TRPB
*
      N= 1
      Z= 0.
      CALL GSPOS('TRPL',N,'TRPB',X,Y,Z,0,'ONLY')
*
* Positioning volumes TRPB & MGPL into the mother SPEB
*
      N= 1
      X= 0.
      Y= 0.
      Z= SPEB(3) - TRPB(3)
      CALL GSPOS('TRPB',N,'SPEB',X,Y,Z,0,'ONLY')
      DO I=1, 5
         Z= Z - TRPB(3) - MGPL(3)
         N= I
         CALL GSPOS('MGPL',N,'SPEB',X,Y,Z,0,'ONLY')
         Z= Z - MGPL(3) - TRPB(3)
         N= (I+1)
         CALL GSPOS('TRPB',N,'SPEB',X,Y,Z,0,'ONLY')
      ENDDO
*
      RETURN
      END
