*
* $Id: gpuspe.F,v 3.2 2006/02/05 22:13:44 cafagna Exp $
*
* $Log: gpuspe.F,v $
* Revision 3.2  2006/02/05 22:13:44  cafagna
* A bug in the SPEctrometr hit definition fixed
*
* Revision 3.1.1.1  2002/07/11 16:02:14  cafagna
* First GPAMELA release on CVS
*
*
*CMZ :  2.01/00 06/03/2000  13.07.03  by  Francesco Cafagna
*CMZ :  2.00/00 03/03/2000  15.39.06  by  Francesco Cafagna
*CMZ :  1.02/00 22/10/99  15.34.29  by  Francesco Cafagna
*CMZ :  1.01/00 23/05/96  15.01.53  by  Francesco Cafagna
*CMZ :  1.00/02 04/04/96  16.47.16  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   21/02/96
      SUBROUTINE GPUSPE(IACT,IS,ID,IPAA,IT,DELOSS,PATH,
     +                  TRAPAR,NUMVOL,IMEC)
************************************************************************
*                                                                      *
* To collect and store the hit structure for SPE                       *
*                                                                      *
* Variables definition:                                                *
* IN:                                                                  *
*  IACT, integer specifing the action to be taken. It is the INWVOL    *
*        variable in GCTRAK common                                     *
*  IS    , set number                                                  *
*  ID    , detector number                                             *
*  IPA   , particle number                                             *
*  IT    , track number                                                *
*  DELOSS, energy loss in the step                                     *
*  PATH  , current track lenght                                        *
*  TRAPAR, track parameter, is the VECT vector in GCTRAK common        *
*  NUMVOL, integr array of numbers identifying the DETECTOR            *
*  IMEC  , integer indicating the LOSS mecanism position inside NMEC   *
*          vector, zero if not present                                 *
*                                                                      *
*                                                                      *
* Called by: GUSTEP                                                    *
* Author: Francesco Cafagna, 21/02/96 16.13.51                         *
*                                                                      *
************************************************************************
#include "gphit.inc"
#include "gcunit.inc"
#include "gpgene.inc"
#include "gctrak.inc"
*
      INTEGER IACT,IS,ID,IPAA,IT,NUMVOL(20),NVOLSPE(3),IMEC,IDHIT
      REAL DELOSS,PATH,TRAPAR(7),VHIT(NHSPE)
      REAL DELTA2,SIGMA2,SIGMA,GRNDM0,GPGAUS
      LOGICAL SAVE

*ET , SB 27/01/06
      IF(IMEC.GT.0.AND.DELOSS.GT.0.) THEN         
         CALL GPUDIFFUSION(IACT,TRAPAR,NUMVOL,DELOSS,STEP,IPAA)
      ENDIF
*end ET, SB  27/01/06



*
* Track is inside a volume
*
      IF(IACT.EQ.0) THEN
         IF(IMEC.GT.0) THEN
            SAVE = .TRUE.
            VHIT(7) = DELOSS + VHIT(7)
         ENDIF
      ENDIF
*
* Entering a new volume or is a new track
*
      IF(IACT.EQ.1) THEN
         SAVE = .FALSE.
         CALL VZERO(VHIT,NHSPE)
         DO I=1,3
            VHIT(I) = TRAPAR(I)
         ENDDO
         IF(IMEC.GT.0) THEN
            SAVE = .TRUE.
            VHIT(7) = DELOSS
         ENDIF
         VHIT(8) = PATH
         VHIT(9) = IPAA
         VHIT(10)= TRAPAR(7)
         IDHIT = -1
         NVOLSPE(1) = NUMVOL(1)
         IF(NUMVOL(1).EQ.0) NVOLSPE(1)=6
         NVOLSPE(2) = NUMVOL(2)
         NVOLSPE(3) = NUMVOL(3)
      ENDIF
*
* Track is exiting current volume
*
      IF(IACT.EQ.2) THEN
         DO I=1,3
            VHIT(I+3) = TRAPAR(I)
#if defined(GPAMELA_INTER)
* interactive case, we need the average position
            VHIT(I) = (VHIT(I) + VHIT(I+3) )/2.
#endif
         ENDDO
         IF(IMEC.GT.0) THEN
            SAVE = .TRUE.
            VHIT(7) = DELOSS + VHIT(7)
         ENDIF
         VHIT(8) = PATH - VHIT(8)
#if defined(GPAMELA_NOGFLUCT)
*
* change in de/dx with gaussian convolution
* see Hall paper: NIM 220 (1984) 356.
*
* FIRST: Look if the STOP mechanism is present
*
         IF(IMEC.EQ.1) THEN
* This particle has NOT been stopped. So gaussian energy spread...
* Delta is in GeV^2/cm
            DELTA2=.5E-8
            SIGMA2=DELTA2*VHIT(8)
            SIGMA=SQRT(SIGMA2)
            GRNDM0 = GPGAUS(0.)
            VHIT(7)=VHIT(7)+GRNDM0*SIGMA
            IF(VHIT(7).LT.0.) VHIT(7)=0.
         ENDIF
#endif
*
* Store the hit
*
         IF(IDHIT.EQ.-1) THEN
c$$$            IF(SAVE) CALL GSAHIT (IS,ID,IT,NUMVOL,VHIT,IDHIT)
cv            IF(SAVE) WRITE(6,*) 'CALL GSAHIT'
            IF(SAVE) CALL GSAHIT (IS,ID,IT,NVOLSPE,VHIT,IDHIT)
            IF (IDHIT.EQ.0) THEN
               WRITE(CHMAIL,10000) IS,ID,IT
               CALL GMAIL(1,0)
            ENDIF
         ELSE
            WRITE(CHMAIL,10100) IS,ID,IT
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
*
* Track is exiting the set up
*
      IF(IACT.EQ.3) THEN
*
* Check if the hit have been previously stored or not
*
         IF(IDHIT.LT.0) THEN
            DO I=1,3
               VHIT(I+3) = TRAPAR(I)
#if defined(GPAMELA_INTER)
* interactive case, we need the average position
               VHIT(I) = (VHIT(I) + VHIT(I+3) )/2.
#endif
            ENDDO
            IF(IMEC.GT.0) THEN
               SAVE = .TRUE.
               VHIT(7) = DELOSS + VHIT(7)
            ENDIF
            VHIT(8) = PATH - VHIT(8)
#if defined(GPAMELA_NOGFLUCT)
*
* change in de/dx with gaussian convolution
* see Hall paper: NIM 220 (1984) 356.
*
* FIRST: Look if the STOP mechanism is present
*
            IF(IMEC.EQ.1) THEN
* This particle has NOT been stopped. So gaussian energy spread...
* Delta is in GeV^2/cm
               DELTA2=.5E-8
               SIGMA2=DELTA2*VHIT(8)
               SIGMA=SQRT(SIGMA2)
               GRNDM0 = GPGAUS(0.)
               VHIT(7)=VHIT(7)+GRNDM0*SIGMA
               IF(VHIT(7).LT.0.) VHIT(7)=0.
            ENDIF
#endif
*
* Store the hit
*
            IF(IDHIT.EQ.-1) THEN
c$$$               IF(SAVE) CALL GSAHIT (IS,ID,IT,NUMVOL,VHIT,IDHIT)
cv               IF(SAVE) WRITE(6,*) 'CALL GSAHIT'
               IF(SAVE) CALL GSAHIT (IS,ID,IT,NVOLSPE,VHIT,IDHIT)
               IF (IDHIT.EQ.0) THEN
                  WRITE(CHMAIL,10200) IS,ID,IT
                  CALL GMAIL(1,0)
               ENDIF
            ELSE
               WRITE(CHMAIL,10300) IS,ID,IT
               CALL GMAIL(1,0)
            ENDIF
         ENDIF
      ENDIF
10000 FORMAT(' GPUSPE error: HIT have not be stored for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
10100 FORMAT(' GPUSPE error: HIT have not be initialized for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
10200 FORMAT(' GPUSPE error: HIT have not be stored for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
10300 FORMAT(' GPUSPE error: HIT have not be initialized for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
      RETURN
      END
