*
* $Id: gpspev.F,v 3.10 2006/12/01 12:25:51 cafagna Exp $
*
* $Log: gpspev.F,v $
* Revision 3.10  2006/12/01 12:25:51  cafagna
*  New Antiproton annihilation cross section added
*
* Revision 3.9  2006/06/30 15:38:16  pam-ba
* S22 and S12 heights positioned in GPAMELA at the nominal heights in PAMELA (see document: Main geometrical parameters of the PAMELA sub-detectors, 20 December 2005)
*
* Revision 3.8  2006/05/02 12:02:43  bottai
* micrometric adjustment of spe geometry
*
* Revision 3.7  2005/12/16 10:20:23  cafagna
* Bug fixed in the new update
*
* Revision 3.6  2005/12/16 09:13:59  cafagna
* New small valume added to the tracker frame
*
* Revision 3.5  2005/12/13 10:31:29  pam-ba
* added a new volume, TPGI, in the spectrometer
*
* Revision 3.4  2005/12/05 12:15:21  pam-ba
* new spectrometer geometry and internal magnetic field
*
* Revision 3.3  2005/07/25 11:53:21  cafagna
* Several updates. See history for details
*
* Revision 3.2  2005/06/21 02:42:27  cafagna
* Major modification to the geometry and to the random number chain
*
* Revision 3.1.1.1  2002/07/11 16:02:14  cafagna
* First GPAMELA release on CVS
*
*
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.06  by  Francesco Cafagna
*CMZ :  1.02/00 07/03/97  14.48.41  by  Francesco Cafagna
*CMZ :  1.00/02 06/02/96  17.34.50  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   09/12/95
      SUBROUTINE GPSPEV
************************************************************************
*                                                                      *
* Volumes definition for the silicon tracking system and magnet        *
* Called by: GPGEM                                                     *
* Author: Francesco Cafagna, 05/12/95 13.39.41                         *
*                                                                      *
************************************************************************
#include "gpgeo.inc"
#include "gpmed.inc"
*
      INTEGER IROT,IVOLU,N,NMED,NUM
      REAL X,Y,Z
C      
      REAL ROWMAT(3)
      REAL OMEGA(36),BETA(36),GAMMA(36)
      REAL DX(36),DY(36),DZ(36)
      REAL DXFLO(6),DYFLO(6),DZFLO(6)
      CHARACTER*19 FILEALLI
      LOGICAL ROTATE
c
c

cv
cv
      DO IK=1,6

      IF(IK.EQ.1)  FILEALLI='parameters_l1s2.dat'
      IF(IK.EQ.2)  FILEALLI='parameters_l2s2.dat'
      IF(IK.EQ.3)  FILEALLI='parameters_l3s2.dat'
      IF(IK.EQ.4)  FILEALLI='parameters_l1s1.dat'
      IF(IK.EQ.5)  FILEALLI='parameters_l2s1.dat'
      IF(IK.EQ.6)  FILEALLI='parameters_l3s1.dat'
       
      write(6,*) 'OPEN ',FILEALLI
      OPEN(91,file=FILEALLI,status='old')
      DO IH=1,6
        II=(6-IH)*6+IK
        READ(91,*) OMEGA(II)
	READ(91,*) BETA(II)
	READ(91,*) GAMMA(II)
	READ(91,*) DX(II)
	READ(91,*) DY(II)
	READ(91,*) DZ(II)
      ENDDO
      
      CLOSE(91)
      
      ENDDO
     
      DO IJ=1,6
       DXFLO(IJ)=0.
       DYFLO(IJ)=0.
       DO IL=1,6
        II=(IJ-1)*6+IL
	DXFLO(IJ)=DXFLO(IJ)+DX(II)
	DYFLO(IJ)=DYFLO(IJ)+DY(II)
       ENDDO
       DXFLO(IJ)=DXFLO(IJ)/6.
       DYFLO(IJ)=DYFLO(IJ)/6.
      ENDDO
      
      DO IJ=1,6
       DO IL=1,6
        II=(IJ-1)*6+IL
	DX(II)=( DX(II)-DXFLO(IJ) )*1.E-4
	DY(II)=( DY(II)-DYFLO(IJ) )*1.E-4
	DZ(II)=(DZ(II)-100.)*1.E-4
       ENDDO
       DXFLO(IJ)=DXFLO(IJ)*1.E-4
       DYFLO(IJ)=DYFLO(IJ)*1.E-4
      ENDDO

      
      DO IJ=1,6
       DO IL=1,6
       II=(IJ-1)*6+IL       
       OMEGA_1=OMEGA(II)*1.E-6
       BETA_1=BETA(II)*1.E-6
       GAMMA_1=GAMMA(II)*1.E-6
c
c
       IF(IJ.EQ.6) THEN
        OMEGA_1=-OMEGA_1
        BETA_1=BETA_1
        GAMMA_1=-GAMMA_1
       ENDIF



       ROWMAT(1)=1.
       ROWMAT(2)=OMEGA_1
       ROWMAT(3)=-GAMMA_1
       CALL GFANG(ROWMAT,COSTH,SINTH,COSPH,SINPH,ROTATE)
       THETA1=ATAN2(SINTH,COSTH)/acos(-1.)*180.
       PHI1=ATAN2(SINPH,COSPH)/acos(-1.)*180.
     
       ROWMAT(1)=-OMEGA_1
       ROWMAT(2)=1.
       ROWMAT(3)=BETA_1

       CALL GFANG(ROWMAT,COSTH,SINTH,COSPH,SINPH,ROTATE)
       THETA2=ATAN2(SINTH,COSTH)/acos(-1.)*180.
       PHI2=ATAN2(SINPH,COSPH)/acos(-1.)*180.

       ROWMAT(1)=GAMMA_1
       ROWMAT(2)=-BETA_1
       ROWMAT(3)=1.

       CALL GFANG(ROWMAT,COSTH,SINTH,COSPH,SINPH,ROTATE)
       THETA3=ATAN2(SINTH,COSTH)/acos(-1.)*180.
       PHI3=ATAN2(SINPH,COSPH)/acos(-1.)*180.

       write(6,*) 'GSROTM(50+II)',50+II,THETA1,PHI1,THETA2,PHI2,THETA3,PHI3 
       IIKROT=50+II
       CALL GSROTM(IIKROT,THETA1,PHI1,THETA2,PHI2,THETA3,PHI3)
       
       ENDDO
      ENDDO

*
*  Define the SPEB     volume
*
      NMED= MN2
      CALL GSVOLU('SPEB','BOX ',NMED,SPEB, 3,IVOLU)
*
*  Define the MGFR     volume
*
      NMED= MAL
cv      CALL GSVOLU('MGFR','BOX ',NMED,MGFR, 3,IVOLU)
      CALL GSVOLU('MGF1','BOX ',NMED,MGFR, 3,IVOLU)
      CALL GSVOLU('MGF2','BOX ',NMED,MGFR, 3,IVOLU)
      CALL GSVOLU('MGF3','BOX ',NMED,MGFR, 3,IVOLU)
      CALL GSVOLU('MGF4','BOX ',NMED,MGFR, 3,IVOLU)
      CALL GSVOLU('MGF5','BOX ',NMED,MGFR, 3,IVOLU)
     
*
*  Define the MGPL     volume
*
      NMED= MMAG
      CALL GSVOLU('MGPL','BOX ',NMED,MGPL, 3,IVOLU)
*
*  Define the MGPI     volume
*
      NMED= MN2
      CALL GSVOLU('MGPI','BOX ',NMED,MGPI, 3,IVOLU)
*
*  Define the TRPB     volume
*
      NMED= MAL
cv      CALL GSVOLU('TRPB','BOX ',NMED,TRPB, 3,IVOLU)
      CALL GSVOLU('TRP1','BOX ',NMED,TRPB, 3,IVOLU)
      CALL GSVOLU('TRP2','BOX ',NMED,TRPB, 3,IVOLU)
      CALL GSVOLU('TRP3','BOX ',NMED,TRPB, 3,IVOLU)
      CALL GSVOLU('TRP4','BOX ',NMED,TRPB, 3,IVOLU)
      CALL GSVOLU('TRP5','BOX ',NMED,TRPB, 3,IVOLU) 
      CALL GSVOLU('TRP6','BOX ',NMED,TRPB, 3,IVOLU)            
*****
cC ml 20/04/05:
*
cc*  Define the TRPL     volume
*  Define the TPAS and TPAI volume
*
      NMED= MN2
cv      CALL GSVOLU('TPAS','BOX ',NMED,TPAS, 3,IVOLU)
      CALL GSVOLU('TPA1','BOX ',NMED,TPAS, 3,IVOLU)
      CALL GSVOLU('TPA2','BOX ',NMED,TPAS, 3,IVOLU)
      CALL GSVOLU('TPA3','BOX ',NMED,TPAS, 3,IVOLU)
      CALL GSVOLU('TPA4','BOX ',NMED,TPAS, 3,IVOLU)
      CALL GSVOLU('TPA5','BOX ',NMED,TPAS, 3,IVOLU)
      CALL GSVOLU('TPA6','BOX ',NMED,TPAS, 3,IVOLU)
      NMED= MAL
      CALL GSVOLU('TPAI','BOX ',NMED,TPAI, 3,IVOLU)
CC end ml.
****************
*
*  Define the TRSL     volume
*
c ml: 26/11/04:
c      NMED= MN2
      NMED=MSIT
      CALL GSVOLU('TRSL','BOX ',NMED,TRSL, 3,IVOLU)
*
* Define the THBP volume
*
      NMED=MG10C
      CALL GSVOLU('THBP','BOX ',NMED,THBP, 3,IVOLU)
C end ml.
*
*  Define the TSPA     volume
*
      NMED= MSIT
      CALL GSVOLU('TSPA','BOX ',NMED,TSPA, 3,IVOLU)
*
*  Define the TRCP     volume
*
      NMED= MCF
      CALL GSVOLU('TRCP','BOX ',NMED,TRCP, 3,IVOLU)
*
*  Define the TBAL     volume
*
      NMED= MAL
      CALL GSVOLU('TBAL','BOX ',NMED,TBAL, 3,IVOLU)
*
*  Define the MGPA     volume
*
      NMED= MAL
      CALL GSVOLU('MGPA','BOX ',NMED,MGPA, 3,IVOLU)
*
*  Define the TPGA     volume
*
      NMED= MN2
      CALL GSVOLU('TPGA','BOX ',NMED,TPGA, 3,IVOLU)
*
*  Define the TPGI     volume
*
      NMED= MN2
      CALL GSVOLU('TPGI','BOX ',NMED,TPGI, 3,IVOLU)
*
*  Define the TPGU     volume
*
      NMED= MN2
      CALL GSVOLU('TPGU','BOX ',NMED,TPGU, 3,IVOLU)
*
*  Define the TPGD     volume
*
      NMED= MN2
      CALL GSVOLU('TPGD','BOX ',NMED,TPGD, 3,IVOLU)

*
* Positioning volume TSPA     into the mother TRSL
*
      GLUEX=XGLUE-0.0005
      GLUEY=XGLUE
      N= 1
      X= 0.
      Y= 0.
      Z= 0.
      CALL GSPOS('TSPA',N,'TRSL',X,Y,Z,0,'ONLY')

c ml: 26/11/04:
* Positioning volume TRCP into mother TPAS
C # Caf mod on 19 Jul 2005 all volumes are placed inside the TPAS one

CC end ml.

      Z=TRPB(3)-2*TPAI(3)-TRCP(3)
      y=-TPAS(2)+TRCP(2)
C # end CAF mod
      TPASSPACE=TPAS(1)-(3*TRSL(1)+4*TRCP(1)+3*GLUEX)
      DO I=1,4
CC ml 20/04/05:         
C Ml. 15/12/05: introducing a space (along x) between the inner part of the
c  aluminum frame and respectively the first and the last carbon fiber barrel.
c It is has been done increasing the dimension of TPAS along x:

         X=-TPAS(1)+TPASSPACE+2*(I-1)*GLUEX+(2*I-1)*TRCP(1)+
     +      2*(I-1)*TRSL(1)
CC end ml
cv         CALL GSPOS('TRCP',I,'TPAS',X,Y,Z,0,'MANY')
           CALL GSPOS('TRCP',I,'TPA1',X,Y,Z,0,'MANY')
	   CALL GSPOS('TRCP',I,'TPA2',X,Y,Z,0,'MANY')
	   CALL GSPOS('TRCP',I,'TPA3',X,Y,Z,0,'MANY')
	   CALL GSPOS('TRCP',I,'TPA4',X,Y,Z,0,'MANY')
	   CALL GSPOS('TRCP',I,'TPA5',X,Y,Z,0,'MANY')
	   CALL GSPOS('TRCP',I,'TPA6',X,Y,Z,0,'MANY')
C # end CAF mod
      ENDDO  
cc ml 20/04/05:
* Positioning volume TRSL     into the mother TPAS
C # Caf mod on 19 Jul 2005 all volumes are placed inside the TPAS one

      Z=TRPB(3)-2*TPAI(3)-TRCP(3)
      DO I=1, NTRSL
c ml: 20/9/05 introducing the glue between TRCP and the silicon ladders.

         X=-TPAS(1)+TPASSPACE+2*(MOD(I-1,3)+1)*TRCP(1)+
     +   (2*(MOD(I-1,3)+1)-1)*GLUEX+(2*(MOD(I-1,3)+1)-1)*TRSL(1)
         IF(I.LE.3) THEN
C ml: 22/9/05:

            Y=TPAS(2)-0.1485+0.0005-TRSL(2)
         ELSE

            Y=TPAS(2)-0.1485-GLUEY-3*TRSL(2)
         ENDIF

cv	  X=X+DX_1
cv	  Y=Y+DY_1
cv	  Z=Z+DZ_1
cv          CALL GSPOS('TRSL',I,'TPAS',X,Y,Z,51,'ONLY')
cv          CALL GSPOS('TRSL',I,'TPAS',X,Y,Z,0,'ONLY')
           X1=X+DX(I)
	   Y1=Y+DY(I)
	   Z1=Z+DZ(I)
           IIRR=50+I
           CALL GSPOS('TRSL',I,'TPA1',X1,Y1,Z1,IIRR,'ONLY')

           X2=X+DX(NTRSL+I)
	   Y2=Y+DY(NTRSL+I)
	   Z2=Z+DZ(NTRSL+I)
           IIRR=50+NTRSL+I
	   CALL GSPOS('TRSL',NTRSL+I,'TPA2',X2,Y2,Z2,IIRR,'ONLY')

           X3=X+DX(2*NTRSL+I)
	   Y3=Y+DY(2*NTRSL+I)
	   Z3=Z+DZ(2*NTRSL+I)
           IIRR=50+2*NTRSL+I
	   CALL GSPOS('TRSL',2*NTRSL+I,'TPA3',X3,Y3,Z3,IIRR,'ONLY')


           X4=X+DX(3*NTRSL+I)
	   Y4=Y+DY(3*NTRSL+I)
	   Z4=Z+DZ(3*NTRSL+I)
           IIRR=50+3*NTRSL+I
	   CALL GSPOS('TRSL',3*NTRSL+I,'TPA4',X4,Y4,Z4,IIRR,'ONLY')

           X5=X+DX(4*NTRSL+I)
	   Y5=Y+DY(4*NTRSL+I)
	   Z5=Z+DZ(4*NTRSL+I)
           IIRR=50+4*NTRSL+I
	   CALL GSPOS('TRSL',4*NTRSL+I,'TPA5',X5,Y5,Z5,IIRR,'ONLY')

           IF(I.LE.3) KK=3+I
	   IF(I.GE.4) KK=I-3
           X6=X+DX(5*NTRSL+KK)
	   Y6=Y-DY(5*NTRSL+KK)
	   Z6=Z-DZ(5*NTRSL+KK)	   
	   IIRR=50+5*NTRSL+KK
	   CALL GSPOS('TRSL',5*NTRSL+I,'TPA6',X6,Y6,Z6,IIRR,'ONLY')
      ENDDO
C # end CAF mod
**********
cc ml: 20/04/05
* Positioning volume THBP     into the mother TPAS
C # Caf mod on 19 Jul 2005 all volumes are placed inside the TPAS one

c ml: 22/9/05:

      Y=-TPAS(2)+0.1485+THBP(2)

      Z=TRPB(3)-2*TPAI(3)-TRCP(3)
      DO I=1, NTHBP

c ml: 21/9/05 introducing the glue between the carbon barrel and the silicon
c       ladders 

         X=-TPAS(1)+TPASSPACE+2*I*TRCP(1)+(2*I-1)*THBP(1)+
     +      (2*(MOD(I-1,3)+1)-1)*GLUEX
cv         CALL GSPOS('THBP',I,'TPAS',X,Y,Z,0,'MANY')
	CALL GSPOS('THBP',I,'TPA1',X,Y,Z,0,'MANY')
	CALL GSPOS('THBP',I,'TPA2',X,Y,Z,0,'MANY')
	CALL GSPOS('THBP',I,'TPA3',X,Y,Z,0,'MANY') 
	CALL GSPOS('THBP',I,'TPA4',X,Y,Z,0,'MANY')
	CALL GSPOS('THBP',I,'TPA5',X,Y,Z,0,'MANY') 
	CALL GSPOS('THBP',I,'TPA6',X,Y,Z,0,'MANY') 
      ENDDO
c end ml.
cc ml: 20/04/05
*
* Positioning volume TPAI into the mother TPAS
*
C # Mod By Caf on 19th Jul 2005 all volumes inside the TPAS
      X=0
      Y=-TPAS(2)+TPAI(2)
      Z=TRPB(3)-TPAI(3)

cv      CALL GSPOS('TPAI',I,'TPAS',X,Y,Z,0,'MANY')
      CALL GSPOS('TPAI',1,'TPA1',X,Y,Z,0,'MANY')
      CALL GSPOS('TPAI',1,'TPA2',X,Y,Z,0,'MANY')
      CALL GSPOS('TPAI',1,'TPA3',X,Y,Z,0,'MANY')
      CALL GSPOS('TPAI',1,'TPA4',X,Y,Z,0,'MANY')
      CALL GSPOS('TPAI',1,'TPA5',X,Y,Z,0,'MANY')
      CALL GSPOS('TPAI',1,'TPA6',X,Y,Z,0,'MANY')
C # end CAF mod
*
* Positioning volume TPAS into the mother TRPB
*
C # Mod By Caf on 15th Jul 2005
      X=0
      Y=-TRPB(2)+1.5+TPAS(2)
      Z=0

cv      CALL GSPOS('TPAS',I,'TRPB',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPA1',1,'TRP1',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPA2',1,'TRP2',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPA3',1,'TRP3',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPA4',1,'TRP4',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPA5',1,'TRP5',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPA6',1,'TRP6',X,Y,Z,0,'ONLY')
c end ml.
*
* Positioning volume MGPA     into the mother MGPL
*
      N= 1
      X= 0.
      Y= 0.
      Z= 0.
      CALL GSPOS('MGPA',N,'MGPL',X,Y,Z,0,'ONLY')
*
* Positioning volume TPGD     into the mother MGFR
*
      X=0.
      Z=-MGFR(3)+TPGD(3)
      Y=0.
cv      CALL GSPOS('TPGD',N,'MGFR',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGD',1,'MGF1',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGD',1,'MGF2',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGD',1,'MGF3',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGD',1,'MGF4',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGD',1,'MGF5',X,Y,Z,0,'ONLY')
*
* Positioning volume TPGI     into the mother MGFR under MGPL 
*
      N=1
      X=0.
      Z=-MGFR(3)+2*TPGD(3)+TPGI(3)
      Y=0.
cv      CALL GSPOS('TPGI',N,'MGFR',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGI',1,'MGF1',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGI',1,'MGF2',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGI',1,'MGF3',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGI',1,'MGF4',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGI',1,'MGF5',X,Y,Z,0,'ONLY')
*
* Positioning volume MGPI     into the mother MGPL
*
      N= 1
      X= 0.
      Y= 0.
CC ML 10/11/05:  Positioning volume MGPI     into the mother MGPA
      Z= 0.
      CALL GSPOS('MGPI',N,'MGPA',X,Y,Z,0,'ONLY')

*
* Positioning volume MGPL     into the mother MGFR
*
c ml: 10/11/05
      N=1
      Z=-MGFR(3)+2*(TPGD(3)+TPGI(3))+MGPL(3)
cv      CALL GSPOS('MGPL',N,'MGFR',X,Y,Z,0,'ONLY')
      CALL GSPOS('MGPL',1,'MGF1',X,Y,Z,0,'ONLY')    
      CALL GSPOS('MGPL',1,'MGF2',X,Y,Z,0,'ONLY') 
      CALL GSPOS('MGPL',1,'MGF3',X,Y,Z,0,'ONLY') 
      CALL GSPOS('MGPL',1,'MGF4',X,Y,Z,0,'ONLY') 
      CALL GSPOS('MGPL',1,'MGF5',X,Y,Z,0,'ONLY') 
*
* Positioning volume TPGI     into the mother MGFR above MGPL
*
      N=2
      X=0.
      Z=-MGFR(3)+2*(TPGD(3)+TPGI(3)+MGPL(3))+TPGI(3)
      Y=0.
cv      CALL GSPOS('TPGI',N,'MGFR',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGI',2,'MGF1',X,Y,Z,0,'ONLY')     
      CALL GSPOS('TPGI',2,'MGF2',X,Y,Z,0,'ONLY') 
      CALL GSPOS('TPGI',2,'MGF3',X,Y,Z,0,'ONLY') 
      CALL GSPOS('TPGI',2,'MGF4',X,Y,Z,0,'ONLY') 
      CALL GSPOS('TPGI',2,'MGF5',X,Y,Z,0,'ONLY') 
*
* Positioning volume TPGA     into the mother MGFR
*
C ML: 10/11/05
      N=1
      X=0.
      Y=MGFR(2)-2*(MGFR(2)-TRPB(2))-TPGA(2)

      Z=-MGFR(3)+2*(TPGD(3)+TPGI(3)+MGPL(3)+TPGI(3))+TPGA(3)

cv      CALL GSPOS('TPGA',N,'MGFR',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGA',1,'MGF1',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGA',1,'MGF2',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGA',1,'MGF3',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGA',1,'MGF4',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGA',1,'MGF5',X,Y,Z,0,'ONLY')
*
* Positioning volumes TRPB & MGPL into the mother SPEB
*
      N= 1
      X= 0.

      Y= -MGFR(2) + TRPB(2)

      Z=-MGFR(3)+2*(TPGD(3)+TPGI(3)+MGPL(3)+TPGI(3)+TPGA(3))+TRPB(3)

cv      CALL GSPOS('TRPB',N,'MGFR',X,Y,Z,0,'ONLY')
      XX1=X+DXFLO(1)
      YY1=Y+DYFLO(1)
      CALL GSPOS('TRP1',1,'MGF1',XX1,YY1,Z,0,'ONLY')
      XX2=X+DXFLO(2)
      YY2=Y+DYFLO(2)
      CALL GSPOS('TRP2',1,'MGF2',XX2,YY2,Z,0,'ONLY')
      XX3=X+DXFLO(3)
      YY3=Y+DYFLO(3)
      CALL GSPOS('TRP3',1,'MGF3',XX3,YY3,Z,0,'ONLY')
      XX4=X+DXFLO(4)
      YY4=Y+DYFLO(4)
      CALL GSPOS('TRP4',1,'MGF4',XX4,YY4,Z,0,'ONLY')
      XX5=X+DXFLO(5)
      YY5=Y+DYFLO(5)
      CALL GSPOS('TRP5',1,'MGF5',XX5,YY5,Z,0,'ONLY')
      Z=SPEB(3)
      DO I=1, 5
         X= 0.
         Y= 0.

         Z=Z-MGFR(3)
         N= I
CV         CALL GSPOS('MGFR',N,'SPEB',X,Y,Z,0,'ONLY')
         IF(N.EQ.1) CALL GSPOS('MGF1',1,'SPEB',X,Y,Z,0,'ONLY')
         IF(N.EQ.2) CALL GSPOS('MGF2',1,'SPEB',X,Y,Z,0,'ONLY')
         IF(N.EQ.3) CALL GSPOS('MGF3',1,'SPEB',X,Y,Z,0,'ONLY')
         IF(N.EQ.4) CALL GSPOS('MGF4',1,'SPEB',X,Y,Z,0,'ONLY')
         IF(N.EQ.5) CALL GSPOS('MGF5',1,'SPEB',X,Y,Z,0,'ONLY')

         Z=Z-MGFR(3)
      ENDDO
      N=2
      X=0.
      Y=MGFR(2) - TRPB(2)
      Z=Z-TRPB(3)
      ZTRPB=Z

cv      CALL GSPOS('TRPB',N,'SPEB',X,Y,Z,10,'ONLY')
      XX6=X+DXFLO(6)
      YY6=Y+DYFLO(6)
      CALL GSPOS('TRP6',1,'SPEB',XX6,YY6,Z,10,'ONLY')
*
* Positioning volume TBAL into the mother SPEB
*
      DO I=1,2
C DTBAL is the distance along x of the volumes TBAL from the end of TRPB
         DTBAL=3.6
         N=I
         IF(I.EQ.1) THEN
            X=TRPB(1)-3.6-TBAL(1)
         ELSE
            X=-(TRPB(1)-3.6-TBAL(1))
         ENDIF
         Y=MGFR(2) - 2*TRPB(2)-TBAL(2)
         Z=ZTRPB
         CALL GSPOS('TBAL',N,'SPEB',X,Y,Z,0,'ONLY')
      ENDDO
*
* Positioning volume TPGU     into the mother MGFR
*
      X=0.

      Z=-MGFR(3)+2*(TPGD(3)+TPGI(3)+MGPL(3)+TPGI(3)+TPGA(3)+TRPB(3))+
     +   TPGU(3)      
      Y=-MGFR(2)+TRPB(2)
CV      CALL GSPOS('TPGU',N,'MGFR',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGU',1,'MGF1',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGU',1,'MGF2',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGU',1,'MGF3',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGU',1,'MGF4',X,Y,Z,0,'ONLY')
      CALL GSPOS('TPGU',1,'MGF5',X,Y,Z,0,'ONLY')
*
      RETURN
      END
