      SUBROUTINE GPNDV
************************************************************************
*                                                                      *
* Volumes definition for the neutron detector                          *
* Called by: GPGEOM                                                    *
* Author: Francesco Cafagna, 05-sep-05                                 *
*                                                                      *
************************************************************************
#include "gpgeo.inc"
#include "gpmed.inc"
#include "gpkey.inc"
*
      INTEGER IROT,IVOLU,N,NMED
      REAL X,Y,Z
*
*  Define the NDBX     volume
*
      NMED= MAL
      CALL GSVOLU('NDBX','BOX ',NMED,NDBX, 3,IVOLU)
*
*  Define the NDBI     volume
*
      NMED= MN2
      CALL GSVOLU('NDBI','BOX ',NMED,NDBI, 3,IVOLU)
*
*  Define the NDTU     volume
*
      NMED= MIRON
      NMED= MSCIN
      CALL GSVOLU('NDTU','TUBE',NMED,NDTU, 3,IVOLU)
*
*  Define the NDTI     volume
*
      NMED= MHEND
      NMED= MSCIN
      CALL GSVOLU('NDTI','TUBE',NMED,NDTI, 3,IVOLU)
*
*  Define the NDPB     volume
*
      NMED= MC2H4
      NMED= MN2
      CALL GSVOLU('NDPB','BOX ',NMED,NDPB, 3,IVOLU)
*
*  Define the NDCD     volume
*
      NMED= MN2
      CALL GSVOLU('NDCD','BOX ',NMED,NDCD, 3,IVOLU)
*
* Positioning volumes NDTI inside NDTU. 
*
      N = 1
      X = 0.
      Y = 0.
      Z = 0.
      CALL GSPOS('NDTI',N,'NDTU',X,Y,Z,0,'ONLY')
*
* Positioning volume NDTU inside the mother NDPB 
*
      N = 0
      Y = 0.
C # 
C # Start to put tube on top of a cmd and 3 pholyetilene planes
C # 
      DO I=1,2
C # 
C # Place a tube layer at a 4 mm distance each
C #
         X = -NDBI(2) + 0.2 + 1.1
         Z = -NDBI(3) + 2.*NDCD(3) + 3.*(2.*NDPB(3)) + NDTU(2) 
     +        + (I-1)*4*NDPB(3)
         DO II=1,18
            N= N + 1
            CALL GSPOS('NDTU',N,'NDBI',X,Y,Z,2,'MANY')
            X = X + 2.2 
         ENDDO
      ENDDO
*
* Positioning volume NDPB inside the mother NDPB 
*
      N = 0
      X = 0.
      Y = 0.
C # 
C # Stack 3 planes then leave the tube gap between the last two
C #
      DO I=1,3
         N= N + 1
         Z = -NDBI(3) + 2.*NDCD(3) + (I-1)*2.*NDPB(3) + NDPB(3)  
         CALL GSPOS('NDPB',N,'NDBI',X,Y,Z,0,'MANY')
      ENDDO
      DO I=1,2
         Z = -NDBI(3) + 2.*NDCD(3) + 4.*2.*NDPB(3) + NDPB(3) 
     +        + (I-1)*4.*NDPB(3)
         N= N + 1
         CALL GSPOS('NDPB',N,'NDBI',X,Y,Z,0,'MANY')
      ENDDO
C # 
C # Positioning the NDCD
C #
      N=1
      X = 0 
      Y = 0
      Z = -NDBI(3) + NDCD(3)
      CALL GSPOS('NDCD',N,'NDBI',X,Y,Z,0,'MANY')
      N = N +1
      Z = -NDBI(3) + 2.*NDCD(3) + 7.*2.*NDPB(3)+ NDCD(3)
      CALL GSPOS('NDCD',N,'NDBI',X,Y,Z,0,'MANY')
C # 
C # Now put the internal volume inside the aluminum box 
C # *
      N = 1
      X = 0.
      Y = 0.
      Z = 0.
      CALL GSPOS('NDBI',N,'NDBX',X,Y,Z,0,'MANY')

      RETURN
      END
