      SUBROUTINE GPDND
************************************************************************
*                                                                      *
* To perform ND digitization                                          *
*                                                                      *
* Called by: GUDIGI                                                    *
* Author: Francesco Cafagna, 23/02/06 12.50.38                         *
*                                                                      *
************************************************************************
#include "gcunit.inc"
#include "gpphit.inc"
      PARAMETER (NH=NHND,NHM=NHMND,NVOL=2)
#include "gprhit.inc"
#include "gpnd.inc"
#include "gpsed.inc"
*
      INTEGER IS,ID,NV,NVM,NNHM
      CHARACTER*4 CSET
      DATA CSET/'ND  '/
*
* Vector zeroed
*
      CALL VZERO(ITUBEND,NHM)
      CALL VZERO(IPARND,NHM)
      CALL VZERO(XINND,NHM)
      CALL VZERO(YINND,NHM)
      CALL VZERO(ZINND,NHM)
      CALL VZERO(XOUTND,NHM)
      CALL VZERO(YOUTND,NHM)
      CALL VZERO(ZOUTND,NHM)
      CALL VZERO(ERELND,NHM)
      CALL VZERO(TIMEND,NHM)
      CALL VZERO(PATHND,NHM)
      CALL VZERO(P0ND,NHM)
*
      CALL VZERO(NUMD  ,NVOL)
*
* Start with nd top
*
      NV = NVOL
      NVM= NVMAX
      IT = -1
      NTHND = 0
      INDEX = 0
      IS= ISND
      ID= IDNDTI
*
* Check on the volume level
*
      IF (NV.GT.NVM) THEN
         WRITE(CHMAIL,10000) CSET,CNSED(IS,ID),NVOL,NVMAX, IDRUN,
     +        IDEVT
         CALL GMAIL(1,0)
         GO TO 10
      ENDIF
      CALL VZERO(VHITS,NH*NHM)
      CALL VZERO(ITRA ,NHM)
      CALL VZERO(NUMBV,NVOL*NHM)
      NHITS = -1
      CALL GPRHIT(CSET,CNSED(IS,ID),IS,ID,NVOL,NH,NHM,1,
     +     IT,NUMD,ITRA,NUMBV,VHITS,NHITS)
*     
*     If there was a problem in GPRHIT then exit
*     
      IF(NHITS.LT.0) THEN
         WRITE(CHMAIL,10200) CSET,CNSED(IS,ID),NHITS,NHM,
     +        IDRUN,IDEVT
         CALL GMAIL(1,0)
         GO TO 10
      ENDIF
*     
*     Fill the CWN common
*     
      NTHND = NHITS 
      DO I=1,NHITS
         ITUBEND(I) = NUMBV(1,I)
         XINND(I) = VHITS(1,I)
         YINND(I) = VHITS(2,I)
         ZINND(I) = VHITS(3,I)
         XOUTND(I) = VHITS(4,I)
         YOUTND(I) = VHITS(5,I)
         ZOUTND(I) = VHITS(6,I)
         ERELND(I) = VHITS(7,I)
         TIMEND(I) = VHITS(8,I)
         PATHND(I) = VHITS(9,I)
         IPARND(I) = VHITS(10,I)
         P0ND (I) = VHITS(11,I)
*     
      ENDDO
      
*
10000 FORMAT(' GPDND: VOLUME level too big: SET=',A4,', DET=',A4,
     +     ',NVOL=',I3,', NVMAX=',I3,', RUN=',I5,', EVT=',I8)
10100 FORMAT(' GPDND: MAX number of hits retrived: SET=',A4,
     +     ', DET=',A4,',NHREAD=',I5,', NHMAX=',I5,
     +     ', RUN=',I5,', EVT=',I8)
10200 FORMAT(' GPDND: Error in GPRHIT: SET=',A4,
     +     ', DET=',A4,',NHITS=',I5,', NHMAX=',I5,
     +     ', RUN=',I5,', EVT=',I8)
 10   RETURN
      END
