      SUBROUTINE GPNDV
************************************************************************
*                                                                      *
* Volumes definition for the neutron detector                          *
* Called by: GPGEOM                                                    *
* Author: Francesco Cafagna, 05-sep-05                                 *
*                                                                      *
************************************************************************
#include "gpgeo.inc"
#include "gpmed.inc"
#include "gpkey.inc"
*
      INTEGER IROT,IVOLU,N,NMED
      REAL X,Y,Z

*
*  Define the NDBO     volume
*
      NMED= MN2
      CALL GSVOLU('NDBO','BOX ',NMED,NDBO, 3,IVOLU)
*
*  Define the NDBX     volume
*
      NMED= MAL
      CALL GSVOLU('NDBX','BOX ',NMED,NDBX, 3,IVOLU)
*
*  Define the NDCD     volume
*
      NMED= MCAD
      CALL GSVOLU('NDCD','BOX ',NMED,NDCD, 3,IVOLU)
*
*  Define the NDBI     volume
*
      NMED= MN2
      CALL GSVOLU('NDBI','BOX ',NMED,NDBI, 3,IVOLU)
*
*  Define the NDTU     volume
*
      NMED= MIRON
      NMED= MSCIN
      CALL GSVOLU('NDTU','TUBE',NMED,NDTU, 3,IVOLU)
*
*  Define the NDTI     volume
*
      NMED= MHE3
      CALL GSVOLU('NDTI','TUBE',NMED,NDTI, 3,IVOLU)
*
*  Define the NDPB     volume
*
      NMED= MCH2
      CALL GSVOLU('NDPB','BOX ',NMED,NDPB, 3,IVOLU)
*
*  Define the NDCO     volume
*
      NMED= MAL
      CALL GSVOLU('NDCO','BOX ',NMED,NDCO, 3,IVOLU)
*
*  Define the NDBS     volume
*
      NMED= MAL
      CALL GSVOLU('NDBS','BOX ',NMED,NDBS, 3,IVOLU)
*
*  Define the NDSS     volume
*
      NMED= MN2
      CALL GSVOLU('NDSS','BOX ',NMED,NDSS, 3,IVOLU)
*
*  Define the NDCI     volume
*
      NMED= MN2
      CALL GSVOLU('NDCI','BOX ',NMED,NDCI, 3,IVOLU)
*
*  Define the NDCM     volume
*
      NMED= MN2
      CALL GSVOLU('NDCM','BOX ',NMED,NDCM, 3,IVOLU)
*
*  Define the NDCE     volume
*
      NMED= MN2
      CALL GSVOLU('NDCE','BOX ',NMED,NDCE, 3,IVOLU)
*
*  Define the NDSI     volume
*
      NMED= MN2
      CALL GSVOLU('NDSI','BOX ',NMED,NDSI, 3,IVOLU)
*
*  Define the NDSM     volume
*
      NMED= MN2
      CALL GSVOLU('NDSM','BOX ',NMED,NDSM, 3,IVOLU)
*
*  Define the NDSE     volume
*
      NMED= MN2
      CALL GSVOLU('NDSE','BOX ',NMED,NDSE, 3,IVOLU)
*
* Positioning volumes NDTI inside NDTU. 
*
      N = 1
      X = 0.
      Y = 0.
      Z = 0.
      CALL GSPOS('NDTI',N,'NDTU',X,Y,Z,0,'ONLY')
*
* Positioning volume NDTU inside the mother NDPB 
*
      N = 0
      Y = 0.
C # 
C # Start to put tube on top of a cmd and 3 pholyetilene planes
C # 
      DO I=1,2
C # 
cC # Place a tube layer at a 4 mm distance each
C # Place a tube layer at a 5 mm distance each
C #
c         X = -NDBI(2) + 0.2 + 1.1
         X = -NDBI(1) + 0.3 + NDTU(2)
C         Z = -NDBI(3) + 2.*NDCD(3) + 3.*(2.*NDPB(3)) + NDTU(2) 
C     +        + (I-1)*4*NDPB(3)
         Z = -NDBI(3)+3.*(2.*NDPB(3))+NDTU(2) 
     +        + (I-1)*2*NDPB(3)+(I-1)*2*NDTU(2)
         DO II=1,18
            N= N + 1
C            CALL GSPOS('NDTU',N,'NDBI',X,Y,Z,2,'MANY')
            CALL GSPOS('NDTU',N,'NDBI',X,Y,Z,2,'ONLY')
C            X = X + 2.2 
            X=X+2*NDTU(2)+GNDTU
         ENDDO
      ENDDO
*
* Positioning volume NDPB inside the mother NDBI
*
      N = 0
      X = 0.
      Y = 0.
C # 
C # Stack 3 planes then leave the tube gap between the last two
C #
      DO I=1,3
         N= N + 1
c         Z = -NDBI(3) + 2.*NDCD(3) + (I-1)*2.*NDPB(3) + NDPB(3)  
         Z=-NDBI(3)+(I-1)*2.*NDPB(3)+NDPB(3)  
C         CALL GSPOS('NDPB',N,'NDBI',X,Y,Z,0,'MANY')
         CALL GSPOS('NDPB',N,'NDBI',X,Y,Z,0,'ONLY')
      ENDDO
      DO I=1,2
C         Z = -NDBI(3) + 2.*NDCD(3) + 4.*2.*NDPB(3) + NDPB(3) 
C     +        + (I-1)*4.*NDPB(3)
         Z = -NDBI(3) + 3.*2.*NDPB(3) + NDPB(3) 
     +        + (I-1)*2.*NDPB(3)+I*2*NDTU(2)
         N= N + 1
C         CALL GSPOS('NDPB',N,'NDBI',X,Y,Z,0,'MANY')
         CALL GSPOS('NDPB',N,'NDBI',X,Y,Z,0,'ONLY')
      ENDDO
C # 
C # Now put the internal volume inside the cadmium box 
C # *
      N = 1
      X = 0.
      Y = 0.
      Z=-NDCD(3)+NDBI(3)+TNDCD
      CALL GSPOS('NDBI',N,'NDCD',X,Y,Z,0,'ONLY')
C # 
C # Positioning the NDCD inside NDBX
C #
      N=1
      X = 0 
      Y = 0
      Z=-NDBX(3)+NDCD(3)+TNDBX
      CALL GSPOS('NDCD',N,'NDBX',X,Y,Z,0,'ONLY')
C # 
C # Positioning the NDBX inside NDBO
C #
      N=1
      X = 0 
      Y = 0
      Z=-NDBO(3)+NDBX(3)
      CALL GSPOS('NDBX',N,'NDBO',X,Y,Z,0,'ONLY')
C # 
C # Positioning the NDCM inside NDCO
C #
      N=0
      X = 0 
      Z=NDCO(3)-NDCM(3)
      DO I=-1,1,2
         N=N+1
         Y = I*(NDCI(2)+1.4+NDCM(2))
         CALL GSPOS('NDCM',N,'NDCO',X,Y,Z,0,'ONLY')
      ENDDO
C # 
C # Positioning the NDCI inside NDCO
C #
      N=1
      X = 0 
      Y = 0
      Z=NDCO(3)-NDCI(3)
      CALL GSPOS('NDCI',N,'NDCO',X,Y,Z,0,'ONLY')
C # 
C # Positioning the NDCE inside NDCO
C #
      N=0
      X = 0 
      Z=NDCO(3)-NDCE(3)
      DO I=-1,1,2
         N=N+1
         Y = I*(NDCI(2)+1.4+2*NDCM(2)+1.4+NDCE(2))
         CALL GSPOS('NDCE',N,'NDCO',X,Y,Z,0,'ONLY')
      ENDDO
C # 
C # Positioning the NDSM inside NDCO
C #
      N=0 
      Z=NDCO(3)-NDSM(3)
      DO I=-1,1,2
         Y = I*(NDCO(2)-9.6-NDSM(2))
         DO j=-1,1,2
            N=N+1
            X=J*(NDCO(1)-2.9-NDSM(1))
            CALL GSPOS('NDSM',N,'NDCO',X,Y,Z,0,'ONLY')
         ENDDO
      ENDDO
C # 
C # Positioning the NDSI inside NDCO
C #
      N=0 
      Z=NDCO(3)-NDSI(3)
      Y=0.
      DO j=-1,1,2
         N=N+1
         X=J*(NDCO(1)-2.9-NDSI(1))
         CALL GSPOS('NDSI',N,'NDCO',X,Y,Z,0,'ONLY')
      ENDDO
C # 
C # Positioning the NDSE inside NDCO
C #
      N=0 
      Z=NDCO(3)-NDSE(3)
      DO I=-1,1,2
         Y = I*(NDCI(2)+1.4+2*NDCM(2)+1.4+NDSE(2))
         DO j=-1,1,2
            N=N+1
            X=J*(NDCE(1)+1.6+NDSE(1))
            CALL GSPOS('NDSE',N,'NDCO',X,Y,Z,0,'ONLY')
         ENDDO
      ENDDO
C # 
C # Positioning the NDCO inside NDBO
C #
      N=1
      X = 0 
      Y = 0
      Z=NDBO(3)-NDCO(3)
      CALL GSPOS('NDCO',N,'NDBO',X,Y,Z,0,'ONLY')
C # 
C # Positioning the NDBS inside NDBO
C #
      N=0
      DO I=-1,1,2 
         N=N+1
         X = 0. 
         Y = I*NDBO(2)-I*NDBS(2)
         Z=-NDBO(3)+NDBS(3)
         CALL GSPOS('NDBS',N,'NDBO',X,Y,Z,0,'ONLY')
      ENDDO
      N=1
      X = 0. 
      Y = 0.
      Z=0.
      CALL GSPOS('NDSS',N,'NDBS',X,Y,Z,0,'ONLY')
      RETURN
      END
