*
* $Id$
*
* $Log$
*
#if defined(GPAMELA_GARFIELD)
*CMZ :  3.00/00 16/07/2001  17.26.37  by  Unknown
*-- Author :    Marialuigia Ambriola   02/05/2001
      SUBROUTINE GPGACL(IDPART,VPART,VXYZ,ECLTOT,NCLUS)
********************************************************************************
*
* A silly subroutine to interface GARFIELD. It needs the particle and
* track parameter to be passed to GARFIELD. It returns the number of
* clusters generated and the total energy released in MeV
*
* Varibles definitions:
* IN
*  - IDPART, GEANT particle ID
*  - VPART , real array containing particle characteristics.
*     VPART(1) = particle MASS (MeV)
*     VPART(2) = particle charge
*     VPART(3) = particle KInetic Energy
*  - VXYZ, real array containing the track starting and ending points
*      VXYZ(1) = X starting point
*      VXYZ(2) = Y starting point
*      VXYZ(3) = Z starting point
*      VXYZ(4) = X ending point
*      VXYZ(5) = Y ending point
*      VXYZ(6) = Z ending  point
*
* OUT
*  - ECLTOT, Total energy released in the track, in MeV
*  - NCLUS , Number of clusters generated along the track
*
* Called by: <USER>
*
* By Caf & ML on 2 May 2001
*
********************************************************************************
      IMPLICIT NONE
*
* Garfield commons
*
#include "dimensions.inc"
#include "parameters.inc"
*
*
*     Local variables
*
#include "gcunit.inc"
      REAL VPART(3),VXYZ(6),ECLTOT
      INTEGER IDPART,NCLUS,IFAIL
      LOGICAL DONE
      REAL XCLS,YCLS,ZCLS,ECLS
      INTEGER NPAIR
*
*     Start filling in the particle properties and the track mode type (ITRTYPE)
*
      CALL GPGAPART(IDPART,IFAIL)
      IF(IFAIL.EQ.1) THEN
*
* No HEED corrispondence
*
         WRITE(CHMAIL,10100)
         CALL GMAIL(1,0)
         TRMASS=VPART(1)
         TRCHAR=VPART(2)
         WRITE(PNAME,10000)IDPART
10000    FORMAT('GEANT',I3)
         NCPNAM=8
         ITRTYP=4
      ENDIF
*
*     The particle is definited
*
      TRENER = VPART(3)
*      PRINT*,'TRFLAG=',TRFLAG(1),TRFLAG(2),TRFLAG(3),TRFLAG(4),TRFLAG(5)
*      TRFLAG(2) = .TRUE.
*
*     Store the track parameters
*
      XT0 = VXYZ(1)
      YT0 = VXYZ(2)
      ZT0 = VXYZ(3)
      XT1 = VXYZ(4)
      YT1 = VXYZ(5)
      ZT1 = VXYZ(6)
*      TRFLAG(1) = .TRUE.
*
*     Initialize the track
*
      CALL TRACLI
*
*     Track it until DONE
*
      ECLTOT = 0
      NCLUS  = 0
*      PRINT*,'LTRMS,LTRDEL,LTREXB=',LTRMS,LTRDEL,LTREXB
*      PRINT*,'BEFORE'
*      PRINT*,'XT0,YT0,ZT0=',XT0,YT0,ZT0
*      PRINT*,'VPART(1)=',VPART(1)
   10 CALL TRACLS(XCLS,YCLS,ZCLS,ECLS,NPAIR,DONE,IFAIL)
      IF(DONE) THEN
C     # The cluster generation is over	
         GO TO 20
      ENDIF
      IF(IFAIL.NE.0. ) THEN
C     # An error occurred
         WRITE(CHMAIL,10200)
         CALL GMAIL(1,0)
         GO TO 20
      ENDIF
c ML:
      IF(ECLS.LE.0.) THEN
         PRINT*,'ATTENZIONE IN GPGACL, Energia del cluster negativa:'
         PRINT*,'ECLS=',ECLS
         GO TO 20
      ENDIF
c END ML.
      ECLTOT = ECLTOT + ECLS
      NCLUS = NCLUS + 1
      GO TO 10
10100 FORMAT(' GPGACL: ERROR !!!! GEANT particle ID not found in ',
     +     'HEED data base')
10200 FORMAT(' GPGACL: ERROR !!!! Error in cluster generation from ',
     +     'TRACLS')
   20 RETURN
      END
#endif
