*
* $Id: gpdcat.F,v 3.1.1.1 2002/07/11 16:02:14 cafagna Exp $
*
* $Log: gpdcat.F,v $
* Revision 3.1.1.1  2002/07/11 16:02:14  cafagna
* First GPAMELA release on CVS
*
*
*               19/09/2002  11.30.50  by  Jens Lund
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.06  by  Francesco Cafagna
*CMZ :  1.02/00 22/10/99  16.17.58  by  Francesco Cafagna
*CMZ :  1.01/00 21/05/96  17.33.38  by  Francesco Cafagna
*CMZ :  1.00/02 04/04/96  16.08.24  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   23/02/96
      SUBROUTINE GPDCAT
************************************************************************
*                                                                      *
* To perform CAT  digitization                                         *
*                                                                      *
* Called by: GUDIGI                                                    *
* Author: Francesco Cafagna, 23/02/96 12.50.38                         *
*                                                                      *
************************************************************************
#include "gcunit.inc"
#include "gpphit.inc"
      PARAMETER (NH=NHCAT,NHM=NHMCAT,NVOL=3)
#include "gprhit.inc"
#include "gpcat.inc"
#include "gpsed.inc"
*
      INTEGER IS,ID,NV,NVM,NNHM
      CHARACTER*4 CSET
*
*
* Vector zeroed
*
      CALL VZERO(ICAT ,NHM)
      CALL VZERO(XCAT ,NHM)
      CALL VZERO(YCAT ,NHM)
      CALL VZERO(ZCAT ,NHM)
      CALL VZERO(XOCAT,NHM)
      CALL VZERO(YOCAT,NHM)
      CALL VZERO(ZOCAT,NHM)
      CALL VZERO(ERCAT,NHM)
      CALL VZERO(TIMECAT,NHM)
      CALL VZERO(PACAT,NHM)
      CALL VZERO(ICATPAR,NHM)
      CALL VZERO(P0CAT,NHM)
      CALL VZERO(NUMD ,NVOL)
*
* Start with tof top
*
      NV = NVOL
      NVM= NVMAX
      IS   = ISCAT
      ID   = IDCATL
      CSET = 'CAT '
      IT = -1
*
* Check on the volume level
*
      IF (NV.GT.NVM) THEN
         WRITE(CHMAIL,10000) CSET,CNSED(IS,ID),NVOL,NVMAX,
     +                        IDRUN,IDEVT
         CALL GMAIL(1,0)
         GO TO 10
      ENDIF
      CALL VZERO(VHITS,NH*NHM)
      CALL VZERO(ITRA ,NHM)
      CALL VZERO(NUMBV,NVOL*NHM)
      NHITS = -1
      CALL GPRHIT(CSET,CNSED(IS,ID),IS,ID,NVOL,NH,NHM,1,
     +            IT,NUMD,ITRA,NUMBV,VHITS,NHITS)
*
* If there was a problem in GPRHIT then exit
*
      IF(NHITS.LT.0) THEN
         WRITE(CHMAIL,10100) CSET,CNSED(IS,ID),NHITS,NHM,
     +                        IDRUN,IDEVT
         CALL GMAIL(1,0)
         GO TO 10
      ENDIF
*
* >>>>>>>>>>>>>>>>>>>>>> DIGI action
*
*
* Fill the CWN common
*
      NTHCAT = NHITS
      DO I=1,NHITS
         ICAT(I)  = NUMBV(NVCAT,I)
#if defined(GPAMELA_INTER)
         XINCAT(I)  = 2*VHITS(1,I)-VHITS(4,I)
         YINCAT(I)  = 2*VHITS(2,I)-VHITS(5,I)
         ZINCAT(I)  = 2*VHITS(3,I)-VHITS(6,I)
#endif
#if !defined(GPAMELA_INTER)
         XINCAT(I)  = VHITS(1,I)
         YINCAT(I)  = VHITS(2,I)
         ZINCAT(I)  = VHITS(3,I)
#endif
         XOUTCAT(I) = VHITS(4,I)
         YOUTCAT(I) = VHITS(5,I)
         ZOUTCAT(I) = VHITS(6,I)
         ERELCAT(I) = VHITS(7,I)
         TIMECAT(I)=  VHITS(8,I)
         PATHCAT(I) = VHITS(9,I)
         IPARCAT(I) = VHITS(10,I)
         P0CAT(I) = VHITS(11,I)
      ENDDO
*JeL:
*
* Next detector
*
C      ID   = IDCATT
C      CALL VZERO(VHITS,NH*NHM)
C      CALL VZERO(ITRA ,NHM)
C      CALL VZERO(NUMBV,NVOL*NHM)
C      NHITS = -1
*
* Update the max number of hits to be retrived
*
C      NNHM = NHM - NTHCAT
C      IF(NNHM.LE.0) THEN
C         WRITE(CHMAIL,10100) CSET,CNSED(IS,ID),NTHCAT,NHM,
C     +                        IDRUN,IDEVT
C         CALL GMAIL(1,0)
C         GO TO 10
C      ENDIF
C      CALL GPRHIT(CSET,CNSED(IS,ID),IS,ID,NVOL,NH,NNHM,1,
C     +            IT,NUMD,ITRA,NUMBV,VHITS,NHITS)
*
* If there was a problem in GPRHIT then exit
*
C      IF(NHITS.LT.0) THEN
C         WRITE(CHMAIL,10200) CSET,CNSED(IS,ID),NHITS,NHM,
C     +                        IDRUN,IDEVT
C         CALL GMAIL(1,0)
C         GO TO 10
C      ENDIF
*
* >>>>>>>>>>>>>>>>>>>>>> DIGI action
*
*
C      DO I=1,NHITS
C         NTHCAT = NTHCAT + 1
C         ICAT(NTHCAT)  = 2 + NUMBV(NVCAT,I)
C#if defined(GPAMELA_INTER)
C         XINCAT(NTHCAT)  = 2*VHITS(1,I)-VHITS(4,I)
C         YINCAT(NTHCAT)  = 2*VHITS(2,I)-VHITS(5,I)
C         ZINCAT(NTHCAT)  = 2*VHITS(3,I)-VHITS(6,I)
C#endif
C#if !defined(GPAMELA_INTER)
C         XINCAT(NTHCAT)  = VHITS(1,I)
C         YINCAT(NTHCAT)  = VHITS(2,I)
C         ZINCAT(NTHCAT)  = VHITS(3,I)
C#endif
C         XOUTCAT(NTHCAT) = VHITS(4,I)
C         YOUTCAT(NTHCAT) = VHITS(5,I)
C         ZOUTCAT(NTHCAT) = VHITS(6,I)
C         ERELCAT(NTHCAT) = VHITS(7,I)
C         TIMECAT(NTHCAT)=  VHITS(8,I)
C         PATHCAT(NTHCAT) = VHITS(9,I)
C         IPARCAT(NTHCAT) = VHITS(10,I)
C         P0CAT(NTHCAT) = VHITS(11,I)
C      ENDDO
*END: JeL.
10000  FORMAT(' GPDCAT: VOLUME level too big: SET=',A4,', DET=',A4,',
     +        NVOL=',I3,', NVMAX=',I3,', RUN=',I5,', EVT=',I8)
10100  FORMAT(' GPDCAT: MAX number of hits retrived: SET=',A4,
     +        ', DET=',A4,',NHREAD=',I5,', NHMAX=',I5,
     +        ', RUN=',I5,', EVT=',I8)
10200  FORMAT(' GPDCAT: Error in GPRHIT: SET=',A4,
     +        ', DET=',A4,',NHITS=',I5,', NHMAX=',I5,
     +        ', RUN=',I5,', EVT=',I8)
   10 RETURN
      END
