*
* $Id: gpcatv.F,v 3.1.1.1 2002/07/11 16:02:14 cafagna Exp $
*
* $Log: gpcatv.F,v $
* Revision 3.1.1.1  2002/07/11 16:02:14  cafagna
* First GPAMELA release on CVS
*
*
*               17/10/2002  22.28.20  by  Jens Lund
*CMZ :  3.00/00 14/11/2000  09.13.05  by  Emiliano Mocchiutti
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.06  by  Francesco Cafagna
*CMZ :  1.00/02 08/02/96  17.12.36  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   08/02/96
      SUBROUTINE GPCATV
************************************************************************
*                                                                      *
* Volumes definition for the TOP  anticoincidence counters             *
* Called by: GPGEO                                                     *
*                                                                      *
* Author: Francesco Cafagna, 08/02/96 16.58.49                         *
*                                                                      *
************************************************************************
#include "gpgeo.inc"
#include "gpmed.inc"
*
      INTEGER IROT,IVOLU,N,NMED,NUM
      REAL X,Y,Z
*JeL:
      REAL TBOX(3),TTRD1(4)
      NMED=MN2
*
* Define the CAT 'virtual' box
      CALL GSVOLU('CATA','BOX ',NMED,CATA, 3,IVOLU)
*
* Define the CAT (cover) Aluminum box
      NMED=MAL
      TBOX(1) = 0.5*56.0
      TBOX(2) = 0.5*1.2
      TBOX(3) = 0.5*54.33
      CALL GSVOLU('ATBB','BOX ',NMED,TBOX, 3,IVOLU)
*
* Define the CAT rims
      NMED=MPLAS
      TBOX(1) = 0.5*55.3
      TBOX(2) = 0.5*0.8
      TBOX(3) = 0.5*53.63
      CALL GSVOLU('PLA2','BOX ',NMED,TBOX, 3,IVOLU)
*
* Define the CAT scintillator
      NMED=MSCIN
      TBOX(1) = 0.5*53.7
      TBOX(2) = 0.5*0.8
      TBOX(3) = 0.5*52.03
      CALL GSVOLU('TOP1','BOX ',NMED,TBOX, 3,IVOLU)
*
* Define middle Pl. box
      NMED=MPLAS
      TBOX(1) = 0.5*20.22
      TBOX(2) = 0.5*0.8
      TBOX(3) = 0.5*16.88
      CALL GSVOLU('PTBM','BOX ',NMED,TBOX, 3,IVOLU)
*
* Define middle Al. box
      NMED=MAL
      TBOX(1) = 0.5*18.82
      TBOX(2) = 0.5*0.8
      TBOX(3) = 0.5*15.48
      CALL GSVOLU('ATBM','BOX ',NMED,TBOX, 3,IVOLU)
*
* Define middle 'air' box
      NMED=MN2
      TBOX(1) = 0.5*18.22
      TBOX(2) = 0.5*1.2
      TBOX(3) = 0.5*14.88
      CALL GSVOLU('LTBM','BOX ',NMED,TBOX, 3,IVOLU)
*
* Define corner Pl. box
      NMED=MPLAS
      TBOX(1) = 0.5*9.95
      TBOX(2) = 0.5*0.8
      TBOX(3) = 0.5*11.115
      CALL GSVOLU('PTBC','BOX ',NMED,TBOX, 3,IVOLU)
*
* Define corner Al. box
      NMED=MAL
      TBOX(1) = 0.5*9.95
      TBOX(2) = 0.5*0.8
      TBOX(3) = 0.5*11.115
      CALL GSVOLU('ATBC','BOX ',NMED,TBOX, 3,IVOLU)
*
* Define corner 'air' box
      NMED=MN2
      TBOX(1) = 0.5*9.95
      TBOX(2) = 0.5*1.2
      TBOX(3) = 0.5*11.115
      CALL GSVOLU('LTBC','BOX ',NMED,TBOX, 3,IVOLU)
*
* Define Pl. trapezoid (TRD1) 'top'
      NMED=MPLAS
      TTRD1(1) = 0.
      TTRD1(2) = 16.9
      TTRD1(3) = 0.5*0.8
      TTRD1(4) = 0.5*4.81
      CALL GSVOLU('PTRT','TRD1',NMED,TTRD1, 4,IVOLU)
*
* Define Al. trapezoid (TRD1) 'top'
      NMED=MAL
      TTRD1(1) = 0.
      TTRD1(2) = 17.7
      TTRD1(3) = 0.5*0.8
      TTRD1(4) = 0.5*4.81
      CALL GSVOLU('ATRT','TRD1',NMED,TTRD1, 4,IVOLU)
*
* Define 'air' trapezoid (TRD1) 'top'
      NMED=MN2
      TTRD1(1) = 0.
      TTRD1(2) = 18.05
      TTRD1(3) = 0.5*1.2
      TTRD1(4) = 0.5*4.81
      CALL GSVOLU('LTRT','TRD1',NMED,TTRD1, 4,IVOLU)
*
* Define Pl. trapezoid (TRD1) 'bottom'
      NMED=MPLAS
      TTRD1(1) = 16.9
      TTRD1(2) = 0.
      TTRD1(3) = 0.5*0.8
      TTRD1(4) = 0.5*4.81
      CALL GSVOLU('PTRB','TRD1',NMED,TTRD1, 4,IVOLU)
*
* Define Al. trapezoid (TRD1) 'bottom'
      NMED=MAL
      TTRD1(1) = 17.7
      TTRD1(2) = 0.
      TTRD1(3) = 0.5*0.8
      TTRD1(4) = 0.5*4.81
      CALL GSVOLU('ATRB','TRD1',NMED,TTRD1, 4,IVOLU)
*
* Define 'air' trapezoid (TRD1) 'bottom'
      NMED=MN2
      TTRD1(1) = 18.05
      TTRD1(2) = 0.
      TTRD1(3) = 0.5*1.2
      TTRD1(4) = 0.5*4.81
      CALL GSVOLU('LTRB','TRD1',NMED,TTRD1, 4,IVOLU)
*
* Define Pl. trapezoid (TRD1) 'left&right'
      NMED=MPLAS
      TTRD1(1) = 0.
      TTRD1(2) = 14.9
      TTRD1(3) = 0.5*0.8
      TTRD1(4) = 0.5*4.75
      CALL GSVOLU('PTRL','TRD1',NMED,TTRD1, 4,IVOLU)
*
* Define Al. trapezoid (TRD1) 'left&right'
      NMED=MAL
      TTRD1(1) = 0.
      TTRD1(2) = 15.7
      TTRD1(3) = 0.5*0.8
      TTRD1(4) = 0.5*4.75
      CALL GSVOLU('ATRL','TRD1',NMED,TTRD1, 4,IVOLU)
*
* Define 'air' trapezoid (TRD1) 'left&right'
      NMED=MN2
      TTRD1(1) = 0.
      TTRD1(2) = 16.05
      TTRD1(3) = 0.5*1.2
      TTRD1(4) = 0.5*4.75
      CALL GSVOLU('LTRL','TRD1',NMED,TTRD1, 4,IVOLU)
*
*
* POSITIONING OF THE CAT VOLUMES
*
*
* Position the aluminum box (ATBB) in CATA
      N = 1
      X = 0.
      Y = 0.
      Z = 0.
      CALL GSPOS('ATBB',N,'CATA',X,Y,Z,0,'ONLY')
*
* Position the plastic box (PLA2) in ATBB
      N = 1
      X = 0.
      Y = 0.
      Z = 0.
      CALL GSPOS('PLA2',N,'ATBB',X,Y,Z,0,'ONLY')
*
* Position the CAT scintillator (TOP1) in PLA2
      X = 0.
      Y = 0.
      Z = 0.
      CALL GSPOS('TOP1',N,'PLA2',X,Y,Z,0,'ONLY')
*
* Position the middle plastic box (PTBM) in TOP1
      X = 0.
      Y = 0.
      Z = 0.
      CALL GSPOS('PTBM',N,'TOP1',X,Y,Z,0,'ONLY')
*
* Position the middle aluminum box (ATBM) in PLA2
      X = 0.
      Y = 0.
      Z = 0.
      CALL GSPOS('ATBM',N,'PLA2',X,Y,Z,0,'ONLY')
*
* Position the middle 'air' box (LTBM) in ATBB
      X = 0.
      Y = 0.
      Z = 0.
      CALL GSPOS('LTBM',N,'ATBB',X,Y,Z,0,'ONLY')
*
* Position the plastic U.L corner box (PTBC) in TOP1
      X = -21.875
      Y = 0.
      Z = 20.4575
      CALL GSPOS('PTBC',N,'TOP1',X,Y,Z,0,'ONLY')
*
* Position the aluminum U.L corner box (ATBC) in PLA2
      X = -22.675
      Y = 0.
      Z = 21.2575
      CALL GSPOS('ATBC',N,'PLA2',X,Y,Z,0,'ONLY')
*
* Position the 'air' U.L corner box (LTBC) in ATBB
      X = -23.025
      Y = 0.
      Z = 21.6075
      CALL GSPOS('LTBC',N,'ATBB',X,Y,Z,0,'ONLY')
*
* Position the plastic U.R corner box (PTBC) in TOP1
      N = 2
      X = 21.875
      Y = 0.
      Z = 20.4575
      CALL GSPOS('PTBC',N,'TOP1',X,Y,Z,0,'ONLY')
*
* Position the aluminum U.R corner box (ATBC) in PLA2
      N = 2
      X = 22.675
      Y = 0.
      Z = 21.2575
      CALL GSPOS('ATBC',N,'PLA2',X,Y,Z,0,'ONLY')
*
* Position the 'air' U.R corner box (LTBC) in ATBB
      X = 23.025
      Y = 0.
      Z = 21.6075
      CALL GSPOS('LTBC',N,'ATBB',X,Y,Z,0,'ONLY')
*
* Position the plastic L.L corner box (PTBC) in TOP1
      N = 3
      X = -21.875
      Y = 0.
      Z = -20.4575
      CALL GSPOS('PTBC',N,'TOP1',X,Y,Z,0,'ONLY')
*
* Position the aluminum L.L corner box (ATBC) in PLA2
      N = 3
      X = -22.675
      Y = 0.
      Z = -21.2575
      CALL GSPOS('ATBC',N,'PLA2',X,Y,Z,0,'ONLY')
*
* Position the 'air' L.L corner box (LTBC) in ATBB
      X = -23.025
      Y = 0.
      Z = -21.6075
      CALL GSPOS('LTBC',N,'ATBB',X,Y,Z,0,'ONLY')
*
* Position the plastic L.R corner box (PTBC) in TOP1
      N = 4
      X = 21.875
      Y = 0.
      Z = -20.4575
      CALL GSPOS('PTBC',N,'TOP1',X,Y,Z,0,'ONLY')
*
* Position the aluminum L.R corner box (ATBC) in PLA2
      N = 4
      X = 22.675
      Y = 0.
      Z = -21.2575
      CALL GSPOS('ATBC',N,'PLA2',X,Y,Z,0,'ONLY')
*
* Position the 'air' L.R corner box (LTBC) in ATBB
      X = 23.025
      Y = 0.
      Z = -21.6075
      CALL GSPOS('LTBC',N,'ATBB',X,Y,Z,0,'ONLY')
*
* Position the plastic 'top' TRD1 (PTRT) in TOP1
      N = 1
      X = 0.
      Y = 0.
      Z = 23.61
      CALL GSPOS('PTRT',N,'TOP1',X,Y,Z,0,'ONLY')
*
* Position the aluminum 'top' TRD1 (ATRT) in PLA2
      N = 1
      X = 0.
      Y = 0.
      Z = 24.41
      CALL GSPOS('ATRT',N,'PLA2',X,Y,Z,0,'ONLY')
*
* Position the 'air' 'top' TRD1 (LTRT) in ATBB
      X = 0.
      Y = 0.
      Z = 24.76
      CALL GSPOS('LTRT',N,'ATBB',X,Y,Z,0,'ONLY')
*
* Position the plastic 'bottom' TRD1 (PTRB) in TOP1
      X = 0.
      Y = 0.
      Z = -23.61
      CALL GSPOS('PTRB',N,'TOP1',X,Y,Z,0,'ONLY')
*
* Position the aluminum 'bottom' TRD1 (ATRB) in PLA2
      X = 0.
      Y = 0.
      Z = -24.41
      CALL GSPOS('ATRB',N,'PLA2',X,Y,Z,0,'ONLY')
*
* Position the 'air' 'bottom' TRD1 (LTRB) in ATBB
      X = 0.
      Y = 0.
      Z = -24.76
      CALL GSPOS('LTRB',N,'ATBB',X,Y,Z,0,'ONLY')
*
* Position the plastic 'left' TRD1 (PTRL) in TOP1 and rotate
      N = 1
      X = -24.475
      Y = 0.
      Z = 0.
      CALL GSPOS('PTRL',N,'TOP1',X,Y,Z,7,'ONLY')
*
* Position the aluminum 'left' TRD1 (ATRL) in PLA2 and rotate
      N = 1
      X = -25.275
      Y = 0.
      Z = 0.
      CALL GSPOS('ATRL',N,'PLA2',X,Y,Z,7,'ONLY')
*
* Position the 'air' 'left' TRD1 (LTRL) in ATBB and rotate
      X = -25.625
      Y = 0.
      Z = 0.
      CALL GSPOS('LTRL',N,'ATBB',X,Y,Z,7,'ONLY')
*
* Position the plastic 'right' TRD1 (PTRL) in TOP1 and rotate
      N = 2
      X = 24.475
      Y = 0.
      Z = 0.
      CALL GSPOS('PTRL',N,'TOP1',X,Y,Z,8,'ONLY')
*
* Position the aluminum 'right' TRD1 (ATRL) in PLA2 and rotate
      N = 2
      X = 25.275
      Y = 0.
      Z = 0.
      CALL GSPOS('ATRL',N,'PLA2',X,Y,Z,8,'ONLY')
*
* Position the 'air' 'right' TRD1 (LTRL) in ATBB and rotate
      X = 25.625
      Y = 0.
      Z = 0.
      CALL GSPOS('LTRL',N,'ATBB',X,Y,Z,8,'ONLY')
*END: JeL.

*EM:
C      NMED=MSCIN
*
*  Define the CATL     volume
*
C      CALL GSVOLU('CATL','BOX ',NMED,CATL, 3,IVOLU)
*
*  Define the CATT     volume
*
C      CALL GSVOLU('CATT','BOX ',NMED,CATT, 3,IVOLU)
*
C      NMED=MN2
*
*  Define the CATH     volume
*
C      CALL GSVOLU('CATH','BOX ',NMED,CATH, 3,IVOLU)
*
*  Define the CATF     volume
*
C      CALL GSVOLU('CATF','BOX ',NMED,CATF, 3,IVOLU)
*
C      NMED=MAL
*
*  Define the CATB     volume
*
C      CALL GSVOLU('CATB','BOX ',NMED,CATB, 3,IVOLU)
*
*  Define the CATO     volume
*
C      CALL GSVOLU('CATO','BOX ',NMED,CATO, 3,IVOLU)
*
*  Define the CATP     volume
*
C      CALL GSVOLU('CATP','BOX ',NMED,CATP, 3,IVOLU)
*
* Positioning volume CATT     into the mother CATB
*
C      N = 1
C      X= CATL(1)-CATB(1)
C      Y= CATL(2)+(2.*CATT(2)-CATB(2))
C      X = -CATT(1)
C      Y = 0.
C      Z = 0.
C      CALL GSPOS('CATT',N,'CATB',X,Y,Z,0,'ONLY')
C      N = 2
C      X = -X
C      Y = -Y
C      Z = 0.
C      CALL GSPOS('CATT',N,'CATB',X,Y,Z,0,'ONLY')
*
* Positioning volume CATL     into the mother CATB
*
C      N = 1
C      X = -CATT(1)-(2.*CATL(1)-CATB(1))
C      Y = CATT(2)-CATB(2)
C      X = -(2*CATT(1)+CATL(1))
C      Y = 0.
C      Z = 0.
C      CALL GSPOS('CATL',N,'CATB',X,Y,Z,0,'ONLY')
C      N = 2
C      X = -X
C      Y = -Y
C      Z = 0.
C      CALL GSPOS('CATL',N,'CATB',X,Y,Z,0,'ONLY')
*
* Positioning volume CATH     into the mother CATB
*
C      N = 1
C      X = 0.
C      Y = 0.
C      Z = 0.
C      CALL GSPOS('CATH',N,'CATB',X,Y,Z,0,'ONLY')
*
* Positioning volume CATF     into the mother CATB
*
C      N = 1
C      X = -(2*CATT(1)+CATL(1))
C      Y = CATL(2)+CATF(2)
C      Z = 0.
C      CALL GSPOS('CATF',N,'CATB',X,Y,Z,0,'ONLY')
C      N = 2
C      X = X
C      Y = -Y
C      Z = 0.
C      CALL GSPOS('CATF',N,'CATB',X,Y,Z,0,'ONLY')
C      N = 3
C      X = -X
C      Y = Y
C      Z = 0.
C      CALL GSPOS('CATF',N,'CATB',X,Y,Z,0,'ONLY')
C      N = 4
C      X = X
C      Y = -Y
C      Z = 0.
C      CALL GSPOS('CATF',N,'CATB',X,Y,Z,0,'ONLY')

*
* Positioning volume CATP  into the mother CATB
*
C      N = 1
C      X = -CATH(1)+CATP(1)
C      Y = 0.
C      Z = 0.
C      CALL GSPOS('CATP',N,'CATB',X,Y,Z,0,'ONLY')
C      N = 2
C      X = -X
C      Y = Y
C      Z = 0.
C      CALL GSPOS('CATP',N,'CATB',X,Y,Z,0,'ONLY')
*
* Positioning volume CATO  into the mother CATB
*
C      N = 1
C      X = 0.
C      Y = -CATH(2)+CATO(2)
C      Z = 0.
C      CALL GSPOS('CATO',N,'CATB',X,Y,Z,0,'ONLY')
C      N = 2
C      X = X
C      Y = -Y
C      Z = 0.
C      CALL GSPOS('CATO',N,'CATB',X,Y,Z,0,'ONLY')
*
      RETURN
      END
