*
* $Id: gpcasv.F,v 3.1.1.1 2002/07/11 16:02:14 cafagna Exp $
*
* $Log: gpcasv.F,v $
* Revision 3.1.1.1  2002/07/11 16:02:14  cafagna
* First GPAMELA release on CVS
*
*
*               17/10/2002  11.58.25  by  Jens Lund
*CMZ :  3.00/00 13/11/2000  09.08.20  by  Emiliano Mocchiutti
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.06  by  Francesco Cafagna
*CMZ :  1.02/00 07/03/97  21.47.47  by  Francesco Cafagna
*CMZ :  1.00/02 08/02/96  17.18.05  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   08/02/96
      SUBROUTINE GPCASV
************************************************************************
*                                                                      *
* Volumes definition for the side anticoincidence counters             *
* Called by: GPGEO                                                     *
*                                                                      *
* Author: Francesco Cafagna, 08/02/96 16.58.49                         *
*                                                                      *
************************************************************************
#include "gpgeo.inc"
#include "gpmed.inc"
*
      INTEGER IROT,IVOLU,N,NMED,NUM
      REAL X,Y,Z
*JeL:
      REAL SBOX(3),STRAP(11)
*
C      NMED=MAL
      NMED=MN2
*
*  Define the CAS 'virtual' volume
*
      CALL GSVOLU('CASA','BOX ',NMED,CASA, 3,IVOLU)
C      CALL GSVOLU('CSSY','BOX ',NMED,CSSY, 3,IVOLU)
*
* Side AC scintillator (CAS), 12 pieces of scint., N2 and Aluminum
*			     to define the right shape
*
* Aluminum (cover) box
      NMED=MAL
      SBOX(1) = 0.5*42.9
      SBOX(2) = 0.5*1.2
      SBOX(3) = 0.5*41.1
      CALL GSVOLU('STRP','BOX ',NMED,SBOX,3,IVOLU)
* Scintillator sheet
      NMED=MSCIN
      SBOX(1) = 0.5*40.6
      SBOX(2) = 0.5*0.8
      SBOX(3) = 0.5*38.8
      CALL GSVOLU('SID1','BOX ',NMED,SBOX,3,IVOLU)
* Plastic sheet to create rims
      NMED=MPLAS
      SBOX(1) = 0.5*42.2
      SBOX(2) = 0.5*0.8
      SBOX(3) = 0.5*40.4
      CALL GSVOLU('PLA1','BOX ',NMED,SBOX,3,IVOLU)
* Plastic trapezoid, TRAP 1,2 & 3
      NMED=MPLAS
      STRAP(1) = 0.5*32.2
      STRAP(2) = 7.361412634
      STRAP(3) = 0.
      STRAP(4) = 0.5*0.8
      STRAP(5) = 0.
      STRAP(6) = 0.
      STRAP(7) = 0.
      STRAP(8) = 0.5*0.8
      STRAP(9) = 0.5*8.32
      STRAP(10) = 0.5*8.32
      STRAP(11) = 0.
      CALL GSVOLU('STP1','TRAP',NMED,STRAP,11,IVOLU)
      STRAP(1) = 0.5*4.8
      STRAP(2) = 20.55604522
      STRAP(3) = 0.
      STRAP(4) = 0.5*0.8
      STRAP(5) = 0.
      STRAP(6) = 0.
      STRAP(7) = 0.
      STRAP(8) = 0.5*0.8
      STRAP(9) = 0.5*3.6
      STRAP(10) = 0.5*3.6
      STRAP(11) = 0.
      CALL GSVOLU('STP2','TRAP',NMED,STRAP,11,IVOLU)
      STRAP(1) = 0.5*1.8
      STRAP(2) = 58.17255342
      STRAP(3) = 0.
      STRAP(4) = 0.5*0.8
      STRAP(5) = 0.5*3.6
      STRAP(6) = 0.5*3.6
      STRAP(7) = 0.
      STRAP(8) = 0.5*0.8
      STRAP(9) = 0.5*9.4
      STRAP(10) = 0.5*9.4
      STRAP(11) = 0.
      CALL GSVOLU('STP3','TRAP',NMED,STRAP,11,IVOLU)
* Aluminum trapezoid, TRAP 1,2 & 3
      NMED=MAL
      STRAP(1) = 0.5*33.0
      STRAP(2) = 7.355684758
      STRAP(3) = 0.
      STRAP(4) = 0.5*0.8
      STRAP(5) = 0.
      STRAP(6) = 0.
      STRAP(7) = 0.
      STRAP(8) = 0.5*0.8
      STRAP(9) = 0.5*8.52
      STRAP(10) = 0.5*8.52
      STRAP(11) = 0.
      CALL GSVOLU('STA1','TRAP',NMED,STRAP,11,IVOLU)
      STRAP(1) = 0.5*5.6
      STRAP(2) = 21.44773633
      STRAP(3) = 0.
      STRAP(4) = 0.5*0.8
      STRAP(5) = 0.
      STRAP(6) = 0.
      STRAP(7) = 0.
      STRAP(8) = 0.5*0.8
      STRAP(9) = 0.5*4.4
      STRAP(10) = 0.5*4.4
      STRAP(11) = 0.
      CALL GSVOLU('STA2','TRAP',NMED,STRAP,11,IVOLU)
      STRAP(1) = 0.5*1.8
      STRAP(2) = 58.17255342
      STRAP(3) = 0.
      STRAP(4) = 0.5*0.8
      STRAP(5) = 0.5*4.4
      STRAP(6) = 0.5*4.4
      STRAP(7) = 0.
      STRAP(8) = 0.5*0.8
      STRAP(9) = 0.5*10.2
      STRAP(10) = 0.5*10.2
      STRAP(11) = 0.
      CALL GSVOLU('STA3','TRAP',NMED,STRAP,11,IVOLU)
* 'air' trapezoid, TRAP 1,2 & 3
      NMED=MN2
      STRAP(1) = 0.5*33.35
      STRAP(2) = 7.355377512
      STRAP(3) = 0.
      STRAP(4) = 0.5*1.2
      STRAP(5) = 0.
      STRAP(6) = 0.
      STRAP(7) = 0.
      STRAP(8) = 0.5*1.2
      STRAP(9) = 0.5*8.61
      STRAP(10) = 0.5*8.61
      STRAP(11) = 0.
      CALL GSVOLU('STL1','TRAP',NMED,STRAP,11,IVOLU)
      STRAP(1) = 0.5*5.6
      STRAP(2) = 21.44773633
      STRAP(3) = 0.
      STRAP(4) = 0.5*1.2
      STRAP(5) = 0.
      STRAP(6) = 0.
      STRAP(7) = 0.
      STRAP(8) = 0.5*1.2
      STRAP(9) = 0.5*4.4
      STRAP(10) = 0.5*4.4
      STRAP(11) = 0.
      CALL GSVOLU('STL2','TRAP',NMED,STRAP,11,IVOLU)
      STRAP(1) = 0.5*2.15
      STRAP(2) = 58.18078646
      STRAP(3) = 0.
      STRAP(4) = 0.5*1.2
      STRAP(5) = 0.5*4.3
      STRAP(6) = 0.5*4.3
      STRAP(7) = 0.
      STRAP(8) = 0.5*1.2
      STRAP(9) = 0.5*11.23
      STRAP(10) = 0.5*11.23
      STRAP(11) = 0.
      CALL GSVOLU('STL3','TRAP',NMED,STRAP,11,IVOLU)
*EM:
* Define the CAS scintillator volume
*
C      NMED=MSCIN
C      CALL GSVOLU('CASX','BOX ',NMED,CASX,3,IVOLU)
C      CALL GSVOLU('CASY','BOX ',NMED,CASY,3,IVOLU)
*
* Positioning Scintillators in cradles
*
      N = 1
      X = 0.
      Y = 0.
      Z = 0.
C      CALL GSPOS('CASX',N,'CSSX',X,Y,Z,0,'ONLY')
C      CALL GSPOS('CASY',N,'CSSY',X,Y,Z,0,'ONLY')
*END: EM.
*
*
* Position Al. box (STRP) in the CAS virt. box (CASA)
      CALL GSPOS('STRP',N,'CASA',X,Y,Z,0,'ONLY')
*
* Position the plastic sheet (PLA1) in STRP
      CALL GSPOS('PLA1',N,'STRP',X,Y,Z,0,'ONLY')
*
* Position the scintillator (SID1) in PLA1
      CALL GSPOS('SID1',N,'PLA1',X,Y,Z,0,'ONLY')

*
* Position Pl. TRAP (STP1) in SID1 and rotate
      X = 18.22
      Y = 0.
      Z = -3.3
      CALL GSPOS('STP1',N,'SID1',X,Y,Z,5,'ONLY')
*
* Position Pl. TRAP (STP2) in SID1 and rotate
      X = 19.4
      Y = 0.
      Z = 15.2
      CALL GSPOS('STP2',N,'SID1',X,Y,Z,4,'ONLY')
*
* Position Pl. TRAP (STP3) in SID1 and rotate
      X = 17.05
      Y = 0.
      Z = 18.5
      CALL GSPOS('STP3',N,'SID1',X,Y,Z,4,'ONLY')

*
* Position Al. TRAP (STA1) in PLA1 and rotate
      X = 18.97
      Y = 0.
      Z = -3.7
      CALL GSPOS('STA1',N,'PLA1',X,Y,Z,5,'ONLY')
*
* Position Al. TRAP (STA2) in PLA1 and rotate
      X = 20.
      Y = 0.
      Z = 15.6
      CALL GSPOS('STA2',N,'PLA1',X,Y,Z,4,'ONLY')
*
* Position Al. TRAP (STA3) in PLA1 and rotate
      X = 17.45
      Y = 0.
      Z = 19.3
      CALL GSPOS('STA3',N,'PLA1',X,Y,Z,4,'ONLY')
*
* Position 'air' TRAP (STL1) in STRP and rotate
      X = 19.2975
      Y = 0.
      Z = -3.875
      CALL GSPOS('STL1',N,'STRP',X,Y,Z,5,'ONLY')
*
* Position 'air' TRAP (STL2) in STRP and rotate
      X = 20.35
      Y = 0.
      Z = 15.6
      CALL GSPOS('STL2',N,'STRP',X,Y,Z,4,'ONLY')
*
* Position 'air' TRAP (STL3) in STRP and rotate
      X = 17.5675
      Y = 0.
      Z = 19.475
      CALL GSPOS('STL3',N,'STRP',X,Y,Z,4,'ONLY')
*END: JeL.
C*
C      NMED=MAL
C*
C*  Define the CAS cradle volume
C*
C      CALL GSVOLU('CSSX','BOX ',NMED,CSSX, 3,IVOLU)
C      CALL GSVOLU('CSSY','BOX ',NMED,CSSY, 3,IVOLU)
C*EM:
C* Define the CAS scintillator volume
C*
C      NMED=MSCIN
C      CALL GSVOLU('CASX','BOX ',NMED,CASX,3,IVOLU)
C      CALL GSVOLU('CASY','BOX ',NMED,CASY,3,IVOLU)
C*
C* Positioning Scintillators in cradles
C*
C      N = 1
C      X = 0.
C      Y = 0.
C      Z = 0.
C      CALL GSPOS('CASX',N,'CSSX',X,Y,Z,0,'ONLY')
C      CALL GSPOS('CASY',N,'CSSY',X,Y,Z,0,'ONLY')
C*END: EM.
C*
      RETURN
      END
