      SUBROUTINE GPCARDV
************************************************************************
*                                                                      *
* Volumes definition for the side anticoincidence counters             *
* Called by: GPGEO                                                     *
*                                                                      *
* Author: Francesco Cafagna, 08/02/96 16.58.49                         *
*                                                                      *
************************************************************************
#include "gconst.inc"
#include "gpgeo.inc"
#include "gpmed.inc"
#include "gprot.inc"
      INTEGER IROT,IVOLU,N,NMED,NUM
      REAL X,Y,Z
      REAL CAR1(11),CR1P(11)
      REAL C1D1(11),C1N1(11),C1N2(11)
      REAL CAR2(11),CR2P(11)
      REAL C2D1(11),C2N1(11),C2N2(11)
      REAL CAR1H,CAR1D,CAR1U,CAR1T
      REAL CAR2H,CAR2D,CAR2U,CAR2T
      REAL BETA, ALPHA, ANGLCAR1, ANGLCAR2
*
* CAR1 Al box sheet
*
      NMED=MAL
      CAR1CF=3.012
      CAR1ANGL=16.83
      CAR1H=6.7*CAR1CF
      CAR1D=12*CAR1CF
      CAR1U=11.3*CAR1CF
      CAR1T=1.2
      CAR1(1) = 0.5*CAR1H
      CAR1(2) = CAR1ANGL
      CAR1(3) = 0.
      CAR1(4) = 0.5*CAR1T
      CAR1(5) = 0.5*CAR1D
      CAR1(6) = CAR1(5)
      CAR1(7) = 0.
      CAR1(8) = 0.5*CAR1T
      CAR1(9) = 0.5*CAR1U
      CAR1(10) = CAR1(9)
      CAR1(11) = 0.
      CALL GSVOLU('CAR1','TRAP',NMED,CAR1,11,IVOLU)
*
* CR1P PLASTIC BOX TO CREATE RIM 
*
      NMED=MPLAS
      CR1P(1) = 0.5*(CAR1H-.7)
      CR1P(2) = CAR1ANGL
      CR1P(3) = 0.
      CR1P(4) = 0.5*(CAR1T-.4)
      CR1P(5) = 0.5*(CAR1D-0.7)
      CR1P(6) = CR1P(5)
      CR1P(7) = 0.
      CR1P(8) = 0.5*(CAR1T-.4)
      CR1P(9) = 0.5*(CAR1U-.7)
      CR1P(10) = CR1P(9)
      CR1P(11) = 0.
      CALL GSVOLU('CR1P','TRAP',NMED,CR1P,11,IVOLU)
*
* Scint sheet
*
      NMED=MSCIN
      C1D1(1) = 0.5*(CAR1H-1.3)
      C1D1(2) = CAR1ANGL
      C1D1(3) = 0.
      C1D1(4) = 0.5*(CAR1T-.4)
      C1D1(5) = 0.5*(CAR1D-1.3)
      C1D1(6) = C1D1(5)
      C1D1(7) = 0.
      C1D1(8) = 0.5*(CAR1T-.4)
      C1D1(9) = 0.5*(CAR1U-1.3)
      C1D1(10) = C1D1(9)
      C1D1(11) = 0.
      CALL GSVOLU('C1D1','TRAP',NMED,C1D1,11,IVOLU)
*
* Empty volume to be subtracted from C1D1 sheet
*
      NMED=MN2
      BETA=ATAN(
     +     2.*C1D1(1)/
     +     (C1D1(9)-C1D1(5)+2.*C1D1(1)*TAN(C1D1(2)*3.14/180.)) )
      A=3.*3.02
      B=3.*3.02
      C1N1(1) = 0.5*A*SIN(BETA)
      C1N1(9) = 0.5*B
      C1N1(2) = -RADDEG*ATAN( 
     +     (C1N1(9)-2.*C1N1(1)/TAN(BETA))*1./(2.*C1N1(1)) )
      C1N1(3) = 0.
      C1N1(4) = 0.5*(CAR1T)
      C1N1(5) = 0.
      C1N1(6) = C1N1(5)
      C1N1(7) = 0.
      C1N1(8) = 0.5*(CAR1T)
      C1N1(10) = C1N1(9)
      C1N1(11) = 0.
      CALL GSVOLU('C1N1','TRAP',NMED,C1N1,11,IVOLU)
      ALPHA=ATAN( 
     +     ABS(A*SIN(BETA)/(B - A*COS(BETA))) )
      BETA=3.14-ALPHA

      A=.6*3.02
      B=1.1*3.02
      C1N2(1) = ABS(0.5*A*SIN(BETA))
      C1N2(9) = 0.5*B
      C1N2(2) = -(90. - RADDEG*
     +     ATAN( 2.*C1N2(1) /( C1N2(9) + (2.*C1N2(1)/ABS(TAN(BETA)))) )) 
      C1N2(3) = 0.
      C1N2(4) = 0.5*CAR1T
      C1N2(5) = 0.
      C1N2(6) = C1N2(5)
      C1N2(7) = 0.
      C1N2(8) = 0.5*CAR1T
      C1N2(10) = C1N2(9)
      C1N2(11) = 0.
      CALL GSVOLU('C1N2','TRAP',NMED,C1N2,11,IVOLU)
*
* CAR2 Al box sheet
*
      NMED=MAL
      CAR2CF=3.012
      CAR2ANGL=16.24
      CAR2H=6.7*CAR2CF
      CAR2D=10.35*CAR2CF
      CAR2U=10.2*CAR2CF
      CAR2T=1.2
      CAR2(1) = 0.5*CAR2H
      CAR2(2) = CAR2ANGL
      CAR2(3) = 0.
      CAR2(4) = 0.5*CAR2T
      CAR2(5) = 0.5*CAR2D
      CAR2(6) = CAR2(5)
      CAR2(7) = 0.
      CAR2(8) = 0.5*CAR2T
      CAR2(9) = 0.5*CAR2U
      CAR2(10) = CAR2(9)
      CAR2(11) = 0.
      CALL GSVOLU('CAR2','TRAP',NMED,CAR2,11,IVOLU)
*
* CR1P PLASTIC BOX TO CREATE RIM 
*
      NMED=MPLAS
      CR2P(1) = 0.5*(CAR2H-.7)
      CR2P(2) = CAR2ANGL
      CR2P(3) = 0.
      CR2P(4) = 0.5*(CAR2T-.4)
      CR2P(5) = 0.5*(CAR2D-0.7)
      CR2P(6) = CR2P(5)
      CR2P(7) = 0.
      CR2P(8) = 0.5*(CAR2T-.4)
      CR2P(9) = 0.5*(CAR2U-.7)
      CR2P(10) = CR2P(9)
      CR2P(11) = 0.
      CALL GSVOLU('CR2P','TRAP',NMED,CR2P,11,IVOLU)
*
* Scint sheet
*
      NMED=MSCIN
      C2D1(1) = 0.5*(CAR2H-1.3)
      C2D1(2) = CAR2ANGL
      C2D1(3) = 0.
      C2D1(4) = 0.5*(CAR2T-.4)
      C2D1(5) = 0.5*(CAR2D-1.3)
      C2D1(6) = C2D1(5)
      C2D1(7) = 0.
      C2D1(8) = 0.5*(CAR2T-.4)
      C2D1(9) = 0.5*(CAR2U-1.3)
      C2D1(10) = C2D1(9)
      C2D1(11) = 0.
      CALL GSVOLU('C2D1','TRAP',NMED,C2D1,11,IVOLU)
*
* Empty volume to be subtracted from C2D1 sheet
*
      NMED=MN2
      BETA=ATAN(
     +     2.*C2D1(1)/
     +     (C2D1(9)-C2D1(5)+2.*C2D1(1)*TAN(C2D1(2)*3.14/180.)) )
      A=3.*3.02
      B=3.*3.02
      C2N1(1) = 0.5*A*SIN(BETA)
      C2N1(9) = 0.5*B
      C2N1(2) = -RADDEG*ATAN( 
     +     (C2N1(9)-2.*C2N1(1)/TAN(BETA))*1./(2.*C2N1(1)) )
      C2N1(3) = 0.
      C2N1(4) = 0.5*(CAR2T)
      C2N1(5) = 0.
      C2N1(6) = C2N1(5)
      C2N1(7) = 0.
      C2N1(8) = 0.5*(CAR2T)
      C2N1(10) = C2N1(9)
      C2N1(11) = 0.
      CALL GSVOLU('C2N1','TRAP',NMED,C2N1,11,IVOLU)
      ALPHA=ATAN( 
     +     ABS(A*SIN(BETA)/(B - A*COS(BETA))) )
      BETA=3.14-ALPHA

      A=.6*3.02
      B=1.1*3.02
      C2N2(1) = ABS(0.5*A*SIN(BETA))
      C2N2(9) = 0.5*B
      C2N2(2) = -(90. - RADDEG*
     +     ATAN( 2.*C2N2(1) /( C2N2(9) + (2.*C2N2(1)/ABS(TAN(BETA)))) )) 
      C2N2(3) = 0.
      C2N2(4) = 0.5*CAR2T
      C2N2(5) = 0.
      C2N2(6) = C2N2(5)
      C2N2(7) = 0.
      C2N2(8) = 0.5*CAR2T
      C2N2(10) = C2N2(9)
      C2N2(11) = 0.
      CALL GSVOLU('C2N2','TRAP',NMED,C2N2,11,IVOLU)
*
      NMED=MN2
      CARDB(1)=1.5*CAR2(9)
      CARDB(2)=1.5*CAR1(9)
      CARDB(3)=CAR1(1)
      CALL GSVOLU('CARD','BOX ',NMED,CARDB, 3,IVOLU)
*
* The zenihtal angle of the paddles
*
      ANGLCAR2=ASIN( 0.5*(CAR1D-(CAR1U-2.*(C1N2(9)+C1N1(9)))) / CAR1H )
      ANGLCAR1=ASIN( 0.5*(CAR2D-(CAR2U-2.*(C2N2(9)+C2N1(9)))) / CAR2H )
*
*  Define ANGLCAR rotation around Z axis
*
      IRZCAR2=11
      CALL GSROTM(IRZCAR2,90.,0.,(90.-ANGLCAR2*RADDEG),
     +     90.,(180.-ANGLCAR2*RADDEG),90.)
      IRZCAR22=12
      CALL GSROTM(IRZCAR22,90.,180.,(270.-ANGLCAR2*RADDEG),
     +     270.,(180.-ANGLCAR2*RADDEG),270.)
      IRZCAR1=13
      CALL GSROTM(IRZCAR1,90.,270.,(90.-ANGLCAR1*RADDEG),
     +     0.,(180.-ANGLCAR1*RADDEG),0.)
      IRZCAR12=14
      CALL GSROTM(IRZCAR12,90.,90.,(90.-ANGLCAR1*RADDEG),
     +     180.,(180.-ANGLCAR1*RADDEG),180.)
*
* Positioning in CAR1
*
      N=1
      X=0
      Y=0
      Z=0
      CALL GSPOS('CR1P',N,'CAR1',X,Y,Z,0,'MANY')
      N=1
      X=( CAR1(9)+CAR1(1)*TAN(CAR1(2)*DEGRAD) ) - 
     +     (C1N1(9)+C1N1(1)*TAN(C1N1(2)*DEGRAD))
      Y=0
      Z=CAR1(1)-C1N1(1)
      CALL GSPOS('C1N1',N,'CAR1',X,Y,Z,0,'ONLY')
      N=1
      X=( CAR1(9)+CAR1(1)*TAN(CAR1(2)*DEGRAD) ) - 2.*C1N1(9) -
     +     (C1N2(9)+C1N2(1)*TAN(C1N2(2)*DEGRAD))
      Y=0
      Z=CAR1(1)-C1N2(1)
      CALL GSPOS('C1N2',N,'CAR1',X,Y,Z,0,'ONLY')
      N=1
      X=0
      Y=0
      Z=0
      CALL GSPOS('C1D1',N,'CR1P',X,Y,Z,0,'ONLY')
*
* Positioning in CAR2
*
      N=1
      X=0
      Y=0
      Z=0
      CALL GSPOS('CR2P',N,'CAR2',X,Y,Z,0,'MANY')
      N=1
      X=( CAR2(9)+CAR2(1)*TAN(CAR2(2)*DEGRAD) ) - 
     +     (C2N1(9)+C2N1(1)*TAN(C2N1(2)*DEGRAD))
      Y=0
      Z=CAR2(1)-C2N1(1)
      CALL GSPOS('C2N1',N,'CAR2',X,Y,Z,0,'ONLY')
      N=1
      X=( CAR2(9)+CAR2(1)*TAN(CAR2(2)*DEGRAD) ) - 2.*C2N1(9) -
     +     (C2N2(9)+C2N2(1)*TAN(C2N2(2)*DEGRAD))
      Y=0
      Z=CAR2(1)-C2N2(1)
      CALL GSPOS('C2N2',N,'CAR2',X,Y,Z,0,'ONLY')
      N=1
      X=0
      Y=0
      Z=0
      CALL GSPOS('C2D1',N,'CR2P',X,Y,Z,0,'ONLY')
*
* Positioning in card
*

      N=1
      X=-(C2N1(9) + C2N2(9)) + CAR2(1)*ABS(TAN(CAR2(2)*DEGRAD)) 
      Y=(CAR1(9) - (C1N1(9)+C1N2(9))) 
     +     + CAR2(1)*ABS(COS(ANGLCAR2*RADDEG)) - 2.*CAR2(4)
      Z=0
      CALL GSPOS('CAR2',N,'CARD',X,Y,Z,IRZCAR22,'ONLY')
      N=2
      X=-X + 2.*CAR1(4)
      Y=-Y + 2.*CAR1(4)
      CALL GSPOS('CAR2',N,'CARD',X,Y,Z,IRZCAR2 ,'ONLY')

      N=1
      Y=(C1N1(9) + C1N2(9)) - CAR1(1)*ABS(TAN(CAR1(2)*DEGRAD))
     +     + 2.* CAR2(4)
      X=(CAR2(9) - (C2N1(9)+C2N2(9))) 
     +     + CAR1(1)*ABS(SIN(ANGLCAR1*RADDEG)) + 2.*CAR1(4)
      Z=0
      CALL GSPOS('CAR1',N,'CARD',X,Y,Z,IRZCAR12,'ONLY')
      N=2
      Y=-Y + 2.* CAR2(4)
      X=-X + 2.* CAR2(4)
      CALL GSPOS('CAR1',N,'CARD',X,Y,Z,IRZCAR1,'ONLY')

      RETURN
      END
