      SUBROUTINE GPDCARD
************************************************************************
*                                                                      *
* To perform CARD digitization                                          *
*                                                                      *
* Called by: GUDIGI                                                    *
* Author: Francesco Cafagna, 23/02/96 12.50.38                         *
*                                                                      *
************************************************************************
#include "gcunit.inc"
#include "gpphit.inc"
      PARAMETER (NH=NHCARD,NHM=NHMCARD,NVOL=2)
#include "gprhit.inc"
#include "gpcard.inc"
#include "gpsed.inc"
*
      INTEGER IS,ID,NV,NVM
      CHARACTER*4 CSET
*
*
* Vector zeroed
*
      CALL VZERO(ICARD,NHM)
      CALL VZERO(XCARD,NHM)
      CALL VZERO(YCARD,NHM)
      CALL VZERO(ZCARD,NHM)
      CALL VZERO(XOCARD,NHM)
      CALL VZERO(YOCARD,NHM)
      CALL VZERO(ZOCARD,NHM)
      CALL VZERO(ERCARD,NHM)
      CALL VZERO(TIMECARD,NHM)
      CALL VZERO(PATHCARD,NHM)
      CALL VZERO(P0CARD,NHM)
      CALL VZERO(ICARDPAR,NHM)
      CALL VZERO(NUMD ,NVOL)
*
      NV = NVOL
      NVM= NVMAX
      IS   = ISCARD
      CSET = 'CARD'
      IT = -1
      NTHCARD = 0
      DO ID=IDCAR1,IDCAR2
*
* Check on the volume level
*
         IF (NV.GT.NVM) THEN
            WRITE(CHMAIL,10000) CSET,CNSED(IS,ID),NVOL,NVMAX,
     +           IDRUN,IDEVT
            CALL GMAIL(1,0)
            GO TO 10
         ENDIF
         CALL VZERO(VHITS,NH*NHM)
         CALL VZERO(ITRA ,NHM)
         CALL VZERO(NUMBV,NVOL*NHM)
         NHITS = -1
         CALL GPRHIT(CSET,CNSED(IS,ID),IS,ID,NVOL,NH,NHM,1,
     +        IT,NUMD,ITRA,NUMBV,VHITS,NHITS)
*
*     If there was a problem in GPRHIT then exit
*     
         IF(NHITS.LT.0) THEN
            WRITE(CHMAIL,10100) CSET,CNSED(IS,ID),NHITS,NHM,
     +           IDRUN,IDEVT
            CALL GMAIL(1,0)
            GO TO 10
         ENDIF
*     
*     >>>>>>>>>>>>>>>>>>>>>> DIGI action
*     
*     
*     Fill the CWN common
*     
         NTHCARD = NTHCARD + NHITS
         DO I=1,NHITS
            ICARD(I)  = NUMBV(1,I) + 2*(ID-1)
#if defined(GPAMELA_INTER)
            XINCARD(I)  = 2*VHITS(1,I)-VHITS(4,I)
            YINCARD(I)  = 2*VHITS(2,I)-VHITS(5,I)
            ZINCARD(I)  = 2*VHITS(3,I)-VHITS(6,I)
#endif
#if !defined(GPAMELA_INTER)
            XINCARD(I)  = VHITS(1,I)
            YINCARD(I)  = VHITS(2,I)
            ZINCARD(I)  = VHITS(3,I)
#endif
            XOUTCARD(I) = VHITS(4,I)
            YOUTCARD(I) = VHITS(5,I)
            ZOUTCARD(I) = VHITS(6,I)
            ERELCARD(I) = VHITS(7,I)
            TIMECARD(I)=  VHITS(8,I)
            PATHCARD(I) = VHITS(9,I)
            IPARCARD(I) = VHITS(10,I)
            P0CARD(I) = VHITS(11,I)
         ENDDO
      ENDDO
10000 FORMAT(' GPDCARD: VOLUME level too big: SET=',A4,', DET=',A4,',
     +     NVOL=',I3,', NVMAX=',I3,', RUN=',I5,', EVT=',I8)
10100 FORMAT(' GPDCARD: Error in GPRHIT: SET=',A4,
     +     ', DET=',A4,',NHITS=',I5,', NHMAX=',I5,
     +     ', RUN=',I5,', EVT=',I8)
10200 FORMAT(' GPDCARD: Error in GPRHIT: SET=',A4,
     +     ', DET=',A4,',NHITS=',I5,', NHMAX=',I5,
     +     ', RUN=',I5,', EVT=',I8)
 10   RETURN
      END
      
