      SUBROUTINE GPUCARD(IACT,IS,ID,IPA,IT,DELOSS,TIME,PATH,
     +                  TRAPAR,NUMVOL,IMEC)
************************************************************************
*                                                                      *
* To collect and store the hit structure for CARD                       *
*                                                                      *
* Variables definition:                                                *
* IN:                                                                  *
*  IACT, integer specifing the action to be taken. It is the INWVOL    *
*        variable in GCTRAK common                                     *
*  IS    , set number                                                  *
*  ID    , detector number                                             *
*  IPA   , particle number                                             *
*  IT    , track number                                                *
*  DELOSS, energy loss in the step                                     *
*  TIME  , current time of flight                                      *
*  PATH  , current track lenght                                        *
*  TRAPAR, track parameter, is the VECT vector in GCTRAK common        *
*  NUMVOL, integr array of numbers identifying the DETECTOR            *
*  IMEC  , integer indicating the LOSS mecanism position inside NMEC   *
*          vector, zero if not present                                 *
*                                                                      *
*                                                                      *
* Called by: GUSTEP                                                    *
* Author: Francesco Cafagna, 21/02/96 16.13.51                         *
*                                                                      *
************************************************************************
#include "gphit.inc"
#include "gcunit.inc"
*
      INTEGER IACT,IS,ID,IPA,IT,NUMVOL(20),IMEC,IDHIT
      REAL DELOSS,TIME,PATH,TRAPAR(7),VHIT(NHCARD)
      LOGICAL SAVE
*
* Track is inside a volume
*
      IF(IACT.EQ.0) THEN
         IF(IMEC.GT.0) THEN
            SAVE = .TRUE.
            VHIT(7) = DELOSS + VHIT(7)
         ENDIF
      ENDIF
*
* Entering a new volume or is a new track
*
      IF(IACT.EQ.1) THEN
         SAVE = .FALSE.
         CALL VZERO(VHIT,NHCARD)
         DO I=1,3
            VHIT(I) = TRAPAR(I)
         ENDDO
         IF(IMEC.GT.0) THEN
            SAVE = .TRUE.
            VHIT(7) = DELOSS
         ENDIF
         VHIT(8) = TIME
         VHIT(9) = PATH
         VHIT(10)= IPA
         VHIT(11)= TRAPAR(7)
         IDHIT = -1
      ENDIF
*
* Track is exiting current volume
*
      IF(IACT.EQ.2) THEN
         DO I=1,3
            VHIT(I+3) = TRAPAR(I)
#if defined(GPAMELA_INTER)
* interactive case, we need the average position
            VHIT(I) = (VHIT(I) + VHIT(I+3) )/2.
#endif
         ENDDO
         IF(IMEC.GT.0) THEN
            SAVE = .TRUE.
            VHIT(7) = DELOSS + VHIT(7)
         ENDIF
         VHIT(8) = (TIME + VHIT(8))/2.
         VHIT(9) = PATH - VHIT(9)
         VHIT(11)= (TRAPAR(7) + VHIT(11))/2.
*
* Store the hit
*
         IF(IDHIT.EQ.-1) THEN
            IF(SAVE) CALL GSAHIT (IS,ID,IT,NUMVOL,VHIT,IDHIT)
            IF (IDHIT.EQ.0) THEN
               WRITE(CHMAIL,10000) IS,ID,IT
               CALL GMAIL(1,0)
            ENDIF
         ELSE
            WRITE(CHMAIL,10100) IS,ID,IT
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
*
* Track is exiting the set up
*
      IF(IACT.EQ.3) THEN
*
* Check if the hit have been previously stored or not
*
         IF(IDHIT.LT.0) THEN
            DO I=1,3
               VHIT(I+3) = TRAPAR(I)
#if defined(GPAMELA_INTER)
* interactive case, we need the average position
               VHIT(I) = (VHIT(I) + VHIT(I+3) )/2.
#endif
            ENDDO
            IF(IMEC.GT.0) THEN
               SAVE = .TRUE.
               VHIT(7) = DELOSS + VHIT(7)
            ENDIF
            VHIT(8) = (TIME + VHIT(8))/2.
            VHIT(9) = PATH - VHIT(9)
            VHIT(11)= (TRAPAR(7) + VHIT(11))/2.
*
* Store the hit
*
            IF(IDHIT.EQ.-1) THEN
               IF(SAVE) CALL GSAHIT (IS,ID,IT,NUMVOL,VHIT,IDHIT)
               IF (IDHIT.EQ.0) THEN
                  WRITE(CHMAIL,10200) IS,ID,IT
                  CALL GMAIL(1,0)
               ENDIF
            ELSE
               WRITE(CHMAIL,10300) IS,ID,IT
               CALL GMAIL(1,0)
            ENDIF
         ENDIF
      ENDIF
10000 FORMAT(' GPUCARD error: HIT have not be stored for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
10100 FORMAT(' GPUCARD error: HIT have not be initialized for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
10200 FORMAT(' GPUCARD error: HIT have not be stored for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
10300 FORMAT(' GPUCARD error: HIT have not be initialized for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
      RETURN
      END
