      SUBROUTINE GPCARDV
************************************************************************
*                                                                      *
* Volumes definition for the side anticoincidence counters             *
* Called by: GPGEO                                                     *
*                                                                      *
* Authors: Francesco Cafagna, 08/02/96 16.58.49                        *
*          Alessandro Bruno, 20/11/06 20.30.00                         *
*                                                                      *
************************************************************************
#include "gconst.inc"
#include "gpgeo.inc"
#include "gpmed.inc"
#include "gprot.inc"
      INTEGER IROT,IVOLU,N,NMED,NUM,I
      REAL X,Y,Z
      REAL ANGLCAR1,ANGLCAR2
      REAL H1,H2
      REAL A1,B1,C1,D1,F1,ANG1C
      REAL A2,B2,C2,D2,F2,ANG2C
      REAL AA,BB,DD,ZH
*
      H1=CAR(2)+CAR(3)
      H2=CAR(1)-H1
*
* Greater Scintillator CAR1 (or type B)
*
      B1=CARB(2)+CAR(4)+CAR(5)+H1/TAN(DEGRAD*CAR(7))
      C1=H2/TAN(DEGRAD*CAR(7))
      A1=CARB(1)-C1
      D1=CARB(1)-CARB(2)-CAR(4)-CAR(5)
      F1=C1+H1/TAN(DEGRAD*CAR(7))
      ANG1C=ATAN((B1/2.+D1-A1/2.)/CAR(1))

      C1D1(1) = CAR(1)/2.
      C1D1(2) = -ANG1C*RADDEG
      C1D1(3) = 0.
      C1D1(4) = CAR(6)
      C1D1(5) = A1/2.
      C1D1(6) = A1/2.
      C1D1(7) = 0.
      C1D1(8) = CAR(6)
      C1D1(9) = B1/2.
      C1D1(10) = B1/2.
      C1D1(11) = 0.

      NMED=MSCIN
      CALL GSVOLU('C1D1','TRAP',NMED,C1D1,11,IVOLU)
*
* Smaller Scintillator CAR2 (or type A)
*
      B2=CARA(2)+CAR(4)+CAR(5)+H1/TAN(DEGRAD*CAR(7))
      C2=H2/TAN(DEGRAD*CAR(7))
      A2=CARA(1)-C2
      D2=CARA(1)-CARA(2)-CAR(4)-CAR(5)
      F2=C2+H1/TAN(DEGRAD*CAR(7))
      ANG2C=ATAN((B2/2.+D2-A2/2.)/CAR(1))

      C2D1(1) = CAR(1)/2.
      C2D1(2) = -ANG2C*RADDEG
      C2D1(3) = 0.
      C2D1(4) = CAR(6)
      C2D1(5) = A2/2.
      C2D1(6) = A2/2.
      C2D1(7) = 0.
      C2D1(8) = CAR(6)
      C2D1(9) = B2/2.
      C2D1(10) = B2/2.
      C2D1(11) = 0.

      NMED=MSCIN
      CALL GSVOLU('C2D1','TRAP',NMED,C2D1,11,IVOLU)
*
* CAR1 Al box sheet
*
      BB=C1D1(9)+ATZ*(1./COS(ATAN(D1/CAR(1)))-
     +               D1/CAR(1)+1./TAN(DEGRAD*CAR(7))+
     +                       1./SIN(DEGRAD*CAR(7)))/2.
      AA=C1D1(5)+ATZ*(1./COS(ATAN(D1/CAR(1)))+
     +               D1/CAR(1)-1./TAN(DEGRAD*CAR(7))+
     +                       1./SIN(DEGRAD*CAR(7)))/2.
      CAR1(1) = C1D1(1)+ATZ
      DD=2.*CAR1(1)*D1/CAR(1)
      CAR1(2) = -RADDEG*ATAN((BB+DD-AA)/(2.*CAR1(1)))
      CAR1(3) = 0.
      CAR1(4) = C1D1(4)+ATY
      CAR1(5) = AA
      CAR1(6) = CAR1(5)
      CAR1(7) = 0.
      CAR1(8) = C1D1(8)+ATY
      CAR1(9) = BB
      CAR1(10) = CAR1(9)
      CAR1(11) = 0.

      NMED=MAL
      CALL GSVOLU('CAR1','TRAP',NMED,CAR1,11,IVOLU)
*
* CR1P PLASTIC BOX TO CREATE RIM
*
      BB=C1D1(9)+PT*(1./COS(ATAN(D1/CAR(1)))-
     +              D1/CAR(1)+1./TAN(DEGRAD*CAR(7))+
     +                       1./SIN(DEGRAD*CAR(7)))/2.
      AA=C1D1(5)+PT*(1./COS(ATAN(D1/CAR(1)))+
     +              D1/CAR(1)-1./TAN(DEGRAD*CAR(7))+
     +                       1./SIN(DEGRAD*CAR(7)))/2.
      CR1P(1) = C1D1(1)+PT
      DD=2.*CR1P(1)*D1/CAR(1)
      CR1P(2) =-RADDEG*ATAN((BB+DD-AA)/(2.*CR1P(1)))
      CR1P(3) = 0.
      CR1P(4) = C1D1(4)
      CR1P(5) = AA
      CR1P(6) = CR1P(5)
      CR1P(7) = 0.
      CR1P(8) = C1D1(8)
      CR1P(9) = BB
      CR1P(10) = CR1P(9)
      CR1P(11) = 0.

      NMED=MPLAS
      CALL GSVOLU('CR1P','TRAP',NMED,CR1P,11,IVOLU)
*
* CAR2 Al box sheet
*
      BB=C2D1(9)+ATZ*(1./COS(ATAN(D2/CAR(1)))-
     +               D2/CAR(1)+1./TAN(DEGRAD*CAR(7))+
     +                       1./SIN(DEGRAD*CAR(7)))/2.
      AA=C2D1(5)+ATZ*(1./COS(ATAN(D2/CAR(1)))+
     +               D2/CAR(1)-1./TAN(DEGRAD*CAR(7))+
     +                       1./SIN(DEGRAD*CAR(7)))/2.
      CAR2(1) = C1D1(1)+ATZ
      DD=2.*CAR2(1)*D2/CAR(1)
      CAR2(2) = -RADDEG*ATAN((BB+DD-AA)/(2.*CAR2(1)))
      CAR2(3) = 0.
      CAR2(4) = C2D1(4)+ATY
      CAR2(5) = AA
      CAR2(6) = CAR2(5)
      CAR2(7) = 0.
      CAR2(8) = C2D1(8)+ATY
      CAR2(9) = BB
      CAR2(10) = CAR2(9)
      CAR2(11) = 0.

      NMED=MAL
      CALL GSVOLU('CAR2','TRAP',NMED,CAR2,11,IVOLU)
*
* CR1P PLASTIC BOX TO CREATE RIM
*
      BB=C2D1(9)+PT*(1./COS(ATAN(D2/CAR(1)))-
     +              D2/CAR(1)+1./TAN(DEGRAD*CAR(7))+
     +                       1./SIN(DEGRAD*CAR(7)))/2.
      AA=C2D1(5)+PT*(1./COS(ATAN(D2/CAR(1)))+
     +              D2/CAR(1)-1./TAN(DEGRAD*CAR(7))+
     +                       1./SIN(DEGRAD*CAR(7)))/2.
      CR2P(1) = C2D1(1)+PT
      DD=2.*CR2P(1)*D2/CAR(1)
      CR2P(2) =-RADDEG*ATAN((BB+DD-AA)/(2.*CR2P(1)))
      CR2P(3) = 0.
      CR2P(4) = C2D1(4)
      CR2P(5) = AA
      CR2P(6) = CR2P(5)
      CR2P(7) = 0.
      CR2P(8) = C2D1(8)
      CR2P(9) = BB
      CR2P(10) = CR2P(9)
      CR2P(11) = 0.

      NMED=MPLAS
      CALL GSVOLU('CR2P','TRAP',NMED,CR2P,11,IVOLU)
*
*  Volumes to be subtracted from C1D1 and C2D1
*
      AA=CAR(2)+CAR(3)
      BB=AA/TAN(DEGRAD*CAR(7))+AA*CAR(4)/CAR(2)

      VSN1(1) = 0.5*AA
      VSN1(2) = RADDEG*ATAN((BB/2.-AA/TAN(DEGRAD*CAR(7)))/AA)
      VSN1(3) = 0.
      VSN1(4) = C1D1(4)
      VSN1(5) = 0.
      VSN1(6) = VSN1(5)
      VSN1(7) = 0.
      VSN1(8) = C1D1(8)
      VSN1(9) = 0.5*BB
      VSN1(10) = VSN1(9)
      VSN1(11) = 0.

      AA=CAR(3)
      BB=AA*(CAR(5)/CAR(3)-CAR(4)/CAR(2))

      VSN2(1) = 0.5*AA
      VSN2(2) = RADDEG*ATAN((BB/2.+(AA)*CAR(4)/CAR(2))/AA)
      VSN2(3) = 0.
      VSN2(4) = C1D1(4)
      VSN2(5) = 0.
      VSN2(6) = VSN2(5)
      VSN2(7) = 0.
      VSN2(8) = C1D1(8)
      VSN2(9) = 0.5*BB
      VSN2(10) = VSN2(9)
      VSN2(11) = 0.

      NMED=MN2
      CALL GSVOLU('VSN1','TRAP',NMED,VSN1,11,IVOLU)
      NMED=MPLAS
      CALL GSVOLU('VSN2','TRAP',NMED,VSN2,11,IVOLU)
*
*  Volumes to be subtracted from CR1P and CR2P
*
      AA=(PT/SIN(DEGRAD*CAR(7)))/(1./TAN(DEGRAD*CAR(7))+
     +    CAR(4)/CAR(2))+CAR(2)+CAR(3)+PT
      BB=AA/TAN(DEGRAD*CAR(7))+AA*CAR(4)/CAR(2)

      VPN1(1) = 0.5*AA
      VPN1(2) = VSN1(2)
      VPN1(3) = 0.
      VPN1(4) = CR1P(4)
      VPN1(5) = 0.
      VPN1(6) = VPN1(5)
      VPN1(7) = 0.
      VPN1(8) = CR1P(8)
      VPN1(9) = 0.5*BB
      VPN1(10) = VPN1(9)
      VPN1(11) = 0.

      AA=CAR(3) + PT -
     +    COS(ATAN(CAR(4)/CAR(2)))*PT/SIN(ATAN(CAR(5)/CAR(3))-
     +    ATAN(CAR(4)/CAR(2)))
      BB=AA*(CAR(5)/CAR(3)-CAR(4)/CAR(2))

      VPN2(1) = 0.5*AA
      VPN2(2) = RADDEG*ATAN((BB/2.+AA*CAR(4)/CAR(2))/AA)
      VPN2(3) = 0.
      VPN2(4) = CAR1(4)
      VPN2(5) = 0.
      VPN2(6) = VPN2(5)
      VPN2(7) = 0.
      VPN2(8) = CAR1(8)
      VPN2(9) = 0.5*BB
      VPN2(10) = VPN2(9)
      VPN2(11) = 0.

      NMED=MAL
      CALL GSVOLU('VPN2','TRAP',NMED,VPN2,11,IVOLU)
      NMED=MN2
      CALL GSVOLU('VPN1','TRAP',NMED,VPN1,11,IVOLU)
*
*  Volumes to be subtracted from CAR1 and CAR2
*
      AA=(ATZ/SIN(DEGRAD*CAR(7)))/(1./TAN(DEGRAD*CAR(7))+
     +    CAR(4)/CAR(2))+CAR(2)+CAR(3)+ATZ
      BB=AA/TAN(DEGRAD*CAR(7))+AA*CAR(4)/CAR(2)

      VAN1(1) = 0.5*AA
      VAN1(2) = VSN1(2)
      VAN1(3) = 0.
      VAN1(4) = CAR1(4)
      VAN1(5) = 0.
      VAN1(6) = VAN1(5)
      VAN1(7) = 0.
      VAN1(8) = CAR1(8)
      VAN1(9) = 0.5*BB
      VAN1(10) = VAN1(9)
      VAN1(11) = 0.

      AA=CAR(3) + ATZ -
     +    COS(ATAN(CAR(4)/CAR(2)))*ATZ/SIN(ATAN(CAR(5)/CAR(3))-
     +    ATAN(CAR(4)/CAR(2)))
      BB=AA*(CAR(5)/CAR(3)-CAR(4)/CAR(2))

      VAN2(1) = 0.5*AA
      VAN2(2) = RADDEG*ATAN((BB/2.+(AA)*CAR(4)/CAR(2))/AA)
      VAN2(3) = 0.
      VAN2(4) = CAR1(4)
      VAN2(5) = 0.
      VAN2(6) = VAN2(5)
      VAN2(7) = 0.
      VAN2(8) = CAR1(8)
      VAN2(9) = 0.5*BB
      VAN2(10) = VAN2(9)
      VAN2(11) = 0.

      NMED=MN2
      CALL GSVOLU('VAN1','TRAP',NMED,VAN1,11,IVOLU)
      CALL GSVOLU('VAN2','TRAP',NMED,VAN2,11,IVOLU)
*
* The zenihtal angle of the paddles
*
      ANGLCAR2=CARA(3)*DEGRAD   !CAR2 inclination
      ANGLCAR1=CARB(3)*DEGRAD   !CAR1 inclination

      NMED=MN2
      CALL GSVOLU('CARD','BOX ',NMED,CARDB, 3,IVOLU)
*
*  Define ANGLCAR rotation around Z axis
*
*    CAR1A
      IRZCAR1B=11
      CALL GSROTM(IRZCAR1B,90.,0.,(90.-ANGLCAR1*RADDEG),
     +     90.,(180.-ANGLCAR1*RADDEG),90.)
*    CAR1B
      IRZCAR1A=12
      CALL GSROTM(IRZCAR1A,90.,180.,(270.-ANGLCAR1*RADDEG),
     +     270.,(180.-ANGLCAR1*RADDEG),270.)
*    CAR2A
      IRZCAR2B=13
      CALL GSROTM(IRZCAR2B,90.,270.,(90.-ANGLCAR2*RADDEG),
     +     0.,(180.-ANGLCAR2*RADDEG),0.)
*    CAR2B
      IRZCAR2A=14
      CALL GSROTM(IRZCAR2A,90.,90.,(90.-ANGLCAR2*RADDEG),
     +     180.,(180.-ANGLCAR2*RADDEG),180.)

*
* Positioning in CAR1
*
      N=1
      Y=0
      Z=C1D1(1)-VSN1(1)
      X=-(C1D1(9)+C1D1(1)*TAN(ANG1C)-
     +     (VSN1(9)-VSN1(1)*TAN(VSN1(2)*DEGRAD)))
      CALL GSPOS('VSN1',N,'C1D1',X,Y,Z,0,'ONLY')
*
      N=1
      Y=0
      Z=CR1P(1)-VPN1(1)
      X=-(CR1P(9)-CR1P(1)*TAN(CR1P(2)*DEGRAD)-
     +     (VPN1(9)-VPN1(1)*TAN(VPN1(2)*DEGRAD)))
      CALL GSPOS('VPN1',N,'CR1P',X,Y,Z,0,'ONLY')
*
      N=1
      Y=0
      Z=CAR1(1)-VAN1(1)
      X=-(CAR1(9)-CAR1(1)*TAN(CAR1(2)*DEGRAD)-
     +     (VAN1(9)-VAN1(1)*TAN(VAN1(2)*DEGRAD)))
      CALL GSPOS('VAN1',N,'CAR1',X,Y,Z,0,'ONLY')
*
      N=1
      Y=0
      Z=C1D1(1)-VSN2(1)
      X=-(C1D1(9)+C1D1(1)*TAN(ANG1C)-
     +     (2.*VSN1(9)+VSN2(9)-VSN2(1)*TAN(VSN2(2)*DEGRAD)))
      CALL GSPOS('VSN2',N,'C1D1',X,Y,Z,0,'ONLY')
*
      N=1
      Y=0
      Z=CR1P(1)-VPN2(1)
      X=-(CR1P(9)-CR1P(1)*TAN(CR1P(2)*DEGRAD)-
     +     (2.*VPN1(9)+VPN2(9)-VPN2(1)*TAN(VPN2(2)*DEGRAD)))
      CALL GSPOS('VPN2',N,'CR1P',X,Y,Z,0,'ONLY')
*
      N=1
      Y=0
      Z=CAR1(1)-VAN2(1)
      X=-(CAR1(9)-CAR1(1)*TAN(CAR1(2)*DEGRAD)-
     +     (2.*VAN1(9)+VAN2(9)-VAN2(1)*TAN(VAN2(2)*DEGRAD)))
      CALL GSPOS('VAN2',N,'CAR1',X,Y,Z,0,'ONLY')
*
      N=1
      X=PT*(1./COS(ATAN(D1/CAR(1)))-
     +    (1./SIN(DEGRAD*CAR(7))))/2.
      Y=0
      Z=0
      CALL GSPOS('C1D1',N,'CR1P',X,Y,Z,0,'ONLY')
*
      N=1
      X=(ATZ-PT)*(1./COS(ATAN(D1/CAR(1)))-
     +    (1./SIN(DEGRAD*CAR(7))))/2.
      Y=0
      Z=0
      CALL GSPOS('CR1P',N,'CAR1',X,Y,Z,0,'ONLY')
*
* Positioning in CAR2
*
      N=2
      Y=0
      Z=C2D1(1)-VSN1(1)
      X=-(C2D1(9)+C2D1(1)*TAN(ANG2C)-
     +     (VSN1(9)-VSN1(1)*TAN(VSN1(2)*DEGRAD)))
      CALL GSPOS('VSN1',N,'C2D1',X,Y,Z,0,'ONLY')
*
      N=2
      Y=0
      Z=CR2P(1)-VPN1(1)
      X=-(CR2P(9)+CR2P(1)*TAN(ANG2C)-
     +     (VPN1(9)-VPN1(1)*TAN(VPN1(2)*DEGRAD)))
      CALL GSPOS('VPN1',N,'CR2P',X,Y,Z,0,'ONLY')
*
      N=2
      Y=0
      Z=CAR2(1)-VAN1(1)
      X=-(CAR2(9)-CAR2(1)*TAN(CAR2(2)*DEGRAD)-
     +     (VAN1(9)-VAN1(1)*TAN(VAN1(2)*DEGRAD)))
      CALL GSPOS('VAN1',N,'CAR2',X,Y,Z,0,'ONLY')
*
      N=2
      Y=0
      Z=C2D1(1)-VSN2(1)
      X=-(C2D1(9)+C2D1(1)*TAN(ANG2C)-
     +   (2.*VSN1(9)+VSN2(9)-VSN2(1)*TAN(VSN2(2)*DEGRAD)))
      CALL GSPOS('VSN2',N,'C2D1',X,Y,Z,0,'ONLY')
*
      N=2
      Y=0
      Z=CR2P(1)-VPN2(1)
      X=-(CR2P(9)-CR2P(1)*TAN(CR2P(2)*DEGRAD)-
     +   (2.*VPN1(9)+VPN2(9)-VPN2(1)*TAN(VPN2(2)*DEGRAD)))
      CALL GSPOS('VPN2',N,'CR2P',X,Y,Z,0,'ONLY')
*
      N=2
      Y=0
      Z=CAR2(1)-VAN2(1)
      X=-(CAR2(9)-CAR2(1)*TAN(CAR2(2)*DEGRAD)-
     +   (2.*VAN1(9)+VAN2(9)-VAN2(1)*TAN(VAN2(2)*DEGRAD)))
      CALL GSPOS('VAN2',N,'CAR2',X,Y,Z,0,'ONLY')
*
      N=1
      X=PT*(1./COS(ATAN(D2/CAR(1)))-1./SIN(DEGRAD*CAR(7)))/2.
      Y=0
      Z=0
      CALL GSPOS('C2D1',N,'CR2P',X,Y,Z,0,'ONLY')
*
      N=1
      X=(ATZ-PT)*(1./COS(ATAN(D2/CAR(1)))-
     +                       1./SIN(DEGRAD*CAR(7)))/2.
      Y=0
      Z=0
      CALL GSPOS('CR2P',N,'CAR2',X,Y,Z,0,'ONLY')
*
* Positioning in card
*
*
*           CAR1A
* CAR2B                CAR2A
*           CAR1B
*
      ZH=49.229-ZTPLA-TPLA(3)
*--- CAR1B
      N=1
      Y=-CARB(5)+CAR(8)/2.*SIN(ANGLCAR1)
      Z=CARB(6)+ZH-CARDB(3)-CAR(8)*COS(ANGLCAR1)/2.
      X=((CARB(7)/2.)-TAN(ANG1C)*CAR(8)/2.)-CARB(4)
      CALL GSPOS('CAR1',N,'CARD',X,Y,Z,IRZCAR1B,'ONLY')
*--- CAR1A
      N=2
      X=-X
      Y=-Y
      CALL GSPOS('CAR1',N,'CARD',X,Y,Z,IRZCAR1A,'ONLY')
*--- CAR2A
      N=1
      X=CARA(4)-CAR(8)/2.*SIN(ANGLCAR2)
      Z=CARA(6)+ZH-CARDB(3)-CAR(8)*COS(ANGLCAR2)/2.
      Y=(CARA(7)/2.-TAN(ANG2C)*CAR(8)/2.)-CARA(5)
      CALL GSPOS('CAR2',N,'CARD',X,Y,Z,IRZCAR2A,'ONLY')
*--- CAR2B
      N=2
      X=-X
      Y=-Y
      CALL GSPOS('CAR2',N,'CARD',X,Y,Z,IRZCAR2B ,'ONLY')
c---------------------------------------------------------------
*
*     LEGS
*
      NMED=MAL
      CALL GSVOLU('LEGB','BOX ',NMED,LEGB, 3,IVOLU)
*
*     empty volumes to be subtracted from LEGB
*
      NMED=MN2
      CALL GSVOLU('LEG1','TRAP',NMED,LEG1, 11,IVOLU)
      X=-LEGB(1)+LEG1(1)
      Y=-LEGB(2)+LEG1(4)
      Z=0.
      CALL GSPOS('LEG1',1,'LEGB',X,Y,Z,RY90,'ONLY')
      Y=-LEGB(2)+2.*LEGP(1)-LEG1(4)
      CALL GSPOS('LEG1',2,'LEGB',X,Y,Z,RY90,'ONLY')
*
      CALL GSVOLU('LEG2','BOX ',NMED,LEG2, 3,IVOLU)
      X=-LEGB(1)+LEG2(1)
      Y=-LEGB(2)+LEGP(1)
      Z=0.
      CALL GSPOS('LEG2',1,'LEGB',X,Y,Z,0,'ONLY')
*
      CALL GSVOLU('LEG3','BOX ',NMED,LEG3, 3,IVOLU)
      X=-LEGB(1)+LEGP(2)*2.+LEG3(1)+0.2
      Y=LEGB(2)-LEG3(2)
      Z=LEGB(3)-LEG3(3)
      CALL GSPOS('LEG3',1,'LEGB',X,Y,Z,0,'ONLY')
      Z=-LEGB(3)+LEG3(3)
      CALL GSPOS('LEG3',2,'LEGB',X,Y,Z,0,'ONLY')
*
      CALL GSVOLU('LEG4','BOX ',NMED,LEG4, 3,IVOLU)
      X=-LEGB(1)+LEG4(1)
      Y=LEGB(2)-LEG4(2)
      Z=0.
      CALL GSPOS('LEG4',1,'LEGB',X,Y,Z,0,'ONLY')
*
      CALL GSVOLU('LEG5','BOX ',NMED,LEG5, 3,IVOLU)
      X=LEGB(1)-LEG5(1)
      Y=LEGB(2)-LEG5(2)
      Z=0.
      CALL GSPOS('LEG5',1,'LEGB',X,Y,Z,0,'ONLY')
*
      CALL GSVOLU('LEG6','BOX ',NMED,LEG6, 3,IVOLU)
      X=-LEGB(1)+LEGP(2)*2.+LEG3(1)
      Y=LEGB(2)-LEG6(2)
      Z=0.
      CALL GSPOS('LEG6',1,'LEGB',X,Y,Z,0,'ONLY')
*
      CALL GSVOLU('LEG7','BOX ',NMED,LEG7, 3,IVOLU)
      X=LEGB(1)-LEGP(3)-LEGP(4)
      Y=-LEGB(2)+LEG7(2)
      Z=LEGP(5)-LEGP(8)-LEG7(3)
      CALL GSPOS('LEG7',1,'LEGB',X,Y,Z,0,'ONLY')
*
      CALL GSVOLU('LEG8','BOX ',NMED,LEG8, 3,IVOLU)
      Z=0.
      CALL GSPOS('LEG8',1,'LEGB',X,Y,Z,0,'ONLY')
*
      CALL GSVOLU('LEG9','BOX ',NMED,LEG9, 3,IVOLU)
      Z=-(LEGP(5)-LEGP(8)-LEG7(3))
      CALL GSPOS('LEG9',1,'LEGB',X,Y,Z,0,'ONLY')
*
*     Positioning LEG BOXES in CARD
*
      N=1
      X=-CARDB(1)+LEGB(1)+LEGP(6)
      Y=-CARDB(2)+LEGB(2)+LEGP(7)
      Z=-0.5
      CALL GSPOS('LEGB',N,'CARD',X,Y,Z,0,'MANY')
      N=2
      X=X
      Y=-Y
      CALL GSPOS('LEGB',N,'CARD',X,Y,Z,RX180,'MANY')
      N=3
      X=-X
      Y=Y
      CALL GSROTM(RZALEX180,90.,180.,90.,
     +     270.,180.,0.)
      CALL GSPOS('LEGB',N,'CARD',X,Y,Z,RZ180,'MANY')
      N=4
      X=X
      Y=-Y
      CALL GSPOS('LEGB',N,'CARD',X,Y,Z,RY180,'MANY')
*
c---------------------------------------------------------------
*
*     CARD TOP PLATE
*
*     TPLT
*
      NMED=MAL
      CALL GSVOLU('TPLT','BOX ',NMED,TPLT, 3,IVOLU)
*
* Empty volumes to be subtracted from TPLT
*
      NMED=MN2
      CALL GSVOLU('TOPC','BOX ',NMED,TOPC, 3,IVOLU)
*
      CALL GSVOLU('TH11','BOX ',NMED,TH11, 3,IVOLU)
      CALL GSVOLU('TH12','BOX ',NMED,TH12, 3,IVOLU)
      CALL GSVOLU('TH21','BOX ',NMED,TH21, 3,IVOLU)
      CALL GSVOLU('TH22','BOX ',NMED,TH22, 3,IVOLU)
*
      CALL GSVOLU('TOPT','TRAP',NMED,TOPT,11,IVOLU)
*
      CALL GSVOLU('TOHO','TUBE',NMED,TOHO,3,IVOLU)

*
*     Positioning empty volumes...
*
*     Positioning TOPC in TPLT
*
      N=1
      X=0.
      Y=0.
      Z=0.
      CALL GSPOS('TOPC',N,'TPLT',X,Y,Z,0,'ONLY')
*
*
*     Positioning H11 in TPLT
*
      N=1
      X=-TOPP(1)
      Y=TOPP(2)
      Z=0.
      CALL GSPOS('TH11',N,'TPLT',X,Y,Z,0,'ONLY')
      N=2
      X=-TOPP(1)
      Y=-TOPP(2)
      CALL GSPOS('TH11',N,'TPLT',X,Y,Z,0,'ONLY')
      N=3
      X=TOPP(1)
      Y=TOPP(2)
      CALL GSPOS('TH11',N,'TPLT',X,Y,Z,0,'ONLY')
      N=4
      X=TOPP(1)
      Y=-TOPP(2)
      CALL GSPOS('TH11',N,'TPLT',X,Y,Z,0,'ONLY')
*
*     Positioning H12 in TPLT
*
      N=1
      X=-TOPP(1)
      Y=TOPP(3)
      Z=0.
      CALL GSPOS('TH12',N,'TPLT',X,Y,Z,0,'ONLY')
      N=2
      X=-TOPP(1)
      Y=-TOPP(3)
      CALL GSPOS('TH12',N,'TPLT',X,Y,Z,0,'ONLY')
      N=3
      X=TOPP(1)
      Y=TOPP(3)
      CALL GSPOS('TH12',N,'TPLT',X,Y,Z,0,'ONLY')
      N=4
      X=TOPP(1)
      Y=-TOPP(3)
      CALL GSPOS('TH12',N,'TPLT',X,Y,Z,0,'ONLY')
*
*     Positioning H21 in TPLT
*
      N=1
      X=-TOPP(4)
      Y=TOPP(5)
      Z=0.
      CALL GSPOS('TH21',N,'TPLT',X,Y,Z,0,'ONLY')
      N=2
      X=-TOPP(4)
      Y=-TOPP(5)
      CALL GSPOS('TH21',N,'TPLT',X,Y,Z,0,'ONLY')
      N=3
      X=TOPP(4)
      Y=TOPP(5)
      CALL GSPOS('TH21',N,'TPLT',X,Y,Z,0,'ONLY')
      N=4
      X=TOPP(4)
      Y=-TOPP(5)
      CALL GSPOS('TH21',N,'TPLT',X,Y,Z,0,'ONLY')
*
*     Positioning H22 in TPLT
*
      N=1
      X=-TOPP(6)
      Y=TOPP(5)
      Z=0.
      CALL GSPOS('TH22',N,'TPLT',X,Y,Z,0,'ONLY')
      N=2
      X=-TOPP(6)
      Y=-TOPP(5)
      CALL GSPOS('TH22',N,'TPLT',X,Y,Z,0,'ONLY')
      N=3
      X=TOPP(6)
      Y=TOPP(5)
      CALL GSPOS('TH22',N,'TPLT',X,Y,Z,0,'ONLY')
      N=4
      X=TOPP(6)
      Y=-TOPP(5)
      CALL GSPOS('TH22',N,'TPLT',X,Y,Z,0,'ONLY')
      N=5
      X=0.
      Y=TOPP(5)
      CALL GSPOS('TH22',N,'TPLT',X,Y,Z,0,'ONLY')
      N=6
      X=0.
      Y=-TOPP(5)
      CALL GSPOS('TH22',N,'TPLT',X,Y,Z,0,'ONLY')
*
*     Positioning TOPT in TPLT
*
      N=1
      X=-CARDB(1)+TOPP(7)/4.
      Y=-CARDB(2)+TOPP(7)/2.
      Z=0.
      CALL GSPOS('TOPT',N,'TPLT',X,Y,Z,0,'ONLY')
      N=2
      X=X
      Y=-Y
      CALL GSPOS('TOPT',N,'TPLT',X,Y,Z,RX180,'ONLY')
      N=3
      X=-X
      Y=Y
      CALL GSPOS('TOPT',N,'TPLT',X,Y,Z,RZ180,'ONLY')
      N=4
      X=X
      Y=-Y
      CALL GSPOS('TOPT',N,'TPLT',X,Y,Z,RY180,'ONLY')
*
*     Positioning TOHO in TPLT
*
      N=1
      X=TPLT(1)-TOPP(8)-TOHO(1)
      Y=TPLT(2)-TOPP(9)-TOHO(2)
      CALL GSPOS('TOHO',N,'TPLT',X,Y,Z,0,'ONLY')
      N=2
      X=-X
      Y=Y
      CALL GSPOS('TOHO',N,'TPLT',X,Y,Z,0,'ONLY')
      N=3
      X=X
      Y=-Y
      CALL GSPOS('TOHO',N,'TPLT',X,Y,Z,0,'ONLY')
      N=4
      X=-X
      Y=Y
      CALL GSPOS('TOHO',N,'TPLT',X,Y,Z,0,'ONLY')
*
*     Positioning TPLT in CARD volume
*
      N=1
      X=0.
      Y=0.
      Z=CARDB(3)-TPLT(3)
      CALL GSPOS('TPLT',N,'CARD',X,Y,Z,0,'ONLY')
C---------------------------------------------------------------
*
*     MAGNETIC SCREEN
*
      NMED=MIRON
      CALL GSVOLU('MGSC','BOX ',NMED,MGSC, 3,IVOLU)
*
*  Empty volume to be subtracted from MGSC
*
      NMED=MN2
      CALL GSVOLU('MGSH','BOX ',NMED,MGSH, 3,IVOLU)

*
*     Positioning in CARD...
*
      N=1
      X=0.
      Y=0.
      Z=0.
      CALL GSPOS('MGSH',N,'MGSC',X,Y,Z,0,'ONLY')
      Z=-CARDB(3)+MGSC(3)
      CALL GSPOS('MGSC',N,'CARD',X,Y,Z,0,'ONLY')
c---------------------------------------------------------------
      RETURN
      END
