*
* $Id$
*
* $Log$
*
*CMZ :  3.00/00 14/11/2000  10.17.50  by  Emiliano Mocchiutti
*CMZ :  2.02/00 12/10/2000  18.19.42  by  Francesco Cafagna
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.06  by  Francesco Cafagna
*CMZ :  1.02/00 21/10/99  14.46.25  by  Francesco Cafagna
*CMZ :  1.00/02 13/03/96  18.39.55  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   09/12/95
      SUBROUTINE GPCALV
************************************************************************
*                                                                      *
* Volumes definition for the silicon calorimeter                       *
* Called by: GPGEM                                                     *
* Author: Francesco Cafagna, 05/12/95 13.39.41                         *
*                                                                      *
************************************************************************
#include "gpgeo.inc"
#include "gpmed.inc"
#include "gpkey.inc"
*
      INTEGER IROT,IVOLU,N,NMED
      REAL X,Y,Z
*
*  Define the CALB     volume
*
      NMED= MN2
      CALL GSVOLU('CALB','BOX ',NMED,CALB, 3,IVOLU)
*
*  Define the CALS     volume
*
      NMED= MAL
      CALL GSVOLU('CALS','BOX ',NMED,CALS, 3,IVOLU)
*
*  Define the CAPL     volume
*
      NMED= MN2
      CALL GSVOLU('CAPL','BOX ',NMED,CAPL, 3,IVOLU)
*
*  Define the CAPD     volume
*
      NMED= MN2
      CALL GSVOLU('CAPD','BOX ',NMED,CAPD, 3,IVOLU)
*
*  Define the CASI     volume
*
      NMED= MSIC
      CALL GSVOLU('CASI','BOX ',NMED,CASI, 3,IVOLU)
*
*  Division in CASI
*
      CALL GSDVN ('CAST','CASI',NCASTR,1)
*
*  Define the CG10     volume
*
      NMED= MG10C
      CALL GSVOLU('C10C','BOX ',NMED,C10C, 3,IVOLU)
*
*  Define the CAAB     volume
*
      NMED= MW2
      CALL GSVOLU('CAAB','BOX ',NMED,CAAB, 3,IVOLU)
*EM:
*
*  Define the CAAD     volume
*
      NMED= MAL
      CALL GSVOLU('CAAD','BOX ',NMED,CAAD, 3,IVOLU)
*
*  Define the CAKA     volume
*
      NMED= MCER
      CALL GSVOLU('CAKA','BOX ',NMED,CAKA, 3,IVOLU)
*
*  Define the CAKP     volume
*
      NMED= MKAP
      CALL GSVOLU('CAKP','BOX ',NMED,CAKP, 3,IVOLU)
*
*  Define the CAGL     volume (Silicon glue)
*
      NMED= MSIC
      CALL GSVOLU('CAGL','BOX ',NMED,CAGL, 3,IVOLU)
*END EM.
*
* Positioning volumes CAKA, C10C, CAGL, CAKP into the mother CAPL and CAPD
* (Kaolite and G10 only for CAPD)
*
      N = 1
      X = 0.
      Y = 0.
*EM:
      Z = -CAPL(3) + CAKA(3)
      CALL GSPOS('CAKA',N,'CAPL',X,Y,Z,0,'ONLY')
      CALL GSPOS('CAKA',N,'CAPD',X,Y,Z,0,'ONLY')
      Z = Z + CAKA(3) + C10C(3)
      CALL GSPOS('C10C',N,'CAPL',X,Y,Z,0,'ONLY')
      CALL GSPOS('C10C',N,'CAPD',X,Y,Z,0,'ONLY')
      Z = Z + C10C(3) + CAGL(3)
      CALL GSPOS('CAGL',N,'CAPL',X,Y,Z,0,'ONLY')
      Z = Z + CAGL(3) + CAKP(3)
      CALL GSPOS('CAKP',N,'CAPL',X,Y,Z,0,'ONLY')
*
* Positioning volume CASI into the mother CAPL
*
      N = 0
      Z = Z + CAKP(3) + CASI(3)
      DO I=-1,1
         Y = I*(2.*CASI(2)+ DCASIY)
         DO II=-1,1
            N= N + 1
            X = II*(2.*CASI(1)+ DCASIX)
*
* Check if detector is excluded
*
            IF(.NOT.NOCASI(N))
     +           CALL GSPOS('CASI',N,'CAPL',X,Y,Z,0,'ONLY')
         ENDDO
      ENDDO
*END EM.
*
* Positioning volume CAPL and CAAB into the mother CALB
*
      X= 0.
      Y= 0.
C      Z= CALB(3) + CAPL(3)
*EM:
      Z= CALB(3) + CAPL(3) - DCASIZ/2.
*END EM. (we have 0.15 cm from the top to the first Si)
      N= 0
      DO I=1,NCAPL
*
* X view, absorber and Y view on the other
*
         Z= Z - 2*CAPL(3)
         N= N + 1
*
* Check if this plane is excluded
*
         IF(.NOT.NOCAPL(N))
     +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,0,'ONLY')
         Z= Z - CAPL(3) - CAAB(3)
*
* Check if this absorber is excluded
*
         IF(.NOT.NOCAAB(I))
     +        CALL GSPOS('CAAB',(I-1),'CALB',X,Y,Z,0,'ONLY')
         Z= Z - CAAB(3) - CAPL(3)
         N= N + 1
*
* Check if this detector is excluded
*
         IF(.NOT.NOCAPL(N))
     +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,3,'ONLY')
      ENDDO
*
* Positioning volume CAPD and CAAD into the mother CALB
*
      N= 0
      DO I=1,NCAPLD
         IF(I.EQ.1) THEN
            Z= Z - CAPD(3) - CAPL(3)
         ELSE
            Z= Z - 2*CAPD(3)
         ENDIF
         N= N + 1
         CALL GSPOS('CAPD',N,'CALB',X,Y,Z,0,'ONLY')
         Z= Z - CAPD(3) - CAAD(3)
         CALL GSPOS('CAAD',(I-1),'CALB',X,Y,Z,0,'ONLY')
         Z= Z - CAAD(3) - CAPD(3)
         N= N + 1
         CALL GSPOS('CAPD',N,'CALB',X,Y,Z,3,'ONLY')
      ENDDO
*
* Put the shell around it
*
      X= 0.
      Y= 0.
      Z= CALS(3)-CALB(3)
      N= 1
      CALL GSPOS('CALB',N,'CALS',X,Y,Z,0,'ONLY')
*
      RETURN
      END
