*
* $Id: gpcalv.F,v 3.5 2006/05/09 12:01:15 cafagna Exp $
*
* $Log: gpcalv.F,v $
* Revision 3.5  2006/05/09 12:01:15  cafagna
* Calo geometry updated
*
* Revision 3.4  2005/07/25 11:53:20  cafagna
* Several updates. See history for details
*
* Revision 3.3  2003/12/17 11:32:48  pamela
* CALO SIMULATION COMPLETED: geometry and special tracking parameters updated and simulation checked by a comparison with the Trieste's standalone Monte Carlo simulation
*
* Revision 3.2  2002/12/05 10:17:41  pamela
* Update CAS and CALO geometries and positions. Makefile updated as well
*
* Revision 3.1.1.1  2002/07/11 16:02:14  cafagna
* First GPAMELA release on CVS
*
*
*CMZ :  3.00/00 14/11/2000  10.17.50  by  Emiliano Mocchiutti
*CMZ :  2.02/00 12/10/2000  18.19.42  by  Francesco Cafagna
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.06  by  Francesco Cafagna
*CMZ :  1.02/00 21/10/99  14.46.25  by  Francesco Cafagna
*CMZ :  1.00/02 13/03/96  18.39.55  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   09/12/95
      SUBROUTINE GPCALV
************************************************************************
*                                                                      *
* Volumes definition for the silicon calorimeter                       *
* Called by: GPGEM                                                     *
* Author: Francesco Cafagna, 05/12/95 13.39.41                         *
*                                                                      *
************************************************************************
#include "gpgeo.inc"
#include "gpmed.inc"
#include "gpkey.inc"
*
      INTEGER IROT,IVOLU,N,NMED
      REAL X,Y,Z
* MA
      REAL X1, Y1
      INTEGER m
* END MA
*
*  Define the CALB     volume
*
      NMED= MN2
      CALL GSVOLU('CALB','BOX ',NMED,CALB, 3,IVOLU)
*
*  Define the CALS     volume
*
      NMED= MAL
      CALL GSVOLU('CALS','BOX ',NMED,CALS, 3,IVOLU)
*
*  Define the CAPL     volume
*
      NMED= MN2
      CALL GSVOLU('CAPL','BOX ',NMED,CAPL, 3,IVOLU)
* F.V.&ML:
*
*  Define the CANS     volume
*
      NMED= MN2
      CALL GSVOLU('CANS','BOX ',NMED,CANS, 3,IVOLU)
* END  F.V.&ML.
*
*  Define the CAPD     volume
*
      NMED= MN2
      CALL GSVOLU('CAPD','BOX ',NMED,CAPD, 3,IVOLU)
*
*  Define the CASI     volume
*
      NMED= MSIC
      CALL GSVOLU('CASI','BOX ',NMED,CASI, 3,IVOLU)
*
*  Division in CASI
*
* ML:
C      CALL GSDVN ('CAST','CASI',NCASTR,1)
      CALL GSDVN ('CAST','CASI',NCASTR,2)
* END ML:
*
*  Define the CG10     volume
*
      NMED= MG10C
      CALL GSVOLU('C10C','BOX ',NMED,C10C, 3,IVOLU)
*
*  Define the CAAB     volume
*
      NMED= MW2
      CALL GSVOLU('CAAB','BOX ',NMED,CAAB, 3,IVOLU)
*EM:
*
*  Define the CAAD     volume
*
      NMED= MAL
      CALL GSVOLU('CAAD','BOX ',NMED,CAAD, 3,IVOLU)
*
*  Define the CAKA     volume
*
      NMED= MCER
      CALL GSVOLU('CAKA','BOX ',NMED,CAKA, 3,IVOLU)
*
*  Define the CAKP     volume
*
      NMED= MKAP
      CALL GSVOLU('CAKP','BOX ',NMED,CAKP, 3,IVOLU)
*
*  Define the CAGL     volume (Silicon glue)
*
      NMED= MSIC
      CALL GSVOLU('CAGL','BOX ',NMED,CAGL, 3,IVOLU)
*END EM.
*
* Positioning volumes CAKA, C10C, CAGL, CAKP into the mother CAPL and CAPD
* (Kaolite and G10 only for CAPD)
*
      N = 1
      X = 0.
      Y = 0.
*EM:
*F.V.&ML:
c      CALL GPVOLU(-2)
C      Z = -CAPL(3) + CAKA(3)
C      CALL GSPOS('CAKA',N,'CAPL',X,Y,Z,0,'ONLY')
      Z = -CANS(3) + CAKA(3)
      CALL GSPOS('CAKA',N,'CANS',X,Y,Z,0,'ONLY')
C      CALL GSPOS('CAKA',N,'CAPD',X,Y,Z,0,'ONLY')
      Z = Z + CAKA(3) + C10C(3)
C      CALL GSPOS('C10C',N,'CAPL',X,Y,Z,0,'ONLY')
      CALL GSPOS('C10C',N,'CANS',X,Y,Z,0,'ONLY')
C      CALL GSPOS('C10C',N,'CAPD',X,Y,Z,0,'ONLY')
      Z = Z + C10C(3) + CAGL(3)
C      CALL GSPOS('CAGL',N,'CAPL',X,Y,Z,0,'ONLY')
      CALL GSPOS('CAGL',N,'CANS',X,Y,Z,0,'ONLY')
      Z = Z + CAGL(3) + CAKP(3)
C      CALL GSPOS('CAKP',N,'CAPL',X,Y,Z,0,'ONLY')
      CALL GSPOS('CAKP',N,'CANS',X,Y,Z,0,'ONLY')
* END F.V.&ML
*
* Positioning volume CASI into the mother CAPL
*
      N = 0
* F.V.&ML:
C      Z= Z + CAKP(3) + CASI(3)
      Z = -CAPL(3)+CASI(3)
* END F.V.&ML
      DO I=-1,1
         Y = I*(2.*CASI(2)+ DCASIY)
         DO II=-1,1
            N= N + 1
            X = II*(2.*CASI(1)+ DCASIX)
*
* Check if detector is excluded
*
            IF(.NOT.NOCASI(N))
     +           CALL GSPOS('CASI',N,'CAPL',X,Y,Z,0,'ONLY')
         ENDDO
      ENDDO
*END EM.
* MA
* 11 MODULI DI 2 W
c     Z = CALB(3) - CAPL(3) - DCASIZ/2
      Z = CALB(3) - CAPL(3) - DCASIZ
      N = 0
      DO M = 0,20,2
*     Positioning CAPL CANS CAAB in CALB to form a module
         X = .10
         y = .05
         DO I = 1,2
*     Positioning CAPL
            N = N + 1
C     if(N.EQ.1) print *,'z ini = ',Z
            IF(.NOT.NOCAPL(N))
     +           CALL GSPOS('CAPL',N,'CALB',X,(Y-0.1),Z,0,'ONLY')
*     Positioning CANS
            Z = Z - CAPL(3) - CANS(3)
            CALL GSPOS('CANS',N,'CALB',0,-0.1,Z,0,'ONLY')
*     Positioning CAAB
            Z = Z - CANS(3) - CAAB(3)
            IF(.NOT.NOCAAB(M+I))
     +           CALL GSPOS('CAAB',(M+I),'CALB',0,-0.1,Z,0,'ONLY')
*     Positioning CANS (ruotato)
            N = N + 1
            Z = Z - CAAB(3) - CANS(3)
            CALL GSPOS('CANS',N,'CALB',0,-0.1,Z,3,'ONLY')
*     Positioning CAPL (ruotato e shiftato)
            X1 = X
            Y1 = Y
            X = -Y1
            Y = X1
            Z = Z - CANS(3) - CAPL(3)
c Mod by Caf on 30th Marc 2007, the X position of the X-view planes should be swapped
c$$$            IF(.NOT.NOCAPL(N))
c$$$     +           CALL GSPOS('CAPL',N,'CALB',X,(Y-0.1),Z,3,'ONLY')
            IF(.NOT.NOCAPL(N))
     +           CALL GSPOS('CAPL',N,'CALB',-X,(Y-0.1),Z,3,'ONLY')

            IF(I.EQ.1) THEN
c              Z = Z - 2*CAPL(3) - DZMO ! SPESSORE TRA I SILICI CHE SI GUARDANO
               Z = Z - 2*CAPL(3) - DZM0 ! corretto
               X1 = X                   ! SHIFT PER IL CAPL PROSSIMO CICLO
               Y1 = Y
               X = -Y1
               Y = X1
            ENDIF
         ENDDO
         Z = Z - DZST - 2*CAPL(3)
      ENDDO
*     END MA

C # *F.V.&ML:
C # C commenting the original code with a 'C' per raw:
C # C*
C # C* Positioning volume CAPL and CAAB into the mother CALB
C # C*
C # C      X= 0.
C # C      Y= 0.
C # CC      Z= CALB(3) + CAPL(3)
C # C*EM:
C # C      Z= CALB(3) + CAPL(3) - DCASIZ/2.
C # C*END EM. (we have 0.15 cm from the top to the first Si)
C # C      N= 0
C # C      DO I=1,NCAPL
C # C*
C # C* X view, absorber and Y view on the other
C # C*
C # C         Z= Z - 2*CAPL(3)
C # C         N= N + 1
C # C*
C # C* Check if this plane is excluded
C # C*
C # C         IF(.NOT.NOCAPL(N))
C # C     +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,0,'ONLY')
C # C         Z= Z - CAPL(3) - CAAB(3)
C # C*
C # C* Check if this absorber is excluded
C # C*
C # C         IF(.NOT.NOCAAB(I))
C # C     +        CALL GSPOS('CAAB',(I-1),'CALB',X,Y,Z,0,'ONLY')
C # C         Z= Z - CAAB(3) - CAPL(3)
C # C         N= N + 1
C # C*
C # C* Check if this detector is excluded
C # C*
C # C         IF(.NOT.NOCAPL(N))
C # C     +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,3,'ONLY')
C # C      ENDDO
C # C end comments.
C # *
C # * Positioning volume CANS ,CAPL and CAAB into the mother CALB
C # *
C #       X= 0.
C #       Y= 0.
C #       Z= CALB(3) + CAPL(3) - DCASIZ/2.
C # *END EM. (we have 0.15 cm from the top to the first Si)
C #       N= 0
C # *
C # *	I DISPARI
C #       DO I=1,NCAPL,2
C # *
C # * X view, absorber and Y view on the other
C # *
C # 	 X=0.10
C # 	 Y=0.05
C #          Z= Z - 2*CAPL(3)
C #          N= N + 1
C # *
C # * Check if this plane is excluded
C # *
C # *
C #          IF(.NOT.NOCAPL(N))
C #      +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,0,'ONLY')
C # *
C #          X = 0.
C #          Y = 0.
C #          Z= Z - CAPL(3) - CANS(3)
C # *
C #          CALL GSPOS('CANS',N,'CALB',X,Y,Z,0,'ONLY')
C # *
C #          Z= Z - CANS(3) - CAAB(3)
C # *
C # * Check if this absorber is excluded
C # *
C # *
C #          IF(.NOT.NOCAAB(I))
C #      +        CALL GSPOS('CAAB',(I-1),'CALB',X,Y,Z,0,'ONLY')
C # *
C #          Z = Z - CAAB(3)- CANS(3)
C #          N = N + 1
C # *     
C #          CALL GSPOS('CANS',N,'CALB',X,Y,Z,3,'ONLY')
C #          Z= Z - CANS(3) - CAPL(3)
C #          X=-0.05
C #          Y=0.10
C # *
C # * Check if this detector is excluded
C # *
C #          IF(.NOT.NOCAPL(N))
C #      +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,3,'ONLY')
C # 	 N=N+2
C # 	 Z = Z -2*(2*CAPL(3)+2*CANS(3)+CAAB(3))
C #       ENDDO
C # *
C # *	I PARI
C # *
C #       X= 0.
C #       Y= 0.
C #       Z= CALB(3) + CAPL(3) - DCASIZ/2.
C # *END EM. (we have 0.15 cm from the top to the first Si)
C #       N= 2
C # *
C # *
C #       DO I=2,NCAPL,2
C # *
C # * X view, absorber and Y view on the other
C # *
C #          Z= Z - 2*CAPL(3)-2*(2*CAPL(3)+2*CANS(3)+CAAB(3))
C #          N= N + 1
C # *
C # * Check if this plane is excluded
C #          X= -0.10
C #          Y= -0.05
C # *
C #          IF(.NOT.NOCAPL(N))
C #      +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,0,'ONLY')
C # 	 X = 0.
C # 	 Y = 0.
C #          Z = Z - CAPL(3) - CANS(3)
C # *
C #        	 CALL GSPOS('CANS',N,'CALB',X,Y,Z,0,'ONLY')
C # *
C # * Check if this absorber is excluded
C # *
C #          N = N + 1
C #          Z = Z - CANS(3) - CAAB(3)
C # *     
C #          IF(.NOT.NOCAAB(I))
C #      +        CALL GSPOS('CAAB',(I-1),'CALB',X,Y,Z,0,'ONLY')
C # *
C # 	 Z= Z - CAAB(3) - CANS(3)
C # *
C #          CALL GSPOS('CANS',N,'CALB',X,Y,Z,3,'ONLY')
C #          Z= Z - CANS(3) - CAPL(3)
C #          X= 0.05
C #          Y= -0.10
C # *
C # *
C # * Check if this detector is excluded
C # *
C #          IF(.NOT.NOCAPL(N))
C #      +        CALL GSPOS('CAPL',N,'CALB',X,Y,Z,3,'ONLY')
C #          N = N + 2
C # *
C #       ENDDO
C # *END F.V.&ML.
C # * F.V.&ML.:
C # * again we have to comment with a 'C' per raw:
C # C*
C # C* Positioning volume CAPD and CAAD into the mother CALB
C # C*
C # C      N= 0
C # C      DO I=1,NCAPLD
C # C         IF(I.EQ.1) THEN
C # C            Z= Z - CAPD(3) - CAPL(3)
C # C         ELSE
C # C            Z= Z - 2*CAPD(3)
C # C         ENDIF
C # C         N= N + 1
C # C         CALL GSPOS('CAPD',N,'CALB',X,Y,Z,0,'ONLY')
C # C         Z= Z - CAPD(3) - CAAD(3)
C # C         CALL GSPOS('CAAD',(I-1),'CALB',X,Y,Z,0,'ONLY')
C # C         Z= Z - CAAD(3) - CAPD(3)
C # C         N= N + 1
C # C         CALL GSPOS('CAPD',N,'CALB',X,Y,Z,3,'ONLY')
C # C      ENDDO
C # * end comments.
C # *END F.V.&ML.
C # end MA comments
*
* Put the shell around it
*
      X= 0.
      Y= 0.
      Z= CALS(3)-CALB(3)
      N= 1
      CALL GSPOS('CALB',N,'CALS',X,Y,Z,0,'ONLY')
*
      RETURN
      END
