*
* $Id: gutrev.F,v 3.8 2006/05/11 00:14:48 cafagna Exp $
*
* $Log: gutrev.F,v $
* Revision 3.8  2006/05/11 00:14:48  cafagna
* A bug in hits retrival for calorimeter
*
* Revision 3.7  2006/05/02 12:07:42  bottai
* cleaning some strip variable
*
* Revision 3.6  2006/04/09 23:28:36  cafagna
* Several new things, among this: ND and CARD
*
* Revision 3.5  2005/10/18 08:32:13  cafagna
*  Bug fixed to avoid clone evnts in calorimeter
*
* Revision 3.4  2005/06/21 02:41:55  cafagna
* Major modification to the geometry and to the random number chain
*
* Revision 3.3  2004/04/06 10:33:45  pamela
* NON-REPRODUCIBILITY problem of a GPAMELA RUN fixed; bug found and fixed filling in the hit structure of the calorimeter
*
* Revision 3.2  2003/12/17 11:32:48  pamela
* CALO SIMULATION COMPLETED: geometry and special tracking parameters updated and simulation checked by a comparison with the Trieste's standalone Monte Carlo simulation
*
* Revision 3.1.1.1  2002/07/11 16:02:00  cafagna
* First GPAMELA release on CVS
*
*
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 24/02/2000  20.09.11  by  Francesco Cafagna
*CMZ :  1.00/02 06/02/96  17.34.50  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   30/11/95
      SUBROUTINE GUTREV
************************************************************************
*                                                                      *
*             User routine to control tracking of one event            *
*                                                                      *
* A new coding of the calorimeter strips have been added to the hit    * 
* structure.                                                           *
* The energy release calculated in gpucal is mapped for each silicon   *
* detector, i.e. nine pads for each plane. The plane is read by strips.* 
* Each strip is the sum of three pads.                                 *
* This is way at the end of the event we sum up the aligned strips of  *
* three pads in the ENEPROVA matrix. To track the sum pattern we       *
* provide a mapping matrix filled with the sum of 1,100 or 10000,      *
* depending on the hitted sector.                                      *
* This hit structure is added to the calorimeter detector CASI and     *
* filled at the end of the event                                       *
*                                                                      *
*                                                                      *
* Called by: GRUN                                                      *
* Author: Francesco Cafagna, 30/11/95 17.22.48                         *
*                                                                      *
************************************************************************
#include "gcflag.inc"
#include "gpgene.inc"
*ml:
#include "gpphit.inc"
      PARAMETER (NH=NHCALI,NHM=NHMCALI,NVOL=3,NVOL1=2)
#include "gpencal.inc"
#include "gpcal.inc"
#include "gpsed.inc"
#include "gpstripspe.inc"
#include "gcnum.inc"
*
      INTEGER MAPCASI(44,96)
C new hit structure for calorimeter:
      INTEGER NUMVOL(20),IDHIT
      REAL VHIT(NHCALI)
C
*end ml.
*
* User action
*
      CALL GPUTRE(1)
*
*     -----------------------------------------------------------------
*
*ET , SB 1/02/06      
c clean strip structure for SPE

      DO I=1,NPLANES
	DO II=1,NSENSORS
          DO III=1,NSTRIPX
		PROXTANTI(I,II,III)=0.
          ENDDO
          DO III=1,NSTRIPY
		PROYTANTI(I,II,III)=0.
	  ENDDO
	ENDDO
       ENDDO	
*end ET, SB  1/02/06

C
C # Increment number of event
C
      IEVNT = IEVNT +1
      ISSAVE = 1
      IENTR = 0
c      print *,' ievnt ',ievnt
      CALL GTREVE
c      print *,' ievnt ',ievnt,' ntmult ',ntmult
c new hit structure for calorimeter:
      CALL VZERO(VHIT,NHCALI)
c
      CALL VZERO(ENEPROVA,44*96)
      CALL VZERO(MAPCASI,44*96)
      if (ISSAVE.eq.1) THEN
         DO IPL=1,44
            DO IMOD=1,9
               DO IST=1,32
                  IF(ENEMAT(IPL,IMOD,IST).GT.0.) THEN
                     IF(IMOD.GE.1.AND.IMOD.LE.3) THEN
                        ENEPROVA(IPL,IST)=ENEPROVA(IPL,IST)+
     +                       ENEMAT(IPL,IMOD,IST)
                        IF(IMOD.EQ.1) MAPCASI(IPL,IST)=
     +                       MAPCASI(IPL,IST)+1
                        IF(IMOD.EQ.2) MAPCASI(IPL,IST)=
     +                    MAPCASI(IPL,IST)+100
                        IF(IMOD.EQ.3) MAPCASI(IPL,IST)=
     +                       MAPCASI(IPL,IST)+10000
                     ELSEIF(IMOD.GT.3.AND.IMOD.LT.7) THEN
                        ENEPROVA(IPL,IST+32)=ENEPROVA(IPL,IST+32)+
     +                       ENEMAT(IPL,IMOD,IST)
                        IF(IMOD.EQ.4) MAPCASI(IPL,IST+32)=
     +                       MAPCASI(IPL,IST+32)+1
                        IF(IMOD.EQ.5) MAPCASI(IPL,IST+32)=
     +                       MAPCASI(IPL,IST+32)+100
                        IF(IMOD.EQ.6) MAPCASI(IPL,IST+32)=
     +                       MAPCASI(IPL,IST+32)+10000
                     ELSEIF(IMOD.GE.7.AND.IMOD.LE.9) THEN
                        ENEPROVA(IPL,IST+64)=ENEPROVA(IPL,IST+64)+
     +                       ENEMAT(IPL,IMOD,IST)
                        IF(IMOD.EQ.7) MAPCASI(IPL,IST+64)=
     +                       MAPCASI(IPL,IST+64)+1
                        IF(IMOD.EQ.8) MAPCASI(IPL,IST+64)=
     +                       MAPCASI(IPL,IST+64)+100
                        IF(IMOD.EQ.9) MAPCASI(IPL,IST+64)=
     +                       MAPCASI(IPL,IST+64)+10000
                     ELSE
                        PRINT*,'IMOD=',IMOD
                     ENDIF
                  ENDIF
               ENDDO
            ENDDO
         ENDDO
c     filling the hit structure:
C     #       NTHCAL=0
         DO I=1,44
            DO II=1,96
               IF(ENEPROVA(I,II).GT.0.) THEN
                  VHIT(1)=MAPCASI(I,II)
                  VHIT(2)=ENEPROVA(I,II)
                  NUMVOL(1)=I
                  NUMVOL(2)=II
                  IS=ISCAL
                  ID=IDCASI
                  IDHIT=-1
                  CALL GSAHIT(IS,ID,1,NUMVOL,VHIT,IDHIT)
               ENDIF
            ENDDO
         ENDDO
      ENDIF
      CALL VZERO(ENEMAT,44*9*32)
         
*
* User action
*     
      CALL GPUTRE(2)
*     
*             Debug and plot tracks.
*
      CALL GDEBUG
      RETURN
      END
