*
* $Id: gustep.F,v 3.8 2008/01/21 18:52:45 pamela Exp $
*
* $Log: gustep.F,v $
* Revision 3.8  2008/01/21 18:52:45  pamela
* Printout wiped out
*
* Revision 3.7  2008/01/21 16:03:03  pamela
* Seconday particles tagged into the TOF hit structure
*
* Revision 3.6  2006/05/18 10:52:31  pam-ba
* TOF geometry completed and a new material, the polystyrene (density 35 g/l), added
*
* Revision 3.5  2006/05/02 11:46:13  pam-ba
* TOF geometry and position updated and a new material, the mylar, added
*
* Revision 3.4  2006/04/09 23:28:36  cafagna
* Several new things, among this: ND and CARD
*
* Revision 3.3  2005/12/20 12:21:03  cafagna
* gpnd directory added along with ND files
*
* Revision 3.2  2005/06/21 02:41:53  cafagna
* Major modification to the geometry and to the random number chain
*
* Revision 3.1.1.1  2002/07/11 16:02:00  cafagna
* First GPAMELA release on CVS
*
*
*CMZ :  3.00/00 04/02/2002  20.35.50  by  Unknown
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.05  by  Francesco Cafagna
*CMZ :  1.02/00 21/10/99  16.30.25  by  Francesco Cafagna
*CMZ :  1.01/00 02/05/96  09.27.53  by  Francesco Cafagna
*CMZ :  1.00/03 15/04/96  17.01.32  by  Francesco Cafagna
*CMZ :  1.00/02 04/04/96  16.51.20  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   30/11/95
      SUBROUTINE GUSTEP
************************************************************************
*                                                                      *
*                                                                      *
*                                                                      *
*             User routine called at the end of each tracking step     *
*             MEC   is the mechanism origin of the step                *
*             INWVOL is different from 0 when the track has reached    *
*                    a volume boundary                                 *
*             ISTOP is different from 0 if the track has stopped       *
*                                                                      *
*                                                                      *
* Called by: GTRACK                                                     *
* Author: Francesco Cafagna, 30/11/95 17.40.20                         *
*                                                                      *
************************************************************************
*
#include "gpques.inc"
#include "gctmed.inc"
#include "gckine.inc"
#include "gcking.inc"
#include "gcflag.inc"
#include "gctrak.inc"
#include "gcvolu.inc"
#include "gcsets.inc"
#include "gpkey.inc"
#include "gpsed.inc"
#include "gcnum.inc"
*
      INTEGER IFL,IN,MECNAM(MAXMEC)
      LOGICAL GPLOOK,DELT,IONIZ,STOPP
      INTEGER IPARTMOD
*
* User action
*
      if (ISSAVE.eq.1) THEN
      CALL GPUSTEP(1)
*
* Store the mechanisms active for the current step
*
      IF(NMEC.EQ.0)THEN
         MECNAM(1)=NAMEC(29)
      ELSE
         DO I=1,NMEC
            MEC=LMEC(I)
            IF(MEC.LE.MAXMEC) THEN
               MECNAM(I)=NAMEC(MEC)
            ELSEIF(MEC-100.LE.MAXME1.AND.MEC-100.GT.0) THEN
               MECNAM(I)=NAMEC1(MEC-100)
            ENDIF
         ENDDO
      ENDIF
*
      IN = INWVOL
*
* Look for ionization
*
      IONIZ = GPLOOK('LOSS',MECNAM,NMEC)
*
* Look for stopped particles
*
      STOPP = GPLOOK('STOP',MECNAM,NMEC)
*
* Look for Delta
*
      IF( (IPART.EQ.3.OR.IPART.EQ.2) ) THEN
         DELT = .TRUE.
      ELSE
         DELT = .FALSE.
      ENDIF
*
* Set the flag for action on detector
*
* IFL = 1 Ionization present
* IFL = 2 Particle stopped for Electrons (Delta)
* IFL = 3 Ionization present and particle stopped for Electrons (Delta)
* IFL = 4 Ionization not present in Xe by GEANT and particle charge
*         different from zero <--> ionization by GARFIELD
* IN  = 2 Forced in case the particle is stopped and is an electron
*
      IFL = -1
      IF (IONIZ) IFL = 1
      IF (STOPP.AND.DELT) THEN
         IFL = 2
         IN = 2
      ENDIF
      IF (IONIZ.AND.STOPP.AND.DELT) THEN
         IFL = 3
         IN = 2
      ENDIF
*
* Acts on a detector if there is an Ionization
*
C      IFL = -1
C      CALL GLOOK('LOSS',MECNAM,NMEC,IFL)
*
* Special patch for delta rays. Check if is an electron and have been stopped
* If is stopped then put IFL = 1 and INWVOL = 2
*
C      IF( (IPART.EQ.3.OR.IPART.EQ.2).AND.(IFL.LE.0) ) THEN
C         IFL = -1
C         CALL GLOOK('STOP',MECNAM,NMEC,IFL)
C         IF(IFL.GT.0) THEN
* This particle has been stoped. Force INWVOL to 2 to store the hit
C            IN =2
C         ENDIF
C      ENDIF
*
* Look for each detector and pass control to the related routine
*
      IF( (ISET.EQ.ISS1) .OR. (ISET.EQ.ISS2) .OR. (ISET.EQ.ISS3) .OR.
     +    (ISET.EQ.ISS4)
     +) THEN
* add 1000 to seconday particle ID
         IF(ISTAK.GT.0)THEN
            IPARTMOD = IPART + 1000
         ELSE
            IPARTMOD = IPART
         ENDIF
         CALL GPUTOF(IN,ISET,IDET,IPARTMOD,ITRA,DESTEP,TOFG,
     +        SLENG,VECT,NUMBV,IFL)
      ENDIF
*
* generate and absorb the transition radiation in TRD
*
      CALL GPXTR
      IF(IN.EQ.2.AND.ISET.EQ.ISTRD.AND.IDET.EQ.IDTRSI) THEN
      ENDIF
      IF (ISET.EQ.ISTRD.AND.IDET.EQ.IDTRSO) THEN
#if defined(GPAMELA_GARFIELD)
C # Force IFL to one in case we are in the Xenon gas with no ionization
         IF( .NOT.IONIZ.AND.(CHARGE.NE.0) ) THEN
C # OK looks like we are in the Xenon without the ionization
            IFL = 4
         ENDIF
#endif
         CALL GPUTRD(IN,ISET,IDET,IPART,ITRA,DESTEP,SLENG,VECT,
     +               NUMBV,IFL)
      ENDIF
      IF (ISET.EQ.ISCAT) THEN
         CALL GPUCAT(IN,ISET,IDET,IPART,ITRA,DESTEP,TOFG,SLENG,VECT,
     +               NUMBV,IFL)
      ENDIF
      IF (ISET.EQ.ISCARD) THEN
         CALL GPUCARD(IN,ISET,IDET,IPART,ITRA,DESTEP,TOFG,SLENG,VECT,
     +               NUMBV,IFL)
      ENDIF
      IF (ISET.EQ.ISCAS) THEN
         CALL GPUCAS(IN,ISET,IDET,IPART,ITRA,DESTEP,TOFG,SLENG,VECT,
     +               NUMBV,IFL)
      ENDIF
      IF (ISET.EQ.ISSPE) THEN
         CALL GPUSPE(IN,ISET,IDET,IPART,ITRA,DESTEP,SLENG,VECT,
     +               NUMBV,IFL)
      ENDIF
c      print *,' iqua '
c      if ( istak.eq.0.and.vect(3).le.20.5.and.nalive.le.130) then
c      if ( istak.eq.0.and.vect(3).le.19.754.and.nalive.le.160) then
      if ( istak.eq.0.and.vect(3).le.19.754.and.nalive.le.170) then
c      if ( istak.eq.0.and.vect(3).le.19.754) then
c         print *,' vect 3 ',vect(3),' ntmult ',ntmult,' ipart ',ipart
c         print *,' ntrack ',ntrack,' nalive ',nalive
c         issave = 1 ! QUIQUIQUIQUIQUIQ
         issave = 0 ! QUIQUIQUIQUIQUIQ
      endif
      IF ((ISET.EQ.ISCAL).AND.(IDET.EQ.IDCAST)) THEN
         if (vect(3).ge.22.5.and.istak.eq.0) then
            ientr = 1
         endif
         if (vect(3).le.18.and.ientr.eq.0) then
c         issave = 1 ! QUIQUIQUIQUIQUIQ
            issave = 0
         endif
c         print *,' qua ',istak,' Z = VECT (3) ',VECT(3)
         CALL GPUCAL(IN,ISET,IDET,IPART,ITRA,DESTEP,SLENG,VECT,
     +               NUMBV,IFL)
c         print *,' qui ',VECT(3),' ntmult ',ntmult
      ENDIF
c      print *,' iua '
      IF ((ISET.EQ.ISND).AND.(IDET.EQ.IDNDTI)) THEN
         CALL GPUND(IN,ISET,IDET,IPART,ITRA,DESTEP,TOFG,SLENG,VECT,
     +               NUMBV,IFL)
      ENDIF
*
* implement gigantic resonance if we are inside a tungsten plane
*
      IF((IPART.EQ.1).AND.GPLOOK('CAAB',NAMES,NLEVEL)) THEN
         CALL GPGIG
      ENDIF
*
*             Something generated ? Store it as a new track.
*
   10 IF(NGKINE.GT.0) THEN
         DO 20 I=1,NGKINE
c Ml: 4/2/2002
c            IFLGK(I)=1
            IFLGK(I)=0
c end Ml.
            ITYPA = GKIN(5,I)
            IF(ITYPA.NE.4) CALL GSKING(I)
   20    CONTINUE
      ENDIF
*
* User action
*
      CALL GPUSTEP(2)
*
*             Debug/plot event
*
      CALL GDEBUG
      ENDIF
      RETURN
      END
