*
* $Id: gpsed.F,v 3.11 2006/05/02 18:00:10 cafagna Exp $
*
* $Log: gpsed.F,v $
* Revision 3.11  2006/05/02 18:00:10  cafagna
* Bugs fixed in TOF set definition, TOF hit back to the original naming scheme
*
* Revision 3.10  2006/05/02 11:44:49  pam-ba
* TOF geometry and position updated and a new material, the mylar, added
*
* Revision 3.9  2006/05/02 11:21:51  pam-ba
* TOF geometry and position updated and a new material, the mylar, added
*
* Revision 3.8  2006/04/09 23:28:35  cafagna
* Several new things, among this: ND and CARD
*
* Revision 3.7  2006/02/05 22:13:33  cafagna
* A bug in the SPEctrometr hit definition fixed
*
* Revision 3.6  2005/12/20 12:21:03  cafagna
* gpnd directory added along with ND files
*
* Revision 3.5  2005/08/25 11:13:03  lundq
* corrected CAS numbering
*
* Revision 3.4  2005/07/25 11:53:20  cafagna
* Several updates. See history for details
*
* Revision 3.3  2005/06/21 02:41:51  cafagna
* Major modification to the geometry and to the random number chain
*
* Revision 3.2  2002/12/04 15:12:54  pamela
* CAS and CALO geometry modified
*
* Revision 3.1.1.1  2002/07/11 16:02:00  cafagna
* First GPAMELA release on CVS
*
*
*               19/09/2002  11.20.48  by  Jens Lund
*CMZ :  3.00/00 06/04/2001  14.50.18  by  Marialuigia Ambriola
*CMZ :  2.03/00 06/11/2000  01.09.51  by  Francesco Cafagna
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 28/02/2000  18.48.57  by  Francesco Cafagna
*CMZ :  1.02/00 04/02/2000  20.31.22  by  Francesco Cafagna
*CMZ :  1.01/00 16/05/96  17.38.13  by  Francesco Cafagna
*CMZ :  1.00/02 28/03/96  23.38.53  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   30/11/95
      SUBROUTINE GPSED
*********************************************************************
*
* To define sets, detectors and HITS
*
* The USER set numbers are:
*  S1  = 1
*  S2  = 2
*  S3  = 3
*  S4  = 4
*  TRD = 5
*  CAT = 6
*  CAS = 7
*  SPE = 8
*  CAL = 9
*  ND  = 10
*  CARD= 11
*
* The USER detector numbers are, inside the SET structure,:
*  S11Y= 1
*  S12X= 2
*  S21X= 1
*  S22Y= 2
*  S31Y= 1
*  S32X= 2
*  CHAE= 1
*  TRSI= 1
*JeL:
*C  CATL= 1
*C  CATT= 2
*  TOP1= 1
*C  CASX= 1
*C  CASY= 2
*  SID1= 1
*END: JeL.
*  TSPA= 1
*  CASI= 2
*  CAST= 1, in case the division have been requested
*
* The USER detector type are:
*  1, scintillator counter
*  2, aerogel
*  3, TRD
*  4, silicon detector
*
* Called by: UGINIT
* Author: F. Cafagna 13/02/96 13.21.27                               *
*                                                                    *
**********************************************************************
#include "gpgeo.inc"
#include "gpkey.inc"
#include "gpsed.inc"
*
      INTEGER NBITSV(6),NWHI,NWDI
      CHARACTER*4 CVOLU(6)
*
      CALL VZERO(NBITSV,6)
      NWHI = 100
      NWDI = 100
*
c      CVOLU(1) ='PAME'
*
* Tof
*
      IF(PTOF) THEN
         NVTOF = 2
         NBITSV(1) = 4
         NBITSV(2) = 2
         CVOLU(1) ='S11M'
         CVOLU(2) ='S11Y'
         CVOLU(3) ='    '
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
         CALL GSDET('S1  ','S11Y',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
     +        ISS1,IDS11Y)
         CNSED(ISS1,IDS11Y) = CVOLU(NVTOF)
*
         NBITSV(1) = 3
         CVOLU(1) ='S12M'
         CVOLU(2) ='S12X'
         CALL GSDET('S1  ','S12X',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISS1,IDS12X)
         CNSED(ISS1,IDS12X) = CVOLU(NVTOF)
*
         NBITSV(1) = 2
         CVOLU(1) ='S21M'
         CVOLU(2) ='S21X'
         CALL GSDET('S2  ','S21X',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISS2,IDS21X)
         CNSED(ISS2,IDS21X) = CVOLU(NVTOF)
*
         NBITSV(1) = 2
         CVOLU(1) ='S22M'
         CVOLU(2) ='S22Y'
         CALL GSDET('S2  ','S22Y',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISS2,IDS22Y)
         CNSED(ISS2,IDS22Y) = CVOLU(NVTOF)
*
         NBITSV(1) = 2
         CVOLU(1) ='S31M'
         CVOLU(2) ='S31Y'
         CALL GSDET('S3  ','S31Y',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISS3,IDS31Y)
         CNSED(ISS3,IDS31Y) = CVOLU(NVTOF)
*
         NBITSV(1) = 2
         CVOLU(1) ='S32M'
         CVOLU(2) ='S32X'
         CALL GSDET('S3  ','S32X',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISS3,IDS32X)
         CNSED(ISS3,IDS32X) = CVOLU(NVTOF)
*
*ML:
*         NVTOF =1
         NVS4=1
*END ML.
         CVOLU(1) ='S4  '
         CVOLU(2) ='    '
*ML:
*         CALL GSDET('S4  ','S4  ',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
*     +   ISS4,IDS4)
         CALL GSDET('S4  ','S4  ',NVS4,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISS4,IDS4)
*         CNSED(ISS4,IDS4) = CVOLU(NVTOF)
         CNSED(ISS4,IDS4) = CVOLU(NVS4)
*END ML.
      ELSE
         ISS1  = -1
         IDS11Y = -1
         IDS12X = -1
         ISS2  = -1
         IDS21X = -1
         IDS22Y = -1
         ISS3   = -1
         IDS31Y = -1
         IDS32X = -1
         ISS4   = -1
         IDS4   = -1
      ENDIF
*
* TRD
*
      IF(PTRD) THEN

         NVTRD = 2
c         NBITSV(1) = 1
c         NBITSV(2) = 1
         NBITSV(1) = 6
         NBITSV(2) = 6
c         CVOLU(2) ='TRDB'
         CVOLU(1) ='TRBS'
         CVOLU(2) ='TRSI'
         CVOLU(3) ='    '
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
         CALL GSDET('TRD ','TRSI',NVTRD,CVOLU,NBITSV,3,NWHI,NWDI,
     +        ISTRD,IDTRSI)
         CNSED(ISTRD,IDTRSI) = CVOLU(NVTRD)
*     ML:
 	 NVTRD=3
         NBITSV(3) = 2
         CVOLU(3) = 'TRSO'
 	 CALL GSDET('TRD ','TRSO',NVTRD,CVOLU,NBITSV,3,NWHI,NWDI,
     +        ISTRD,IDTRSO)
         CNSED(ISTRD,IDTRSO) = CVOLU(NVTRD)
****** DON'T MODIFY !!!!!! SEE GPDTRD
         NVTRD = 2
*END ML.
*
      ELSE
         ISTRD = -1
         IDTRSI= -1
*ML:
	 IDTRSO= -1
*END ML.
      ENDIF
*
* CAT
*
      IF(PCAT) THEN
*JeL:
C         NVCAT = 2
         NVCAT = 1
c         NBITSV(1) = 1
         NBITSV(1) = 1
C         NBITSV(2) = 2
C         CVOLU(1) ='CATB'
C         CVOLU(2) ='CATL'
         CVOLU(1) ='TOP1'
         CVOLU(2) ='    '
         CVOLU(3) ='    '
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
C         CALL GSDET('CAT ','CATL',NVCAT,CVOLU,NBITSV,1,NWHI,NWDI,
C     +   ISCAT,IDCATL)
         CALL GSDET('CAT ','TOP1',NVCAT,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISCAT,IDCATL)
         CNSED(ISCAT,IDCATL) = CVOLU(NVCAT)
C         CVOLU(2) ='CATT'
C         CALL GSDET('CAT ','CATT',NVCAT,CVOLU,NBITSV,1,NWHI,NWDI,
C     +   ISCAT,IDCATT)
C         CNSED(ISCAT,IDCATT) = CVOLU(NVCAT)
      ELSE
         ISCAT = -1
C         IDCATT= -1
         IDCATL= -1
*END: JeL.
      ENDIF
*
* CAS
*
      IF(PCAS) THEN
*JoLu 05-08-25
*         NVCAS = 1
         NVCAS = 4
*JeL:
c         NBITSV(1) = 1
         NBITSV(1) = 4
C         CVOLU(1) ='CASX'

*JoLu 05-08-25
*         CVOLU(1) ='SID1'
*         CVOLU(2) ='    '
*         CVOLU(3) ='    '
*         CVOLU(4) ='    '
         CVOLU(1) ='CASA'
         CVOLU(2) ='STRP'
         CVOLU(3) ='PLA1'
         CVOLU(4) ='SID1'
         CVOLU(5) ='    '
         CVOLU(6) ='    '
C         CALL GSDET('CAS ','CASX',NVCAS,CVOLU,NBITSV,1,NWHI,NWDI,
C     +   ISCAS,IDCASX)
         CALL GSDET('CAS ','SID1',NVCAS,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISCAS,IDCASX)
         CNSED(ISCAS,IDCASX) = CVOLU(NVCAS)
C         CVOLU(1) ='CASY'
C         CALL GSDET('CAS ','CASY',NVCAS,CVOLU,NBITSV,1,NWHI,NWDI,
C     +   ISCAS,IDCASY)
C         CNSED(ISCAS,IDCASY) = CVOLU(NVCAS)
*END: JeL.
      ELSE
         ISCAS = -1
         IDCASX= -1
      ENDIF
*
* SPE
*
      IF(PSPE) THEN
         NVSPE = 3
         NBITSV(1) = 3
         NBITSV(2) = 3
         NBITSV(3) = 3
         NBITSV(4) = 3
         NBITSV(5) = 2
         CVOLU(1) ='MGFR'
c$$$         CVOLU(2) ='TRPB'
c$$$         CVOLU(3) ='TPAS'
         CVOLU(2) ='TRSL'
         CVOLU(3) ='TSPA'
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
         CALL GSDET('SPE ','TSPA',NVSPE,CVOLU,NBITSV,4,NWHI,NWDI,
     +   ISSPE,IDTSPA)
         CNSED(ISSPE,IDTSPA) = CVOLU(NVSPE)
      ELSE
         ISSPE = -1
         IDTSPA= -1
      ENDIF
*
* CAL
*
      IF(PCAL) THEN
c         NBITSV(1) = 1
c         NBITSV(2) = 1
c         NBITSV(1) = INT(LOG(FLOAT(2*NCAPL))/LOG(2.)) + 1
c         NBITSV(3) = INT(LOG(FLOAT(NCASTR))/LOG(2.))+1
         NBITSV(1) = 8
         NBITSV(2) = 4
         NBITSV(3) = 8
         CVOLU(1) ='CAPL'
         CVOLU(2) ='CASI'
         CVOLU(3) ='CAST'
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
         NVCAL = 3
         CALL GSDET('CAL ','CAST',NVCAL,CVOLU,NBITSV,4, NWHI,NWDI,
     +      ISCAL,IDCAST)
         CNSED(ISCAL,IDCAST) = CVOLU(NVCAL)
*
* CAL second detector to store the energy released per strip
*
         NBITSV(1) = 8
         NBITSV(2) = 8
         CVOLU(1) ='CAPL'
         CVOLU(2) ='CASI'
         CVOLU(3) ='    '
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
         NVCALI = 2
         CALL GSDET('CAL ','CASI',NVCALI,CVOLU,NBITSV,4, NWHI,NWDI,
     +      ISCAL,IDCASI)
         CNSED(ISCAL,IDCASI) = CVOLU(NVCALI)
      ELSE
         ISCAL  = -1
         IDCASI = -1
         IDCAST = -1
      ENDIF
*
* ND
*
      IF(PND) THEN
         NVND = 2
         NBITSV(1) = 6
         NBITSV(2) = 6
         CVOLU(1) ='NDTU'
         CVOLU(2) ='NDTI'
         CVOLU(3) ='    '
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
         CALL GSDET('ND  ','NDTI',NVND,CVOLU,NBITSV,3,NWHI,NWDI,
     +        ISND,IDNDTI)
         CNSED(ISND,IDNDTI) = CVOLU(NVND)
      ELSE
         ISND = -1
         IDNDTI= -1
      ENDIF
*
* CARD
*
      IF(PCARD) THEN
         NVCARD = 2
         NBITSV(1) = 3
         CVOLU(1) ='CAR1'
         CVOLU(2) ='C1D1'
         CVOLU(3) ='    '
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
         CALL GSDET('CARD','C1D1',NVCARD,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISCARD,IDCAR1)
         CNSED(ISCARD,IDCAR1) = CVOLU(NVCARD)
         CVOLU(1) ='CAR2'
         CVOLU(2) ='C2D1'
         CALL GSDET('CARD','C2D1',NVCARD,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISCARD,IDCAR2)
         CNSED(ISCARD,IDCAR2) = CVOLU(NVCARD)
      ELSE
         ISCARD = -1
         IDCAR1 = -1
         IDCAR2 = -1
      ENDIF
*
* User action
*
      CALL GPUSED
      CALL GPSETS('*','*')
*
      RETURN
      END
