*
* $Id: gpgeo.F,v 3.15 2006/11/16 18:45:28 pam-ba Exp $
*
* $Log: gpgeo.F,v $
* Revision 3.15  2006/11/16 18:45:28  pam-ba
* Simulated an aluminum container for S4
*
* Revision 3.14  2006/11/16 12:01:12  pam-ba
* S4 dimensions corrected.
*
* Revision 3.13  2006/11/10 11:39:33  pam-ba
* S2 and S1 z-positions corrected, He3 and plystyrene mixture added, Top Plate geometry simulated and titanium mixture added.
*
* Revision 3.12  2006/10/12 11:11:20  pam-ba
* ND geometry updated.
*
* Revision 3.11  2006/10/02 11:17:29  pam-ba
* NDET 'SPHE' data card meaning changed. Now it eliminates the whole PAMELA container.
*
* Revision 3.10  2006/05/18 10:52:31  pam-ba
* TOF geometry completed and a new material, the polystyrene (density 35 g/l), added
*
* Revision 3.9  2006/05/02 15:23:14  cafagna
* Few mispelled command in gpgeo.inc and gpgeo.F
*
* Revision 3.8  2006/05/02 11:07:05  pam-ba
* TOF geometry and position updated and a new material, the mylar, added
*
* Revision 3.7  2006/04/09 23:28:33  cafagna
* Several new things, among this: ND and CARD
*
* Revision 3.6  2005/12/14 03:12:41  cafagna
* Neutron detector added. Geometry and GPCALOR package
*
* Revision 3.5  2005/12/05 12:15:20  pam-ba
* new spectrometer geometry and internal magnetic field
*
* Revision 3.4  2005/07/25 11:53:20  cafagna
* Several updates. See history for details
*
* Revision 3.3  2005/06/21 02:41:47  cafagna
* Major modification to the geometry and to the random number chain
*
* Revision 3.2  2002/12/04 15:12:54  pamela
* CAS and CALO geometry modified
*
* Revision 3.1.1.1  2002/07/11 16:02:00  cafagna
* First GPAMELA release on CVS
*
*
*               16/07/2004  16.44.06  by  Alexey Bakaldin
*               15/10/2002  15.29.36  by  Jens Lund
*CMZ :  3.00/00 13/11/2000  09.03.11  by  Emiliano Mocchiutti
*CMZ :  2.01/00 05/04/2000  14.35.17  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.05  by  Francesco Cafagna
*CMZ :  1.02/00 08/11/99  18.44.50  by  Francesco Cafagna
*CMZ :  1.01/00 13/05/96  09.16.26  by  Francesco Cafagna
*CMZ :  1.00/02 04/04/96  12.00.53  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   05/12/95
      SUBROUTINE GPGEO
************************************************************************
*                                                                      *
* Volumes definition for PAMELA                                        *
*                                                                      *
* Called by: UGINIT                                                    *
* Author: Francesco Cafagna, 05/12/95 13.21.27                         *
*                                                                      *
************************************************************************
#include "gpgeo.inc"
#include "gpmed.inc"
#include "gpkey.inc"
#include "gprot.inc"
#include "gpdrot.inc"
*
      INTEGER IROT,IVOLU,N,NMED,NUM
      REAL X,Y,Z
*
*  Define 90 degree rotation around Z axis
*
      CALL GSROTM(RZ90,90.,90.,90.,180.,0.,0.)
*
*  Define 90 degree rotation around X axis
*
      CALL GSROTM(RX90,90.,0.,180.,90.,90.,90.)
*
*  Define 90 degree rotation around Z axis and 180 along X
*
      CALL GSROTM(RZ90X180,90.,90.,90.,360.,180.,0.)
*
*  Define 180 degree rotation around Z axis
*
      CALL GSROTM(RZ180,90.,180.,90.,270.,0.,0.)
*JeL:
*
*  Define 180 degree rotation aroun Z axis and 180 along X
*
      CALL GSROTM(RZ180X180,90.,180.,90.,90.,180.,0.)
*
*  Define 270 degree rotation around Z axis
*
      CALL GSROTM(RZ270,90.,270.,90.,360.,0.,0.)
*
*  Define 90 degree rotation around Y axis
*
      CALL GSROTM(RY90,0.,0.,90.,90.,90.,180.)
*
*  Define 270 degree rotation around Y axis
*
      CALL GSROTM(RY270,180.,0.,90.,90.,90.,0.)
*
*  Define 180 degree rotation around Y axis
*
      CALL GSROTM(RY180,90.,180.,90.,90.,180.,0.)
*
*  Define 180 degree rotation around X axis
*
      CALL GSROTM(RX180,90.,0.,90.,270.,180.,0.)

*END: JeL.
*
*  Define the PAMELA   volume
*
      NMED=MN2
      CALL GSVOLU('PAME','TUBE',NMED,PAME, 3,IVOLU)
*AB:
*
*  Define the Aluminium shell volumes
*
      NMED=MAL
C      CALL GSVOLU('SHEL','TUBE',NMED,SHEL, 3,IVOLU)
      CALL GSVOLU('SHEL','CONE',NMED,SHEL, 5,IVOLU)
*
*  Define the Aluminium inner shell volumes
*
      IF(SPH) THEN
         NMED=MAL
         CALL GSVOLU('TSPH','SPHE',NMED,TSPH, 6,IVOLU)
c      ELSE
c         NMED=MAL
c         CALL GSVOLU('TFLA','TUBE',NMED,TFLA, 3,IVOLU)
c      ENDIF
*
*  Define the Aluminium shell volumes
*
         NMED=MAL
         CALL GSVOLU('MSHE','TUBE',NMED,MSHE, 3,IVOLU)
*
*  Define the Aluminium shell volumes
*
         NMED=MAL
         CALL GSVOLU('BSPH','SPHE',NMED,BSPH, 6,IVOLU)
*END: AB.
c ml: 28/10/04 
      ENDIF
*
*  Define the top plate  
*
c      NMED=MTAV
      NMED=MN2
      CALL GSVOLU('TPLA','BOX ',NMED,TPLA, 3,IVOLU)
      NMED=MTAV
      CALL GSVOLU('TPTU','BOX ',NMED,TPTU,3,IVOLU)
      NMED=MTAV
      CALL GSVOLU('TPTM','BOX ',NMED,TPTM,3,IVOLU)
      NMED=MTAV
      CALL GSVOLU('TPTL','BOX ',NMED,TPTL,3,IVOLU)
      NMED=MN2
      CALL GSVOLU('TPCV','BOX ',NMED,TPCV,3,IVOLU)
*
* Volume definition for scintillators, TOF and anticoincidence counter
*
      IF(TOF ) CALL GPTOFV
      IF(CAT ) CALL GPCATV
      IF(CAS ) CALL GPCASV
      IF(CARD) CALL GPCARDV
*
* Volume definition for TRD
*
      IF(TRD ) CALL GPTRDV
*
* Volume definition for Spectrometer
*
      IF(SPE ) CALL GPSPEV
*
* Volume definition for Calorimeter
*
      IF(CAL ) CALL GPCALV
*
* Volume definition for ND
*
      IF(ND  ) CALL GPNDV
*
*  Volume positioning starting from the TOP
*
      IF(SPH) THEN
         X= 0.
         Y= 0.
*
* Positioning volume SHEL     into the mother PAME
*
         N= 1
         Z= ZSHEL
         CALL GSPOS('SHEL',N,'PAME',X,Y,Z,0,'ONLY')
*
* Positioning volume SHEI     into the mother PAME
*
C         N= 1
C         Z= ZSHEI
c         CALL GSPOS('SHEI',N,'PAME',X,Y,Z,0,'ONLY')
C         IF(SPH) THEN
*
* Positioning volume TSPH     into the mother PAME
*
         N= 1
         Z= ZTSPH
         CALL GSPOS('TSPH',N,'PAME',X,Y,Z,0,'ONLY')
C      ELSE
C*
C* Positioning volume TFLA     into the mother PAME
C*
C         N= 1
C         Z= ZTFLA
C         CALL GSPOS('TFLA',N,'PAME',X,Y,Z,0,'ONLY')
C      ENDIF
*AB:
*
* Positioning volume MSHE     into the mother PAME
*
         N= 1
         Z= ZMSHE
         CALL GSPOS('MSHE',N,'PAME',X,Y,Z,0,'ONLY')
*
* Positioning volume BSPH     into the mother PAME
*
         N= 1
         Z= ZBSPH
         CALL GSPOS('BSPH',N,'PAME',X,Y,Z,0,'ONLY')
* END: AB.
      ENDIF
*
* Positioning volume S1     into the mother PAME
*
      N= 1
c$$$<<<<<<< gpgeo.F
      Z= ZS1
      IF(TOF) CALL GSPOS('S1  ',N,'PAME',X,Y,Z,0,'ONLY')
c$$$=======
c$$$c ml:24/11/04
c$$$cc      Z=ZCAL+CALS(3)+ZSPEBP+2*(SPEB(3)+TPLA(3)+S22(3)+S21(3)+CATA(2))+ 
c$$$cc     +     2*TRDB(3)+2*S12(3)+S11(3)
c$$$cc      print*,'gpgeo: xs11, ys11, zs11=',x,y,z
c$$$C      Z= ZS11
c$$$cc      IF(TOF) CALL GSPOS('S11 ',N,'PAME',X,Y,Z,0,'ONLY')
c$$$>>>>>>> 3.7
c$$$c end ml.
*
* Positioning volume S2     into the mother PAME
*
c      N= 1
c$$$<<<<<<< gpgeo.F
C ML:
C      Z= ZS2
C      IF(TOF) CALL GSPOS('S2  ',N,'PAME',X,Y,Z,0,'ONLY')
CC      Z=-TPS2(3)+S2(3)
CC      IF(TOF) CALL GSPOS('S2  ',N,'TPS2',X,Y,Z,0,'ONLY')
c$$$=======
c$$$c ml:24/11/04
c$$$cc      Z=ZCAL+CALS(3)+ZSPEBP+2*(SPEB(3)+TPLA(3)+S22(3)+S21(3)+CATA(2))+ 
c$$$cc     +     2*TRDB(3)+S12(3)
c$$$C      Z= ZS12
c$$$cc      print*,'gpgeo: xs12, ys12, zs12=',x,y,z
c$$$cc      IF(TOF) CALL GSPOS('S12 ',N,'PAME',X,Y,Z,0,'ONLY')
c$$$>>>>>>> 3.7
c$$$c end ml.
*
* Positioning volume TRDB     into the mother PAME
*
      IF(TRD) THEN
         N= 1
         Z= ZTRD
         CALL GSPOS('TRDB',N,'PAME',X,Y,Z,0,'ONLY')
c end ml.
C FC commented out on 21-10-1999 by caf
c         CALL GSPOS('TRDS',N,'PAME',X,Y,Z,0,'ONLY')
c         Z= ZTRD - TRDS(3) - TRDT(3)
c         CALL GSPOS('TRDT',N,'PAME',X,Y,Z,0,'ONLY')
c         N= 2
c         Z= ZTRD + TRDS(3) + TRDT(3)
c         CALL GSPOS('TRDT',N,'PAME',X,Y,Z,0,'ONLY')
C FC end of comment on 21-10-1999
      ENDIF
*
* Positioning volume CARD    into the mother PAME
*
      IF(CARD) THEN
         N=1
         X=0
         Y=0
         Z=ZTPLA+TPLA(3)+CARDB(3)
         CALL GSPOS('CARD',N,'PAME',X,Y,Z,0,'ONLY')
      ENDIF

c$$$*
c$$$* Positioning volume S21     into the mother PAME
c$$$*
c$$$      N= 1
c$$$c ml:24/11/04
c$$$      Z=ZCAL+CALS(3)+ZSPEBP+2*SPEB(3)+2*TPLA(3)+2*S22(3)+S21(3)
c$$$c      Z= ZS21
c$$$      print*,'gpgeo: xs21, ys21, zs21=',x,y,z
c$$$      IF(TOF) CALL GSPOS('S21 ',N,'PAME',X,Y,Z,0,'ONLY')
c$$$c  end ml.
c$$$*
c$$$* Positioning volume S22     into the mother PAME
c$$$*
c$$$      N= 1
c$$$c ml:24/11/04
c$$$      Z=ZCAL+CALS(3)+ZSPEBP+2*SPEB(3)+2*TPLA(3)+S22(3)
c$$$c      Z= ZS22
c$$$      print*,'gpgeo: xs22, ys22, zs2=',x,y,z
c$$$      IF(TOF) CALL GSPOS('S22 ',N,'PAME',X,Y,Z,0,'ONLY')
c$$$c end ml.
c$$$>>>>>>> 3.7
c ml: 28/10/04
*
*  Positioning volume TPLA into the mother PAME
*
      N=1
      X=0.
      Y=0.
      Z=ZTPLA
      CALL GSPOS('TPLA',N,'PAME',X,Y,Z,0,'ONLY')
      Z=-TPLA(3)+TPTL(3)
      CALL GSPOS('TPTL',N,'TPLA',X,Y,Z,0,'ONLY')
      Z=0.
      CALL GSPOS('TPCV',N,'TPTL',X,Y,Z,0,'ONLY')
      N=1
      Z=-TPLA(3)+2*TPTL(3)+S2(3)
      CALL GSPOS('S2  ',N,'TPLA',X,Y,Z,0,'ONLY')
      N=0
      Z=-TPLA(3)+2*TPTL(3)+S2(3)
      DO I=1,4
         N=N+1
         IF(MOD(I,2).EQ.1) THEN
            Y=-(YTPLA-TPTM(2))
            IF(I.EQ.1) X=-(XTPLA-TPTM(1))
            IF(I.EQ.3) X=(XTPLA-TPTM(1))
         ELSE
            Y=(YTPLA-TPTM(2))
            IF(I.EQ.2) X=-(XTPLA-TPTM(1))
            IF(I.EQ.4) X=(XTPLA-TPTM(1))
         ENDIF
         CALL GSPOS('TPTM',N,'TPLA',X,Y,Z,0,'ONLY')  
      ENDDO
      N=1
      X=0.
      Y=0.
      Z=TPLA(3)-CATA(2)
      CALL GSPOS('CATA',N,'TPLA',X,Y,Z,2,'ONLY')
      N=0
      Z=TPLA(3)-TPTU(3)
      DO I=1,4
         N=N+1
         IF(MOD(I,2).EQ.1) THEN
            Y=-(YTPLA-TPTU(2))
            IF(I.EQ.1) X=-(XTPLA-TPTU(1))
            IF(I.EQ.3) X=(XTPLA-TPTU(1))
         ELSE
            Y=(YTPLA-TPTU(2))
            IF(I.EQ.2) X=-(XTPLA-TPTU(1))
            IF(I.EQ.4) X=(XTPLA-TPTU(1))
         ENDIF
         CALL GSPOS('TPTU',N,'TPLA',X,Y,Z,0,'ONLY')
      ENDDO
      X=0.
      Y=0.
*JeL:
*
* Positioning volume CATA     into the mother PAME
*
      N= 1
C ML      Z= ZCAT
C Com. by JeL IF(CAT) CALL GSPOS('CATB',N,'PAME',X,Y,Z,0,'ONLY')
C ML:      IF(CAT) CALL GSPOS('CATA',N,'PAME',X,Y,Z,2,'ONLY')
C      Z=0.
C      IF(CAT) CALL GSPOS('CATA',N,'TPCA',X,Y,Z,2,'ONLY')
c end ml.
*END: JeL.
*
* Positioning volume CAS      into the mother PAME
*
*EM:
*JeL:
C      Z= ZCAS
c       Z= ZSPEC-2.1
      Z=ZCAS
*end JeL.
      IF(CAS) THEN
*com by JeL:
CC         X = 0
C         N = 0
C         DO I = 1,2
C            X = ((-1)**(I+1))*CASXD
CC            Y = ((-1)**I)*( CASY(2) + CASX(2) )
C            Y = ((-1)**I)*CASY(2)
Cc fc mod by caf on 21-10-1999
Cc            DO II=1, 5
Cc               Z = ZCAS - 4.*CASX(3) + (II-1) * 2*CASX(3)
Cc               N = N + 1
Cc               CALL GSPOS('CASX',N,'PAME',X,Y,Z,0,'ONLY')
Cc            ENDDO
Cc fc end mod
C            Z = ZCAS
C            N = N + 1
C*
C            CALL GSPOS('CSSX',N,'PAME',X,Y,Z,0,'ONLY')
C         ENDDO
C*
CC         Y = 0
C         N = 0
C         DO I = 1,2
C            X = ((-1)**I)*(CASX(1)+0.1)
CC            X = ((-1)**I)*(CASX(1)+CASY(1))
C            Y = ((-1)**I)*CASYD
Cc fc mod by caf on 21-10-1999
Cc            DO II=1, 5
Cc               Z = ZCAS - 4.*CASY(3) + (II-1) * 2*CASY(3)
Cc               N = N + 1
Cc               CALL GSPOS('CASY',N,'PAME',X,Y,Z,0,'ONLY')
Cc            ENDDO
Cc fc end mod
C            Z = ZCAS
C            N = N + 1
C            CALL GSPOS('CSSY',N,'PAME',X,Y,Z,0,'ONLY')
C         ENDDO
*end com by JeL.
*JeL:
         N = 1
*ML:
C         X = 10.75
         X = 8.872
C         Y = -14.1
         Y = -17.215
*END ML.
         CALL GSPOS('CASA',N,'PAME',X,Y,Z,0,'ONLY')
         N = 2
*ML:
C         X = 14.1
         X = 17.9285
C         Y = 10.75
         Y = 6.305
*END ML.
         CALL GSPOS('CASA',N,'PAME',X,Y,Z,1,'ONLY')
         N = 3
*ML:
C         X = -10.75
         X = -5.5095
C         Y = 14.1
         Y = 17.215
*END ML.
         CALL GSPOS('CASA',N,'PAME',X,Y,Z,4,'ONLY')
         N = 4
*ML:
C         X = -14.1
         X = -17.9285
C         Y = -10.75
         Y = -10.195
*END ML.
         CALL GSPOS('CASA',N,'PAME',X,Y,Z,6,'ONLY')
*end JeL.
      ENDIF
*END: EM.
*
* Positioning volume SPEB     into the mother PAME
*
      N= 1
      X= 0.
      Y= 0.
      Z= ZSPEC
      IF(SPE) CALL GSPOS('SPEB',N,'PAME',X,Y,Z,0,'ONLY')
c end ml.
*
* Positioning volume S3     into the mother PAME
*
      N= 1
      X= 0.
      Y= 0.
      Z= ZS3
      IF(TOF) CALL GSPOS('S3  ',N,'PAME',X,Y,Z,0,'ONLY')
*
* Positioning volume CALB     into the mother PAME
*
      N= 1
      X= 0.
      Y= 0.
      Z= ZCAL
      IF(CAL) CALL GSPOS('CALS',N,'PAME',X,Y,Z,0,'ONLY')
*
* Positioning volume S4AL     into the mother PAME
*
      N= 1
      Z= ZS4
      IF(TOF) CALL GSPOS('S4AL',N,'PAME',X,Y,Z,0,'ONLY')
*
* Positioning volume NDBO    into the mother PAME
*
      N=1
c      Z=ZCAL-CALS(3)-2*S4(3)-8.
      Z=ZND
C      IF(ND ) CALL GSPOS('NDBX',N,'PAME',X,Y,Z,0,'ONLY')
      IF(ND ) CALL GSPOS('NDBO',N,'PAME',X,Y,Z,0,'ONLY')
*
* User action
*
      CALL GPUGEO
      RETURN
      END
