*
* $Id$
*
* $Log$
*
#if defined(GPAMELA_GARFIELD)
*CMZ :  3.00/00 11/05/2001  17.32.49  by  Unknown
*-- Author :    Marialuigia Ambriola   30/04/2001
      SUBROUTINE GPGARIN
*-----------------------------------------------------------------------
*   MAIN   - This program reads headers from the input file and calls
*            the appropriate routines to carry out the requested action.
*   VARIABLE : GSTRING      : serves for identifying the header.
*   (Last changed on 13/ 2/00.)
*-----------------------------------------------------------------------
      IMPLICIT NONE
C # GPAMELA Related commons
#include "gcunit.inc"
#include "gpunit.inc"
C # END. GPAMELA Related commons
#include "dimensions.inc"
C ML:
C # +SEQ,CELLDATA.
C # +SEQ,GASDATA.
#include "celldata.inc"
#include "gasdata.inc"
C END ML.
C # +SEQ,BFIELD.
#include "printplot.inc"
#include "input.inc"
      LOGICAL STDSTR
      INTEGER NC,IFAIL,GNWORD,INPCMP
      CHARACTER*(MXCHAR) GSTRING
      EXTERNAL STDSTR,INPCMP
      WRITE(CHMAIL,10000)
      CALL GMAIL(1,0)
*** Initialise variables, graphics, input and algebra.
      CALL INIT
*** Set the LUN number garfield has to read from and open it
      LUN=LUGAR
      CALL DSNOPN(CHGAR,LEN(CHGAR),LUN,'READ-FILE',IFAIL)
      IF (IFAIL.NE.0) THEN
         WRITE(CHMAIL,10100) IFAIL, CHGAR, LUN
         CALL GMAIL(1,0)
         GOTO 20
      ENDIF
*** Start an input loop that stops at the EOF or at the STOP command.
      IFAIL=0
*** Otherwise the line should start with an & symbol.
   10 CONTINUE
      CALL INPNUM(GNWORD)
*   Skip blank lines.
      IF(GNWORD.EQ.0)THEN
         CALL INPWRD(GNWORD)
         GOTO 10
      ENDIF
*   Stay in main if requested.
      IF(INPCMP(1,'&MAIN')+INPCMP(2,'MAIN').NE.0)THEN
         CALL INPWRD(GNWORD)
         GOTO 10
      ENDIF
*   Make sure it starts with an ampersand.
      CALL INPSTR(1,1,GSTRING,NC)
      IF(GSTRING(1:1).NE.'&')THEN
         WRITE(CHMAIL,10200)
         CALL GMAIL(1,0)
         CALL INPWRD(GNWORD)
         GOTO 10
      ELSEIF(NC.EQ.1.AND.GNWORD.EQ.1)THEN
         WRITE(CHMAIL,10300)
         CALL GMAIL(1,0)
         CALL INPWRD(GNWORD)
         GOTO 10
      ENDIF
      IF((GNWORD.GT.2.AND.NC.EQ.1).OR.(GNWORD.GT.1.AND.NC.GT.1)) THEN
         WRITE(CHMAIL,10400)
         CALL GMAIL(1,0)
      ENDIF
*** Stop if STOP is the keyword.
C # Just exit in the GPAMELA case
      IF(INPCMP(1,'&ST#OP')+INPCMP(2,'ST#OP')+ INPCMP(1,'&Q#UIT')+
     +INPCMP(2,'Q#UIT')+ INPCMP(1,'&EX#IT')+INPCMP(2,'EX#IT').NE.0)
     +THEN
         GOTO 20
*** Call CELDEF if CELL is a keyword,
      ELSEIF(INPCMP(1,'&C#ELL')+INPCMP(2,'C#ELL').NE.0) THEN
*   Call cell reading routine.
         CALL CELDEF(IFAIL)
         IF(IFAIL.EQ.1) PRINT *,' !!!!!! MAIN   WARNING : The cell'//
     +   ' section failed ; various sections can not be entered.'
*** Call MAGINP if MAGNETIC is a keyword.
      ELSEIF(INPCMP(1,'&M#AGNETIC-#FIELD')+ INPCMP(2,'M#AGNETIC-#'//
     +   'FIELD').NE.0) THEN
         PRINT *,' !!!!!! MAIN   WARNING : The &CELL and &MAGNETIC'//
     +   ' sections are absent in this compilation.'
         CALL SKIP
*** Read gas data if GAS is the first keyword,
      ELSEIF(INPCMP(1,'&G#AS')+INPCMP(2,'G#AS').NE.0)THEN
*   Call the gas data reading routine.
         CALL GASDEF(IFAIL)
         IF(IFAIL.NE.0.AND.JFAIL.EQ.1)THEN
            PRINT *,' !!!!!! MAIN   WARNING : Gas section failed'//
     +      ' ; CO2 will be used for the time being.'
            CALL XXXGAS(IFAIL)
            IF(IFAIL.NE.0)PRINT *,' ###### MAIN   ERROR   : CO2'//
     +      ' data are not correct ; no gas data.'
         ELSEIF(IFAIL.NE.0)THEN
            PRINT *,' !!!!!! MAIN   WARNING : The gas section'//
     +      ' failed ; various sections can not be entered.'
         ENDIF
*** Call FLDINP if FIELD is a keyword.
      ELSEIF(INPCMP(1,'&F#IELD')+INPCMP(2,'F#IELD').NE.0)THEN
         PRINT *,' !!!!!! MAIN   WARNING : The &FIELD section is '//
     +   'absent in this compilation.'
         CALL SKIP
*** Call OPTINP if OPTIMISE is a keyword.
      ELSEIF(INPCMP(1,'&O#PTIMISE')+INPCMP(2,'O#PTIMISE').NE.0)THEN
         PRINT *,' !!!!!! MAIN   WARNING : The &OPTIMISE section '//
     +   'is absent in this compilation.'
         CALL SKIP
C ML:
C ML *** Warn if the drift section has not been compiled.
C ML
C ML      ELSEIF(INPCMP(1,'&D#RIFT')+INPCMP(2,'D#RIFT').NE.0)THEN
C ML         PRINT *,' !!!!!! MAIN   WARNING : The &DRIFT section is '//
C ML     +   'absent in this compilation.'
C ML C #          CALL SKIP
C ML         CALL INPWRD(GNWORD)
C ML         GOTO 10
*** Call DRFINP if DRIFT is the keyword.
      ELSEIF(INPCMP(1,'&D#RIFT')+INPCMP(2,'D#RIFT').NE.0)THEN
         IF((.NOT.GASSET).AND.JFAIL.EQ.1)THEN
            PRINT *,' !!!!!! MAIN   WARNING : No gas data found'//
     +           ' so far ; CO2 will be used for the time being.'
            CALL XXXGAS(IFAIL)
            IF(IFAIL.NE.0)THEN
               PRINT *,' ###### MAIN   ERROR   : The CO2 data'//
     +              ' are not correct ; no gas data.'
               CALL SKIP
               GOTO 10
            ENDIF
         ELSEIF(.NOT.GASSET)THEN
            PRINT *,' !!!!!! MAIN   WARNING : No valid gas data'//
     +           ' found so far ; drift section not executed.'
            CALL SKIP
            GOTO 10
         ENDIF
         IF(CELSET)THEN
            CALL DRFINP
         ELSE
            PRINT *,' !!!!!! MAIN   WARNING : No valid cell data'//
     +           ' found so far ; drift section not executed.'
            CALL SKIP
         ENDIF
C END ML.
*** Warn if the signal section has not been compiled.
      ELSEIF(INPCMP(1,'&SI#GNAL')+INPCMP(2,'SI#GNAL').NE.0)THEN
         PRINT *,' !!!!!! MAIN   WARNING : The &SIGNAL section is '//
     +   'absent in this compilation.'
         CALL SKIP
*** Header is recognised.
      ELSE
         PRINT *,' !!!!!! MAIN   WARNING : ',GSTRING(1:NC),' is'//
     +   ' not a valid header.'
         CALL SKIP
      ENDIF
*** Read a new header.
      GOTO 10
10000 FORMAT(' GPGARIN: Welcome, this is Garfield - version 7.04,',
     +       ' updated until 6/1/2001.')
10100 FORMAT(' GPGARIN: ERROR ID:',I8,' OPENING FILE:',A,', ON LUN',
     +      ': ',I8)
10200 FORMAT(' GPGARIN: WARNING : Please enter a section',
     +           ' header, a control statement or a global command.')
10300 FORMAT(' GPGARIN: WARNING : A section name should',
     +           ' be appended to the &; try again.')
10400 FORMAT(' GPGARIN: WARNING : Keywords on the header',
     +           ' line are ignored in this version of the program.')
10500 FORMAT(' GPGARIN: Exiting  garfield INIT')
   20 CONTINUE
      WRITE(CHMAIL,10500)
      CALL GMAIL(1,0)
      RETURN
      END
#endif
