*
* $Id: gpucal.F,v 3.2 2003/12/17 11:32:48 pamela Exp $
*
* $Log: gpucal.F,v $
* Revision 3.2  2003/12/17 11:32:48  pamela
* CALO SIMULATION COMPLETED: geometry and special tracking parameters updated and simulation checked by a comparison with the Trieste's standalone Monte Carlo simulation
*
* Revision 3.1.1.1  2002/07/11 16:02:14  cafagna
* First GPAMELA release on CVS
*
*
*CMZ :  2.03/00 31/10/2000  10.57.01  by  Francesco Cafagna
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 29/02/2000  10.23.24  by  Francesco Cafagna
*CMZ :  1.02/00 08/02/2000  21.29.53  by  Francesco Cafagna
*CMZ :  1.00/02 04/04/96  16.47.16  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   21/02/96
      SUBROUTINE GPUCAL(IACT,IS,ID,IPA,IT,DELOSS,PATH,
     +                  TRAPAR,NUMVOL,IMEC)
************************************************************************
*                                                                      *
* To collect and store the hit structure for CAL                       *
*                                                                      *
* Variables definition:                                                *
* IN:                                                                  *
*  IACT, integer specifing the action to be taken. It is the INWVOL    *
*        variable in GCTRAK common                                     *
*  IS    , set number                                                  *
*  ID    , detector number                                             *
*  IPA   , particle number                                             *
*  IT    , track number                                                *
*  DELOSS, energy loss in the step                                     *
*  PATH  , current track lenght                                        *
*  TRAPAR, track parameter, is the VECT vector in GCTRAK common        *
*  NUMVOL, integer array of numbers identifying the DETECTOR           *
*  IMEC  , integer indicating the LOSS mecanism position inside NMEC   *
*          vector, zero if not present                                 *
*                                                                      *
*                                                                      *
* NOTE: The IT variable is overwritten and the GSCHIT is used          *
*       to account for the multi-tracks produced in an e.m. shower     *
*                                                                      *
* Called by: GUSTEP                                                    *
* Author: Francesco Cafagna, 21/02/96 16.13.51                         *
*                                                                      *
************************************************************************
#include "gphit.inc"
#include "gcunit.inc"
*ml: (19/02/03)
#include "gckine.inc"
#include "gcflag.inc"
#include "gpencal.inc"
*end ml
*EM:
      PARAMETER (CALIB=0.0001085200)
*END EM.
      INTEGER IACT,IS,ID,IPA,IT,NUMVOL(20),IMEC,IDHIT
      REAL DELOSS,PATH,TRAPAR(7),VHIT(NHCAL),XYZM(3),XYZD(3)
*      REAL DELOSS,PATH,TRAPAR(7),XYZM(3),XYZD(3)
      REAL DELTA2,SIGMA2,SIGMA,GRNDM0,GPGAUS,PATHINI
      LOGICAL SAVE
*
*ml (19/02/02):
      INTEGER IPL,IMOD,IST
      DATA IEVOLD/-1/
*
* It's a new event
*
      IF(IEVOLD.NE.IEVENT) THEN
c         print*,'IS,ID,NUMVOL=',IS,ID,NUMVOL
c         print*,'GPUCAL:last event=',ievold
         IEVOLD=IEVENT
         CALL VZERO(ENEMAT,44*9*32)
      ENDIF
*end ml.
*
* Track is inside a volume
*
      IF(IACT.EQ.0) THEN
         IF(IMEC.GT.0) THEN
            SAVE = .TRUE.
*EM:
cccc            VHIT(4) = (DELOSS/CALIB) + VHIT(4)
* END EM
C ML
            VHIT(4) = DELOSS + VHIT(4)
            ENEMAT(NUMVOL(1),NUMVOL(2),NUMVOL(3))=
     +           ENEMAT(NUMVOL(1),NUMVOL(2),NUMVOL(3))+DELOSS
*END ML
         ENDIF
      ENDIF
*
* Entering a new volume or is a new track
*
      IF(IACT.EQ.1) THEN
         SAVE = .FALSE.
         CALL VZERO(VHIT,NHCAL)
         DO I=1,3
            VHIT(I) = TRAPAR(I)
         ENDDO
         IF(IMEC.GT.0) THEN
            SAVE = .TRUE.
*EM:
c            VHIT(4) = DELOSS/CALIB
*END EM.
            VHIT(4) = DELOSS
C ML:
            ENEMAT(NUMVOL(1),NUMVOL(2),NUMVOL(3))=
     +           ENEMAT(NUMVOL(1),NUMVOL(2),NUMVOL(3))+DELOSS
*END ML
         ENDIF
         IDHIT = -1
* Store the particle and momentum if is the first track
c         IF(IT.EQ.1) THEN
c            VHIT(5) = IPA
c            VHIT(6) = TRAPAR(7)
c         ENDIF
         PATHINI = PATH
      ENDIF
*
* Track is exiting current volume
*
      IF(IACT.EQ.2) THEN
         IF(IMEC.GT.0) THEN
            SAVE = .TRUE.
*EM:
c            VHIT(4) = (DELOSS/CALIB) + VHIT(4)
*END EM
            VHIT(4) = DELOSS + VHIT(4)
*ML:
            ENEMAT(NUMVOL(1),NUMVOL(2),NUMVOL(3))=
     +           ENEMAT(NUMVOL(1),NUMVOL(2),NUMVOL(3))+DELOSS
*END EM
         ENDIF
#if defined(GPAMELA_NOGFLUCT)
*
* change in de/dx with gaussian convolution
* see Hall paper: NIM 220 (1984) 356.
*
* FIRST: Look if the STOP mechanism is present
*
         IF(IMEC.EQ.1) THEN
* This particle has NOT been stopped. So gaussian energy spread...
* Delta is in GeV^2/cm
            DELTA2=.5E-8
            SIGMA2=DELTA2*(PATH - PATHINI)
            SIGMA=SQRT(SIGMA2)
            GRNDM0 = GPGAUS(0.)
*EM:
c            VHIT(4)=VHIT(4)+GRNDM0*SIGMA/CALIB
CML17/04/03            VHIT(4)=VHIT(4)+GRNDM0*SIGMA
*END EM
CML17/04/03            IF(VHIT(4).LT.0.) VHIT(4)=0.
         ENDIF
#endif
*
* Store the hit
*
         IF(IDHIT.EQ.-1) THEN
*ML:
*            IF(SAVE) CALL GSCHIT (IS,ID,1,NUMVOL,VHIT,4,IDHIT)
            IF(SAVE) THEN
               CALL GSCHIT (IS,ID,1,NUMVOL,VHIT,1,IDHIT)
c               CALL GSAHIT (IS,ID,IT,NUMVOL,VHIT,IDHIT)
            ENDIF
*END ML.
            IF (IDHIT.EQ.0) THEN
               WRITE(CHMAIL,10000) IS,ID,IT
               CALL GMAIL(1,0)
            ENDIF
         ELSE
            WRITE(CHMAIL,10100) IS,ID,IT
            CALL GMAIL(1,0)
         ENDIF
      ENDIF
*
* Track is exiting the set up
*
      IF(IACT.EQ.3) THEN
*
* Check if the hit have been previously stored or not
*
         IF(IDHIT.LT.0) THEN
            IF(IMEC.GT.0) THEN
               SAVE = .TRUE.
*EM:
c               VHIT(4) = (DELOSS/CALIB) + VHIT(4)
* END EM.
               VHIT(4) = DELOSS + VHIT(4)
*ML:
               ENEMAT(NUMVOL(1),NUMVOL(2),NUMVOL(3))=
     +              ENEMAT(NUMVOL(1),NUMVOL(2),NUMVOL(3))+DELOSS
*END ML.
            ENDIF
#if defined(GPAMELA_NOGFLUCT)
*
* change in de/dx with gaussian convolution
* see Hall paper: NIM 220 (1984) 356.
*
* FIRST: Look if the STOP mechanism is present
*
            IF(IMEC.EQ.1) THEN
* This particle has NOT been stopped. So gaussian energy spread...
* Delta is in GeV^2/cm
               DELTA2=.5E-8
               SIGMA2=DELTA2*(PATH - PATHINI)
               SIGMA=SQRT(SIGMA2)
               GRNDM0 = GPGAUS(0.)
*EM:
c               VHIT(4)=VHIT(4)+GRNDM0*SIGMA/CALIB
CML17/04/03               VHIT(4)=VHIT(4)+GRNDM0*SIGMA
*END EM.
CML17/04/03               IF(VHIT(4).LT.0.) VHIT(4)=0.
            ENDIF
#endif
*
* Store the hit
*
            IF(IDHIT.EQ.-1) THEN
*ML
C               IF (SAVE) CALL GSCHIT (IS,ID,1,NUMVOL,VHIT,4,IDHIT)
               IF (SAVE) THEN 
                  CALL GSCHIT (IS,ID,1,NUMVOL,VHIT,1,IDHIT)
               ENDIF
CL               IF (SAVE) CALL GSCHIT (IS,ID,1,NUMVOL,VHIT,1,IDHIT)
*END ML.
               IF (IDHIT.EQ.0) THEN
                  WRITE(CHMAIL,10200) IS,ID,IT
                  CALL GMAIL(1,0)
               ENDIF
            ELSE
               WRITE(CHMAIL,10300) IS,ID,IT
               CALL GMAIL(1,0)
            ENDIF
         ENDIF
      ENDIF
10000 FORMAT(' GPUCAL error: HIT have not be stored for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
10100 FORMAT(' GPUCAL error: HIT have not be initialized for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
10200 FORMAT(' GPUCAL error: HIT have not be stored for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
10300 FORMAT(' GPUCAL error: HIT have not be initialized for SET='
     +       ,I4,', DET=',I4,', TRACK=',I6)
      RETURN
      END
