*
* $Id$
*
* $Log$
*
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.06  by  Francesco Cafagna
*CMZ :  1.02/00 20/03/97  15.53.07  by  Francesco Cafagna
*CMZ :  1.01/00 04/05/96  10.27.46  by  Francesco Cafagna
*-- Author :    Paolo (The Magic) Papini   23/04/96
      SUBROUTINE GPSDINI
************************************************************************
*                                                                      *
* To calculate parameters for spectrometer digitizing                  *
*                                                                      *
* Called by: GPDIGI                                                    *
* Author: Paolo (The Magic) Papini, 23/04/96 17.21.55                  *
*                                                                      *
************************************************************************
#include "gcunit.inc"
#include "gpsed.inc"
#include "gpgeo.inc"
#include "gpdigi.inc"
#include "gpdspe.inc"
*
      INTEGER JUNK
*
      REAL X0,X1,X2,Y0,Y1,Y2,Z0,SIG2X,SIG2Y,SIG1X,SIG1Y,
     +UDSPE(NUDSPE)
*
#include "gpddspe.inc"
*
* CHARX and CHARY calculation and CCX,CCY
*
      STEPX=WXSTR*5.5/NPCHXY
      STEPY=WYSTR*5.5/NPCHXY
      STEPZ=2.*TSPA(3)/NPCHZ
*
* Silicon thickness
*
      D=2.*TSPA(3)
*
* Diffusion temperature (Volt)
*
      TVX=0.04
      TVY=0.02
*
* Volt (junction)
*
      UD=50.
*
* Volt (external)
*
      UU=100.
*
      DO I=1,NPCHXY
         X0=(I-0.5)*STEPX
C         X1=-WXSTR/2.
C         X2=WXSTR/2.
         STRDIV=0.6
         X1=-WXSTR*STRDIV
         X2=WXSTR*STRDIV
         X1_I=-WXSTR*(1.-STRDIV)
         X2_I=WXSTR*(1.-STRDIV)
         Y0=(I-0.5)*STEPY
         Y1=-WYSTR/2.
         Y2=WYSTR/2.
         DO J=1,NPCHZ
            Z0=(J-0.5)*STEPZ
            SIG2X=-1.*D**2*TVX/UD*LOG(1.-2.*UD*(D-Z0)/(UU+UD)/D)
            SIG2Y=-1.*D**2*TVY/UD*LOG(1.-2.*UD*(D-Z0)/(UU+UD)/D)
            SIG1X=SQRT(SIG2X)
            SIG1Y=SQRT(SIG2Y)
            CHARX(I,J)=FREQ((X2-X0)/SIG1X)-FREQ((X1-X0)/SIG1X)
            CHARX_I(I,J)=FREQ((X2_I-X0)/SIG1X)-FREQ((X1_I-X0)/SIG1X)
            CHARY(I,J)=FREQ((Y2-Y0)/SIG1Y)-FREQ((Y1-Y0)/SIG1Y)
         END DO
      END DO
      PX1=0.9 ! C1-x
      PX2=0.5 ! C2-X
      PY1=0.98  ! C1-Y
      PY2=0.5  ! C2-Y
      CCX(1)=PX1
      CCX(2)=(1.-PX1)/2.*PX2
      CCX(3)=(1.-PX1)/2.*(1-PX2)
      CCY(1)=PY1
      CCY(2)=(1.-PY1)/2.*PY2
      CCY(3)=(1.-PY1)/2.*(1.-PY2)
*
* Store the USER parameters into the User's DIGI bank
*
      JUNK = 0
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = ADCX
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = ADCY
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = PIEDX
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = PIEDY
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = ENOISX
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = ENOISY
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = NPCHXY
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = NPCHZ
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = WXSTR
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = WYSTR
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = D
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = TVX
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = TVY
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = UD
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = UU
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = PX1
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = PX2
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = PY1
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = PY2
      JUNK = JUNK + 1
      IF(JUNK.LE.NUDSPE) UDSPE(JUNK) = STRDIV
*
      IF(JUNK.EQ.NUDSPE) THEN
         CALL GSDETU('SPE ',CNSED(ISSPE,IDTSPA),NUDSPE,UDSPE)
      ELSE
         WRITE(CHMAIL,10000) JUNK,NUDSPE
      ENDIF
*
10000 FORMAT(' GPSDINI: Too many user`s DIGI parameter: NUDSPE=',
     +       I4,', NCOUNT=',I4)
      RETURN
      END
