*
* $Id: gpgacl.F,v 3.1.1.1 2002/07/11 16:02:15 cafagna Exp $
*
* $Log: gpgacl.F,v $
* Revision 3.1.1.1  2002/07/11 16:02:15  cafagna
* First GPAMELA release on CVS
*
*
#if defined(GPAMELA_GARFIELD)
*CMZ :  3.00/00 16/07/2001  17.26.37  by  Unknown
*-- Author :    Marialuigia Ambriola   02/05/2001
      SUBROUTINE GPGACL(IDPART,VPART,VXYZ,ECLTOT,NCLUS)
********************************************************************************
*
* A silly subroutine to interface GARFIELD. It needs the particle and
* track parameter to be passed to GARFIELD. It returns the number of
* clusters generated and the total energy released in MeV
*
* Varibles definitions:
* IN
*  - IDPART, GEANT particle ID
*  - VPART , real array containing particle characteristics.
*     VPART(1) = particle MASS (MeV)
*     VPART(2) = particle charge
*     VPART(3) = particle KInetic Energy
*  - VXYZ, real array containing the track starting and ending points
*      VXYZ(1) = X starting point
*      VXYZ(2) = Y starting point
*      VXYZ(3) = Z starting point
*      VXYZ(4) = X ending point
*      VXYZ(5) = Y ending point
*      VXYZ(6) = Z ending  point
*
* OUT
*  - ECLTOT, Total energy released in the track, in MeV
*  - NCLUS , Number of clusters generated along the track
*
* Called by: <USER>
*
* By Caf & ML on 2 May 2001
*
********************************************************************************
      IMPLICIT NONE
*
* Garfield commons
*
#include "dimensions.inc"
#include "parameters.inc"
*
*
*     Local variables
*
#include "gcunit.inc"
      REAL VPART(3),VXYZ(6),ECLTOT
      INTEGER IDPART,NCLUS,IFAIL
      LOGICAL DONE
      LOGICAL MASS,CHARGE,ENER
      REAL XCLS,YCLS,ZCLS,ECLS
      INTEGER NPAIR
*
*     Start filling in the particle properties and the track mode type (ITRTYPE)
*
      MASS=.FALSE.
      CHARGE=.FALSE.
      ENER=.FALSE.
*
      CALL GPGAPART(IDPART,IFAIL)
*
* No HEED corrispondence
*
cml         WRITE(CHMAIL,10100)
cml         CALL GMAIL(1,0)
         TRMASS=VPART(1)
         TRCHAR=VPART(2)
         WRITE(PNAME,10000)IDPART
10000    FORMAT('GEANT',I3)
         NCPNAM=8
         ITRTYP=4
         IF(TRMASS.LT.0.) THEN
            WRITE(CHMAIL,10300)
            CALL GMAIL(1,0)          
         ELSE
            MASS=.TRUE.
         ENDIF
         IF(ABS(TRCHAR).LT.0.99.OR.ABS(TRCHAR).GT.1.01) THEN
            WRITE(CHMAIL,10400)
            CALL GMAIL(1,0)          
         ELSE
            CHARGE=.TRUE.
         ENDIF
*
*     The particle is definited
*
      TRENER = VPART(3)
      IF(TRENER.LE.0.) THEN
         WRITE(CHMAIL,10100)
         CALL GMAIL(1,0)
      ELSE
         ENER=.TRUE.
      ENDIF
      IF(MASS.AND.CHARGE.AND.ENER)THEN
         TRFLAG(2)=.TRUE.
      ELSE
         TRFLAG(2)=.FALSE.
      ENDIF
*      PRINT*,'TRFLAG=',TRFLAG(1),TRFLAG(2),TRFLAG(3),TRFLAG(4),TRFLAG(5)
*      TRFLAG(2) = .TRUE.
*
*     Store the track parameters
*
      XT0 = VXYZ(1)
      YT0 = VXYZ(2)
      ZT0 = VXYZ(3)
      XT1 = VXYZ(4)
      YT1 = VXYZ(5)
      ZT1 = VXYZ(6)
*      TRFLAG(1) = .TRUE.
*
*     Initialize the track
*
      CALL TRACLI
*
*     Track it until DONE
*
      ECLTOT = 0
      NCLUS  = 0
*      PRINT*,'LTRMS,LTRDEL,LTREXB=',LTRMS,LTRDEL,LTREXB
*      PRINT*,'BEFORE'
*      PRINT*,'XT0,YT0,ZT0=',XT0,YT0,ZT0
*      PRINT*,'VPART(1)=',VPART(1)
   10 CALL TRACLS(XCLS,YCLS,ZCLS,ECLS,NPAIR,DONE,IFAIL)
      IF(DONE) THEN
C     # The cluster generation is over	
         GO TO 20
      ENDIF
      IF(IFAIL.NE.0. ) THEN
C     # An error occurred
         WRITE(CHMAIL,10200)
         CALL GMAIL(1,0)
         GO TO 20
      ENDIF
c ML:
      IF(ECLS.LE.0.) THEN
         PRINT*,'ATTENZIONE IN GPGACL, Energia del cluster negativa:'
         PRINT*,'ECLS=',ECLS
         GO TO 20
      ENDIF
c END ML.
      ECLTOT = ECLTOT + ECLS
      NCLUS = NCLUS + 1
      GO TO 10
C 10100 FORMAT(' GPGACL: ERROR !!!! GEANT particle ID not found in ',
C     +     'HEED data base')
10100 FORMAT(' GPGACL: ERROR !!!! Energy is not positive ')
10200 FORMAT(' GPGACL: ERROR !!!! Error in cluster generation from ',
     +     'TRACLS')
10300 FORMAT(' GPGACL: ERROR !!!! Mass is negative ')
10400 FORMAT(' GPGACL: ERROR !!!! Currently only charge +1 or -1')
   20 RETURN
      END
#endif
