*
* $Id: gpsed.F,v 3.2 2002/12/04 15:12:54 pamela Exp $
*
* $Log: gpsed.F,v $
* Revision 3.2  2002/12/04 15:12:54  pamela
* CAS and CALO geometry modified
*
* Revision 3.1.1.1  2002/07/11 16:02:00  cafagna
* First GPAMELA release on CVS
*
*
*               19/09/2002  11.20.48  by  Jens Lund
*CMZ :  3.00/00 06/04/2001  14.50.18  by  Marialuigia Ambriola
*CMZ :  2.03/00 06/11/2000  01.09.51  by  Francesco Cafagna
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 28/02/2000  18.48.57  by  Francesco Cafagna
*CMZ :  1.02/00 04/02/2000  20.31.22  by  Francesco Cafagna
*CMZ :  1.01/00 16/05/96  17.38.13  by  Francesco Cafagna
*CMZ :  1.00/02 28/03/96  23.38.53  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   30/11/95
      SUBROUTINE GPSED
*********************************************************************
*
* To define sets, detectors and HITS
*
* The USER set numbers are:
*  S11 = 1
*  S12 = 2
*  S21 = 3
*  S22 = 4
*  S31 = 5
*  S32 = 6
*  S4  = 7
*  TRD = 8
*  CAT = 9
*  CAS = 10
*  SPE = 11
*  CAL = 12
*
* The USER detector numbers are, inside the SET structure,:
c ml:27/10/03:
C*  S11X= 1
*  S11Y= 1
c*  S12Y= 1
*  S12X= 1
c end ml.
*  S21X= 1
*  S22Y= 1
*  S31Y= 1
*  S32X= 1
*  CHAE= 1
*  TRSI= 1
*JeL:
*C  CATL= 1
*C  CATT= 2
*  TOP1= 1
*C  CASX= 1
*C  CASY= 2
*  SID1= 1
*END: JeL.
*  TSPA= 1
*  CASI= 1
*  CAST= 1, in case the division have been requested
*
* The USER detector type are:
*  1, scintillator counter
*  2, aerogel
*  3, TRD
*  4, silicon detector
*
* Called by: UGINIT
* Author: F. Cafagna 13/02/96 13.21.27                               *
*                                                                    *
**********************************************************************
#include "gpgeo.inc"
#include "gpkey.inc"
#include "gpsed.inc"
*
      INTEGER NBITSV(6),NWHI,NWDI
      CHARACTER*4 CVOLU(6)
*
      CALL VZERO(NBITSV,6)
      NWHI = 100
      NWDI = 100
*
c      CVOLU(1) ='PAME'
*
* Tof
*
      IF(PTOF) THEN
c         NVTOF = 3
         NVTOF = 2
c         NBITSV(1) = 1
c         NBITSV(2) = 1
c         NBITSV(3) = 4
         NBITSV(1) = 1
         NBITSV(2) = 4
         CVOLU(1) ='S11 '
c ml:27/10/04:
c         CVOLU(2) ='S11X'
         CVOLU(2) ='S11Y'
c end ml.
         CVOLU(3) ='    '
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
c ml:27/10/04:
c         CALL GSDET('S11 ','S11X',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
c     +   ISS11,IDS11X)
c         CNSED(ISS11,IDS11X) = CVOLU(NVTOF)
         CALL GSDET('S11 ','S11Y',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
     +        ISS11,IDS11Y)
         CNSED(ISS11,IDS11Y) = CVOLU(NVTOF)
*
         CVOLU(1) ='S12 '
c         CVOLU(2) ='S12Y'
         CVOLU(2) ='S12X'
c         CALL GSDET('S12 ','S12Y',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
c     +   ISS12,IDS12Y)
c         CNSED(ISS12,IDS12Y) = CVOLU(NVTOF)
         CALL GSDET('S12 ','S12X',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISS12,IDS12X)
         CNSED(ISS12,IDS12X) = CVOLU(NVTOF)
c end ml.
*
         CVOLU(1) ='S21 '
         CVOLU(2) ='S21X'
         CALL GSDET('S21 ','S21X',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISS21,IDS21X)
         CNSED(ISS21,IDS21X) = CVOLU(NVTOF)
*
         CVOLU(1) ='S22 '
         CVOLU(2) ='S22Y'
         CALL GSDET('S22 ','S22Y',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISS22,IDS22Y)
         CNSED(ISS22,IDS22Y) = CVOLU(NVTOF)
*
         CVOLU(1) ='S31 '
         CVOLU(2) ='S31Y'
         CALL GSDET('S31 ','S31Y',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISS31,IDS31Y)
         CNSED(ISS31,IDS31Y) = CVOLU(NVTOF)
*
         CVOLU(1) ='S32 '
         CVOLU(2) ='S32X'
         CALL GSDET('S32 ','S32X',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISS32,IDS32X)
         CNSED(ISS32,IDS32X) = CVOLU(NVTOF)
*
*ML:
*         NVTOF =1
         NVS4=1
*END ML.
         CVOLU(1) ='S4  '
         CVOLU(2) ='    '
*ML:
*         CALL GSDET('S4  ','S4  ',NVTOF,CVOLU,NBITSV,1,NWHI,NWDI,
*     +   ISS4,IDS4)
         CALL GSDET('S4  ','S4  ',NVS4,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISS4,IDS4)
*         CNSED(ISS4,IDS4) = CVOLU(NVTOF)
         CNSED(ISS4,IDS4) = CVOLU(NVS4)
*END ML.
      ELSE
         ISS11  = -1
c ml: 27/10/04:
c         IDS11X = -1
         IDS11Y = -1
         ISS12  = -1
c         IDS12Y = -1
         IDS12X = -1
c end ml.
         ISS21  = -1
         IDS21X = -1
         ISS22  = -1
         IDS22Y = -1
         ISS31  = -1
         IDS31Y = -1
         ISS32  = -1
         IDS31X = -1
         ISS4   = -1
         IDS4   = -1
      ENDIF
*
* TRD
*
      IF(PTRD) THEN

         NVTRD = 2
c         NBITSV(1) = 1
c         NBITSV(2) = 1
         NBITSV(1) = 6
         NBITSV(2) = 6
c         CVOLU(2) ='TRDB'
         CVOLU(1) ='TRBS'
         CVOLU(2) ='TRSI'
         CVOLU(3) ='    '
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
         CALL GSDET('TRD ','TRSI',NVTRD,CVOLU,NBITSV,3,NWHI,NWDI,
     +        ISTRD,IDTRSI)
         CNSED(ISTRD,IDTRSI) = CVOLU(NVTRD)
*     ML:
 	 NVTRD=3
         NBITSV(3) = 2
         CVOLU(3) = 'TRSO'
 	 CALL GSDET('TRD ','TRSO',NVTRD,CVOLU,NBITSV,3,NWHI,NWDI,
     +        ISTRD,IDTRSO)
         CNSED(ISTRD,IDTRSO) = CVOLU(NVTRD)
****** DON'T MODIFY !!!!!! SEE GPDTRD
         NVTRD = 2
*END ML.
*
      ELSE
         ISTRD = -1
         IDTRSI= -1
*ML:
	 IDTRSO= -1
*END ML.
      ENDIF
*
* CAT
*
      IF(PCAT) THEN
*JeL:
C         NVCAT = 2
         NVCAT = 1
c         NBITSV(1) = 1
         NBITSV(1) = 1
C         NBITSV(2) = 2
C         CVOLU(1) ='CATB'
C         CVOLU(2) ='CATL'
         CVOLU(1) ='TOP1'
         CVOLU(2) ='    '
         CVOLU(3) ='    '
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
C         CALL GSDET('CAT ','CATL',NVCAT,CVOLU,NBITSV,1,NWHI,NWDI,
C     +   ISCAT,IDCATL)
         CALL GSDET('CAT ','TOP1',NVCAT,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISCAT,IDCATL)
         CNSED(ISCAT,IDCATL) = CVOLU(NVCAT)
C         CVOLU(2) ='CATT'
C         CALL GSDET('CAT ','CATT',NVCAT,CVOLU,NBITSV,1,NWHI,NWDI,
C     +   ISCAT,IDCATT)
C         CNSED(ISCAT,IDCATT) = CVOLU(NVCAT)
      ELSE
         ISCAT = -1
C         IDCATT= -1
         IDCATL= -1
*END: JeL.
      ENDIF
*
* CAS
*
      IF(PCAS) THEN
         NVCAS = 1
*JeL:
c         NBITSV(1) = 1
         NBITSV(1) = 4
C         CVOLU(1) ='CASX'
         CVOLU(1) ='SID1'
         CVOLU(2) ='    '
         CVOLU(3) ='    '
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
C         CALL GSDET('CAS ','CASX',NVCAS,CVOLU,NBITSV,1,NWHI,NWDI,
C     +   ISCAS,IDCASX)
         CALL GSDET('CAS ','SID1',NVCAS,CVOLU,NBITSV,1,NWHI,NWDI,
     +   ISCAS,IDCASX)
         CNSED(ISCAS,IDCASX) = CVOLU(NVCAS)
C         CVOLU(1) ='CASY'
C         CALL GSDET('CAS ','CASY',NVCAS,CVOLU,NBITSV,1,NWHI,NWDI,
C     +   ISCAS,IDCASY)
C         CNSED(ISCAS,IDCASY) = CVOLU(NVCAS)
*END: JeL.
      ELSE
         ISCAS = -1
         IDCASX= -1
      ENDIF
*
* SPE
*
      IF(PSPE) THEN
         NVSPE = 4
c         NBITSV(1) = 1
c         NBITSV(2) = 1
         NBITSV(1) = 3
         NBITSV(2) = 1
         NBITSV(3) = INT(LOG(FLOAT(NTRSL))/LOG(2.)) + 1
         NBITSV(4) = 2
c         CVOLU(2) ='SPEB'
         CVOLU(1) ='TRPB'
         CVOLU(2) ='TRPL'
         CVOLU(3) ='TRSL'
         CVOLU(4) ='TSPA'
         CVOLU(5) ='    '
         CVOLU(6) ='    '
         CALL GSDET('SPE ','TSPA',NVSPE,CVOLU,NBITSV,4,NWHI,NWDI,
     +   ISSPE,IDTSPA)
         CNSED(ISSPE,IDTSPA) = CVOLU(NVSPE)
      ELSE
         ISSPE = -1
         IDTSPA= -1
      ENDIF
*
* CAL
*
      IF(PCAL) THEN
c         NBITSV(1) = 1
c         NBITSV(2) = 1
c         NBITSV(1) = INT(LOG(FLOAT(2*NCAPL))/LOG(2.)) + 1
c         NBITSV(3) = INT(LOG(FLOAT(NCASTR))/LOG(2.))+1
         NBITSV(1) = 8
         NBITSV(2) = 4
         NBITSV(3) = 8
         CVOLU(1) ='CAPL'
         CVOLU(2) ='CASI'
         CVOLU(3) ='CAST'
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
         NVCAL = 3
         CALL GSDET('CAL ','CAST',NVCAL,CVOLU,NBITSV,4, NWHI,NWDI,
     +      ISCAL,IDCAST)
         CNSED(ISCAL,IDCAST) = CVOLU(NVCAL)
*
* CAL second detector to store the energy released per strip
*
         NBITSV(1) = 8
         NBITSV(2) = 8
         CVOLU(1) ='CAPL'
         CVOLU(2) ='CASI'
         CVOLU(3) ='    '
         CVOLU(4) ='    '
         CVOLU(5) ='    '
         CVOLU(6) ='    '
         NVCALI = 2
         CALL GSDET('CAL ','CASI',NVCALI,CVOLU,NBITSV,4, NWHI,NWDI,
     +      ISCAL,IDCASI)
         CNSED(ISCAL,IDCASI) = CVOLU(NVCALI)
      ELSE
         ISCAL  = -1
         IDCASI = -1
      ENDIF
*
* User action
*
      CALL GPUSED
*
      RETURN
      END
