*
* $Id: gpgeo.F,v 3.2 2002/12/04 15:12:54 pamela Exp $
*
* $Log: gpgeo.F,v $
* Revision 3.2  2002/12/04 15:12:54  pamela
* CAS and CALO geometry modified
*
* Revision 3.1.1.1  2002/07/11 16:02:00  cafagna
* First GPAMELA release on CVS
*
*
*               16/07/2004  16.44.06  by  Alexey Bakaldin
*               15/10/2002  15.29.36  by  Jens Lund
*CMZ :  3.00/00 13/11/2000  09.03.11  by  Emiliano Mocchiutti
*CMZ :  2.01/00 05/04/2000  14.35.17  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.05  by  Francesco Cafagna
*CMZ :  1.02/00 08/11/99  18.44.50  by  Francesco Cafagna
*CMZ :  1.01/00 13/05/96  09.16.26  by  Francesco Cafagna
*CMZ :  1.00/02 04/04/96  12.00.53  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   05/12/95
      SUBROUTINE GPGEO
************************************************************************
*                                                                      *
* Volumes definition for PAMELA                                        *
*                                                                      *
* Called by: UGINIT                                                    *
* Author: Francesco Cafagna, 05/12/95 13.21.27                         *
*                                                                      *
************************************************************************
#include "gpgeo.inc"
#include "gpmed.inc"
#include "gpkey.inc"
*
      INTEGER IROT,IVOLU,N,NMED,NUM
      REAL X,Y,Z
*
*  Define 90 degree rotation around Z axis
*
      IROT=1
      CALL GSROTM(IROT,90.,90.,90.,180.,0.,0.)
*
*  Define 90 degree rotation around X axis
*
      IROT=2
      CALL GSROTM(IROT,90.,0.,180.,90.,90.,90.)
*
*  Define 90 degree rotation around Z axis and 180 along X
*
      IROT=3
      CALL GSROTM(IROT,90.,90.,90.,360.,180.,0.)
*
*  Define 180 degree rotation around Z axis
*
      IROT=4
      CALL GSROTM(IROT,90.,180.,90.,270.,0.,0.)
*JeL:
*
*  Define 180 degree rotation aroun Z axis and 180 along X
*
      IROT=5
      CALL GSROTM(IROT,90.,180.,90.,90.,180.,0.)
*
*  Define 270 degree rotation around Z axis
*
      IROT=6
      CALL GSROTM(IROT,90.,270.,90.,360.,0.,0.)
*
*  Define 90 degree rotation around Y axis
*
      IROT = 7
      CALL GSROTM(IROT,0.,0.,90.,90.,90.,180.)
*
*  Define 270 degree rotation around Y axis
*
      IROT = 8
      CALL GSROTM(IROT,180.,0.,90.,90.,90.,0.)
*
*  Define 180 degree rotation around Y axis
*
      IROT=9
      CALL GSROTM(IROT,90.,180.,90.,90.,180.,0.)

*END: JeL.
*
*  Define the PAMELA   volume
*
      NMED=MN2
      CALL GSVOLU('PAME','TUBE',NMED,PAME, 3,IVOLU)
*AB:
*
*  Define the Aluminium shell volumes
*
      NMED=MAL
C      CALL GSVOLU('SHEL','TUBE',NMED,SHEL, 3,IVOLU)
      CALL GSVOLU('SHEL','CONE',NMED,SHEL, 5,IVOLU)
*
*  Define the Aluminium inner shell volumes
*
      IF(SPH) THEN
         NMED=MAL
         CALL GSVOLU('TSPH','SPHE',NMED,TSPH, 6,IVOLU)
      ELSE
         NMED=MAL
         CALL GSVOLU('TFLA','TUBE',NMED,TFLA, 3,IVOLU)
      ENDIF
*
*  Define the Aluminium shell volumes
*
      NMED=MAL
      CALL GSVOLU('MSHE','TUBE',NMED,MSHE, 3,IVOLU)
*
*  Define the Aluminium shell volumes
*
      NMED=MAL
      CALL GSVOLU('BSPH','SPHE',NMED,BSPH, 6,IVOLU)
*END: AB.
c ml: 28/10/04 
*
*  Define the top plate (to be completed) 
*
      NMED=MN2
cfc      CALL GSVOLU('TPLA','BOX ',NMED,TPLA, 3,IVOLU)
c end ml.
*
* Volume definition for scintillators, TOF and anticoincidence counter
*
      IF(TOF) CALL GPTOFV
      IF(CAT) CALL GPCATV
      IF(CAS) CALL GPCASV
*
* Volume definition for TRD
*
      IF(TRD) CALL GPTRDV
*
* Volume definition for Spectrometer
*
      IF(SPE) CALL GPSPEV
*
* Volume definition for Calorimeter
*
      IF(CAL) CALL GPCALV

*
*  Volume positioning starting from the TOP
*
      X= 0.
      Y= 0.
*
* Positioning volume SHEL     into the mother PAME
*
      N= 1
      Z= ZSHEL
      CALL GSPOS('SHEL',N,'PAME',X,Y,Z,0,'ONLY')
*
* Positioning volume SHEI     into the mother PAME
*
C         N= 1
C         Z= ZSHEI
c         CALL GSPOS('SHEI',N,'PAME',X,Y,Z,0,'ONLY')
      IF(SPH) THEN
*
* Positioning volume TSPH     into the mother PAME
*
         N= 1
         Z= ZTSPH
         CALL GSPOS('TSPH',N,'PAME',X,Y,Z,0,'ONLY')
      ELSE
*
* Positioning volume TFLA     into the mother PAME
*
         N= 1
         Z= ZTFLA
         CALL GSPOS('TFLA',N,'PAME',X,Y,Z,0,'ONLY')
      ENDIF
*AB:
*
* Positioning volume MSHE     into the mother PAME
*
         N= 1
         Z= ZMSHE
         CALL GSPOS('MSHE',N,'PAME',X,Y,Z,0,'ONLY')
*
* Positioning volume BSPH     into the mother PAME
*
         N= 1
         Z= ZBSPH
         CALL GSPOS('BSPH',N,'PAME',X,Y,Z,0,'ONLY')
*END: AB.
*
* Positioning volume S11     into the mother PAME
*
      N= 1
c ml:24/11/04
      Z=ZCAL+CALS(3)+3.7+2*(SPEB(3)+TPLA(3)+S22(3)+S21(3)+CATA(2))+ 
     +     26.4+2*S12(3)+S11(3)
C      Z= ZS11
      IF(TOF) CALL GSPOS('S11 ',N,'PAME',X,Y,Z,0,'ONLY')
c end ml.
*
* Positioning volume S12     into the mother PAME
*
      N= 1
c ml:24/11/04
      Z=ZCAL+CALS(3)+3.7+2*(SPEB(3)+TPLA(3)+S22(3)+S21(3)+CATA(2))+ 
     +     26.4+S12(3)
C      Z= ZS12
      IF(TOF) CALL GSPOS('S12 ',N,'PAME',X,Y,Z,0,'ONLY')
c end ml.
*
* Positioning volume TRDB     into the mother PAME
*
      N= 1
c ml:24/11/04
      Z=ZCAL+CALS(3)+3.7+2*(SPEB(3)+TPLA(3)+S22(3)+S21(3)+CATA(2))+ 
     +     TRDB(3)
c      Z= ZTRD
      IF(TRD) THEN
         CALL GSPOS('TRDB',N,'PAME',X,Y,Z,0,'ONLY')
c end ml.
C FC commented out on 21-10-1999 by caf
c         CALL GSPOS('TRDS',N,'PAME',X,Y,Z,0,'ONLY')
c         Z= ZTRD - TRDS(3) - TRDT(3)
c         CALL GSPOS('TRDT',N,'PAME',X,Y,Z,0,'ONLY')
c         N= 2
c         Z= ZTRD + TRDS(3) + TRDT(3)
c         CALL GSPOS('TRDT',N,'PAME',X,Y,Z,0,'ONLY')
C FC end of comment on 21-10-1999
      ENDIF
*
* Positioning volume S21     into the mother PAME
*
      N= 1
c ml:24/11/04
      Z=ZCAL+CALS(3)+3.7+2*SPEB(3)+2*TPLA(3)+2*S22(3)+S21(3)
c      Z= ZS21
      IF(TOF) CALL GSPOS('S21 ',N,'PAME',X,Y,Z,0,'ONLY')
c  end ml.
*
* Positioning volume S22     into the mother PAME
*
      N= 1
c ml:24/11/04
      Z=ZCAL+CALS(3)+3.7+2*SPEB(3)+2*TPLA(3)+S22(3)
c      Z= ZS22
      IF(TOF) CALL GSPOS('S22 ',N,'PAME',X,Y,Z,0,'ONLY')
c end ml.
c ml: 28/10/04
*
*  Positioning volume TPLA into the mother PAME
*
      N=1
c ml:24/11/04
      Z=ZCAL+CALS(3)+3.7+2*SPEB(3)+TPLA(3)
c      Z=ZTPLA
cfc      CALL GSPOS('TPLA',N,'PAME',X,Y,Z,0,'ONLY')
c end ml.
*JeL:
*
* Positioning volume CATA     into the mother PAME
*
      N= 1
c ml:24/11/04
      Z=ZCAL+CALS(3)+3.7+2*(SPEB(3)+TPLA(3)+S21(3)+S22(3))+CATA(2)
C      Z= ZCAT
C Com. by JeL IF(CAT) CALL GSPOS('CATB',N,'PAME',X,Y,Z,0,'ONLY')
      IF(CAT) CALL GSPOS('CATA',N,'PAME',X,Y,Z,2,'ONLY')
c end ml.
*END: JeL.
*
* Positioning volume CAS      into the mother PAME
*
*EM:
*JeL:
C      Z= ZCAS
       Z= ZSPEC-2.1
*end JeL.
      IF(CAS) THEN
*com by JeL:
CC         X = 0
C         N = 0
C         DO I = 1,2
C            X = ((-1)**(I+1))*CASXD
CC            Y = ((-1)**I)*( CASY(2) + CASX(2) )
C            Y = ((-1)**I)*CASY(2)
Cc fc mod by caf on 21-10-1999
Cc            DO II=1, 5
Cc               Z = ZCAS - 4.*CASX(3) + (II-1) * 2*CASX(3)
Cc               N = N + 1
Cc               CALL GSPOS('CASX',N,'PAME',X,Y,Z,0,'ONLY')
Cc            ENDDO
Cc fc end mod
C            Z = ZCAS
C            N = N + 1
C*
C            CALL GSPOS('CSSX',N,'PAME',X,Y,Z,0,'ONLY')
C         ENDDO
C*
CC         Y = 0
C         N = 0
C         DO I = 1,2
C            X = ((-1)**I)*(CASX(1)+0.1)
CC            X = ((-1)**I)*(CASX(1)+CASY(1))
C            Y = ((-1)**I)*CASYD
Cc fc mod by caf on 21-10-1999
Cc            DO II=1, 5
Cc               Z = ZCAS - 4.*CASY(3) + (II-1) * 2*CASY(3)
Cc               N = N + 1
Cc               CALL GSPOS('CASY',N,'PAME',X,Y,Z,0,'ONLY')
Cc            ENDDO
Cc fc end mod
C            Z = ZCAS
C            N = N + 1
C            CALL GSPOS('CSSY',N,'PAME',X,Y,Z,0,'ONLY')
C         ENDDO
*end com by JeL.
*JeL:
         N = 1
*ML:
C         X = 10.75
         X = 8.872
C         Y = -14.1
         Y = -17.215
*END ML.
         CALL GSPOS('CASA',N,'PAME',X,Y,Z,0,'ONLY')
         N = 2
*ML:
C         X = 14.1
         X = 17.9285
C         Y = 10.75
         Y = 6.305
*END ML.
         CALL GSPOS('CASA',N,'PAME',X,Y,Z,1,'ONLY')
         N = 3
*ML:
C         X = -10.75
         X = -5.5095
C         Y = 14.1
         Y = 17.215
*END ML.
         CALL GSPOS('CASA',N,'PAME',X,Y,Z,4,'ONLY')
         N = 4
*ML:
C         X = -14.1
         X = -17.9285
C         Y = -10.75
         Y = -10.195
*END ML.
         CALL GSPOS('CASA',N,'PAME',X,Y,Z,6,'ONLY')
*end JeL.
      ENDIF
*END: EM.
*
* Positioning volume SPEB     into the mother PAME
*
      N= 1
      X= 0.
      Y= 0.
c ml: 24/11/03:
       Z=ZCAL+CALS(3)+3.7+SPEB(3)
c      Z= ZSPEC
      IF(SPE) CALL GSPOS('SPEB',N,'PAME',X,Y,Z,0,'ONLY')
c end ml.
*
* Positioning volume S31     into the mother PAME
*
      N= 1
      X= 0.
      Y= 0.
c ml: 24/11/04:
      Z=ZCAL+CALS(3)+1.8+2*S32(3)+S31(3)
c      Z= ZS31
      IF(TOF) CALL GSPOS('S31 ',N,'PAME',X,Y,Z,0,'ONLY')
c end ml.
*
* Positioning volume S32     into the mother PAME
*
      N= 1
      X= 0.
      Y= 0.
c ml: 24/11/04:
      Z=ZCAL+CALS(3)+1.8+S32(3)
c      Z= ZS32
      IF(TOF) CALL GSPOS('S32 ',N,'PAME',X,Y,Z,0,'ONLY')
c end ml.
*
* Positioning volume CALB     into the mother PAME
*
      N= 1
      X= 0.
      Y= 0.
      Z= ZCAL
      IF(CAL) CALL GSPOS('CALS',N,'PAME',X,Y,Z,0,'ONLY')
*
* Positioning volume S4     into the mother PAME
*
      N= 1
c ml: 24/11/04:
      Z=ZCAL-CALS(3)-S4(3)
C      Z= ZS4
      IF(TOF) CALL GSPOS('S4  ',N,'PAME',X,Y,Z,0,'ONLY')
c end ml.
*
* User action
*
      CALL GPUGEO
      RETURN
      END
