*
* $Id$
*
* $Log$
*
*CMZ :  2.01/00 05/04/2000  14.35.18  by  Marialuigia Ambriola
*CMZ :  2.00/00 03/03/2000  15.39.05  by  Francesco Cafagna
*CMZ :  1.02/00 21/10/99  16.30.25  by  Francesco Cafagna
*CMZ :  1.00/02 18/03/96  17.18.03  by  Francesco Cafagna
*-- Author :    Francesco Cafagna   05/12/95
      SUBROUTINE GPTOFV
************************************************************************
*                                                                      *
* Volumes definition for the scintillators counters                    *
* Called by: GPGEO                                                     *
* Author: Francesco Cafagna, 05/12/95 13.39.41                         *
*                                                                      *
************************************************************************
#include "gpgeo.inc"
#include "gpmed.inc"
*
      INTEGER IROT,IVOLU,N,NMED,NUM
      REAL X,Y,Z
*
      NMED=MN2
*
*  Define the S11     volume
*
      CALL GSVOLU('S11 ','BOX ',NMED,S11, 3,IVOLU)
*
*  Define the S12     volume
*
      CALL GSVOLU('S12 ','BOX ',NMED,S12, 3,IVOLU)
*
*  Define the S21     volume
*
      CALL GSVOLU('S21 ','BOX ',NMED,S21, 3,IVOLU)
*
*  Define the S22     volume
*
      CALL GSVOLU('S22 ','BOX ',NMED,S22, 3,IVOLU)
*
*  Define the S31     volume
*
      CALL GSVOLU('S31 ','BOX ',NMED,S31, 3,IVOLU)
*
*  Define the S32     volume
*
      CALL GSVOLU('S32 ','BOX ',NMED,S32, 3,IVOLU)
*
*  Change medium just for S4.
*
      NMED=MSCIN
*
*  Define the S4     volume
*
      CALL GSVOLU('S4  ','BOX ',NMED,S4, 3,IVOLU)
*
*  Start subvolume definition.
*
*
*  Define the S11X     volume
*
      CALL GSVOLU('S11X','BOX ',NMED,S11X, 3,IVOLU)
*
*  Define the S12Y     volume
*
      CALL GSVOLU('S12Y','BOX ',NMED,S12Y, 3,IVOLU)
*
*  Define the S21X     volume
*
      CALL GSVOLU('S21X','BOX ',NMED,S21X, 3,IVOLU)
*
*  Define the S22Y     volume
*
      CALL GSVOLU('S22Y','BOX ',NMED,S22Y, 3,IVOLU)
*
*  Define the S31Y     volume
*
      CALL GSVOLU('S31Y','BOX ',NMED,S31Y, 3,IVOLU)
*
*  Define the S32X     volume
*
      CALL GSVOLU('S32X','BOX ',NMED,S32X, 3,IVOLU)

      NMED=MCF
*
*  Define the SC11     volume
*
      CALL GSVOLU('SC11','BOX ',NMED,SC11, 3,IVOLU)
*
*  Define the SC12     volume
*
      CALL GSVOLU('SC12','BOX ',NMED,SC12, 3,IVOLU)
*
*  Define the SC21     volume
*
      CALL GSVOLU('SC21','BOX ',NMED,SC21, 3,IVOLU)
*
*  Define the SC22     volume
*
      CALL GSVOLU('SC22','BOX ',NMED,SC22, 3,IVOLU)

*
*  Define the SC31     volume
*
      CALL GSVOLU('SC31','BOX ',NMED,SC31, 3,IVOLU)
*
*  Define the SC32     volume
*
      CALL GSVOLU('SC32','BOX ',NMED,SC32, 3,IVOLU)

*
* Positioning volumes
*
      Y= 0
      Z= 0
      DO I=1,NS11X
         N= I
         X= -S11(1) + (2*I-1)*S11X(1)
         CALL GSPOS('S11X',N,'S11 ',X,Y,Z,0,'ONLY')
      ENDDO
      X= 0.
      Y= 0.
      DO I=1,2
         N= I
         Z= (-1.)**I*S11(3) + (-1.)**(I+1)*SC11(3)
         CALL GSPOS('SC11',N,'S11 ',X,Y,Z,0,'ONLY')
      ENDDO
*
      X= 0
      Z= 0
      DO I=1,NS12Y
         N= I
         Y= -S12(2) + (2*I-1)*S12Y(2)
         CALL GSPOS('S12Y',N,'S12 ',X,Y,Z,0,'ONLY')
      ENDDO
      X= 0.
      Y= 0.
      DO I=1,2
         N= I
         Z= (-1.)**I*S12(3) + (-1.)**(I+1)*SC12(3)
         CALL GSPOS('SC12',N,'S12 ',X,Y,Z,0,'ONLY')
      ENDDO
*
      Y= 0
      Z= 0
      DO I=1,NS21X
         N= I
         X= -S21(1) + (2*I-1)*S21X(1)
         CALL GSPOS('S21X',N,'S21 ',X,Y,Z,0,'ONLY')
      ENDDO
      X= 0.
      Y= 0.
      DO I=1,2
         N= I
         Z= (-1.)**I*S21(3) + (-1.)**(I+1)*SC21(3)
         CALL GSPOS('SC21',N,'S21 ',X,Y,Z,0,'ONLY')
      ENDDO
*
      X= 0
      Z= 0
      DO I=1,NS22Y
         N= I
         Y= -S22(2) + (2*I-1)*S22Y(2)
         CALL GSPOS('S22Y',N,'S22 ',X,Y,Z,0,'ONLY')
      ENDDO
      X= 0.
      Y= 0.
      DO I=1,2
         N= I
         Z= (-1.)**I*S22(3) + (-1.)**(I+1)*SC22(3)
         CALL GSPOS('SC22',N,'S22 ',X,Y,Z,0,'ONLY')
      ENDDO
*
      X= 0
      Z= 0
      DO I=1,NS31Y
         N= I
         Y= -S31(2) + (2*I-1)*S31Y(2)
         CALL GSPOS('S31Y',N,'S31 ',X,Y,Z,0,'ONLY')
      ENDDO
      X= 0.
      Y= 0.
      DO I=1,2
         N= I
         Z= (-1.)**I*S31(3) + (-1.)**(I+1)*SC31(3)
         CALL GSPOS('SC31',N,'S31 ',X,Y,Z,0,'ONLY')
      ENDDO
*
      Y= 0
      Z= 0
      DO I=1,NS32X
         N= I
         X= -S32(1) + (2*I-1)*S32X(1)
         CALL GSPOS('S32X',N,'S32 ',X,Y,Z,0,'ONLY')
      ENDDO
      X= 0.
      Y= 0.
      DO I=1,2
         N= I
         Z= (-1.)**I*S32(3) + (-1.)**(I+1)*SC32(3)
         CALL GSPOS('SC32',N,'S32 ',X,Y,Z,0,'ONLY')
      ENDDO
*
      RETURN
      END
